<?php
$request = \Config\Services::request();
$general = service('settings') -> get('App.general') ?? [];
helper('utils'); // helper 
helper('colorRows'); // Load the helper

/* --- Основни настройки ------------------------------------ */
$preval          = $general['preval'] ?? [];
$_priceType      = $general['zenoobr']['price_type'] ?? 'discount';
$_currency       = $preval['base_currency'] ?? 'BGN';
$_perPageOptions = [10, 20, 100, 200, 500, 1000];

/* --- Точност ------------------------------------------------- */
$_isRoundedToFirst = (bool) ($ofer -> isRoundedToFirst ?? false);
$_priceAccuracy    = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

/* --- Цени -------------------------------------------------- */
$_pricesWithDds     = !empty($general['prices_with_dds']);
$_dealerPricesLabel = 'ДИЛЪРСКИ ЦЕНИ ' . ($_pricesWithDds ? '(С ДДС)' : '(БЕЗ ДДС)');

/* --- Валута ---------------------------------------------- */
$_default_valutaSymbol = match ($_currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

$_show = [
    'cenaB'    => true,
    'cenaA'    => true,
    'cenaSpec' => true,
    'cenaKl'   => true,
    'cenaKKC'  => true,
    'dost'     => true,
];

// RULES
if ($_priceType === 'gensoft') {
    // създава нов масив с стойност false
    $_show            = array_fill_keys(array_keys($_show), false);
    $_show['cenaKKC'] = true;
} elseif ($_priceType === 'discount') {
    $_show['cenaKl'] = false;
    $_show['dost']   = false;
}

$_labelValuta = "<div class='w-50 m-auto' style='background-color:#C61111;color:#fff!important;padding:1px 6px;border-radius:4px;font-size:0.85em;'> $_currency </div>";

$_mqrka = isset($mqrka) ? array_column($mqrka, null, 'sp_mqrka_id') : [];
?>

<div id="zenova-data"
     data-zenova-id="<?= isset($ofer) && is_object($ofer) ? $ofer -> id : '' ?>">
</div>

<table id="tbl_products" class="table table-striped table-sm mt-5" cellspacing="0" width="100%">
    <thead  class="css-background">
        <tr style="background: #C61111;color: white;">
            <th class="p-1 fw-600" colspan="13">
                <span style="background: #C61111;"><?= $_dealerPricesLabel ?></span>
            </th>
        </tr>

        <tr class="css-bg-purple">
            <th colspan="2" style="text-align: left !important;  padding-left: 13px;">
                <i id="deleteSelectedProducts" class="btn-outline-danger px-1 fa fa-trash cursor-pointer" data-route="<?= route_to('Zenova-delete-products') ?>" data-toggle="tooltip"></i>
            </th> 

            <th>
                <i id="allToSite" class="btn-outline-success px-1 fa fa-check" data-route="<?= route_to('Zenova-productToSites', 'all') ?>" data-product-ids="<?= $ofer -> productsID ?? '' ?>" title="добавяне на всички продукти към сайт"></i>

                <i id="deleteFromAllSites" class="btn-outline-danger px-1 fa fa-trash" data-route="<?= route_to('Zenova-productToSites', 'all') ?>" data-product-ids="<?= $ofer -> productsID ?? '' ?>" title="премахване на всички продукти от сайт"></i>
            </th> 

            <th></th>  

            <th>
                <input id="filter" class="css-focus-strong p-2" type="search" placeholder="<?= lang('LANG__global.placeholder.filter') ?>">
            </th>

            <th colspan="9"></th>   
        </tr>

        <tr>
            <th class="w-2">               
                <input id="selectAllProducts" type="checkbox" title="Маркирай този продукт, ако желаеш да бъде изтрит">
            </th> 

            <th class="w-6"></th>
            <th class="w-2">
                <i class="fa fa-globe"></i>
            </th>
            <th class="w-5"><?= lang('LANG__zenovaOferta.tbl.th.marka') ?></th>
            <th class="w-15" data-field="name"><?= lang('LANG__zenovaOferta.tbl.th.product') ?></th>
            <th class="w-10"><?= lang('LANG__zenovaOferta.tbl.th.description') ?></th>
            <th class="w-5">Налич.</th>

            <?php if ($_show['cenaB']): ?>
                <th class="w-5">Цена B 
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($_show['cenaA']): ?>
                <th class="w-5">Цена A 
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($_show['cenaSpec']): ?>
                <th class="w-5">Цена спец. 
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($_show['cenaKl']): ?>
                <th class="w-5">Ключ. кл. 
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($_show['cenaKKC']): ?>
                <th class="w-5">ККЦ
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($_show['dost']): ?>
                <th class="w-5">Дост. цена 
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <th class="w-7"><?= lang('LANG__zenovaOferta.tbl.th.img') ?></th>
        </tr>       
    </thead>

    <tbody> 
        <?php
        if (!isset($list)) {
            return;
        }

        $_colorRows = json_decode((string) $ofer?->colorRows, true) ?? [];
        $_clRow     = [];

        foreach ($list as $key => $row) {
            $_gensoftJson = json_decode((string) $row['gensoft_json']);
            $_clRow       = generate_colorRows(['list' => $list, 'key' => $key, 'colspan' => 12, 'colorRows' => $_colorRows]);

            $_mqrka_unit = $_mqrka[$row['sp_mqrka_id']]['mqrka_unit'] ?? '';
            ?> 

            <tr class="text-center" data-id="<?= $row['product_id'] ?>"> 
                <td class="align-middle text-center fw-400">
                    <?php //$oferId -> идва от м.ф. избор на продукт  ?>
                    <input type="checkbox" class="product-check" data-ofer-id="<?= $ofer -> id ?? $oferId ?? '' ?>"  value="<?= $row['product_id'] ?>">
                    <input type="hidden" name="zenova[productsID][]" value="<?= $row['product_id'] ?>">       
                    <input type="hidden" name="zProduct[][product_id]" value="<?= $row['product_id'] ?>">
                    <input type="hidden" name="zProduct[][zenovaLista_id]" value="<?= $row['id'] ?? '' ?>"> 
                </td> 

                <td class="action align-middle text-center fw-40"> 
                    <div>
                        <?php
                        $urlParams   = array(
                            'ctrl'       => 'zenova',
                            'product_id' => $row['product_id'],
                            'arg'        => '',
                        );
                        ?>

                        <i class="delete_product btn-outline-danger p-1 border-0 fa fa-trash"
                           data-delete-route="<?= route_to('Zenova-delete-product') ?>"
                           data-ofer-id="<?= $ofer -> id ?? '' ?>"
                           title="<?= lang('LANG__global.tbl.btn.title.delete') ?>"></i>

                        <i class="edit_product btn-outline-primary p-1 border-0 fa fa-edit" data-route="<?= route_to('Popup_editProduct-open', urldecode(http_build_query($urlParams))) ?>" title="Редакция на продукт с id - <?= $row['product_id'] ?>"></i> 

                        <i class="prodAttr btn-outline-dark p-1 border-0 fa fa-info-circle" data-route="<?= route_to('Zenova-productAttrInfo', $row['product_id']) ?>" title="х-ки на продукт"></i>
                    </div>

                    <div>
                        <i class="btn-outline-dark p-1 border-0 fa fa-arrows" title="<?= lang('LANG__global.tbl.btn.title.move') ?>"></i>
                        <i class="rowPosition btn-outline-dark p-1 border-0 fa fa-list"></i>

                        <?php
                        $url         = array(
                            'curentZenovaId' => $row['zenovaLista_id'] ?? '',
                            'productId'      => $row['product_id'],
                        );
                        ?>
                        <i class="moveProductToZenova btn-outline-dark p-1 border-0 fa fa-exchange" data-route="<?= route_to('POPup_moveProductToZenova-open', urldecode(http_build_query($url))) ?>" title="преместване на продукт в ценова листа"></i>
                    </div>  

                    <?php if (empty($_ENV['app.gensoftEnable'])): ?>
                        <div>
                            <button id="clone-product" class="btn btn-outline-success border-0" data-route="<?= route_to('Popup_editProduct-clone', urldecode(http_build_query($urlParams))) ?>" data-product-name="<?= $row['product_name'] ?>" type="button" title="клониране на продукт">
                                <i class="fa fa-copy"></i>
                            </button>
                        </div> 
                    <?php endif ?>
                </td> 

                <td class="align-middle text-center fw-400 css-background">
                    <?php $_hasPrice = ((float) ($_gensoftJson -> KKC ?? 0) !== 0.0) || ((float) ($row['cenaKKC'] ?? 0) !== 0.0); ?>

                    <input class="toSite" name="toSite[<?= $row['product_id'] ?>]" 
                           data-route="<?= route_to('Zenova-productToSites', $row['product_id']) ?>" 
                           data-price='<?= json_encode([$row['cenaB'], $row['cenaA'], $row['cenaSpec'], $row['cenaKl'], $row['cenaKKC']]) ?>' 
                           data-has-kkc="<?= $_hasPrice ?>"
                           data-has-rootcat="<?= $row['categoryRoot_id'] ?? '' ?>"
                           data-has-mqrka="<?= $row['sp_mqrka_id'] ?? '' ?>"
                           type="checkbox" <?= !empty($row['sp_site_id']) ? 'checked' : '' ?> 
                           title="добавяне на продукта към всички сайтове" 
                           value="1">
                </td> 

                <td class="productBrandImg align-middle text-center fw-400">
                    <img class="mw-100 m-auto" src="<?= $row['image_brand'] != '' ? $_ENV['app.imageCasheDir'] . $row['image_brand'] . '/' . pathinfo($row['image_brand'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image_brand'], PATHINFO_EXTENSION) : '' ?>" onerror="this.onerror=null;this.src='';" data-img="<?= $row['image_brand'] ?>" alt=" ">
                </td> 

                <td class="productName align-middle text-left fw-400" <?= empty($row['gensoft_item_id']) ? '' : "title='Gensoft номеклатура: . {$row['gensoft_productName']}'" ?> data-name="<?= $row['product_name'] ?? '' ?>">

                    <?= empty($row['product_name']) ? '<b class="bg-danger">Липсва продуктово име</b><br>' . $row['gensoft_productName'] : $row['product_name'] ?>

                    <div>
                        <?php
                        if ($row['gensoft_item_id']) {
                            echo '<img class="w-20" src="' . $_ENV['app.imageDataDir'] . 'logos/genSoft.jpg" alt="">';
                        }
                        // echo $_gensoftJson -> qty_safe ?? '' ? '<p class="bg-secondary m-2">' . $_ENV['app.sklad4'] . '</p>' : '';
                        ?>  
                    </div>
                </td> 

                <td class="productDesk text-left fw-400">
                    <div class="maxHeight">
                        <?= $row['description'] ?>
                    </div>

                    <?php if (!empty($row['description'])) { ?>
                        <i class="css-icon-active fa fa-info-circle text-primary text-center d-block cursor-pointer" data-toggle="tooltip" title="<?= htmlentities($row['description']) ?>"></i> 
                    <?php } ?>
                </td> 

                <!--  наличност -->
                <td class="position-relative align-middle text-center fw-400">
                    <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);"><?= ($row['nalichnost'] ?? 0) . ' ' . $_mqrka_unit ?>
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">

                        <?php
                        if ($_gensoftJson -> kol_lock ?? null) {
                            echo '<small>запаз. - ' . $_gensoftJson -> kol_lock . $_mqrka_unit . '</small>';
                        }
                        ?> 

                        <?php if ($_ENV['app.gensoftEnable'] && !empty($row['gensoft_item_id'])): ?>

                            <button class="getGensoftInfo col btn text-primary " data-route="<?= route_to('Popup_izboProduct-getGensoftInfo') ?>" data-name="<?= $row['gensoft_productName'] ?? 'null' ?>" type="button">
                                <i class="fa fa-info-circle"></i>
                            </button>
                        <?php endif ?> 
                    </div>
                </td> 

                <?php if ($_show['cenaB']): ?>
                    <td class="align-middle text-center fw-400">
                        <?= $row['cenaB'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaB']) : '' ?>
                    </td>
                <?php endif ?>

                <?php if ($_show['cenaA']): ?>
                    <td class="align-middle text-center fw-400">
                        <?= $row['cenaA'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaA']) : '' ?>
                    </td>
                <?php endif ?>

                <?php if ($_show['cenaSpec']): ?>
                    <td class="align-middle text-center fw-400">
                        <?= $row['cenaSpec'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaSpec']) : '' ?>
                    </td>
                <?php endif ?>

                <?php if ($_show['cenaKl']): ?>
                    <td class="align-middle text-center fw-400">
                        <?= $row['cenaKl'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaKl']) : '' ?>
                    </td>
                <?php endif ?>

                <?php if ($_show['cenaKKC']): ?>
                    <td class="position-relative align-middle text-center fw-400">
                        <?php
                        $_zenaProdava = !empty($row['cenaKKC']) ? h_toFixed($row['cenaKKC'], $_isRoundedToFirst) : null;
                        $_gsKKC       = !empty($_gensoftJson -> KKC) ? h_toFixed($_gensoftJson -> KKC, $_isRoundedToFirst) : null; // gensoft KKC 

                        $_gPromoPercent = !empty($_gensoftJson -> promoPercent) && is_numeric($_gensoftJson -> promoPercent) ? (float) $_gensoftJson -> promoPercent : null; // gensoft промо % 
                        // промо цена (ако се ползва по-нататък)
                        $_promoPrice    = ($_gPromoPercent && is_numeric($_gsKKC)) ? h_toFixed($_gsKKC * (1 + $_gPromoPercent / 100), $_isRoundedToFirst) : null;
                        ?>

                        <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);">
                            <?= !empty($_zenaProdava) ? $_zenaProdava : $_gsKKC ?>
                        </div>

                        <?php if ($_promoPrice !== null && !empty($_gsKKC)): ?>
                            <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">
                                <small class="<?= $_gPromoPercent < 0 ? 'text-danger' : 'text-success' ?>">
                                    <?=
                                    sprintf(
                                            '%s %s &nbsp;(%s%%)',
                                            $_gPromoPercent > 0 ? '+' : '',
                                            $_promoPrice,
                                            $_gPromoPercent
                                    )
                                    ?>
                                </small>
                            </div>
                        <?php endif; ?>
                    </td>
                <?php endif ?>

                <?php if ($_show['dost']): ?>
                    <td class="zenaDostavna align-middle text-center fw-400 css-background">
                        <?= $row['price_dostavna'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) : '' ?>
                    </td>
                <?php endif ?>

                <td class="productImage align-middle text-center fw-400">
                    <?php
                    echo match ($row['badge_index']) {
                        '1' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></div>',
                        '2' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                        '3' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></div>',
                        '4' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></div>',
                        default => ''
                    };
                    ?>
                    <div class="d-flex">
                        <span class="<?= $row['image'] != '' ? 'fa fa-search-plus' : '' ?> position-absolute"></span>

                        <?php
                        $_imgSrc   = empty($row['image']) ? '' : $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION);
                        $_largeImg = $_ENV['app.imageDir'] . $row['image'];
                        ?>

                        <img class="zoomImg mw-100 m-auto" src="<?= $_imgSrc ?>" data-full-image="<?= $_largeImg ?>" onerror="this.onerror=null;this.src='';" alt=" ">  

                    </div>
                </td>         
            </tr> 
            <?php
            echo implode('', $_clRow);
        }
        ?> 
    </tbody> 
</table>

<?php if (!empty($totalProducts)): ?>
    <div class="d-flex col justify-content-between">
        <div>
            <span><?= lang('LANG__global.tbl.footer.total') ?></span> 
            <span class="countResults"><?= $totalProducts ?></span>
            <span>продукта</span>
        </div>


        <div>
            <label for="perPageSelect">Продукти на страница:</label>
            <select id="perPageSelect" class="form-control form-control-sm d-inline-block w-auto" 
                    onchange="window.location = '<?= route_to('Zenova-edit', $ofer -> id ?? 0) ?>?perPage=' + this.value + '&page=1'">
                        <?php foreach ($_perPageOptions as $opt): ?>
                    <option value="<?= $opt ?>" <?= ($opt == $perPage) ? 'selected' : '' ?>><?= $opt ?></option>
                <?php endforeach; ?>
            </select>
        </div>


        <ul class="pagination">
            <?= $pagination ?>
        </ul>
    </div> 
<?php endif ?>

<script>
    /**
     * Debug helper:
     * Logs current pagination parameters on page load
     */
    document.addEventListener('DOMContentLoaded', function () {
        const urlParams = new URLSearchParams(window.location.search);

        const perPage = urlParams.get('perPage');
        const page = urlParams.get('page');

        console.log('Current page:', page);
        console.log('Per page:', perPage);

        // Validate per-page select state
        const perPageSelect = document.getElementById('perPageSelect');
        if (perPageSelect && perPage) {
            console.log('Select value:', perPageSelect.value);
        }
    });

    document.addEventListener("DOMContentLoaded", function () {
        const thead = document.querySelector("thead.tableFloatingHeaderOriginal");

        if (! thead)
            return;

        const observer = new MutationObserver(() => {
            const style = window.getComputedStyle(thead);

            if (style.position === "fixed") {
                thead.style.top = "12px";
            }
        });

        observer.observe(thead, {
            attributes: true,
            attributeFilter: [ "style", "class" ]
        });
    });
</script>
