<?php

use \IonAuth\Libraries\IonAuth;

/** СИСТЕМА  ============================================== */
$routes -> group('setups', ['namespace' => 'App\Setups\Controllers'], function ($routes) {
    $routes -> add('PatchFile', 'PatchFile::index', ['as' => 'PatchFile']);
    $routes -> get('LogViewer', 'LogViewer::index', ['as' => 'LogViewer']); //логове за грешки

    $routes -> group('Nastrojka', function ($r) {
        $model    = model('App\Models\common\MODEL__global');
        $IonAuth  = new IonAuth();
        $response = array_column($model -> get__userPreferences($IonAuth -> user() -> row()?->user_id), null, 'modul_name');
        $perPage  = isset($response['seo']) ? $response['seo']['per_page'] : 10;

        $c = 'Nastrojka';

        $r -> add('index', "$c::index");

        $views = ['0', 'firma', 'set', 'sites', 'portal', 'gensoft'];
        foreach ($views as $w) {
            $r -> get("index?view={$w}", "$c::index", ['as' => "Nastrojka-{$w}"]);
        }

        $r -> get("index?view=seo&tab=seo&mode=products&page=1&perPage=$perPage", "$c::index", ['as' => "Nastrojka-seo"]);

        $r -> add('format_allPpoduktModel', "$c::format_allPpoduktModel", ['as' => 'Nastrojka-format_allPpoduktModel']);
        $r -> add('delete_site/(:num)', "$c::delete_site/$1", ['as' => 'Nastrojka-deleteSite']);
        $r -> add('save_site', "$c::save_site", ['as' => 'Nastrojka-saveSite']);
        $r -> add('save_portal?(:any)', "$c::save_portal", ['as' => 'Nastrojka-savePortal']);
        $r -> add('save/(:any)', "$c::save/$1", ['as' => 'Nastrojka-save']);

        // запис на ценообразуване
        $r -> post('save-price-type', "$c::save_price_type", ['as' => 'Nastrojka-save_price_type']);
        // запис с/без ддс
        $r -> post('save-prices-with-dds', "$c::save_prices_with_dds", ['as' => 'Nastrojka-save_prices_with_dds']);

        //$r -> get("seo?tab=seo&mode=products&page=1&perPage=$perPage", "$c::seo", ['as' => 'Nastrojka-seo']);
    });

    /** CRON DASHBOARD В НАСТРОЙКИ =============== */
    $routes -> group('CronDashboard', function ($r) {
        $c = 'CronDashboard';

        $r -> add('create', "$c::create", ['as' => 'CronDashboard-create']);

        $r -> add('toggle/(:segment)', "$c::toggle/$1", ['as' => 'CronDashboard-toggle']);
        $r -> get('status', "$c::status", ['as' => 'CronDashboard-status']);
    });

    /** DB MANAGER =============== */
    $routes -> group('DBManager', function ($r) {
        $c = 'DBManager';

        $r -> add('truncateTables', "$c::truncateTables", ['as' => 'DBManager-truncateTables']);
    });

    /** ПРЕВАЛУТИРАНЕ =============== */
    $routes -> group('Preval', function ($r) {
        $c = 'Preval';

        $r -> get('preval/checkAPI', "$c::checkAPI", ['as' => 'Preval-checkAPI']);
        $r -> get('preval/getRates', "$c::getRates", ['as' => 'Preval-getRates']);
        $r -> post('preval/updateDatabase', "$c::updateDatabase", ['as' => 'Preval-updateDatabase']);
        $r -> get('preval/getSettings', "$c::getSettings");
        $r -> post('preval/save', "$c::save", ['as' => 'Preval-save']);

        // Алтернативни маршрути за настройки 
        $r -> get('api/checkRateAPI', "$c::checkAPI");
        $r -> get('api/getRates', "$c::getRates");
        $r -> get('preval', "$c::index");

        $r -> post('api/gensoft-toggle', "$c::gensoftToggle", ['as' => 'Preval-gensoftToggle']);
    });

    /** ВАРИАЦИИ =============== */
    $routes -> group('VariationRules', function ($r) {
        $c = 'VariationRules';
        // Generate variations based on rules (single request)
        $r -> post('generate', "$c::generate", ['as' => 'VariationRules-generate']);
        // Generate variations in batch mode
        $r -> post('generate-batch', "$c::generateBatch", ['as' => 'VariationRules-generateBatch']);
        // Legacy / explicit route for batch generation (if still needed)
        $r -> post('generate-batch', "$c::generateBatch");
    });

    /** СВЪРЗАНИ ПРОДУКТИ =============== */
    $routes -> group('RelatedRules', function ($r) {
        $c = 'RelatedRules';

        $r -> post('generate-batch', "$c::generateBatch", ['as' => 'RelatedRules-generateBatch']);
        $r -> post('save', "$c::save", ['as' => 'RelatedRules-save']);
    });
});
/* =========================================================== */
