<?php

namespace App\Setups\Controllers;

use \App\Models\BaseModel;

class CronDashboard extends \App\Controllers\BaseController {

    public function index() {
        $jobs = db_connect() -> table(BaseModel::TBL_CRONJOBS)
                        -> orderBy('job_key')
                        -> get() -> getResult();

        return $jobs;
    }

    public function create() {
        $jobKey = trim($this -> request -> getPost('job_key'));
        $title  = trim($this -> request -> getPost('title'));

        if ($jobKey === '' || $title === '') {
            return json_encode([
                'success' => false,
                'message' => 'Липсващи данни'
            ]);
        }

        db_connect() -> table(BaseModel::TBL_CRONJOBS)
                -> insert([
                    'job_key' => $jobKey,
                    'title'   => $title
                ]);

        return json_encode(true);
    }

    public function toggle(string $job) {
        db_connect() -> table(BaseModel::TBL_CRONJOBS)
                -> where('job_key', $job)
                -> set('is_enabled', '1 - is_enabled', false)
                -> update();

        return json_encode(true);
    }

    public function status() {
        $jobs = db_connect() -> table(BaseModel::TBL_CRONJOBS)
                        -> orderBy('job_key')
                        -> get() -> getResult();

        $data = [
            'cronJobs' => $jobs
        ];

        $view_htmlTable = view('Setups\Views\nastrojki\page\set\VIEW__nastrojki_page-set-cronJobs', $data);

        if (preg_match('#<tbody([\s\S]*)</tbody>#i', $view_htmlTable, $matches)) {
            $modifiedTbody = preg_replace_callback('#<tr([^>]*)(>)#i', function ($matches) {
                // Check if the <tr> already has other attributes
                $attributes = isset($matches[1]) ? $matches[1] : '';
                return '<tr' . $attributes . '>';
            }, $matches[0]);

            return trim(preg_replace('#</?tbody[^>]*>#i', ' ', $modifiedTbody));
        }
    }

}
