<?php

namespace App\Setups\Controllers;

use App\Controllers\BaseController;
use \App\Setups\Models\MODEL__relatedRules;

class RelatedRules extends BaseController {

    protected MODEL__relatedRules $MODEL__relatedRules;

    public function __construct() {
        parent::__construct();
        $this -> MODEL__relatedRules = new MODEL__relatedRules();
    }

    public function save() {
        if (!$this -> request -> isAJAX()) {
            return $this -> response -> setJSON(['ok' => false]);
        }

        $settings = service('settings');
        $general  = $settings -> get('App.general') ?? [];

        $minTimer  = (int) $this -> request -> getPost('rel_min_timer');
        $crawlTime = (int) $this -> request -> getPost('rel_crawl_time');
        $productId = (int) $this -> request -> getPost('product_id');
        $field     = $this -> request -> getPost('rel_field'); // product_name, oem, kod...
        $substrLen = (int) $this -> request -> getPost('rel_substr_len');
        $likeType  = $this -> request -> getPost('rel_like_type'); // both, start, end
        $limit     = (int) $this -> request -> getPost('rel_limit');

        $sameCategory    = (int) $this -> request -> getPost('rel_same_category');
        $sameSubcategory = (int) $this -> request -> getPost('rel_same_subcategory');
        $onlyActive      = (int) $this -> request -> getPost('rel_only_active');

        $generatorSettings = [
            'min_timer'            => $minTimer * 60,
            'crawl_time'           => $crawlTime * 60,
            'rel_field'            => $field,
            'rel_substr_len'       => $substrLen,
            'rel_like_type'        => $likeType,
            'rel_limit'            => $limit,
            'rel_same_category'    => $sameCategory,
            'rel_same_subcategory' => $sameSubcategory,
            'rel_only_active'      => $onlyActive,
        ];

        $general['related_generator'] = $generatorSettings;
        $settings -> set('App.general', $general);

        if (!$productId) {
            return $this -> response -> setJSON([
                        'ok'  => true,
                        'msg' => '✓ Настройките са запазени (без генериране на свързани продукти)',
            ]);
        }

        $baseProduct = $this -> MODEL__relatedRules -> get_baseProduct($productId);

        if (!$baseProduct) {
            return $this -> response -> setJSON([
                        'ok'  => false,
                        'msg' => 'Основните продукт не е намерен',
            ]);
        }

        $baseValue = $baseProduct[$field] ?? '';

        if (!$baseValue) {
            return $this -> response -> setJSON([
                        'ok'  => false,
                        'msg' => 'Основното поле е празно',
            ]);
        }

        $needle = mb_substr($baseValue, 0, $substrLen);

        $like = match ($likeType) {
            'start' => $needle . '%',
            'end' => '%' . $needle,
            default => '%' . $needle . '%',
        };

        $rows = $this -> MODEL__relatedRules -> get_relatedProducts($productId, $baseProduct, [
            'field'           => $field,
            'like'            => $like,
            'like_type'       => $likeType, // both | start | end
            'limit'           => $limit,
            'onlyActive'      => $onlyActive,
            'sameCategory'    => $sameCategory,
            'sameSubcategory' => $sameSubcategory,
        ]);

        $res = $this -> MODEL__relatedRules -> save_relatedProducts($productId, $rows);

        $relatedIds = $res['ids'];
        return $this -> response -> setJSON([
                    'ok'          => true,
                    'msg'         => '✓ Настройките са запазени и продуктът е обновен',
                    'product_id'  => $productId,
                    'needle'      => $needle,
                    'like'        => $like,
                    'related_ids' => $relatedIds,
                    'count'       => count($relatedIds),
        ]);
    }

    private function generateForSingleProduct(int $productId) {
        $general = service('settings') -> get('App.general') ?? [];
        $cfg     = $general['related_generator'] ?? [];

        $field           = $cfg['rel_field'] ?? 'product_name';
        $substrLen       = (int) ($cfg['rel_substr_len'] ?? 10);
        $likeType        = $cfg['rel_like_type'] ?? "both";
        $limit           = (int) ($cfg['rel_limit'] ?? 10);
        $sameCategory    = !empty($cfg['rel_same_category']);
        $sameSubcategory = !empty($cfg['rel_same_subcategory']);
        $onlyActive      = !empty($cfg['rel_only_active']);

        $baseProduct = $this -> MODEL__relatedRules -> get_baseProduct($productId);

        if (!$baseProduct) {
            return false;
        }

        $baseValue = $baseProduct[$field] ?? '';

        if (!$baseValue) {
            return false;
        }

        $needle = mb_substr($baseValue, 0, $substrLen);

        if (!$needle) {
            return false;
        }

        if ($likeType === 'start') {
            $like = $needle . '%';
        } elseif ($likeType === 'end') {
            $like = '%' . $needle;
        } else {
            $like = '%' . $needle . '%';
        }

        // SEARCH
        $rows = $this -> MODEL__relatedRules -> р($productId, $baseProduct, [
            'field'           => $field,
            'like'            => $like,
            'like_type'       => $likeType,
            'limit'           => $limit,
            'onlyActive'      => $onlyActive,
            'sameCategory'    => $sameCategory,
            'sameSubcategory' => $sameSubcategory,
        ]);

        $res = $this -> MODEL__relatedRules -> save_relatedProducts($productId, $rows);

        $relatedIds = is_array($res) ? $res['ids'] : [];

        return [
            'product_id'  => $productId,
            'needle'      => $needle,
            'like'        => $like,
            'count'       => count($relatedIds),
            'related_ids' => $relatedIds,
        ];
    }

    public function generateBatch() {
        if (!$this -> request -> isAJAX()) {
            return $this -> response -> setJSON(['ok' => false]);
        }

        $offset = (int) $this -> request -> getPost('offset');
        $limit  = (int) $this -> request -> getPost('limit');

        if (!$limit) {
            $limit = 50;
        }

        $products = $this -> MODEL__relatedRules -> get_activeProductsBatch($limit, $offset);

        if (empty($products)) {
            return $this -> response -> setJSON([
                        'ok'        => true,
                        'processed' => 0,
                        'done'      => true
            ]);
        }


        $processed = count($products);
        foreach ($products as $p) {
            $this -> generateForSingleProduct((int) $p['product_id']);
        }

        return $this -> response -> setJSON([
                    'ok'        => true,
                    'processed' => $processed,
                    'done'      => false,
                    'offset'    => $offset,
                    'limit'     => $limit,
        ]);
    }

}
