<?php
$_link         = $_GET['link'] ?? '';
$_key          = $_GET['key'] ?? '';
$_activeView   = $_GET['view'] ?? '';
$_allowedViews = ['set', 'firma', 'gensoft', 'portal', 'seo'];

$_breadcrumb = <<<HTML
<ol class="breadcrumb bg-transparent mb-1 p-1">
    <li class="breadcrumb-item font-italic">
        <a class="fa fa-home" href="/"></a>
    </li>
    <li class="breadcrumb-item"><i>Настройки</i></li>
    <li class="breadcrumb-item"><i>Общи настройки</i></li>
    <li class="breadcrumb-item"><i id="mainLink"></i></li>
    <li class="breadcrumb-item"><b id="activeLink" class="fw-bold px-1 bg-secondary"></b></li>
</ol>
HTML;
?>

<div class="content-wrapper css-nomargin m-0 pb-0">
    <header class="content-header py-0 bg-primary text-white" style="background-color: #023585 !important;">
    </header>

    <div id="infoMessage"> <?= $message ?? '' ?> </div>

    <div class="content" style="padding-top:50px">
        <?php if ($_activeView !== 'portal'): ?>
            <form id="form-settings" class="tabs-body tab-content" name="form-settings"
                  action="<?= route_to('Nastrojka-save', $_activeView) ?>" method="post"
                  onkeydown="return event.key !== 'Enter';">
                      <?php
                      echo match ($_activeView) {
                          'set' => view($view['set'], ['_breadcrumb' => $_breadcrumb]),
                          'firma' => view($view['firma'], ['_breadcrumb' => $_breadcrumb]),
                          'gensoft' => view($view['gensoft'], ['_breadcrumb' => $_breadcrumb]),
                          'seo' => view($view['seo'], ['_breadcrumb' => $_breadcrumb]),
                          default => ''
                      };
                      ?>
            </form>
        <?php else: ?>
            <?= view($view['portal'], ['_breadcrumb' => $_breadcrumb]) ?>
        <?php endif; ?>
    </div>
</div>

<script>
    var LANG__nastrojki = <?= json_encode(lang('LANG__nastrojki.js')); ?>
</script>
