<?php
if (!function_exists('renderSelect')) {

    function renderSelect($gensoft, $key, $kasi_banki, $env_sklad, $i) {
        ?>
        <div class="section-title w-50"><?= $env_sklad ?></div>
        <h6 class="text-muted mb-2">Банки и каси <?= $env_sklad ?></h6>

        <?php foreach (['B' => 'По банка', 'K' => 'В брой'] as $kbTip => $label): ?>

            <label class="form-label"><?= $label ?></label>

            <select class="css-dropdown-p css-focus-strong css-border-none w-100 mb-2" name="settings[kasaBanki][<?= $i ?>][<?= $kbTip ?>]">
                <option value=""></option>
                <?php foreach ($kasi_banki ?? [] as $row):
                    ?>
                    <?php
                    if ($row['kb_tip'] === $kbTip):
                        $_selected = ($gensoft -> kasaBanki[$i][$kbTip] ?? '') == $row['kb_id'] ? 'selected' : '';
                        ?>
                        <option value="<?= $row['kb_id'] ?>" <?= $_selected ?>>
                            <?= $row['kb_name'] ?>
                        </option>
                    <?php endif; ?>
                <?php endforeach; ?>
            </select>
        <?php endforeach; ?>

        <hr>

        <div class="row">
            <label class="col-md-5">Характеристика №</label>
            <div class="col-md-2">
                <input type="text" class="css-input-p css-focus-strong css-border-none" name="settings[props][key<?= $key ?>]" value="<?= $gensoft -> props['key' . $key] ?? '' ?>">
            </div>
            <label class="col-md-3 text-right">Стойност</label>
            <div class="col-md-2">
                <input type="text" class="css-input-p css-focus-strong css-border-none" name="settings[props][val<?= $key ?>]" value="<?= $gensoft -> props['val' . $key] ?? '' ?>">
            </div>
        </div>


        <?
    }

}
?>
<!--  ==== Таб данни на фирмата ============ -->
<section id="tab-firma" class="tab-pane fade active show" role="tabpanel"> 
    <br>

    <div class="container">
        <div class="row">
            <!-- Навигационни табове -->
            <nav class="col-3 p-0" aria-label="Настройки">
                <ul class="nav nav-tabs flex-column py-2 left-tabs" id="accordionMenu" role="tablist" style="box-shadow: 10px 3px 5px #6f6f6f;">
                    <li class="nav-item">
                        <a class="nav-link pl-2" data-toggle="tab" href="#tab-db" role="tab" style="font-size:16px">
                            <i class="fa fa-cogs"></i>&nbsp;Gensoft база данни
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link pl-2 active" data-toggle="tab" href="#tab-order" role="tab" style="font-size:16px">
                            <i class="fa fa-link"></i>&nbsp;Gensoft поръчка
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link pl-2" data-toggle="tab" href="#tab-cron" role="tab" style="font-size:16px">
                            <i class="fa fa-link"></i>&nbsp;Gensoft Cron Job задачи
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="js-passwordRequired nav-link pl-2" data-toggle="tab" href="#tab-sql" role="tab" style="font-size:16px">
                            <i class="fa fa-link"></i>&nbsp;Gensoft sql заявки
                        </a>
                    </li>
                </ul>
            </nav>

            <!-- Съдържание на табовете -->
            <main class="col css-background pb-2" style="box-shadow: 6px 9px 10px #6f6f6f;">

                <section class="tab-content px-4 py-2">
                    <? // $_breadcrumb ?>

                    <hr class="nav-tabs">

                    <!-- ===========  База данни =============== -->
                    <article class="tab-pane" id="tab-db">
                        <div class="mb-1 row">
                            <label class="col-5">Gensoft път до база данни <?= $_ENV['app.baseSklad'] ?></label>
                            <p class="col mb-1">
                                <input class="css-input-p css-focus-strong css-border-none" type="text" name="settings[gensoftSrv]" value="<?= $gensoft -> gensoftSrv ?? '' ?>">
                            </p>  
                        </div>

                        <div class="mb-1 row">
                            <label class="col-5">Gensoft път до база данни <?= $_ENV['app.sklad4'] ?></label>
                            <p class="col mb-1">
                                <input class="css-input-p css-focus-strong css-border-none" type="text" name="settings[gensoftSrv2]" value="<?= $gensoft -> gensoftSrv2 ?? '' ?>">
                            </p>  
                        </div> 
                    </article>

                    <!-- ============== Поръчка ============== -->
                    <article class="tab-pane active" id="tab-order">
                        <div class="section-box py-3 mt-4">
                            <div class="section-title w-25">Превозвач</div>

                            <?= empty($kontragents) ? '<div>Няма клиенти в базата данни</div>' : '' ?>

                            <?php
                            $transportOptions = [
                                'S'  => 'Speedy',
                                'E'  => 'Еконт',
                                'F'  => 'Фирмен транспорт',
                                'ST' => 'Собствен транспорт'
                            ];
                            $_priceLevel      = $gensoft -> prevoz ?? '';
                            ?>

                            <!-- Превозвачи -->
                            <?php foreach ($transportOptions as $key => $transport): ?>
                                <div class="form-group row align-items-center">
                                    <label class="col-3"><?= $transport ?></label>
                                    <div class="col">
                                        <select class="css-dropdown-p css-focus-strong css-border-none w-100" name="settings[prevoz][<?= $key ?>]">
                                            <option value=""></option>
                                            <?php foreach ($kontragents ?? [] as $row): ?>
                                                <?php
                                                if ($row['tip'] === 'P'):
                                                    $_selected = ($gensoft -> prevoz[$key] ?? '') === $row['klient_name'] ? 'selected' : '';
                                                    ?>
                                                    <option value="<?= $row['klient_name'] ?>" <?= $_selected ?>>
                                                        <?= $row['klient_name'] ?>
                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                        </div>

                        <!-- Банки и каси -->
                        <div class="row my-4">
                            <div class="col-md-6">    
                                <div class="section-box py-4">
                                    <?php
                                    if (!empty($kasi_banki[0])) {
                                        renderSelect($gensoft, '', $kasi_banki[0] ?? [], $_ENV['app.baseSklad'], 1);
                                    }
                                    ?>
                                </div>
                            </div>

                            <div class="col-md-6">    
                                <div class="section-box py-4">
                                    <?php
                                    if (!empty($kasi_banki[1])) {
                                        renderSelect($gensoft, 2, $kasi_banki[1] ?? [], $_ENV['app.sklad4'], 2);
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>


                        <!-- Характеристики -->

                    </article>

                    <!-- Cronjob задачи -->
                    <article class="tab-pane" id="tab-cron">
                        <div class="row">
                            <p><label>Легенда:</label>&nbsp;Определяне кое ценово ниво да бъде присвоено, като цена на едро(крайно клиентската цена автоматично ще бъде присвоена на цена на дребно) за актуализиране на цените в Генсофт автоматично на всяка минута.</p>

                            <label  class="col-3">Цена на едро<b class="text-red">*</b></label>

                            <p class="col">
                                <?php
                                $_priceLevel = $gensoft -> priceLevel ?? '';

                                $_options = [
                                    'cenaB'    => 'цена B',
                                    'cenaA'    => 'цена А',
                                    'cenaSpec' => 'цена Специална',
                                    'cenaKl'   => 'цена Ключов клиент'
                                ];
                                ?>

                                <select class="validate css-dropdown-p css-focus-strong css-border-none w-100" name="settings[priceLevel]">
                                    <option value=""></option>
                                    <?php foreach ($_options as $value => $label): ?>
                                        <option value="<?= $value ?>" <?= $_priceLevel === $value ? 'selected' : '' ?>><?= $label ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </p>  
                        </div>
                    </article>

                    <!-- Gensoft sql заявки -->
                    <article class="tab-pane" id="tab-sql">
                        <h5>Създаване на колонота ITEM_ID за таблиците STOKI, STOKI_DEF, SER_NO</h5>

                        <button class="sql btn p-1 btn-warning rounded-0" data-route="<?= route_to('Cron-gensoftPrepareDb') ?>" type="button">
                            <i class="fa fa-plus"></i>&nbsp;Подготовка на Gensoft база данни при първо инициализиране</button>

                        <br><br>

                        Резултат:&nbsp;<span></span>
                    </article> 
                </section> 

                <button class="js-saveForm btn p-1 btn-primary float-right rounded-0" type="submit">
                    <i class="fa fa-save m-1"></i>&nbsp;<?= lang('LANG__global.btn.save') ?>
                </button>

            </main>

        </div><!-- end row -->
    </div><!-- end container -->
</section> <!-- end tab фирма-->

