<?php
$tab                 = 'seo';
$_userPreferences    = array_column($userPreferences ?? [], null, 'modul_name');
$_userPreferencesTip = $_userPreferences[$tab] ?? [];
?>

<div id="currentView" class="visibleCols css-background d-flex justify-content-end" data-view="<?= $tab ?>">
    <div class="p-2">
        <label class="fw-500"><?= lang('LANG__global.perPage.labelTxt') ?> 
            <?php
            $perPageParams       = urldecode(http_build_query([
                'user_preferences_id' => $_userPreferencesTip['user_preferences_id'] ?? '',
                'tab'                 => $tab]))
            ?>
            <select id="perPage" class="css-dropdown-p css-focus-strong css-border-none input-sm py-2" data-id="<?= $_userPreferencesTip['user_preferences_id'] ?? '' ?>" data-route="<?= route_to('BaseController-userPreferences', $perPageParams) ?>">
                <?php foreach ([10, 25, 50, 100] as $opt) : ?>
                    <option <?= ( $_userPreferencesTip['per_page'] ?? '') == $opt ? 'selected' : '' ?> value="<?= $opt ?>"><?= $opt ?></option>
                <?php endforeach; ?>
            </select> 
            <?= lang('LANG__global.perPage.labelTxt2') ?></label>  
    </div>
</div> 

<div class="container-fluid">
    <? // $_breadcrumb ?>

    <div class="card shadow-sm border-0 mb-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center py-3 rounded-top">
            <h4 class="mb-0 fw-semibold">
                <i class="fa fa-search me-2"></i> SEO настройки
            </h4>

            <div class="d-flex align-items-center justify-content-end flex-nowrap" style="gap: 10px;">

                <div class="seo-control seo-category-filter <?php echo $_GET['mode'] === 'categories' ? 'd-none' : '' ?>">
                    <select id="seoCategory" class="form-select form-select-sm">
                        <option value="">Всички категории</option>
                    </select>
                </div>

                <div class="seo-control">
                    <select id="seoMode" class="form-select form-select-sm">
                        <option <?= ($_GET['mode'] ?? '') === 'products' ? 'selected' : '' ?> value="products">Продукти</option>
                        <option  <?= ($_GET['mode'] ?? '') === 'categories' ? 'selected' : '' ?> value="categories">Категории</option>
                    </select>
                </div>

                <div class="seo-control">
                    <input type="text" id="seoSearch" class="form-control form-control-sm"
                           placeholder="Търси по име..." value="<?= $_GET['search'] ?? '' ?>">
                </div>
            </div>
        </div>
    </div>

    <div id="seoAlert"
         class="alert alert-dismissible fade show d-none"
         role="alert">
        <span id="seoAlertText"></span>
        <button type="button" class="btn-close" aria-label="Close"></button>
    </div>

    <div class="seo-toolbar">
        <button id="btnAutoAll"
                class="btn btn-warning btn-sm seo-btn-main"
                data-route="<?= route_to('SeoController-autoGenerateAll') ?>"
                title="Автоматично генерирай SEO за всички продукти"
                type="button">
            <i class="fa fa-magic me-1"></i> Автоматично генериране
        </button>

        <div class="seo-bulk-actions">
            <button type="button" id="btnNoindexSelected" class="btn btn-danger btn-sm" data-route="<?= route_to('SeoController-bulkIndex') ?>">
                <i class="fa fa-check me-1"></i> Noindex избрани
            </button>

            <button type="button" id="btnIndexSelected" class="btn btn-success btn-sm" data-route="<?= route_to('SeoController-bulkNoindex') ?>">
                <i class="fa fa-ban me-1"></i> Index избрани
            </button>
        </div>
    </div>

    <div id="renderHtml" class="card shadow-sm border-0">
        <div  class="table-responsive">
            <table id="seoTable" class="table table-hover table-striped align-middle mb-0">
                <thead class="bg-primary text-white sticky-top">
                    <tr>
                        <th width="35">
                            <input type="checkbox" id="checkAll">
                        </th>
                        <th>Име</th>
                        <th width="200">SEO Title</th>
                        <th width="250">SEO Description</th>
                        <th width="150">Ключови думи</th>
                        <th width="180">Canonical URL</th>
                        <th width="120">Slug</th>
                        <th width="60" class="text-center">noindex</th>
                        <th width="80" class="text-center">Auto</th>
                    </tr>
                </thead>

                <tbody class="bg-white">
                    <tr id="loadingRows" class="hide">
                        <td colspan="9" class="text-center text-muted py-3">
                            <i class="fa fa-spinner fa-spin me-1"></i> Зареждане...
                        </td>
                    </tr>
                    <?php if (empty($seo['list'])): ?>
                        <tr id="notResultsFound">
                            <td colspan="9" class="text-center text-danger py-3">
                                Няма намерени записи
                            </td>
                        </tr>
                        <?php
                    else:
                        foreach ($seo['list'] as $row):
                            ?>
                            <tr data-id="<?= (int) ($row['seo_id'] ?? 0) ?>"
                                data-pid="<?= (int) ($row['product_id'] ?? 0) ?>"
                                data-cid="<?= (int) ($row['category_id'] ?? 0) ?>">
                                <td>
                                    <input type="checkbox" class="row-check">
                                </td>

                                <td><?= $row['name'] ?? '-' ?></td>

                                <td>
                                    <input class="seo-field form-control form-control-sm"
                                           name="seo_title"
                                           data-route="<?= route_to('SeoController-save') ?>"
                                           value="<?= esc($row['seo_title'] ?? '') ?>">
                                </td>

                                <td>
                                    <textarea class="seo-field form-control form-control-sm"
                                              name="seo_description"
                                              data-route="<?= route_to('SeoController-save') ?>"><?= $row['seo_description'] ?? '' ?>
                                    </textarea>
                                </td>

                                <td>
                                    <input class="seo-field form-control form-control-sm "
                                           name="focus_keyword"
                                           data-route="<?= route_to('SeoController-save') ?>"
                                           value="<?= $row['focus_keyword'] ?? '' ?>">
                                </td>

                                <td>
                                    <input class="seo-field form-control form-control-sm "
                                           name="canonical_url"
                                           data-route="<?= route_to('SeoController-save') ?>"
                                           value="<?= $row['canonical_url'] ?? '' ?>">
                                </td>

                                <td>
                                    <input class="seo-field form-control form-control-sm "
                                           name="seo_slug"
                                           data-route="<?= route_to('SeoController-save') ?>"
                                           value="<?= $row['seo_slug'] ?? '' ?>" >
                                </td>

                                <td class="text-center">
                                    <input class="seo-field form-check-input"
                                           name="noindex"
                                           data-route="<?= route_to('SeoController-save') ?>"
                                           type="checkbox"
                                           <?= !empty($row['noindex']) ? 'checked' : '' ?>>
                                </td>

                                <td class="text-center">
                                    <button class="btnAutoSEO btn btn-sm btn-secondary" data-route="<?= route_to('SeoController-autoGenerate') ?>" type="button">
                                        <i class="fa fa-magic"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach ?>
                    <?php endif ?> 
                </tbody>
            </table>

            <div class="d-flex col p-2 justify-content-between">
                <div>
                    <span><?= lang('LANG__global.tbl.footer.total') ?></span> 
                    <span class="countResults"><?= $seo['totalRows'] ?? '' ?></span>
                    <span><?= lang('LANG__global.tbl.footer.records') ?></span>
                </div>
                <ul class="pagination">
                    <?= $seo['pagination'] ?? '' ?>
                </ul>
            </div> 
        </div>
    </div>
</div>
