<!--  ==== Таб настройки на системата ============ -->
<div class="container">
    <br>
    <div class="row">
        <!-- Навигационни табове -->
        <aside class="col-3 p-0">
            <ul class="nav nav-tabs flex-column pr-2 left-tabs" id="accordionMenu" role="tablist" style="box-shadow: 10px 3px 5px #6f6f6f;">
                <li class="nav-item">
                    <a class="nav-link active pl-2" data-toggle="tab" href="#tab-general" role="tab" style="font-size:16px">
                        <i class="fa fa-cogs"></i>&nbsp;Генерални
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link pl-2" data-toggle="tab" href="#tab-courier" role="tab" style="font-size:16px">
                        <i class="fa fa-link"></i>&nbsp;Данни за куриер
                    </a>
                </li>

                <li class="nav-item">
                    <a class="js-passwordRequired nav-link pl-2" data-toggle="tab" href="#tab-zenoobr" role="tab" style="font-size:16px">
                        <i class="fa fa-link"></i>&nbsp;Ценообразуване
                    </a>
                </li>

                <li class="nav-item">
                    <a class="js-passwordRequired nav-link pl-2" data-toggle="tab" href="#tab-preval" role="tab" style="font-size:16px">
                        <i class="fa fa-exchange"></i>&nbsp;Превалутиране
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link pl-2" data-toggle="tab" href="#tab-func" role="tab" style="font-size:16px">
                        <i class="fa fa-link"></i>&nbsp;Функции
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link pl-2" data-toggle="tab" href="#tab-cronJоbs" role="tab" style="font-size:16px">
                        <i class="fa fa-link"></i>&nbsp;Cron Jobs задачи
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link pl-2" data-toggle="tab" href="#tab-related" role="tab" style="font-size:16px">
                        <i class="fa fa-link"></i>&nbsp;Свързани продукти
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link pl-2" data-toggle="tab" href="#tab-variations" role="tab" style="font-size:16px">
                        <i class="fa fa-random"></i>&nbsp;Генериране на вариации
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link pl-2" data-toggle="tab" href="#tab-db" role="tab" style="font-size:16px">
                        <i class="fa fa-database"></i>&nbsp;База данни
                    </a>
                </li>
            </ul>
        </aside>


        <!-- Съдържание на табовете -->
        <main class="col p-2 css-background" style="box-shadow: 6px 9px 10px #6f6f6f;">
            <section class="tab-content px-3 py-2">
                <? // $_breadcrumb ?>
                <!-- Общи настройки -->
                <?= view($view['page']['set']['general']) ?>
                <!--  Данни за куриер  -->
                <?= view($view['page']['set']['curier']) ?>
                <!-- Ценобразуване -->
                <?= view($view['page']['set']['zenoobr']) ?>
                <!-- Превалутиране -->
                <?= view($view['page']['set']['preval']) ?>
                <!-- Функции -->
                <?= view($view['page']['set']['func']) ?>
                <!-- cronJobs -->
                <?= view($view['page']['set']['cronJobs']) ?>
                <!-- related view  -->
                <?= view($view['page']['set']['related'], ['rules' => $rules ?? []]) ?>
                <!-- variation generator view -->
                <?= view($view['page']['set']['variation_generator'], ['rules' => $rules ?? []]) ?>
                <!-- База данни -->
                <?= view($view['page']['set']['db']) ?>
            </section>
        </main>
    </div>
</div>
<script>
    $(document).ready(function () {

        /**
         * Read GET parameter from URL
         */
        function getQueryParam (name) {
            return new URLSearchParams(window.location.search).get(name);
        }

        /**
         * Activate tab by name (example: "preval")
         */
        function activateTab (tabName) {
            const tabId = '#tab-' + tabName;

            const $link = $('a[data-toggle="tab"][href="' + tabId + '"]');
            const $pane = $(tabId);

            if (! $link.length || ! $pane.length) {
                return;
            }

            // Remove active/show from all tabs
            $('.nav-link').removeClass('active');
            $('.tab-pane').removeClass('active show');

            // Activate requested tab
            $link.addClass('active');
            $pane.addClass('active show');
        }

        /**
         * MAIN LOGIC:
         * If URL contains ?tab=preval → open Preval tab
         */
        const tabFromUrl = getQueryParam('tab');

        if (tabFromUrl) {
            activateTab(tabFromUrl);
        }

    });
</script>
