<?php
//$request = \Config\Services::request();
$settings = service('settings') -> get('App.general') ?? [];

/* --- Основни настройки ------------------------------------ */
$preval   = $settings['preval'] ?? [];
$currency = $preval['base_currency'] ?? 'BGN';

/* --- Валута ---------------------------------------------- */
$_default_valutaCode   = $currency;
$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв',
};

$_text   = json_decode($portal_setings -> text ?? '[]', true);
$_emails = $_text['email'] ?? [];
$_order  = $_text['order'] ?? [];
?>

<!-- ================  Email Settings ======================== -->
<section class="section-box pt-4 mt-4">
    <div class="section-title">Имейли за поръчки</div>

    <div class="form-group row align-items-center">
        <label class="col-6">Email за получаване на поръчки основен <b class="text-red font-size-14">*</b></label>
        <div class="col">
            <input class="css-input-p css-focus-strong css-border-none" name="settings[text][email][systemEmail]" type="email" value="<?= $_emails['systemEmail'] ?? '' ?>" required>
        </div>
    </div>

    <div class="form-group row align-items-center">
        <label class="col-6 align-self-baseline">
            Еmail за получаване на поръчки допълнителни <small class="text-muted font-size-13">(разделяйте с запетая)</small>
        </label>

        <div class="col">
            <input class="css-input-p css-focus-strong css-border-none" name="settings[text][email][additional]" type="text" value="<?= $_emails['additional'] ?? '' ?>">
        </div>
    </div>

    <div class="form-group row align-items-center">
        <label class="col-6">Email за получаване - заявка за дилър <b class="text-red font-size-14">*</b></label>

        <div class="col">
            <input class="css-input-p css-focus-strong css-border-none" name="settings[text][email][dilarEmail]" type="email" value="<?= $_emails['dilarEmail'] ?? '' ?>" required>
        </div>
    </div> 
</section>

<br>

<!-- ============= блок Атрибути на поръчката ========================= -->
<section class="section-box pt-4 mt-4">
    <div class="section-title">Атрибути на поръчката</div>

    <div class="row">
        <div class="col-6">
            <div class="form-group row align-items-center">
                <label class="col-5">Мин. сума с ДДС (<?= $_default_valutaSymbol ?>):</label>
                <div class="col">
                    <input class="css-input-p css-focus-strong css-border-none" name="settings[text][order][minPrice]"  data-isNumeric type="text" value="<?= $_order['minPrice'] ?? '' ?>">
                </div>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-5">Транспортни разходи (<?= $_default_valutaSymbol ?>):</label>
                <div class="col">
                    <input class="css-input-p css-focus-strong css-border-none" id="deliveryPrice" name="settings[text][order][deliveryPrice]" data-isNumeric type="text" value="<?= $_order['deliveryPrice'] ?? 0 ?>">
                    <small class="form-text text-muted">Оставете 0, ако не се показва</small>
                </div>
            </div>

            <!-- БЕЗПЛАТНА ДОСТАВКА -->
            <div class="form-group row align-items-center">
                <label class="col-5">Безплатна доставка Дилър (<?= $_default_valutaSymbol ?>):</label>
                <div class="col-2">
                    <input class="css-input-p css-focus-strong css-border-none" name="settings[text][order][freeDostavkaPrice]"  data-isNumeric type="text" value="<?= $_order['freeDostavkaPrice'] ?? '' ?>">
                </div>

                <label class="ml-auto">Диапазон:</label>
                <div class="col-2">
                    <input class="css-input-p css-focus-strong css-border-none" name="settings[text][order][freeDostavkaLeftPrice]"  data-isNumeric type="text" value="<?= $_order['freeDostavkaLeftPrice'] ?? '' ?>">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-5">Безплатна доставка Клиент (<?= $_default_valutaSymbol ?>):</label>
                <div class="col-2">
                    <input class="css-input-p css-focus-strong css-border-none" name="settings[text][order][freeDostavkaKlPrice]"  data-isNumeric type="text" value="<?= $_order['freeDostavkaKlPrice'] ?? '' ?>">
                </div>

                <label class="ml-auto">Диапазон:</label>
                <div class="col-2">
                    <input class="css-input-p css-focus-strong css-border-none" name="settings[text][order][freeDostavkaKlLeftPrice]"  data-isNumeric type="text" value="<?= $_order['freeDostavkaKlLeftPrice'] ?? '' ?>">
                </div>
            </div> 
        </div>

        <div class="col-6">
            <!-- ТЕЛЕФОН -->
            <div class="form-group row align-items-baseline">
                <label class="col-5">Телефон за бърза поръчка:</label>
                <div class="col">
                    <input id="fastOrderTel" class="mask css-input-p css-focus-strong css-border-none" data-inputmask = "'mask': '+35\\9 999-999-999'"  name="settings[text][order][fastOrderTel]" data-isNumeric type="tel" value="<?= $_order['fastOrderTel'] ?? '' ?>">
                    <small class="text-muted font-size-13">(формат +359 899-ххх-ххх )</small>
                </div>
            </div>
        </div>
    </div>
</section>

