<article class="tab-pane fade" id="tab-cronJоbs">
    <h4 class="text-center">🕒 CRON JOBS АВТОМАТИЗИРАНИ ЗАДАЧИ</h4>

    <hr class="nav-tabs"> 

    <div id="accordion"class="info-multi round-10" style="background: transparent;">
        <div class="card" style="background: transparent;border: 1px solid #fff;">
            <div>
                <h5 class="mb-0">
                    <button class="btn btn-link" data-toggle="collapse" data-target="#collapseOne">
                        <i class="fa fa-info-circle"></i>
                        <span>Легенда</span>
                    </button>
                </h5>
            </div>

            <div id="collapseOne" class="collapse show" data-parent="#accordion">
                <div class="card-body row">
                    <div class="col-3">
                        <p class="cron-desc">
                            Cron задачите се използват за автоматично изпълнение
                            на системни процеси без намеса на потребител
                            <span>(импорт, синхронизация, почистване и обновяване на данни)</span>
                        </p>
                    </div>

                    <div class="col">
                        <ul class="cron-legend-list">
                            <li>🟢 <strong>Активно</strong> – задачата се изпълнява по график</li>
                            <li>🔴 <strong>Неактивно</strong> – задачата е изключена</li>
                            <li>🟠 <strong>Изпълнява се</strong> – в момента е активна</li>
                            <li>🕒 <strong>Последно изпълнение</strong> – последен успешен старт</li>
                        </ul>

                        <div class="cron-command">
                            <strong>Сървърна Cron команда</strong>
                            <code>
                                /opt/cpanel/ea-php81/root/usr/bin/php
                                /home/<b>rnr75</b>/public_html/<b>oferta.com/cronJobs/
                                    CRON__import.php</b>
                            </code>

                            <small>
                                Забележка:Cron класът трябва предварително да е създаден в директорията cronJobs!<br>
                                <b>rnr75</b> – потребител в хостинга<br>
                                <b>oferta.com</b> – директория на проекта<br>
                                <b>cronJobs</b> – директория на cron задачите<br>
                                <b>CRON__import.php</b> – Файл за Cron клас
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="addCronForm" class="d-flex gap-3">
        <div class="gap-2">
            <label class="text-muted mb-0">Cron клас</label>
            <input
                class="css-input-p css-focus-strong css-border-none"
                type="text"
                name="job_key"
                placeholder="Пример: CRON__ImpProduct"
                required>
        </div>

        <div class="gap-2">
            <label class="text-muted mb-0">Cron Задача</label>
            <input
                class="css-input-p css-focus-strong css-border-none"
                type="text"
                name="title"
                placeholder="описание на задачата"
                required
                >
        </div>

        <div class="pt-3">
            <button id="js-createCronJob" 
                    class="btn p-1 btn-primary round-10" 
                    data-route="<?= route_to('CronDashboard-create') ?>"
                    data-route-refresh="<?= route_to('CronDashboard-status') ?>"
                    type="button">
                Добави
            </button>
        </div>
    </div>

    <br>


    <table class="table table-striped table-sm" cellspacing="0" width="100%">
        <thead class="css-bg-purple">
            <tr>
                <th class="w-40">Задача</th>
                <th class="w-13">Последно изпълена</th>
                <th class="w-15">Статус</th>
                <th>Състояние</th>
                <th class="col-3">Действия</th>
            </tr>
        </thead>

        <tbody id="cronTBody">
            <?php
            foreach ($cronJobs as $j):
                // skip на cron задачите от Gensoft
                if (!$_ENV['app.gensoftEnable'] && str_contains($j -> title, 'Gensoft')) {
                    continue;
                }
                ?>
                <tr>
                    <td class="text-left"><?= $j -> title ?>
                        <br>
                        <small>Cron клас: <?= $j -> job_key ?></small>
                    </td>
                    <td>
                        <?= $j -> last_run ?? '—' ?>
                        <?= $j -> last_status ?? '' ?>
                    </td>

                    <td>
                        <?php if ($j -> is_running): ?>
                            <span class="badge running">Изпълнява се</span>
                        <?php endif ?>
                    </td>

                    <td>
                        <span class="badge-<?= $j -> is_enabled ? 'enabled' : 'disabled' ?> round-10 p-1 fw-bold">
                            <?= $j -> is_enabled ? 'Активно' : 'Неактивно' ?>
                        </span>
                    </td>

                    <td>
                        <div class="d-flex">
                            <a class="btn bg-primary round-10 mr-2 p-1"
                               href="/cronJobs/debug/Debug_<?= $j -> job_key ?>.php" 
                               target="_blank">
                                <i class="fa fa-info-circle"></i> Debug
                            </a>

                            <?php if ((int) $j -> is_enabled === 1): ?>

                                <!-- ⛔ STOP – когато задачата върви -->
                                <a class="js-action btn bg-red round-10  p-1"
                                   href="#"
                                   data-route="<?= route_to('CronDashboard-toggle', $j -> job_key) ?>"
                                   data-route-refresh="<?= route_to('CronDashboard-status') ?>"
                                   data-action="stop">
                                    <span class="icon-white">⛔</span> Деактивиране
                                </a>
                            <?php else: ?>
                                <!-- ▶ START – когато задачата НЕ върви -->
                                <a class="js-action btn run bg-green round-10  p-1"
                                   href="#"
                                   data-route="<?= route_to('CronDashboard-toggle', $j -> job_key) ?>"
                                   data-route-refresh="<?= route_to('CronDashboard-status') ?>"
                                   data-action="run">
                                    ▶ Активиране
                                </a>
                            </div>
                        <?php endif ?>
                    </td>
                </tr>
            <?php endforeach ?>
        </tbody>
    </table>

</article>
