<!-- =============== Данни за куриер ===================== -->
<article class="tab-pane" id="tab-courier">
    <!-- ЕКОНТ настройки -->
    <section class="row section-box pt-4 mt-4">
        <div class="section-title w-25">ЕКОНТ</div>

        <div class="col-4">
            <h6 class="text-muted mb-2"> Данни от api на ЕКОНТ</h6>

            <div class="mb-2">
                <label class="fw-400">Потребител</label>
                <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[econtUser]" type="text" value="<?= $settings -> econtUser ?? '' ?>">
            </div>

            <div class="mb-2">
                <label class="fw-400">Парола</label>
                <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[econtPass]" type="text"  value="<?= $settings -> econtPass ?? '' ?>">
            </div>
        </div>

        <div class="col <?= empty($settings -> econtPass) ? 'hide' : '' ?>">
            <h6 class="text-muted mb-2"> товарителница (настройки по подразбиране)</h6>

            <div class="mb-1 row">
                <label class="p-2 col-4 fw-400">Офис на куриер</label>
                <div class="col">
                    <input class="izborOfice pointer-events-none css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[econtOfis]" type="text" value="<?= $settings -> econtOfis ?? '' ?>">
                    <button id="econtLocator" class="css-btn-save btn btn-sm " type="button"><i class="fa fa-map-marker"></i>&nbsp;локатор</button>
                </div>
            </div>

            <div class="mb-1 row">
                <label class="p-2 col-4 fw-400">Подател (фирма)</label>
                <div class="col">
                    <select class="css-dropdown-p css-focus-strong css-border-none w-100" name="settings[econtSender]">
                        <option value=""></option>
                        <?php
                        if (empty($econt['senders'])) {
                            echo '<option value="">не са открити податели в Еконт </option>';
                        }
                        foreach ($econt['senders'] as $k => $name):
                            if (!empty($name['client']['name'])):
                                $_selected = $k == ($settings -> econtSender ?? '') ? 'selected' : '';
                                echo "<option value=\"$k\" $_selected>{$name['client']['name']}</option>";
                            endif;
                        endforeach;
                        ?>
                    </select>
                </div>
            </div>

            <div class="mb-1 row">
                <label class="p-2 col-4 fw-400">Упълномощено лице</label>
                <div class="col">
                    <select class="css-dropdown-p css-focus-strong css-border-none w-100" name="settings[econtAgent]">
                        <option value=""></option>
                        <?php
                        if (empty($econt['agents'])) {
                            echo '<option value="">не са открити упълномощени лица в Еконт </option>';
                        }
                        foreach ($econt['agents'] as $k => $val):
                            if (!empty($val['value'])):
                                $_selected = $k == ($settings -> econtAgent ?? '') ? 'selected' : '';
                                echo "<option value=\"$k\" $_selected>{$val['value']}</option>";
                            endif;
                        endforeach;
                        ?>
                    </select>
                </div>
            </div>

            <div class="mb-1 row">
                <label class="p-2 col-4 fw-400">Имейл към подател при доставка</label>
                <div class="col">
                    <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[econtAgentEmail]" type="text" value="<?= $settings -> econtAgentEmail ?? '' ?>">
                </div>
            </div>

            <div class="mb-2 row">
                <label class="p-2 col-4 fw-400">За чия сметка е плащането</label>
                <div class="col">
                    <?php
                    $_selectedWhoPay = $settings -> econtWhoPay ?? '';

                    $_whoPayOptions = [
                        ''                    => '',
                        'za_smetkaPoluchatel' => 'За сметка на клиент',
                        'za_smetkaMe'         => 'За сметка на продавач',
                        'za_smetkaShare'      => 'Споделени разходи за доставка (50% от сумата м/у продавач и клиент)',
                        'za_smetkaCustom'     => 'Сума на доставка за клиент (споделени разходи м/у продавач и клиент)',
                    ];
                    ?>

                    <select class="css-dropdown-p css-focus-strong css-border-none fw-semi w-100" name="settings[econtWhoPay]">
                        <?php foreach ($_whoPayOptions as $value => $label): ?>
                            <option value="<?= $value ?>" <?= $_selectedWhoPay === $value ? 'selected' : '' ?>>
                                <?= $label ?>
                            </option>
                        <?php endforeach; ?>
                    </select>

                </div>
            </div>
        </div>
    </section>

    <br>

    <!-- SPEEDY настройки -->
    <section class="row section-box pt-4 mt-4">
        <div class="section-title w-25">SPEEDY</div>

        <div class="col-4">
            <h6 class="text-muted mb-2"> Данни от api на SPEEDY</h6>

            <div class="mb-2">
                <label class="fw-400">Потребител </label>
                <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[speedyUser]" type="text" value="<?= $settings -> speedyUser ?? '' ?>">
            </div>

            <div class="mb-2">
                <label class="fw-400">Парола</label>
                <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" type="text" name="settings[speedyPass]"  value="<?= $settings -> speedyPass ?? '' ?>">
            </div>
        </div>

        <div class="col  <?= empty($settings -> speedyPass) ? 'hide' : '' ?>">
            <h6 class="text-muted mb-2"> товарителница (настройки по подразбиране)</h6>

            <div class="mb-2 row">
                <label class="p-2 col-4 fw-400">Офис на куриер</label>
                <div class="col">
                    <input class="izborOfice pointer-events-none css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[speedyOfis]" type="text" value="<?= $settings -> speedyOfis ?? '' ?>">
                    <button id="speedyLocator" class="css-btn-save btn btn-sm " type="button"><i class="fa fa-map-marker"></i>&nbsp;локатор</button>
                </div>
            </div>

            <div class="mb-1 row">
                <label class="p-2 col-4 fw-400">Подател (фирма)</label>
                <div class="col">
                    <select class="css-dropdown-p css-focus-strong css-border-none fw-semi w-100" name="settings[speedySender]">
                        <option value=""></option>
                        <?php
                        if (empty($speedy['senders'])) {
                            echo '<option value="">не са открити податели в Speedy </option>';
                        }
                        foreach ($speedy['senders'] as $k => $row):
                            if (!empty($row['clientName'])):
                                $_selected = $row['clientId'] == ($settings -> speedySender ?? '') ? 'selected' : '';
                                echo "<option value=\"{$row['clientId']}\" $_selected>Име: {$row['clientName']}, Адрес: {$row['address']['fullAddressString']}</option>";
                            endif;
                        endforeach;
                        ?>
                    </select>
                </div>
            </div>

            <div class="mb-1 row">
                <label class="p-2 col-4 fw-400">Допъл. хартиено копие</label>
                <div class="col">
                    <select class="css-dropdown-p css-focus-strong css-border-none fw-semi w-100" name="settings[speedySenderCopy]">
                        <?php
                        $_labels = ['none' => 'none', 'ON_SAME_PAGE' => 'на същата страница', 'ON_SINGLE_PAGE' => 'на отделна страница'];
                        $_s      = $settings -> speedySenderCopy ?? '';
                        foreach ($_labels as $val => $label) {
                            $_selected = ($_s == $val) ? 'selected' : '';
                            echo "<option value=\"$val\" $_selected>$label</option>";
                        }
                        ?>
                    </select>
                </div>
            </div>

            <div class="mb-1 row">
                <label class="p-2 col-4 fw-400">Формат</label>
                <div class="col">
                    <select class="css-dropdown-p css-focus-strong css-border-none fw-semi w-100" name="settings[speedyFormat]">
                        <?php
                        $_formats        = ['A4', 'A4_4xA6', 'A6'];
                        $_selectedFormat = $settings -> speedyFormat ?? '';
                        foreach ($_formats as $val) {
                            $_selected = ($_selectedFormat == $val) ? 'selected' : '';
                            echo "<option value=\"$val\" $_selected>$val</option>";
                        }
                        ?>
                    </select>
                </div>
            </div>

            <div class="mb-1 row">
                <label class="p-2 col-4 fw-400">За чия сметка е плащането</label>
                <div class="col">
                    <?php
                    $_selectedWhoPay2 = $settings -> speedyWhoPay ?? '';

                    $_whoPayOptions2 = [
                        ''          => '',
                        'RECIPIENT' => 'Получател',
                        'SENDER'    => 'Подател',
                    ];
                    ?>

                    <select class="css-dropdown-p css-focus-strong css-border-none fw-semi w-100" name="settings[speedyWhoPay]">
                        <?php foreach ($_whoPayOptions2 as $value => $label): ?>
                            <option value="<?= $value ?>" <?= $_selectedWhoPay2 === $value ? 'selected' : '' ?>>
                                <?= $label ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
        </div>
    </section>

    <button class="js-saveFormVisible css-btn-save btn p-1 btn-primary float-right align-self-end round-10" type="submit">
        <i class="fa fa-save m-1"></i>&nbsp;<?= lang('LANG__global.btn.save') ?>
    </button>
</article>
