<?php
$general = service('settings') -> get('App.general') ?? [];
$cfg     = $general['variation_generator'] ?? [];

$field  = $cfg['base_field'] ?? 'product_name';
$split  = $cfg['split_type'] ?? 'delimiter';
$delim  = $cfg['delimiter'] ?? '-';
$substr = $cfg['substr_len'] ?? 30;
$limit  = $cfg['limit'] ?? 20;

$minTimer  = isset($cfg['min_timer']) ? (int) ($cfg['min_timer'] / 60) : 5;
$crawlTime = isset($cfg['crawl_time']) ? (int) ($cfg['crawl_time'] / 60) : 1;

$sc = !empty($cfg['same_category']);
$ss = !empty($cfg['same_subcategory']);
$sb = !empty($cfg['same_brand']);
$sm = !empty($cfg['same_model']);
$oa = !empty($cfg['only_active']);
?>

<div class="tab-pane fade related-card" id="tab-variations" role="tabpanel">

    <div class="d-flex justify-content-center mb-4">
        <h3 class="text-primary mb-0">
            <i class="fa fa-random me-2"></i>
            Генериране на вариации (други продукти)
        </h3>
    </div>

    <section class="px-2" style="max-height:75vh;overflow-y: auto;">

        <div id="accordion" class="info-multi round-10" style="background: transparent;">
            <div class="card px-1" style="background: transparent;border: 1px solid #fff;">
                <div>
                    <h5 class="mb-0">
                        <button class="btn btn-link w-100 text-left" data-toggle="collapse" data-target="#collapseOne">
                            <i class="fa fa-info-circle"></i>
                            <span>Легенда</span>
                        </button>
                    </h5>
                </div>

                <div id="collapseOne" class="collapse" data-parent="#accordion">
                    Инструментът автоматично генерира <b>вариации на продукти</b>,
                    като анализира имената, кодовете или OEM номерата и открива
                    други продукти със същата основа.

                    <br><br>

                    Системата извлича стабилна част от основния продукт – т.нар. „основа“,
                    която се използва за търсене на сходни артикули. Това може да бъде
                    текстът преди зададен разделител или най-дългата последователност
                    от думи, която се среща и при други продукти.

                    <br><br>

                    По този начин автоматично се откриват различни варианти на един и същи
                    продукт – например различни размери, версии, модели или модификации:
                    <br>
                    • „Фар за Audi A4“ → ще намери други фарове за Audi A4  
                    • Продукти със сходен OEM → ще бъдат групирани като вариации  
                    • Артикули със сходна основа в името → ще се свържат автоматично  

                    <br><br>

                    Можете да контролирате как се извършва генерирането:
                    <br>
                    • Кое поле да се използва за сравнение (име, OEM, код)  
                    • Как да се извлича основата – чрез разделител или интелигентен SUBSTR режим  
                    • Максимален брой вариации, които да бъдат записани  

                    <br><br>

                    По желание резултатите могат да бъдат ограничени само до:
                    <br>
                    • Същата категория  
                    • Същата подкатегория  
                    • Същата марка  
                    • Същия модел  

                    <br><br>

                    При натискане на „Запази настройките“ конфигурацията се записва
                    и може да се използва за автоматично или масово генериране.
                    Ако е зададен Product ID, системата веднага обновява
                    вариациите само за този конкретен продукт.

                    <br><br>

                    Функцията „Масово генериране“ обработва всички продукти на части (batch),
                    като последователно създава и обновява вариациите за целия каталог,
                    без да натоварва сървъра и с визуален индикатор за напредъка.
                </div>
            </div>
        </div>

        <div class="bg-white px-2" style="border-radius: 14px;border: 1px solid #c9c9c9;box-shadow: 2px 2px 4px #c1c1c1;">
            <div class="row saas-header config-header">
                <i class="fa fa-sliders"></i> Конфигурация
            </div>

            <!-- ROW 1 -->
            <div class="row g-4 mt-3">
                <div class="col-lg-4">
                    <label>Основно поле</label>
                    <select id="var_base_field" class="form-control form-control-lg">
                        <option value="product_name" <?= $field == 'product_name' ? 'selected' : '' ?>>product_name</option>
                        <option value="oem" <?= $field == 'oem' ? 'selected' : '' ?>>oem</option>
                        <option value="kod" <?= $field == 'kod' ? 'selected' : '' ?>>kod</option>
                    </select>
                </div>

                <div class="col-lg-4">
                    <label>Метод за групиране</label>
                    <select id="var_split_type" class="form-control form-control-lg">
                        <option value="delimiter" <?= $split == 'delimiter' ? 'selected' : '' ?>>Разделител</option>
                        <option value="substr" <?= $split == 'substr' ? 'selected' : '' ?>>SUBSTR</option>
                    </select>
                </div>

                <div class="col-lg-2">
                    <label>Delimiter</label>
                    <input id="var_delimiter" class="form-control form-control-lg" value="<?= esc($delim) ?>">
                </div>

                <div class="col-lg-2">
                    <label>SUBSTR</label>
                    <input id="var_substr" type="number" class="form-control form-control-lg" value="<?= esc($substr) ?>">
                </div>
            </div>

            <!-- ROW 2 -->
            <div class="row g-4 mt-4">
                <div class="col-lg-3"><input type="checkbox" id="var_same_category" <?= $sc ? 'checked' : '' ?>> Съща категория</div>
                <div class="col-lg-3"><input type="checkbox" id="var_same_subcategory" <?= $ss ? 'checked' : '' ?>> Съща подкатегория</div>
                <div class="col-lg-3"><input type="checkbox" id="var_same_brand" <?= $sb ? 'checked' : '' ?>> Съща марка</div>
                <div class="col-lg-3"><input type="checkbox" id="var_same_model" <?= $sm ? 'checked' : '' ?>> Същ модел</div>
            </div>

            <!-- ROW 3 -->
            <div class="row g-4 mt-4">
                <div class="col-lg-4">
                    <label>Макс. резултати</label>
                    <input id="var_limit" type="number" class="form-control form-control-lg" value="<?= esc($limit) ?>">
                </div>

                <div class="col-lg-4">
                    <label>Product ID</label>
                    <input id="var_product_id" type="number" class="form-control form-control-lg">
                </div>

                <div class="col-lg-4 d-flex align-items-end">
                    <button id="btnGenerateVariations"
                            class="btn btn-success w-100"
                            data-route="<?= route_to('VariationRules-generate') ?>">
                        <i class="fa fa-save me-2"></i>
                        Запази настройките
                    </button>
                </div>
            </div>

            <!-- ROW 4 -->
            <div class="row g-4 mt-4">
                <div class="col-lg-4">
                    <label>Минимален тайминг (минути)</label>
                    <input id="var_min_timer" type="number" class="form-control form-control-lg" value="<?= esc($minTimer) ?>">
                </div>

                <div class="col-lg-4">
                    <label>Време за обхождане (минути)</label>
                    <input id="var_crawl_time" type="number" class="form-control form-control-lg" value="<?= esc($crawlTime) ?>">
                </div>
            </div>

            <div id="varStatusBox" class=" d-none mt-4"></div>
        </div>



        <hr class="my-4">

        <div class="bg-white px-2 my-3" style="border-radius: 14px;border: 1px solid #c9c9c9;box-shadow: 2px 2px 4px #c1c1c1;">

            <div class="row saas-header batch-header">
                <i class="fa fa-database"></i>
                <span>Масово генериране (Batch Engine)</span>
            </div>

            <div class="row g-4 p-3">

                <div class="col-lg-3">
                    <label>Продукти на стъпка</label>
                    <input type="number" id="var_batch_limit"
                           class="form-control form-control-lg"
                           value="50">
                    <div class="text-muted small mt-1">
                        Колко продукта да се обработят наведнъж
                    </div>
                </div>

                <div class="col-lg-3">
                    <label>Започни от продукт №</label>
                    <input type="number" id="var_batch_offset"
                           class="form-control form-control-lg"
                           value="0">
                    <div class="text-muted small mt-1">
                        Полезно при продължаване на прекъсната обработка
                    </div>
                </div>

                <div class="col-lg-6 d-flex align-items-end" style="display: inline !important; margin-top: 17px;">
                    <button id="btnGenerateVariationsBatch"
                            class="btn btn-warning w-100"
                            style="height:54px;font-weight:600">
                        <i class="fa fa-industry me-2"></i>
                        Стартирай масово генериране
                    </button>
                </div>

            </div>

            <!-- PROGRESS -->
            <div class="p-3 d-none" id="varBatchProgressBox">
                <div class="fw-semibold mb-2">Batch Progress</div>

                <div class="progress">
                    <div id="varBatchProgressBar"
                         class="progress-bar progress-bar-striped progress-bar-animated"
                         style="width:0%">
                        0%
                    </div>
                </div>

                <div class="mt-2 text-muted small">
                    Offset: <span id="varBatchOffset">0</span> |
                    Processed: <span id="varBatchProcessed">0</span>
                </div>
            </div>

        </div>
    </section>
</div>

<script>
    $(document).on('click', '#btnGenerateVariations', function (e) {
        e.preventDefault();

        const url = $(this).data('route');
        const box = $('#varStatusBox');

        box.removeClass('alert-success alert-danger').addClass('d-none');

        const data = {
            product_id: $('#var_product_id').val(),

            var_base_field: $('#var_base_field').val(),
            var_split_type: $('#var_split_type').val(),
            var_delimiter: $('#var_delimiter').val(),
            var_substr: $('#var_substr').val(),
            var_limit: $('#var_limit').val(),

            var_same_category: $('#var_same_category').is(':checked') ? 1 : 0,
            var_same_subcategory: $('#var_same_subcategory').is(':checked') ? 1 : 0,
            var_same_brand: $('#var_same_brand').is(':checked') ? 1 : 0,
            var_same_model: $('#var_same_model').is(':checked') ? 1 : 0,

            var_min_timer: $('#var_min_timer').val(),
            var_crawl_time: $('#var_crawl_time').val(),

            mode: 'save_only'
        };

        $.ajax({
            url: url,
            type: 'POST',
            data: data,
            dataType: 'json',

            success: function (res) {
                if (res && res.ok) {
                    box
                            .removeClass('d-none text-danger')
                            .addClass('text-success')
                            .html('✓ Настройките са запазени');
                }
                else {
                    box
                            .removeClass('d-none text-success')
                            .addClass('text-danger')
                            .html('✗ ' + ( res.msg || 'Грешка при запазване' ));
                }
            },

            error: function () {
                box
                        .removeClass('d-none text-success')
                        .addClass('text-danger')
                        .html('✗ Системна грешка');
            }
        });
    });

    $(document).on('click', '#btnGenerateVariationsBatch', function () {

        let offset = parseInt($('#var_batch_offset').val()) || 0;
        let limit = parseInt($('#var_batch_limit').val()) || 50;

        $('#varBatchProgressBox').removeClass('d-none');

        function runBatch () {

            $.ajax({
                url: '<?= route_to('VariationRules-generateBatch') ?>',
                type: 'POST',
                dataType: 'json',
                global: false,
                data: {
                    offset: offset,
                    limit: limit
                },

                success: function (res) {
                    console.log('VARIATION BATCH:', res);

                    if (! res.ok || res.processed === 0) {
                        $('#varBatchProgressBar')
                                .removeClass('progress-bar-animated')
                                .addClass('bg-success')
                                .css('width', '100%')
                                .text('ГОТОВО');
                        return;
                    }

                    offset += res.processed;

                    $('#varBatchOffset').text(offset);
                    $('#varBatchProcessed').text(res.processed);

                    let percent = Math.min(100, Math.round(( offset / 20000 ) * 100));

                    $('#varBatchProgressBar')
                            .css('width', percent + '%')
                            .text(percent + '%');

                    setTimeout(runBatch, 300);
                },

                error: function (xhr) {
                    console.error(xhr.responseText);
                    alert('Batch грешка');
                }
            });
        }

        runBatch();
    });
</script>
