<article class="tab-pane fade show" id="tab-zenoobr">

    <h4 class="mb-3 font-weight-bold">
        <i class="fa fa-sliders-h text-primary"></i>&nbsp;
        Ценообразуване (Ролева система)
    </h4>

    <p class="text-muted mb-4" style="max-width:600px">
        Изберете тип на ценообразуването и вижте съответната конфигурация по-долу.
    </p>

    <div class="info-box info-multi mb-4" style="max-width:900px;">
        <div style="display:flex;align-items:center;margin-bottom:8px;">
            <i class="fa fa-info-circle text-primary mr-2"></i>
            <strong>Как работи ценообразуването</strong>
        </div>

        <ul style="margin:0;padding-left:18px;font-size:14px;line-height:1.7;color:#374151;">
            <li>
                <b>Базова цена</b> за всички изчисления е
                <b>крайната клиентска цена</b>, а не доставната.
            </li>

            <li>
                Всички роли, отстъпки и нива се
                <b>изчисляват върху клиентската цена</b>.
            </li>

            <li>
                <b>Ценообразуване с отстъпка</b> – ролите получават процентна
                отстъпка от базовата клиентска цена.
            </li>

            <li>
                <b>Мулти ценообразуване</b> – използват се предварително
                дефинирани ценови нива (B, A, Специална и др.).
            </li>

            <li>
                <b>Gensoft ценообразуване</b> – цените се управляват
                изцяло от външната система Gensoft.
            </li>

            <li style="color:#92400e;">
                ⚠️ Промяната на типа ценообразуване влияе на начина,
                по който се формират цените за клиентите.
            </li>
        </ul>
    </div>


    <div class="col-5 mb-4">
        <label class="font-weight-bold">Тип ценообразуване</label>

        <select id="priceType"
                name="settings[zenoobr][price_type]"
                class="form-control custom-select-modern">

            <option value="gensoft"
                    <?= ($settings -> zenoobr['price_type'] ?? '') === 'gensoft' ? 'selected' : '' ?>>
                Gensoft ценообразуване (неактивно)
            </option>

            <option value="multi"
                    <?= ($settings -> zenoobr['price_type'] ?? '') === 'multi' ? 'selected' : '' ?>>
                Мулти ценообразуване
            </option>

            <option value="discount"
                    <?= ($settings -> zenoobr['price_type'] ?? 'discount') === 'discount' ? 'selected' : '' ?>>
                Ценообразуване с отстъпка
            </option>

        </select>


    </div>

    <div class="mt-4">
        <button style="padding:10px;" id="savePriceType"
                type="button"
                class="btn btn-primary">
            <i class="fa fa-save"></i> Запази ценообразуване
        </button>

        <span id="priceTypeSaved"
              class="text-success ml-3"
              style="display:none;">
            ✔ Запазено
        </span>
    </div>

    <br/>
    <br/>

    <div id="gensoftInfo" class="info-box info-gensoft" style="padding:16px 20px;">
        <div style="display:block; margin-bottom:4px; white-space:nowrap; width:100%;">
            <i class="fa fa-info-circle"></i>
            <span style="font-weight:600;">Gensoft ценообразуване</span>
        </div>

        <div style="margin:0; line-height:1.4; font-size:14px; width:100%;">
            Това ценообразуване е интегрирано в Gensoft.
        </div>
    </div>

    <div id="multiImage" class="info-box info-multi" style="display:none;">
        <h5 class="mb-3"><i class="fa fa-layer-group"></i> Мулти ценообразуване</h5>

        <p>
            Този режим използва няколко нива на ценообразуване.<br>
            Изображението долу показва структурата на нивата и тяхната подредба.
        </p>

        <div class="multi-img-wrapper">
            <img src="/assets/images/product_image/normalna_cenova_lista.jpg"
                 class="img-fluid rounded shadow-lg"
                 style="max-width:600px;">
        </div>
    </div>


    <div id="discountPanel">

        <div class="row">

            <div class="col-md-4 mb-4">
                <div class="card shadow-sm border-0 rounded-lg modern-card">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center mb-4">
                            <div class="icon-badge mr-3"><i class="fa fa-tag"></i></div>
                            <h5 class="m-0">Цена B</h5>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Отстъпка (%)</label>
                            <input type="number" class="form-control modern-input"
                                   name="settings[zenoobr][B_discount]"
                                   value="<?= $settings -> zenoobr['B_discount'] ?? '' ?>">
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card shadow-sm border-0 rounded-lg modern-card">
                    <div class="card-body p-4">

                        <div class="d-flex align-items-center mb-4">
                            <div class="icon-badge success mr-3"><i class="fa fa-star"></i></div>
                            <h5 class="m-0">Цена A</h5>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Отстъпка (%)</label>
                            <input type="number" class="form-control modern-input"
                                   name="settings[zenoobr][A_discount]"
                                   value="<?= $settings -> zenoobr['A_discount'] ?? '' ?>">
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Оборот за следващо ниво</label>
                            <input type="number" class="form-control modern-input"
                                   name="settings[zenoobr][A_turnover]"
                                   value="<?= $settings -> zenoobr['A_turnover'] ?? '' ?>">
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Дата от</label>
                            <input type="date" class="form-control modern-input"
                                   name="settings[zenoobr][A_from]"
                                   value="<?= $settings -> zenoobr['A_from'] ?? '' ?>">
                        </div>

                        <div class="form-group mb-0">
                            <label class="font-weight-bold">Дата до</label>
                            <input type="date" class="form-control modern-input"
                                   name="settings[zenoobr][A_to]"
                                   value="<?= $settings -> zenoobr['A_to'] ?? '' ?>">
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card shadow-sm border-0 rounded-lg modern-card">
                    <div class="card-body p-4">

                        <div class="d-flex align-items-center mb-4">
                            <div class="icon-badge success mr-3" style="background:#17a2b8">
                                <i class="fa fa-diamond"></i>
                            </div>
                            <h5 class="m-0">Специално</h5>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Отстъпка (%)</label>
                            <input type="number" class="form-control modern-input"
                                   name="settings[zenoobr][Spec_discount]"
                                   value="<?= $settings -> zenoobr['Spec_discount'] ?? '' ?>">
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Оборот за следващо ниво</label>
                            <input type="number" class="form-control modern-input"
                                   name="settings[zenoobr][Spec_turnover]"
                                   value="<?= $settings -> zenoobr['Spec_turnover'] ?? '' ?>">
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Дата от</label>
                            <input type="date" class="form-control modern-input"
                                   name="settings[zenoobr][Spec_from]"
                                   value="<?= $settings -> zenoobr['Spec_from'] ?? '' ?>">
                        </div>

                        <div class="form-group mb-0">
                            <label class="font-weight-bold">Дата до</label>
                            <input type="date" class="form-control modern-input"
                                   name="settings[zenoobr][Spec_to]"
                                   value="<?= $settings -> zenoobr['Spec_to'] ?? '' ?>">
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>

</article>

<style>
    #multiImage {
        display: none; 
        width: 100%;
    }

    #gensoftInfo p {
        margin-bottom: 15px;
        display: block;
    }

    #multiImage h5 {
        margin-bottom: 12px;
    }

    #multiImage p {
        margin-bottom: 15px;
        display: block;
    }

    #multiImage .multi-img-wrapper {
        text-align: center;
        margin-top: 20px;
        width: 100%;
    }
    .custom-select-modern {
        appearance: none;
        background: white url("data:image/svg+xml,<svg fill='%23007bff' height='24' viewBox='0 0 24 24' width='24' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/></svg>") no-repeat right 12px center/18px;
        padding: 12px 40px 12px 14px;
        border-radius: 10px;
        border: 2px solid #007bff33;
        font-size: 16px;
        transition: .2s;
    }
    .custom-select-modern:focus {
        border-color: #007bff;
        box-shadow: 0 0 6px rgba(0,123,255,.4);
    }

    .info-box {
        padding: 20px 24px;
        border-radius: 12px;
        font-size: 15px;
        line-height: 1.5;
    }
    .info-gensoft {
        background: #f1f3f5;
        border-left: 5px solid #6c757d;
    }
    .info-multi {
        background: #eef8ff;
        border-left: 5px solid #0d6efd;
    }

    .modern-card {
        transition: .2s;
        border-radius: 14px;
    }
    .modern-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0,0,0,.15);
    }

    .icon-badge {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        background: #007bff;
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 22px;
    }
    .icon-badge.success {
        background: #28a745;
    }

    .modern-input {
        border-radius: 8px !important;
        padding: 10px 14px !important;
    }

</style>

<script>

    $(document).ready(function () {

        function switchPriceType (type) {
            $("#gensoftInfo, #multiImage, #discountPanel").hide();

            if (type === "gensoft")
                $("#gensoftInfo").fadeIn(150);
            if (type === "multi")
                $("#multiImage").fadeIn(150);
            if (type === "discount")
                $("#discountPanel").fadeIn(150);
        }

        // INIT
        switchPriceType($("#priceType").val() || "discount");

        $("#priceType").on("change", function () {
            switchPriceType(this.value);
            $("#priceTypeSaved").hide();
        });

        // SAVE BUTTON

        //-------------------------------------------------------------------------------------------

        $("#savePriceType").on("click", function () {

            let type = $("#priceType").val();

            let data = {
                price_type: type
            };

            if (type === "discount") {
                data.settings = {
                    zenoobr: {
                        B_discount: $("input[name='settings[zenoobr][B_discount]']").val(),
                        A_discount: $("input[name='settings[zenoobr][A_discount]']").val(),
                        A_turnover: $("input[name='settings[zenoobr][A_turnover]']").val(),
                        A_from: $("input[name='settings[zenoobr][A_from]']").val(),
                        A_to: $("input[name='settings[zenoobr][A_to]']").val(),
                        Spec_discount: $("input[name='settings[zenoobr][Spec_discount]']").val(),
                        Spec_turnover: $("input[name='settings[zenoobr][Spec_turnover]']").val(),
                        Spec_from: $("input[name='settings[zenoobr][Spec_from]']").val(),
                        Spec_to: $("input[name='settings[zenoobr][Spec_to]']").val()
                    }
                };
            }

            $.ajax({
                url: '<?= route_to('Nastrojka-save_price_type') ?>',
                type: "POST",
                dataType: "json",
                data: data,
                success: function (res) {
                    if (res.ok) {
                        $("#priceTypeSaved").fadeIn(200);
                    }
                }
            });
        });


    });

    $(document).ready(function () {

        function switchPriceType (type) {
            $("#gensoftInfo, #multiImage, #discountPanel").hide();

            if (type === "gensoft")
                $("#gensoftInfo").fadeIn(150);
            if (type === "multi")
                $("#multiImage").fadeIn(150);
            if (type === "discount")
                $("#discountPanel").fadeIn(150);
        }

        switchPriceType($("#priceType").val());

        $("#priceType").on("change", function () {
            switchPriceType($(this).val());
        });

    });
</script>
