<?php

namespace IonAuth\Controllers;

use \IonAuth\Models\Group_permisions_model;
use \Zend\Permissions\Acl\Acl;
use \Zend\Permissions\Acl\Role\GenericRole as Role;
use \Zend\Permissions\Acl\Resource\GenericResource as Resource;

class Group_permisions extends \App\Controllers\BaseController {

    public function __construct() {
        parent::__construct();

        $this -> Group_permisions_model = new Group_permisions_model();
        $this -> acl                    = new Acl();

        if (!$this -> ionAuth -> loggedIn()) {
            header('Location: ' . base_url() . 'login');
            exit;
        }
        else {
            $this -> user  = $this -> ionAuth -> user() -> row();
            $this -> group = $this -> ionAuth -> getUsersGroups($this -> user -> id) -> getRow();
        }

        $this -> acl -> addRole(new Role('admin'));
        $this -> acl -> addResource(new Resource('deny'));
        $this -> acl -> deny(null, 'deny');

        if (!$this -> ionAuth -> isAdmin()) {
            // $group_perm -> btns_allowed  - btns_allowed sql колона
            // $t['home']['zenova'] - ['home'] за home изглед ['zenova'] - масив
            $group_perm         = $this -> Group_permisions_model -> Group_permisions_model_get($this -> ionAuth -> getUsersGroups($this -> ionAuth -> user() -> row() -> id) -> getRow() -> id);

            $this -> arr_btns   = json_decode($group_perm -> btns_allowed, true);
            $this -> arr_module = explode(',', $group_perm -> module_allowed_view);
            $this -> arr_forms  = explode(',', $group_perm -> forms_allowed_view);
        }
    }

    /*
      |--------------------------------------------------------
      | ИЗВЛ. НА ПРАВАТА ЗА ГРУПА
      |------------------------------------------------------- */

    public function index($id) {
        // $this -> Headers_cotroller = new Headers();

        $data = [
            'message'    => '',
            'activelink' => '',
            'create_btn' => '<button type="submit" form="form-groupPermisions"  class="btn btn-primary"><i class="fa fa-save"></i> Запис</button>',
            'cansel_btn' => '<a href="/adminLTE/users/groupList" data-toggle="tooltip" title="" class="btn btn-default" data-original-title="Отказ"><i class="fa fa-reply"></i></a>',
            'group'      => $this -> ionAuth -> group($id) -> row()
        ];

        // запис на правата за групата
        if ($this -> request -> getPost()) {
            $groupUpdate = $this -> Group_permisions_set($id);

            if ($groupUpdate) {
                $data['message'] = view($this -> show_alert, ['messages' => array('Правата на групата са актуализирани')]);
            }
            else {
                $data['message'] = view($this -> show_alert, ['errors' => array('Грешка при обновяване на правата за групата!')]);
            }
        }

        $get_groups_permisions = $this -> Group_permisions_model -> Group_permisions_model_get($id);


        if ($get_groups_permisions != []) {
            $data['groups_permissions']['allow_module'] = explode(',', $get_groups_permisions -> module_allowed_view);
            $data['groups_permissions']['allow_forms']  = explode(',', $get_groups_permisions -> forms_allowed_view);
            $data['allow_btns']                         = json_decode($get_groups_permisions -> btns_allowed, true);
        }
        $body = view('IonAuth\Views\Group_permisions\VIEW__groupPermisions_form', $data);

        return $this -> view($body, lang('GroupPermisions.home-title', [$data['group'] -> name]), ['users' => ['menu-open' => 'menu-open', 'g_active' => 'active']]);
    }

    /*
      |--------------------------------------------------------
      | ЗАПИС НА ПРАВАТА ЗА ГРУПА
      |------------------------------------------------------- */

    public function Group_permisions_set($group_id) {

        $checkbox_module_permisions = '';
        $checkbox_forms_permisions  = '';
        $checkbox_btns_permisions   = '';

        // права за модулите
        if ($this -> request -> getPost('module_permisions') != []) {
            $checkbox_module_permisions = implode(',', $this -> request -> getPost('module_permisions'));
        }
        // права за формите 
        if ($this -> request -> getPost('forms_permisions') != []) {
            $checkbox_forms_permisions = implode(',', $this -> request -> getPost('forms_permisions'));
        }
        // права за бутоните
        if ($this -> request -> getPost('btns_permisions') != []) {
            $checkbox_btns_permisions = json_encode($this -> request -> getPost('btns_permisions'));
        }

        $arr = [
            'group_id'            => $group_id,
            'module_allowed_view' => $checkbox_module_permisions,
            'forms_allowed_view'  => $checkbox_forms_permisions,
            'btns_allowed'        => $checkbox_btns_permisions
        ];

        // връща true при успешен запис
        return $this -> Group_permisions_model -> Group_permisions_model_set($arr);
    }

    // проверка за правата на групата
    // ================================
    public function check_groupPermisions($data = []) {

        // ако групата е  админ
        if ($this -> ionAuth -> isAdmin()) {
            $this -> acl -> allow('admin');
            return $this -> acl;
        }

        // проверка за модул права
        if (isset($data['modul'])) {

            $this -> acl -> allow(null, null, $this -> arr_module);

            if (!$this -> acl -> isAllowed(null, null, $data['modul'])) {
                $this -> session -> setFlashdata('message', 'Достъпът до ' . $data['modulName'] . ' е забранен!!');

                header('Location: ' .  base_url().'adminLTE/Denied_page');
            }
        }

        // проверка за форми права
        if (isset($data['forms'])) {
            $this -> acl -> allow(null, null, $this -> arr_forms);
        }

        // проверка за бутони права
        // $this -> Group_perm_contr -> check_groupPermisions(['buttons' => 'oferti']);
        // sql "oferti":{"zenova":["create","edit","delete"]
        if (isset($data['buttons'])) {

            if (isset($this -> arr_btns[$data['buttons']]) && $this -> arr_btns[$data['buttons']] != []) {
                foreach (array_keys($this -> arr_btns[$data['buttons']]) as $tab) {

                    $this -> acl -> addResource(new Resource($tab));
                    $this -> acl -> allow(null, $tab, $this -> arr_btns[$data['buttons']][$tab]);
                }
            }
        }
        return $this -> acl;
    }

    // за офертите проверка дали има групата има права за бутоните
    // $this -> Group_perm_contr -> check_isAllowed(['modul' => 'zenova', 'btn' => 'delete'])
    // ===========================================================
    public function check_isAllowed($data = []) {

        // ако групата е разл. от админ
        if ($this -> ionAuth -> isAdmin()) {
            $this -> acl -> allow('admin');
            return $this -> acl -> isAllowed('admin');
        }
        else {
            // ако има ресурс в базата данни
            if ($this -> acl -> hasResource($data['modul'])) {
                return $this -> acl -> isAllowed(null, $data['modul'], $data['btn']);
            }
        }
    }

}
