<!DOCTYPE html>
<html>

    <head> 
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Потребители</title>

        <link href="<?php echo base_url() ?>assets/bootstrap/css/bootstrap.min.css" rel="stylesheet">
        <link href="<?php echo base_url() ?>assets/css/navbar/navbar.css" rel="stylesheet">

        <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
          <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
          <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

  
    </head> 

    <body>

        <?php echo $header; ?>

        <?php
        $dataAttr = ['class' => 'form-control', 'required' => 'true']
        ?>



        <div class="container">

            <h1><?php echo lang('Auth.create_user_heading'); ?></h1>  <hr>

            <div id="infoMessage"><?php echo $message; ?></div>

            <?php echo form_open('create_user'); ?>

            <div class="form-group">
                <?php echo form_label(lang('Auth.create_user_username_label'), 'username'); ?> 
                <div class="input-group"><span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span><?php echo form_input($identity, '', $dataAttr); ?>
                </div>
            </div>


            <div class="form-group">
                <?php echo form_label(lang('Auth.create_user_fname_label'), 'first_name'); ?> 
                <div class="input-group"><span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                    <?php echo form_input($first_name, '', $dataAttr); ?>
                </div>
            </div>

            <div class="form-group">
                <?php echo form_label(lang('Auth.create_user_lname_label'), 'last_name'); ?>
                <div class="input-group"><span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                    <?php echo form_input($last_name, '', ['class' => 'form-control']); ?>
                </div>
            </div>

            <div class="form-group">
                <?php echo form_label(lang('Auth.create_user_email_label'), 'email'); ?> 
                <div class="input-group"><span class="input-group-addon"><i class="glyphicon glyphicon-envelope"></i></span>
                    <?php echo form_input($email, '', $dataAttr); ?>
                </div>
            </div>

            <div class="form-group">
                <?php echo form_label(lang('Auth.create_user_password_label'), 'password'); ?> 
                <div class="input-group"><span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                    <?php echo form_input($password, '', ['minlength'=>'4','class' => 'form-control', 'required' => 'true']); ?>
                </div>
            </div>

            <div class="form-group">
                <?php echo form_label(lang('Auth.create_user_password_confirm_label'), 'password_confirm'); ?>
                <div class="input-group"><span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                    <?php echo form_input($password_confirm, '', ['minlength'=>'4','class' => 'form-control', 'required' => 'true']); ?>
                </div>
            </div>

            <div class="form-group">           
                <?php echo form_label(lang('Auth.create_user_groups_label'), 'groups'); ?>
                <select name="groups[]" class="form-control">
                    <?php
                    foreach ($groups as $group) {
                        $group['id'] == 1 ? $selected = 'selected="selected"' : $selected = '';
                        echo '<option value="' . $group['id'] . '" ' . $selected . ' >' . $group['name'] . '</option>';
                    }
                    ?> 
                </select>
            </div>
            <br><br>
            <p><?php echo form_submit('submit', lang('Auth.create_user_submit_btn'), ['class' => 'btn btn-primary']); ?>
                <a href="<?php echo base_url() . 'userList' ?>" class="btn btn-default">Отказ</a>  
            </p>

            <?php echo form_close(); ?>

        </div>

        <script src="/assets/plugins/_bootstrap/jquery-3.3.1.min.js"></script>
         <script src="<?= '/assets/plugins/_bootstrap/bootstrap_3_3_7.min.js'?>"></script>