<!DOCTYPE html>
<html lang="bg">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> <?= esc($title) ?> </title>
    <!-- Bootstrap & FontAwesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <style>
      body {
        background-color: #f8f9fc;
        font-family: 'Inter', 'Segoe UI', sans-serif;
        color: #333;
      }

      /* === Modern Sidebar === */
      .modern-sidebar {
        position: fixed;
        top: 0;
        left: 0;
        width: 240px;
        height: 100vh;
        background: linear-gradient(180deg, #0d6efd 0%, #2563eb 100%);
        color: #fff;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        padding: 20px 0;
        box-shadow: 3px 0 15px rgba(0, 0, 0, 0.1);
        z-index: 1050;
      }

      .sidebar-top {
        display: flex;
        flex-direction: column;
        gap: 20px;
      }

      .sidebar-logo {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        font-weight: 600;
        font-size: 1.1rem;
      }

      .sidebar-nav {
        display: flex;
        flex-direction: column;
      }

      .nav-item {
        display: flex;
        align-items: center;
        gap: 10px;
        color: rgba(255, 255, 255, 0.9);
        padding: 10px 20px;
        text-decoration: none;
        transition: all 0.3s ease;
        border-left: 4px solid transparent;
        font-weight: 500;
      }

      .nav-item:hover {
        background: rgba(255, 255, 255, 0.1);
        color: #fff;
        transform: translateX(5px);
      }

      .nav-item.active {
        background: rgba(255, 255, 255, 0.15);
        border-left: 4px solid #fff;
        color: #fff;
      }

      .sidebar-bottom {
        border-top: 1px solid rgba(255, 255, 255, 0.2);
        padding-top: 10px;
      }

      .nav-item.logout {
        color: #ffcccc;
      }

      /* === Main === */
      .main-content {
        margin-left: 240px;
        padding: 2rem;
        min-height: 100vh;
        background-color: #f3f6fb;
      }

      .card-preview {
        background: white;
        border-radius: 1rem;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
        padding: 2rem;
      }

      .table th {
        background-color: #f0f4ff;
        color: #0d6efd;
        width: 30%;
      }

      .table td {
        background-color: #fff;
      }

      @media (max-width: 991px) {
        .modern-sidebar {
          left: -240px;
          transition: left 0.3s ease;
        }

        .modern-sidebar.show {
          left: 0;
        }

        .main-content {
          margin-left: 0;
        }
      }
    </style>
  </head>
  <body>
    <!-- 🟦 Sidebar -->
    <aside class="modern-sidebar">
      <div class="sidebar-top">
        <div class="sidebar-logo">
          <i class="fa-solid fa-chart-pie"></i>
          <span>Табло</span>
        </div>
        <nav class="sidebar-nav">
         <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
            <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
          </a>
        
          <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
            <i class="fa-solid fa-list-check"></i><span>Задачи</span>
          </a>
        
          <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
            <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-building"></i><span>Активни</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-ban"></i><span>Неактивни</span>
          </a>
        <a href="/clients" class="nav-item"><i class="fa-solid fa-users"></i><span>Профили</span></a>
        <a href="/clients/create" class="nav-item active"><i class="fa-solid fa-user-plus"></i><span>Нов профил</span></a>
        <a href="/calendar" class="nav-item"><i class="fa-solid fa-calendar-days"></i><span>Календар</span></a>
        <a href="/dashboard/cashflow" class="nav-item">
            <i class="fa-solid fa-money-bill-transfer"></i><span>Разходи</span>
        </a>
        
        <a href="/dashboard/debtors" class="nav-item">
            <i class="fa-solid fa-user-clock"></i><span>Длъжници</span>
        </a>
        
        
        <a href="/refillstock" class="nav-item">
            <i class="fa-solid fa-boxes-packing"></i><span>Дозареждане на стока</span>
        </a>
        
        <a href="/analytics" class="nav-item active"><i class="fa-solid fa-chart-line"></i>Аналитика</a>
        </nav>
      </div>
      <div class="sidebar-bottom">
        <a href="#" class="nav-item logout">
          <i class="fa-solid fa-right-from-bracket"></i>
          <span>Изход</span>
        </a>
      </div>
    </aside>

    <div class="main-content">
      <div class="card-preview">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <h4 class="text-success fw-bold mb-0">
            <i class="fa-solid fa-eye me-2"></i>Преглед на профил на фирма
          </h4>
          <div>
            <a href="/clients/edit/
											<?= $data['id'] ?>" class="btn btn-outline-primary btn-sm me-2">
              <i class="fa fa-pen me-1"></i> Редактирай </a>
            <button class="btn btn-outline-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal">
              <i class="fa fa-trash me-1"></i> Изтрий </button>
          </div>
        </div> <?php

      $labels = [
            'firm_name'   => 'Име на фирмата',
            'potential'   => 'Потенциал',
            'activity'    => 'Основен предмет на дейност',
            'status'      => 'Статус',
            'products'    => 'Основни продукти които предлага',
            'contact'     => 'Основно лице за контакт и телефон',
            'client_type' => 'Тип клиент',
            'salesperson' => 'Търговец',
            'notes'       => 'Особености',
          ];
       ?>
    <table class="table table-bordered align-middle">
          <tbody> <?php foreach ($labels as $key => $label): ?> <tr>
              <th> <?= esc($label) ?> </th>
              <td> <?= nl2br(esc($data[$key] ?? '—')) ?> </td>
            </tr> <?php endforeach; ?> </tbody>
        </table>
        <div class="text-end mt-3">
          <a href="/clients" class="btn btn-secondary">
            <i class="fa fa-arrow-left me-1"></i> Назад към списъка </a>
        </div>
      </div>
    </div>
    <!-- 🗑️ Модал за изтриване -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow">
          <div class="modal-header bg-danger bg-opacity-10 border-0">
            <h5 class="modal-title text-danger" id="deleteModalLabel">
              <i class="fa fa-triangle-exclamation me-2"></i>Потвърди изтриване
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Затвори"></button>
          </div>
          <div class="modal-body"> Наистина ли искаш да изтриеш клиента <strong> <?= esc($data['firm_name']) ?> </strong>? </div>
          <div class="modal-footer border-0">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Откажи</button>
            <a href="/clients/delete/
											<?= $data['id'] ?>" class="btn btn-danger">Да, изтрий </a>
          </div>
        </div>
      </div>
    </div>
  </body>
</html>