<!DOCTYPE html>
<html lang="bg">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Дашборд • ERP / CRM</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- FontAwesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

  <!-- ApexCharts -->
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  <style>
    body {
      background-color: #f8f9fc;
      font-family: 'Poppins', sans-serif;
      color: #333;
    }
    .card {
      border: none;
      border-radius: 1rem;
      box-shadow: 0 4px 12px rgba(0,0,0,0.05);
      transition: transform .2s ease, box-shadow .2s ease;
    }
    .card:hover {
      transform: translateY(-3px);
      box-shadow: 0 6px 20px rgba(0,0,0,0.08);
    }
    .apps-viewport {
      background-color: #fff;
      border-radius: 1rem;
      padding: 3rem 0;
      margin-bottom: 3rem;
      box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }
    .apps-header h1 { font-weight: 700; font-size: 1.6rem; }
    .apps-section-title { margin-top: 2rem; font-size: 1.25rem; font-weight: 600; }
    .icon-box {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 80px; height: 80px;
      border-radius: 18px;
      color: #fff;
      font-size: 32px;
      box-shadow: 0 6px 15px rgba(0,0,0,0.1);
      background: linear-gradient(135deg, #007bff, #6bc3ff);
      position: relative;
    }
    .app-tile { display: block; text-decoration: none; color: inherit; transition: transform .2s ease; }
    .app-tile:hover { transform: translateY(-5px); }

    .ttl-project {
      display: flex;
      justify-content: space-around;
      flex-wrap: wrap;
      gap: 20px;
      padding: 1rem 0;
      text-align: center;
    }
    .pr-data h5 { font-weight: 600; margin: 0; }
    .pr-data span { font-size: 0.9rem; color: #777; }

    .dt-do-bx { max-height: 680px; overflow-y: auto; padding: 1rem; }
    .d-items { padding: 10px; border-bottom: 1px solid #eee; }
    .d-items:last-child { border-bottom: none; }
    .total-earning h2 { font-weight: 700; color: #007bff; }

    @media (prefers-color-scheme: dark) {
      body { background-color: #1e1e2f; color: #e5e5e5; }
      .card, .apps-viewport { background-color: #2a2a40; color: #fff; }
      .app-label { color: #eee; }
      .d-items { border-bottom-color: #3c3c55; }
    }
  </style>
  
  <style>
/* === MODERN BACKGROUND + FONT + FADE-IN === */
body {
  font-family: 'Inter', 'Poppins', 'Segoe UI', sans-serif;
  color: #222;
  background: radial-gradient(1000px 600px at 15% -10%, rgba(99,102,241,0.2), transparent 60%),
              radial-gradient(1000px 600px at 120% 20%, rgba(236,72,153,0.2), transparent 60%),
              linear-gradient(180deg, #f8f9fc 0%, #eef1f7 100%);
  letter-spacing: 0.25px;
  opacity: 0;
  animation: fadeInBody 0.9s ease-out forwards;
}

@keyframes fadeInBody {
  from { opacity: 0; transform: translateY(10px); }
  to   { opacity: 1; transform: translateY(0); }
}

/* --- Cards with smooth shadow and depth --- */
.card {
  border: none;
  border-radius: 1rem;
  background: rgba(255,255,255,0.95);
  backdrop-filter: blur(10px);
  box-shadow: 0 8px 25px rgba(0,0,0,0.05);
  transform: translateY(10px);
  opacity: 0;
  animation: fadeCard 0.8s ease-out forwards;
}
@keyframes fadeCard {
  to { opacity: 1; transform: translateY(0); }
}

/* --- Headers --- */
.apps-header h1 {
  font-weight: 800;
  font-size: 1.9rem;
  background: linear-gradient(90deg, rgba(99,102,241,1), rgba(236,72,153,0.9));
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  margin-bottom: 0.6rem;
  animation: fadeInText 1s ease both;
}
.apps-header p {
  color: #555;
  font-size: 1.05rem;
  animation: fadeInText 1.2s ease both;
}
@keyframes fadeInText {
  from { opacity: 0; transform: translateY(8px); }
  to { opacity: 1; transform: translateY(0); }
}

/* --- Card hover --- */
.card:hover {
  transform: translateY(-3px);
  box-shadow: 0 12px 32px rgba(0,0,0,0.08);
}

/* --- Scrollbar refinement --- */
::-webkit-scrollbar {
  width: 8px;
}
::-webkit-scrollbar-thumb {
  background-color: rgba(99,102,241,0.4);
  border-radius: 4px;
}
::-webkit-scrollbar-thumb:hover {
  background-color: rgba(99,102,241,0.7);
}

/* --- DataTables & Footer tweaks --- */
.dataTables_wrapper .dataTables_filter input {
  border-radius: 8px;
  border: 1px solid #ccc;
  padding: 5px 10px;
}
.card-footer {
  margin-top: 1rem;
  background: linear-gradient(90deg, #f8f9fb 0%, #eef1f5 100%);
  border-top: 1px solid #e9ecef;
  color: #555;
  font-weight: 500;
}

/* --- Dark Mode polish --- */
@media (prefers-color-scheme: dark) {
  body {
    background: linear-gradient(180deg, #1e1e2b 0%, #191923 100%);
    color: #ddd;
  }
  .card {
    background: rgba(40,42,60,0.92);
    border: 1px solid rgba(255,255,255,0.08);
  }
  .apps-header h1 {
    -webkit-text-fill-color: rgba(255,255,255,0.9);
  }
}
</style>

<!-- FullCalendar -->
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>

</head>
<body>
<!-- 🟦 Фиксиран Sidebar -->
<!-- 🧭 Modern Sidebar -->

<style>
/* 🌙 Modern Sidebar */
.modern-sidebar {
  position: absolute; /* или sticky, в зависимост от ефекта */
  top: 0;
  left: 0;
  width: 240px;
  min-height: 100%;
  background: linear-gradient(180deg, #0d6efd 0%, #2563eb 100%);
  color: #fff;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
  padding: 20px 0;
  box-shadow: 3px 0 15px rgba(0, 0, 0, 0.1);
  z-index: 1050;
}

.sidebar-top {
  display: flex;
  flex-direction: column;
  gap: 20px;
}

.sidebar-logo {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
  font-weight: 600;
  font-size: 1.1rem;
}

.sidebar-nav {
  display: flex;
  flex-direction: column;
}

.nav-item {
  display: flex;
  align-items: center;
  gap: 10px;
  color: rgba(255,255,255,0.9);
  padding: 10px 20px;
  text-decoration: none;
  transition: all 0.3s ease;
  border-left: 4px solid transparent;
  font-weight: 500;
}

.nav-item:hover {
  background: rgba(255,255,255,0.1);
  color: #fff;
  transform: translateX(5px);
}

.nav-item.active {
  background: rgba(255,255,255,0.15);
  border-left: 4px solid #fff;
  color: #fff;
}

.sidebar-bottom {
  border-top: 1px solid rgba(255,255,255,0.2);
  padding-top: 10px;
}

.nav-item.logout {
  color: #ffcccc;
}

.main-content {
  margin-left: 240px;
  transition: margin-left 0.3s ease;
  background: #f8f9fa;
  min-height: 100vh;
}
/* Prevent card-body from stretching */
.card.flex-fill {
  height: auto;
}

/* Make chart define the height, not card-body */
#overviewGroupsChart {
  height: 500px;
}
/* 📱 Responsive */
@media (max-width: 991px) {
  .modern-sidebar {
    left: -240px;
    transition: left 0.3s ease;
  }
  .modern-sidebar.show {
    left: 0;
  }
  .main-content {
    margin-left: 0;
  }
}
</style>

<aside class="modern-sidebar">
  <div class="sidebar-top">
    <div class="sidebar-logo">
      <i class="fa-solid fa-chart-pie"></i>
      <span>Табло</span>
    </div>

    <nav class="sidebar-nav">

         <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
            <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
          </a>
        
          <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
            <i class="fa-solid fa-list-check"></i><span>Задачи</span>
          </a>
        
          <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
            <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-building"></i><span>Активни</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-ban"></i><span>Неактивни</span>
          </a>

            <a href="/clients" class="nav-item"><i class="fa-solid fa-users"></i><span>Профили</span></a>
            <a href="/clients/create" class="nav-item "><i class="fa-solid fa-user-plus"></i><span>Нов профил</span></a>
            <a href="/calendar" class="nav-item"><i class="fa-solid fa-calendar-days"></i><span>Календар</span></a>
            <a href="/dashboard/cashflow" class="nav-item">
                <i class="fa-solid fa-money-bill-transfer"></i><span>Разходи</span>
            </a>
            
            <a href="/dashboard/debtors" class="nav-item">
                <i class="fa-solid fa-user-clock"></i><span>Длъжници</span>
            </a>
            
            
            <a href="/refillstock" class="nav-item">
                <i class="fa-solid fa-boxes-packing"></i><span>Дозареждане на стока</span>
            </a>
            
            <a href="/analytics" class="nav-item "><i class="fa-solid fa-chart-line"></i>Аналитика</a>

    </nav>
  </div>

  <div class="sidebar-bottom">
    <a href="#" class="nav-item logout">
      <i class="fa-solid fa-right-from-bracket"></i><span>Изход</span>
    </a>
  </div>
</aside>


<div class="main-content">
<div class="col-12 py-5">
<?php
// 🔹 НАВИГАЦИЯ (НЕ СЕ ПИПА)
if (! function_exists('render_attrs')) {
  function render_attrs(array $attrs): string {
    $pairs = [];
    foreach ($attrs as $k => $v) {
      if ($v === null || $v === false) continue;
      if ($v === true) { $pairs[] = $k; continue; }
      $raw = in_array($k, ['onclick'], true);
      $pairs[] = sprintf('%s="%s"', $k, $raw ? $v : esc($v, 'attr'));
    }
    return $pairs ? ' ' . implode(' ', $pairs) : '';
  }
}
$groups = [];
foreach (($nav['groups'] ?? []) as $g) {
  $row = [];
  foreach ($g['items'] ?? [] as $it) {
    $row[] = [
      'label' => $it['label'],
      'fa'    => $it['icon'] ?? 'fa fa-square',
      'attrs' => $it['attrs'] ?? ['href' => '#'],
      'id'    => $it['id'] ?? null,
    ];
  }
  $groups[$g['title']] = $row;
}
?>


<div class="apps-viewport"
     style="--bg-url: url('<?= $_ENV['app.imageDataDir'] . 'logos/rvb-logo.png' ?>');">
  <div class="container-fluid px-0 d-flex flex-column justify-content-center align-items-center">
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-lg-10 col-xl-8 text-center apps-header">
        <h1>Контролен панел • ERP / CRM анализи</h1>
    <p class="lead text-muted">
      Централизирана информация за продажби, партньори и ефективност.  
      Динамични данни, графики и статистики за по-интелигентни бизнес решения.
    </p>
      </div>
    </div>

<div class="d-flex gap-2 mb-3">

    <button class="btn btn-sm btn-outline-primary" onclick="savePreset('active')">
        💾 Запази филтрите (Активни)
    </button>

    <button class="btn btn-sm btn-outline-primary" onclick="savePreset('inactive')">
        💾 Запази филтрите (Неактивни)
    </button>

    <button class="btn btn-sm btn-outline-primary" onclick="savePreset('earnings')">
        💾 Запази филтрите (Печалби)
    </button>

    <button class="btn btn-sm btn-outline-primary" onclick="savePreset('stock')">
        💾 Запази филтрите (Движение на стока)
    </button>

    <button class="btn btn-sm btn-outline-primary" onclick="savePreset('deliveries')">
        💾 Запази филтрите (Залежала стока)
    </button>

    <button class="btn btn-sm btn-success ms-3" onclick="saveAllPresets()">
        💾 Запази всички филтри
    </button>

</div>





    <?php $globalIndex = 0; foreach ($groups as $title => $items): ?>
      <div class="apps-section" data-group-title="<?= esc($title) ?>">
        <h2 class="apps-section-title text-center"><?= esc($title) ?></h2>
        <div class="row justify-content-center w-100 app-grid">
          <?php foreach ($items as $it): $g = 'g' . (($globalIndex++ % 8) + 1); ?>
            <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-4 px-2 text-center app-tile-wrap">
              <a class="app-tile" <?= render_attrs($it['attrs'] ?? []) ?> target="_blank" data-item-id="<?= esc($it['id']) ?>">
                <div class="icon-box <?= $g ?>">
                  <i class="icon-fa <?= esc($it['fa'] ?? 'fa fa-square') ?>"></i>
                </div>
                <div class="app-label"><?= nl2br(esc($it['label'])) ?></div>
              </a>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
</div>

<!-- 🧩 Трите диаграмни бокса на един ред -->
<div class="container-fluid px-4">
  <div class="row g-4 align-items-stretch">

    <!-- Project Overview -->
    <div class="col-xl-5 col-lg-5 col-md-12 d-flex" style="flex: 0 0 39%;">
      <div class="card flex-fill">

        <!-- Card header with toggles -->
        <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
          <h5 class="mb-0 fw-bold">ГЛАВНИ ГРУПИ - приходи и обороти</h5>

          <!-- Chart series toggles -->
          <div class="btn-group btn-group-sm">
            <button class="btn btn-outline-primary active" id="toggleProfit">
              Чист приход
            </button>
            <button class="btn btn-outline-success active" id="toggleTurnover">
              Оборот
            </button>
          </div>
        </div>

        <!-- Chart body -->
        <div class="card-body">
          <div id="overviewGroupsChart" style="min-height: 320px;"></div>
        </div>

        <!-- Totals row -->
        <div id="groupsTotals" class="ttl-project border-top pt-3">
          <!-- Filled dynamically by JS -->
        </div>

      </div>
    </div>

 

<script>

document.querySelectorAll('input[type="date"]').forEach(input => {

  input.addEventListener('keydown', e => {
    // Allow control / navigation keys
    if (
      e.key === 'Tab' ||
      e.key === 'ArrowLeft' ||
      e.key === 'ArrowRight' ||
      e.key === 'Backspace' ||
      e.key === 'Delete'
    ) {
      return;
    }

    // Block number typing
    if (!e.ctrlKey && !e.metaKey) {
      e.preventDefault();
    }
  });

});
document.addEventListener("DOMContentLoaded", async () => {

  // ==========================
  // FETCH DATA
  // ==========================
  const response = await fetch('/dashboard/overviewGroups');
  const data = await response.json();

  // ==========================
  // CALCULATE TOTALS
  // ==========================
  const totalProfit   = data.profit.reduce((a, b) => a + b, 0).toFixed(2);
  const totalTurnover = data.turnover.reduce((a, b) => a + b, 0).toFixed(2);

  // Render totals below the chart
  document.querySelector("#groupsTotals").innerHTML = `
    <div class="pr-data">
      <h5>${totalProfit} лв</h5>
      <span>Чист приход</span>
    </div>
    <div class="pr-data">
      <h5 class="text-primary">${totalTurnover} лв</h5>
      <span>Оборот</span>
    </div>
    <div class="pr-data">
      <h5>${data.labels.length}</h5>
      <span>Групи</span>
    </div>
  `;

  // ==========================
  // SERIES VISIBILITY STATE
  // At least ONE must stay enabled
  // ==========================
  let showProfit   = true;
  let showTurnover = true;

  // Build chart series based on active toggles
  function buildSeries() {
    const series = [];

    if (showProfit) {
      series.push({
        name: "Чист приход",
        data: data.profit
      });
    }

    if (showTurnover) {
      series.push({
        name: "Оборот",
        data: data.turnover
      });
    }

    return series;
  }

  // ==========================
  // INITIALIZE APEX CHART
  // ==========================
  const chart = new ApexCharts(
    document.querySelector("#overviewGroupsChart"),
    {
      chart: {
        type: "bar",
        height: 510
      },
      plotOptions: {
        bar: {
          horizontal: true,
          borderRadius: 6
        }
      },
      series: buildSeries(),
      xaxis: {
        categories: data.labels,
        labels: {
          style: { fontSize: "12px" }
        }
      },
      colors: ['#007bff', '#3ac977'],
      grid: { strokeDashArray: 4 },
      dataLabels: { enabled: false },
      tooltip: {
        y: {
          formatter: val => val.toFixed(2) + " лв"
        }
      },
      legend: { show: false }
    }
  );

  chart.render();

  // ==========================
  // TOGGLE BUTTON LOGIC
  // Prevent disabling the last visible series
  // ==========================
  const profitBtn   = document.getElementById("toggleProfit");
  const turnoverBtn = document.getElementById("toggleTurnover");

  function updateChart() {
    chart.updateSeries(buildSeries());
  }

  profitBtn.addEventListener("click", () => {
    // Block disabling if this is the last active series
    if (showProfit && !showTurnover) return;

    showProfit = !showProfit;
    profitBtn.classList.toggle("active", showProfit);
    updateChart();
  });

  turnoverBtn.addEventListener("click", () => {
    // Block disabling if this is the last active series
    if (showTurnover && !showProfit) return;

    showTurnover = !showTurnover;
    turnoverBtn.classList.toggle("active", showTurnover);
    updateChart();
  });

});
</script>


<!-- ✅ МОИТЕ ЗАДАЧИ -->
<div class="col-xl-2 col-lg-3 col-md-12 d-flex tasks" style="flex: 0 0 20%;">
  <div class="card flex-fill shadow-sm">
    <div class="card-header border-0 d-flex justify-content-between align-items-center">
      <h5 class="mb-0 fw-bold">Моите задачи</h5>
      <div>
        <a href="#" class="text-primary small me-2">Всички</a>
        <a href="#" class="text-dark small" id="addTaskBtn">+ Добави</a>
      </div>
    </div>
    <div class="card-body p-3">
      <div class="dt-do-bx" id="todoList">
        <div class="text-center text-muted py-3">Няма задачи</div>
      </div>
    </div>
  </div>
</div>

<!-- 🟩 Modal: Добавяне на нова задача -->
<div class="modal fade" id="addTaskModal" tabindex="-1" aria-labelledby="addTaskModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg rounded-4">
      <div class="modal-header bg-success bg-opacity-10 border-0">
        <h5 class="modal-title fw-bold text-success" id="addTaskModalLabel">
          <i class="fa-solid fa-list-check me-2"></i>Добавяне на нова задача
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <div class="modal-body">
        <form id="taskForm" class="row g-3">
          <!-- Фирма -->
          <div class="col-md-6">
            <label class="form-label fw-semibold">Фирма *</label>
            <div class="input-group">
              <select id="firmSelect" class="form-select form-select-sm select2">
                <option value="">Избери фирма</option>
                <option value="3S СОТ2" data-grad="Хасково" data-adres="ул.Драгоман 14" data-tel="---">3S СОТ2</option>
                <option value="СКАЙ ЛИНК" data-grad="София" data-adres="бул. България 25" data-tel="0888123456">СКАЙ ЛИНК</option>
              </select>
              <button style="display:none;" class="btn btn-outline-secondary btn-sm" type="button" id="clearFirm">
                <i class="fa fa-eraser"></i>
              </button>
            </div>
          </div>
<!-- Кой потребител е отговорен -->
<div class="col-md-6">
    <label class="form-label fw-semibold">Потребител *</label>
    <select id="taskUserSelect" class="form-select form-select-sm">
        <option value="">Зареждане...</option>
    </select>
</div>
          <!-- Град -->
          <div class="col-md-6">
            <label class="form-label fw-semibold">Град *</label>
            <input type="text" id="grad" class="form-control form-control-sm" required>
          </div>

          <!-- Адрес -->
          <div class="col-md-6">
            <label class="form-label fw-semibold">Адрес *</label>
            <input type="text" id="adres" class="form-control form-control-sm" required>
          </div>

          <!-- Телефон -->
          <div class="col-md-6">
            <label class="form-label fw-semibold">Телефон *</label>
            <input type="text" id="tel" class="form-control form-control-sm" required>
          </div>

          <!-- Дати -->
          <div class="col-md-6">
            <label class="form-label fw-semibold">Начална дата</label>
            <input type="text" id="startDate" class="form-control form-control-sm date-picker2" >
          </div>
          <div class="col-md-6">
            <label class="form-label fw-semibold">Крайна дата</label>
            <input type="text" id="endDate"   class="form-control form-control-sm date-picker2" >
          </div>

          <!-- Приоритет -->
          <div class="col-md-6">
            <label class="form-label fw-semibold">Приоритет</label>
                <select id="prioritet" class="form-select form-select-sm">
                  <option value="Нормален" style="color:#0d6efd;">◼ Нормален</option>
                  <option value="Висок" style="color:#dc3545;">◼ Висок</option>
                  <option value="Нисък" style="color:#198754;">◼ Нисък</option>
                </select>
          </div>

          <!-- Оферта и стойност -->
          <div class="col-md-3">
            <label class="form-label fw-semibold">Оферта №</label>
            <input type="text" id="oferta" class="form-control form-control-sm">
          </div>
          <div class="col-md-3">
            <label class="form-label fw-semibold">Стойност на проекта</label>
            <input type="number" id="projectValue" class="form-control form-control-sm" step="0.01">
          </div>

          <!-- Документ -->
          <div class="col-md-6">
            <label class="form-label fw-semibold">Документ към проекта</label>
            <input type="text" id="document" class="form-control form-control-sm" placeholder="Фактура / Протокол">
          </div>

          <!-- Описание -->
          <div class="col-12">
            <label class="form-label fw-semibold">Описание *</label>
            <textarea id="description" class="form-control form-control-sm" rows="3" required></textarea>
          </div>

          <!-- Коментар -->
          <div class="col-12">
            <label class="form-label fw-semibold">Коментар</label>
            <textarea id="comment" class="form-control form-control-sm" rows="2"></textarea>
          </div>

          <!-- Статус -->
          <div class="col-md-6">
            <label class="form-label fw-semibold">Статус</label>
            <select id="status" class="form-select form-select-sm">
              <option value="НОВА" style="color:#0d6efd;">НОВА</option>
              <option value="В ПРОЦЕС НА РАБОТА" style="color:#fd7e14;">В ПРОЦЕС НА РАБОТА</option>
              <option value="ЗАВЪРШЕНА" style="color:#198754;">ЗАВЪРШЕНА</option>
              <option value="НЕЗАВЪРШЕНА" style="color:#dc3545;">НЕЗАВЪРШЕНА</option>
            </select>
          </div>

          <!-- Бутон за запазване -->
          <div class="col-12 text-end mt-3">
            <button type="submit" class="btn btn-success btn-sm px-4">
              <i class="fa fa-save me-1"></i> Запази задача
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- 🧩 CSS поправки -->
<style>
.modal {
  overflow-y: auto !important;
}
.modal-dialog {
  margin-top: 3vh !important;
  margin-bottom: 3vh !important;
}
.modal-backdrop {
  position: fixed !important;
  top: 0;
  left: 0;
  width: 100vw;
  height: 100vh;
  background-color: rgba(0, 0, 0, 0.5) !important;
  z-index: 1040;
}
body.modal-open {
  overflow: visible !important;
}
.modal-dialog-centered {
    display: flex;
    align-items: center;
    min-height: 1000px;
}
#addTaskModal .modal-body {
  max-height: 75vh;
  overflow-y: auto;
  padding-right: 1rem;
}

/* 🟢 Гарантирано пълен overlay */
.modal-backdrop.show {
  position: fixed !important;
  inset: 0 !important; /* същото като top:0; left:0; right:0; bottom:0 */
  width: 100vw !important;
  height: auto !important;
  background-color: rgba(0, 0, 0, 0.55) !important;
  z-index: 1050 !important;
}

#earningsTable table th,
#earningsTable table td {
    width: 33.33% !important;
}
#earningsTable table {
    table-layout: fixed !important;
    width: 100%;
}

#earningsTable table th,
#earningsTable table td {
    vertical-align: middle !important; 
    text-align: center;                
}

#earningsTable table th {
    font-weight: 600;
}
</style>

<!-- 🧩 Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
const STORAGE_KEY = "tasks";

function getTasks() {
  return JSON.parse(localStorage.getItem(STORAGE_KEY) || "[]");
}

function saveTasks(tasks) {
  localStorage.setItem(STORAGE_KEY, JSON.stringify(tasks));
}
function today() {
    const d = new Date();
    return d.toISOString().split("T")[0];
}

document.getElementById("startDate").value = today();

// =========================================
//   ЗАРЕЖДАНЕ НА ФИРМИ И ПОТРЕБИТЕЛИ
// =========================================
let allFirms1 = [];

function loadFirmsTask() {
  fetch("/dashboard/loadFirmsFromDB")
    .then(r => r.json())
    .then(data => {
      firmSelect.innerHTML = `<option value="">Избери фирма</option>`;

      data.forEach(f => {
        firmSelect.innerHTML += `
          <option value="${f.klient_name}"
            data-grad="${f.klient_grad || ''}"
            data-adres="${f.klient_adres || ''}"
            data-tel="${f.klient_tel || ''}">
            ${f.klient_name}
          </option>`;
      });

      // ✅ ЕТО ТОВА ЛИПСВАШЕ
      if (pendingFirm) {
        firmSelect.value = pendingFirm;
        firmSelect.dispatchEvent(new Event("change"));
        pendingFirm = null;
      }
    });
}

function loadUsersTask() {
  fetch("/dashboard/loadUsers")
    .then(r => r.json())
    .then(users => {
      taskUserSelect.innerHTML = `<option value="">Избери потребител</option>`;

      users.forEach(u => {
        const name = `${u.first_name} ${u.last_name}`;
        taskUserSelect.innerHTML += `<option value="${name}">${name}</option>`;
      });

      // ✅ И ТУК
      if (pendingUser) {
        taskUserSelect.value = pendingUser;
        pendingUser = null;
      }
    });
}

loadFirmsTask();
loadUsersTask();

// =========================================
//   ОТВАРЯНЕ НА МОДАЛ
// =========================================
document.getElementById("addTaskBtn").onclick = (e) => {
    e.preventDefault();
    new bootstrap.Modal(document.getElementById("addTaskModal")).show();
};

// =========================================
//  АВТО-ПОПЪЛВАНЕ НА ФИРМЕНА ИНФОРМАЦИЯ
// =========================================
document.getElementById("firmSelect").addEventListener("change", function () {
    const o = this.selectedOptions[0];
    document.getElementById("grad").value = o.dataset.grad || "";
    document.getElementById("adres").value = o.dataset.adres || "";
    document.getElementById("tel").value = o.dataset.tel || "";
});

function getTaskVisualInfo(task) {
    const today = new Date();
    const end = task.endDate ? new Date(task.endDate) : null;

    let visualStatus = task.status || "НОВА";
    let bgColor = "#0d6efd22"; // default синьо
    let badge = "🟦 НОВА";
    let deadlineText = "";

    // ако има краен срок и е минал
    if (end && end < today && task.status !== "ЗАВЪРШЕНА") {
        visualStatus = "НЕЗАВЪРШЕНА";
    }

    switch (visualStatus) {
        case "НОВА":
            bgColor = "#0d6efd22";
            badge = "🟦 НОВА";
            break;

        case "В ПРОЦЕС НА РАБОТА":
            bgColor = "#fd7e1422";
            badge = "🟧 В ПРОЦЕС";
            break;

        case "ЗАВЪРШЕНА":
            bgColor = "#19875422";
            badge = "🟩 ЗАВЪРШЕНА";
            break;

        case "НЕЗАВЪРШЕНА":
            bgColor = "#dc354522";
            badge = "🟥 НЕЗАВЪРШЕНА";
            break;
    }

    // срок
    if (end) {
        const diff = Math.ceil((end - today) / 86400000);

        if (diff > 0 && visualStatus !== "ЗАВЪРШЕНА") {
            deadlineText = `⏳ Остават ${diff} дни`;
        } else if (diff === 0) {
            deadlineText = "⚠️ Краен срок: ДНЕС";
        } else if (diff < 0 && visualStatus === "НЕЗАВЪРШЕНА") {
            deadlineText = `❌ Просрочено с ${Math.abs(diff)} дни`;
        }
    } else {
        deadlineText = "ℹ️ Без краен срок";
    }

    return {
        visualStatus,
        bgColor,
        badge,
        deadlineText
    };
}

// =========================================
//  РЕНДЕР НА ЗАДАЧИТЕ
// =========================================
function renderTasks() {
    const list = document.getElementById("todoList");
    const tasks = getTasks();

    if (!tasks.length) {
        list.innerHTML = `<div class="text-center text-muted py-3">Няма задачи</div>`;
        return;
    }

    list.innerHTML = tasks.map(task => {
        const info = getTaskVisualInfo(task);

        return `
        <div class="p-2 mb-2 border rounded" style="background:${info.bgColor};">
            <div class="fw-bold">${info.badge}</div>
            <div class="small fw-semibold">${info.deadlineText}</div>
            <div class="mt-1"><b>${task.firm}</b></div>
            <div class="small text-muted">${task.description}</div>
            <div class="small">Приоритет: <b>${task.prioritet || "Нормален"}</b></div>
            <div class="small">Краен срок: ${task.endDate || "—"}</div>
        </div>`;
    }).join("");
}
function normalizeDate(value) {
  if (!value) return "";

  // вече ISO
  if (/^\d{4}-\d{2}-\d{2}$/.test(value)) {
    return value;
  }

  // d/m/Y от flatpickr
  if (value.includes("/")) {
    const [d, m, y] = value.split("/");
    return `${y}-${m}-${d}`;
  }

  return "";
}
const firmSelect     = document.getElementById("firmSelect");
const taskUserSelect = document.getElementById("taskUserSelect");
const grad           = document.getElementById("grad");
const adres          = document.getElementById("adres");
const tel            = document.getElementById("tel");
const startDate      = document.getElementById("startDate");
const endDate        = document.getElementById("endDate");
const prioritet      = document.getElementById("prioritet");
const oferta         = document.getElementById("oferta");
const projectValue   = document.getElementById("projectValue");
const documentInput  = document.getElementById("document"); // 👈 ВАЖНО
const description    = document.getElementById("description");
const comment        = document.getElementById("comment");
const status         = document.getElementById("status");
/* ========================================================================
   CREATE / UPDATE TASK
======================================================================== */
function buildTask() {
  return {
    id: Date.now().toString(),
    firm: firmSelect.value.trim(),
    user: taskUserSelect.value.trim(),
    grad: grad.value.trim(),
    adres: adres.value.trim(),
    tel: tel.value.trim(),
    startDate: normalizeDate(startDate.value) || today(),
    endDate: normalizeDate(endDate.value),
    prioritet: prioritet.value,
    oferta: oferta.value.trim(),
    projectValue: projectValue.value || "",
    document: documentInput.value.trim(), // ✅ ТУК Е ПОПРАВКАТА
    description: description.value.trim(),
    comment: comment.value.trim(),
    status: status.value || "НОВА"
  };
}

document.getElementById("taskForm").addEventListener("submit", function (e) {
  e.preventDefault();

    

    const tasks = getTasks();
    const task = buildTask();

    tasks.push(task);
    saveTasks(tasks);

    // 🔥 ВАЖНО
    if (typeof renderTasks === "function") {
      renderTasks();
    }

    if (typeof renderCalendar === "function") {
      renderCalendar();
    }

    this.reset();
    startDate.value = today();

    bootstrap.Modal
      .getInstance(document.getElementById("addTaskModal"))
      .hide();
});


// =========================================
//   СТАРТИРАЙ РЕНДЕРА
// =========================================
document.addEventListener("DOMContentLoaded", renderTasks);

</script>



    <!-- Total Earning -->
    <div class="col-xl-5 col-lg-5 col-md-12 d-flex prihodi" style="flex: 0 0 39%;">
      <div class="card flex-fill">
        <div class="card-header border-0 pb-0">
          <h5 class="mb-0 fw-bold">Общо приходи</h5>
        </div>
        <div class="card-body text-center d-flex flex-column justify-content-center">
          <h2 class="mb-3">0 €</h2>
          <div class="d-flex justify-content-center align-items-center gap-2 mb-3 flex-wrap">
  <ul class="nav nav-pills mb-0">
    <li class="nav-item"><button class="nav-link active">Ден</button></li>
    <li class="nav-item"><button class="nav-link">Седмица</button></li>
    <li class="nav-item"><button class="nav-link">Месец</button></li>
    <li class="nav-item"><button class="nav-link">Година</button></li>
  </ul>

  <div class="input-group input-group-sm" style="width: 270px;">
    <input type="date" id="fromDate" class="form-control" onkeydown="return false;">
    <span class="input-group-text">до</span>
    <input type="date" id="toDate" class="form-control"  onkeydown="return false;">
    <button class="btn btn-primary btn-sm" id="applyRange"><i class="fa fa-filter"></i></button>
    <!-- 🧍‍♂️ Филтър по агент -->
<div class="mt-2 text-center">
  <select id="agentFilter" class="form-select form-select-sm d-inline-block" style="width:auto; min-width:200px;">
    <option value="">Всички агенти</option>
    <?php foreach ($agents as $agent): ?>
      <option value="<?= esc($agent) ?>"><?= esc($agent) ?></option>
    <?php endforeach; ?>
  </select>
</div>

<div class="mt-2 text-center">
  <button id="toggleView" class="btn btn-outline-secondary btn-sm d-none">
    📊 Табличен изглед
  </button>
</div>

  </div>
</div>

          <div id="earningChart" style="min-height:260px;"></div>
          
          <!-- 📋 Табличен изглед (скрит по подразбиране) -->
<div id="earningsTable" class="d-none mt-3 text-start" style="max-width:600px;margin:auto;">
    
    <div id="activeFilters" class="alert alert-info py-2 px-3 d-none mt-3" 
     style="max-width:200px;margin:auto;font-size:14px; margin-top:-40px;margin-bottom:30px;">
</div>

  <h6 id="tableTitle" class="fw-bold text-center mb-3">
    ЧИСТ ПРИХОД ПО ТИП КЛИЕНТИ
  </h6>
  <div class="text-center mb-2">
    <button id="toggleMetric" class="btn btn-outline-primary btn-sm">
      Показвай оборот
    </button>
  </div>
  <table class="table table-sm table-striped align-middle">
    <thead class="table-light">
      <tr>
        <th>Тип клиент</th>
        <th id="metricHeader" class="text-end">Чист приход</th>
        <th class="text-end">Дял от общия оборот</th>
      </tr>
    </thead>
    <tbody></tbody>
    <tfoot class="table-light">
      <tr>
        <th>ОБЩ ТОТАЛ</th>
        <th id="summaryTotal" class="text-end"></th>
        <th></th>
      </tr>
    </tfoot>
  </table>
</div>

        </div>
      </div>
    </div>

  </div>
</div>


<script>

document.addEventListener("DOMContentLoaded", () => {

  // Offset from the top (useful if you have a fixed header)
  const OFFSET = 80;

  // All sidebar navigation items
  const menuItems = document.querySelectorAll(".sidebar-nav .nav-item");

  /**
   * Smoothly scrolls the page to a target element
   * @param {string} selector - CSS selector of the target element
   */
  function scrollToTarget(selector) {
    const el = document.querySelector(selector);
    if (!el) return;

    // Calculate the final scroll position with offset
    const y =
      el.getBoundingClientRect().top +
      window.pageYOffset -
      OFFSET;

    window.scrollTo({
      top: y,
      behavior: "smooth"
    });
  }

  // ==========================
  // MENU CLICK HANDLING
  // ==========================
  menuItems.forEach(item => {
    item.addEventListener("click", e => {
      const target = item.dataset.target;
      if (!target) return;

      // If we are already on /dashboard, prevent full page reload
      if (window.location.pathname === "/dashboard") {
        e.preventDefault();

        // Update the URL (hash) without reloading the page
        history.pushState(null, "", item.getAttribute("href"));

        // Scroll to the related container
        scrollToTarget(target);

        // Set active menu item
        setActive(item);
      }
    });
  });

  // ==========================
  // HANDLE DIRECT URL WITH HASH
  // Example: /dashboard#tasks
  // ==========================
  function handleHash() {
    const hash = window.location.hash;
    if (!hash) return;

    // Find the menu item that matches the hash
    const item = document.querySelector(
      `.nav-item[href$="${hash}"]`
    );
    if (!item) return;

    const target = item.dataset.target;
    if (!target) return;

    // Delay to ensure layout is fully rendered
    setTimeout(() => {
      scrollToTarget(target);
      setActive(item);
    }, 200);
  }

  // ==========================
  // SET ACTIVE MENU ITEM
  // ==========================
  function setActive(activeItem) {
    menuItems.forEach(i => i.classList.remove("active"));
    activeItem.classList.add("active");
  }

  // Run hash handling on page load
  handleHash();

});

// 💰 Периодични бутони
document.querySelectorAll('.nav-link').forEach(btn => {
  btn.addEventListener('click', async () => {
    document.querySelectorAll('.nav-link').forEach(b => b.classList.remove('active'));
    btn.classList.add('active');

    const period = btn.textContent.toLowerCase();
    const response = await fetch(`/dashboard/data/${period}`);
    const data = await response.json();

    updateEarnings(data);
  });
});

// 🎯 Филтър по агент
document.getElementById('agentFilter').addEventListener('change', async () => {
  const from = document.getElementById('fromDate').value;
  const to   = document.getElementById('toDate').value;
  const agent = document.getElementById('agentFilter').value;

  if (!from || !to) {
    alert('Моля, изберете начален и краен период!');
    return;
  }

  const response = await fetch(`/dashboard/dataCustom?from=${from}&to=${to}&agent=${encodeURIComponent(agent)}`);
  const data = await response.json();

  if (data.error) return alert(data.error);

  updateEarnings(data);
});

// 📅 Custom filter
document.getElementById('applyRange').addEventListener('click', async () => {
  const from = document.getElementById('fromDate').value;
  const to   = document.getElementById('toDate').value;

  if (!from || !to) {
    alert('Изберете начален и краен период!');
    return;
  }

  const response = await fetch(`/dashboard/dataCustom?from=${from}&to=${to}`);
  const data = await response.json();

  if (data.error) return alert(data.error);

  updateEarnings(data);
});

// 🔵 Обобщаване на приходи
function updateEarnings(data) {
  const earningValue = document.querySelector(".card-body h2");
  earningValue.textContent = data.total.toLocaleString('bg-BG', { minimumFractionDigits: 2 }) + " €";

  const toggleBtn = document.getElementById("toggleView");

  if (data.summary) {
    toggleBtn.classList.remove("d-none");
    toggleBtn.dataset.summary = JSON.stringify(data.summary);
    toggleBtn.dataset.summaryTotal = data.summary_total;
  } else {
    toggleBtn.classList.add("d-none");
  }

  earningChart.updateOptions({
    xaxis: { categories: data.labels },
    series: [
      { name: "Оборот", data: data.income },
      { name: "Чист приход", data: data.profit }
    ]
  });

  updateActiveFilters();
}

// 🔵 Ново – показва кои филтри са активни
function updateActiveFilters() {
    const agent = document.getElementById("agentFilter").value || "Всички агенти";
    const from  = document.getElementById("fromDate").value;
    const to    = document.getElementById("toDate").value;

    const box = document.getElementById("activeFilters");

    let html = "";

    function fmt(d) {
        if (!d) return "";
        const p = d.split("-");
        return `${p[2]}.${p[1]}.${p[0]}`;
    }

    if (from && to) {
        html += `<b>Период:</b> ${fmt(from)} → ${fmt(to)}<br>`;
    }

    html += `<b>Агент:</b> ${agent}`;

    box.innerHTML = html;

    if (!document.getElementById("earningsTable").classList.contains("d-none")) {
        box.classList.remove("d-none");
    }
}

// 🔄 Превключване графика <-> таблица
document.getElementById("toggleView").addEventListener("click", function () {
  const chartDiv = document.getElementById("earningChart");
  const tableDiv = document.getElementById("earningsTable");
  const filterBox = document.getElementById("activeFilters");

  const titleEl        = document.getElementById("tableTitle");
  const metricHeader   = document.getElementById("metricHeader");
  const toggleMetricBtn= document.getElementById("toggleMetric");

  if (tableDiv.classList.contains("d-none")) {

    const rawSummary = JSON.parse(this.dataset.summary || "[]");
    const tbody      = tableDiv.querySelector("tbody");

    const summary = rawSummary.map(r => ({
      client_type: r.client_type || "Неопределен",
      profit:     Number(r.profit ?? r.total ?? 0),
      turnover:   Number(r.turnover ?? r.income ?? 0)
    }));

    window.currentMetric = window.currentMetric || "profit";

    const totalProfit   = summary.reduce((s, r) => s + r.profit, 0);
    const totalTurnover = summary.reduce((s, r) => s + r.turnover, 0);

    function renderTable(metric = "profit") {
      tbody.innerHTML = "";

      const grouped = {};

      summary.forEach(r => {
        const type = r.client_type;
        if (!grouped[type]) grouped[type] = { profit: 0, turnover: 0 };

        grouped[type].profit   += r.profit;
        grouped[type].turnover += r.turnover;
      });

      const totalMetric = metric === "profit" ? totalProfit : totalTurnover;

      Object.entries(grouped).forEach(([type, val]) => {
        const value = metric === "profit" ? val.profit : val.turnover;
        const share = totalMetric > 0 ? (value / totalMetric) * 100 : 0;

        tbody.insertAdjacentHTML("beforeend", `
          <tr>
            <td>${type}</td>
            <td class="text-end">${value.toLocaleString("bg-BG", {minimumFractionDigits:2})} €</td>
            <td class="text-end">${share.toFixed(2)} %</td>
          </tr>
        `);
      });

      // ❗ FIX: тук сетваме тотала
      document.getElementById("summaryTotal").textContent =
        totalMetric.toLocaleString("bg-BG", { minimumFractionDigits: 2 }) + " €";

      titleEl.textContent   = metric === "profit" ? "ЧИСТ ПРИХОД ПО ТИП КЛИЕНТИ" : "ОБОРОТ ПО ТИП КЛИЕНТИ";
      metricHeader.textContent = metric === "profit" ? "Чист приход" : "Оборот";
    }

    renderTable(window.currentMetric);

    toggleMetricBtn.onclick = () => {
      window.currentMetric = (window.currentMetric === "profit") ? "turnover" : "profit";
      toggleMetricBtn.textContent = window.currentMetric === "profit" ? "Показвай оборот" : "Показвай чист приход";
      renderTable(window.currentMetric);
    };

    chartDiv.classList.add("d-none");
    tableDiv.classList.remove("d-none");
    filterBox.classList.remove("d-none");

    updateActiveFilters();

    this.textContent = "📈 Графичен изглед";

  } else {

    chartDiv.classList.remove("d-none");
    tableDiv.classList.add("d-none");
    filterBox.classList.add("d-none");

    this.textContent = "📊 Табличен изглед";
  }
});

document.addEventListener('DOMContentLoaded', ()=>{


    let activeMetric = 'net'; // net | turnover

    function updateActiveMetricUI() {
        const title = document.getElementById('activeMetricTitle');
        const btn   = document.getElementById('toggleActiveMode');

        if (!title || !btn) return; // защита

        if (activeMetric === 'net') {
            title.innerText = 'ЧИСТ ПРИХОД';
            btn.innerText   = '🔁 Към: ОБОРОТ';
        } else {
            title.innerText = 'ОБОРОТ';
            btn.innerText   = '🔁 Към: ЧИСТ ПРИХОД';
        }
    }

    const toggleBtn = document.getElementById('toggleActiveMode');
    if (toggleBtn) {
        toggleBtn.onclick = () => {
            activeMetric = activeMetric === 'net' ? 'turnover' : 'net';
            updateActiveMetricUI();
            reloadActiveTable(); // трябва да съществува
        };
    }

    // 🔹 ПЪРВОНАЧАЛНО СЪСТОЯНИЕ
    updateActiveMetricUI();

   //------------------------------------------------------------------------------------
   
   let inactiveMetric = 'turnover';

    function updateInactiveMetricUI() {
        const title = document.getElementById('inactiveMetricTitle');
        const btn   = document.getElementById('toggleValueBtn');
    
        if (inactiveMetric === 'turnover') {
            title.innerText = 'ОБОРОТ';
            btn.innerText   = '🔁 Към: ЧИСТ ПРИХОД';
        } else {
            title.innerText = 'ЧИСТ ПРИХОД';
            btn.innerText   = '🔁 Към: ОБОРОТ';
        }
    }
    
    document.getElementById('toggleValueBtn').onclick = () => {
        inactiveMetric = inactiveMetric === 'turnover' ? 'net' : 'turnover';
        updateInactiveMetricUI();
        reloadInactiveTable();
    };
    
    updateInactiveMetricUI();
});
</script>




<!-- 🧩 Втори ред: Активни / Неактивни фирми -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/jquery.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>

<style>
  /* Преход и визуални подобрения */
  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    border: 1px solid #ccc;
    padding: 5px 10px;
  }
  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 6px;
    border: none;
    padding: 5px 10px;
    margin: 2px;
  }
  .dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: #007bff;
    color: white !important;
  }
  .dataTables_wrapper .dataTables_info {
    padding-top: 10px;
    font-size: 0.85rem;
    color: #777;
  }
  .card-footer {
    background: #f9fafb;
    border-top: 1px solid #eee;
    font-size: 0.9rem;
    color: #555;
    text-align: center;
    padding: 0.75rem;
  }
  .table thead th {
    background-color: #f4f6fb;
    font-weight: 600;
    color: #333;
  }
  .table-hover tbody tr:hover {
    background-color: #f8f9fc;
    transition: background-color 0.2s ease;
  }
  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>

<div class="container-fluid px-4 mt-4 active-firms-class" style="padding-bottom:70px;" >
  <div class="row g-4 align-items-stretch active-firms">

        <div class="row g-4">
  <!-- 🟢 АКТИВНИ ФИРМИ -->
<div class="col-xl-6 col-md-12">
  <div class="card shadow-sm h-100 border-0 rounded-4 overflow-hidden">
    
    <!-- Заглавие -->
    <div class="card-header bg-transparent border-0 text-center pt-4 pb-3">
      <h5 class="fw-bold mb-0 text-success">
        <i class="fa-solid fa-building me-2"></i>Активни фирми
      </h5>
    </div>

    <!-- Филтри -->
    <div id="activeFilters" class="bg-light p-3 px-4 border-bottom">
      <div class="row g-3 align-items-end justify-content-center">
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-success">От дата:</label>
          <input type="date" id="activeFrom" class="form-control form-control-sm"  onkeydown="return false;">
        </div>
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-success">До дата:</label>
          <input type="date" id="activeTo" class="form-control form-control-sm"  onkeydown="return false;">
        </div>
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-success">Агент:</label>
          <select id="activeAgent" class="form-select form-select-sm">
            <option value="">Всички</option>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-success">Група:</label>
          <select id="activeGroup" class="form-select form-select-sm">
            <option value="">Всички</option>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-success">Покажи последните месеци:</label>
          <div class="d-flex align-items-center gap-2">
            <input type="number" id="activeMonthsBack" class="form-control form-control-sm text-center"
                   style="width: 90px;" min="1" max="24" value="6">
            <button class="btn btn-sm btn-outline-success" id="applyActiveMonthsBtn">
              <i class="fa fa-sync-alt me-1"></i> Обнови
            </button>
          </div>
        </div>
        <div class="col-md-3 d-flex align-items-center justify-content-center gap-2 mt-2">
          <button class="btn btn-sm btn-success" id="activeFilterBtn">
            <i class="fa fa-filter me-1"></i> Филтрирай
          </button>
          <button class="btn btn-sm btn-outline-secondary" id="activeResetBtn">
            <i class="fa fa-rotate-left me-1"></i> Нулирай
          </button>
        </div>
      </div>
    </div>

<div class="d-flex justify-content-between align-items-center px-4 py-2 bg-light border-bottom shadow-sm rounded-top" id="activeToolbar">

  <div class="fw-bold text-success">
    📊 Справка: <span id="activeMetricTitle">ЧИСТ ПРИХОД</span>
  </div>

  <button class="btn btn-outline-success btn-sm px-3" id="toggleActiveMode">
    🔁 Към: ОБОРОТ
  </button>

</div>

    <!-- Таблица -->
    <div class="card-body p-3">
      <div class="table-responsive">
        <table id="activeCompanies" class="display dataTable table align-middle" style="width:100%">
          <thead></thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
 




              
            </div>
          </div>
        <style>
        
      #activeToolbar {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: linear-gradient(to right, #f3fff6, #e9f7ef);
  border-bottom: 2px solid #bfe3c4;
  padding: 0.6rem 1rem;
  white-space: nowrap; /* 🔥 предотвратява прехвърляне */
}

#activeFooter {
  font-size: 0.95rem;
  color: #146c43;
  letter-spacing: 0.2px;
  margin: 0;
}

#toggleActiveMode {
  border-radius: 8px;
  font-weight: 500;
  transition: all 0.2s ease;
}

#toggleActiveMode:hover {
  background-color: #198754;
  color: #fff;
  transform: translateY(-1px);
}

        #activeCompanies thead th.sorting,
#activeCompanies thead th.sorting_asc,
#activeCompanies thead th.sorting_desc {
  position: relative;
  padding-right: 20px !important; /* добавяме малко отстояние вдясно за стрелката */
}

#activeCompanies thead th.sorting_asc::after,
#activeCompanies thead th.sorting_desc::after {
  right: 5px !important; /* приближаваме я малко към ръба */
  top: 50%;
  transform: translateY(-50%);
  font-size: 0.7rem;
  color: #ffeb3b;
  text-shadow: 0 0 4px rgba(0,0,0,0.3);
}
            #activeFooter,
.card-header h5.text-success {
  text-align: center !important;
  width: 100%;
}
.dataTables_wrapper .dataTables_filter{
    margin-bottom: 30px;
}
/* Заглавие на таблицата */
#activeCompanies thead th {
  background: #28a745 !important;   /* Зелен фон */
  color: #fff !important;           /* Бял текст */
  font-weight: 600;
  text-transform: uppercase;
  letter-spacing: 0.04em;
  font-size: 0.85rem;
  border-bottom: 2px solid #1e7e34 !important;
  padding-top: 10px !important;
  padding-bottom: 10px !important;
}

/* Редуващи се редове */
#activeCompanies tbody tr:nth-child(even) {
  background-color: #f6fff8 !important;
}
#activeCompanies tbody tr:nth-child(odd) {
  background-color: #ffffff !important;
}

/* Hover ефект */
#activeCompanies tbody tr:hover {
  background-color: #e7fbe9 !important;
  transition: background-color 0.2s ease-in-out;
}

/* Текст и подравняване */
#activeCompanies td, #activeCompanies th {
  vertical-align: middle !important;
  text-align: left;
  padding: 8px 10px !important;
}
#activeCompanies td:first-child, #activeCompanies th:first-child {
  text-align: center;
  width: 45px;
}

/* Стрелки при сортиране */
table#activeCompanies.dataTable thead .sorting_asc,
table#activeCompanies.dataTable thead .sorting_desc {
  background-image: none !important;
  position: relative;
}
table#activeCompanies.dataTable thead .sorting_asc::after {
  content: "▲";
  position: absolute;
  right: 8px;
  color: #ffeb3b; /* контрастна жълта стрелка */
  font-size: 0.7rem;
}
table#activeCompanies.dataTable thead .sorting_desc::after {
  content: "▼";
  position: absolute;
  right: 8px;
  color: #ffeb3b;
  font-size: 0.7rem;
}

/* Pagination + Search + Info в зелено */
#activeCompanies_wrapper .dataTables_paginate a,
#activeCompanies_wrapper .dataTables_info,
#activeCompanies_wrapper .dataTables_length label,
#activeCompanies_wrapper .dataTables_filter label {
  color: #1e7e34 !important;
  font-weight: 500;
}

/* Бутони на pagination */
#activeCompanies_wrapper .dataTables_paginate a.paginate_button {
  border: 1px solid #28a745;
  border-radius: 6px;
  color: #28a745 !important;
  background: #fff;
  padding: 4px 8px;
  margin: 0 2px;
  transition: all 0.2s;
}
#activeCompanies_wrapper .dataTables_paginate a.paginate_button:hover,
#activeCompanies_wrapper .dataTables_paginate a.paginate_button.current {
  background: #28a745 !important;
  color: #fff !important;
  border-color: #28a745;
}

/* Полета за търсене и избор на брой записи */
#activeCompanies_wrapper select,
#activeCompanies_wrapper input[type="search"] {
  border-radius: 6px;
  border: 1px solid #28a745;
  color: #155724;
}
#activeCompanies_wrapper input[type="search"]:focus {
  box-shadow: 0 0 4px rgba(40,167,69,0.4);
  border-color: #28a745;
}

/* Без големи отстояния под таблицата */
#activeCompanies_wrapper {
  margin-bottom: 0 !important;
  padding-bottom: 0 !important;
}
#activeCompanies_wrapper .dataTables_info,
#activeCompanies_wrapper .dataTables_paginate {
  margin-top: 6px !important;
  margin-bottom: 0 !important;
  padding-bottom: 0 !important;
}/* === Неутрален стил за Search и Length контролите === */
#activeCompanies_wrapper .dataTables_length label,
#activeCompanies_wrapper .dataTables_filter label {
  color: #444 !important;
  font-weight: 500;
}

#activeCompanies_wrapper select,
#activeCompanies_wrapper input[type="search"] {
  border-radius: 6px;
  border: 1px solid #ccc !important;
  color: #333 !important;
  box-shadow: none !important;
}

#activeCompanies_wrapper input[type="search"]:focus {
  border-color: #888 !important;
  box-shadow: 0 0 4px rgba(0,0,0,0.1) !important;
}
        </style>
     
<!-- 🔴 Неактивни фирми -->
<div class="col-xl-6 col-md-12">
  <div class="card shadow-sm h-100 border-0 rounded-4 overflow-hidden">

    <!-- Заглавие -->
    <div class="card-header bg-transparent border-0 text-center pt-4 pb-3">
      <h5 class="fw-bold mb-0 text-primary">
        <i class="fa-solid fa-ban me-2"></i>Неактивни фирми
      </h5>
    </div>

    <!-- Филтри (същия стил като активните) -->
    <div id="inactiveFilters" class="bg-light p-3 px-4 border-bottom">
      <div class="row g-3 align-items-end justify-content-center">
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-primary">От дата:</label>
          <input type="date" id="inactiveFrom" class="form-control form-control-sm"  onkeydown="return false;">
        </div>
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-primary">До дата:</label>
          <input type="date" id="inactiveTo" class="form-control form-control-sm"  onkeydown="return false;">
        </div>
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-primary">Агент:</label>
          <select id="inactiveAgent" class="form-select form-select-sm">
            <option value="">Всички</option>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-primary">Група:</label>
          <select id="inactiveGroup" class="form-select form-select-sm">
            <option value="">Всички</option>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label mb-1 small fw-semibold text-primary">Покажи последните месеци:</label>
          <div class="d-flex align-items-center gap-2">
            <input type="number" id="monthsBack" class="form-control form-control-sm text-center"
                   style="width: 90px;" min="1" max="24" value="6">
            <button class="btn btn-sm btn-outline-primary" id="applyMonthsBtn">
              <i class="fa fa-sync-alt me-1"></i> Обнови
            </button>
          </div>
        </div>
        <div class="col-md-3 d-flex align-items-center justify-content-center gap-2 mt-2">
          <button class="btn btn-sm btn-primary" id="inactiveFilterBtn">
            <i class="fa fa-filter me-1"></i> Филтрирай
          </button>
          <button class="btn btn-sm btn-outline-secondary" id="inactiveResetBtn">
            <i class="fa fa-rotate-left me-1"></i> Нулирай
          </button>
        </div>
      </div>
    </div>

    <!-- Лента с общ брой и бутон -->
    <div class="d-flex justify-content-between align-items-center px-4 py-2 bg-light border-bottom shadow-sm rounded-top" id="inactiveToolbar">
      <div class="fw-bold text-primary">
      📊 Справка: <span id="inactiveMetricTitle">ОБОРОТ</span>
    </div>
    
    <button class="btn btn-outline-primary btn-sm px-3" id="toggleValueBtn">
      🔁 Към: ЧИСТ ПРИХОД
    </button>
    </div>

    <!-- Таблица -->
    <div class="card-body p-3">
      <div class="table-responsive">
        <table id="inactiveCompanies" class="display dataTable table align-middle" style="width:100%">
          <thead></thead>
          <tbody></tbody>
        </table>
      </div>
    </div>

  </div>
</div>



<div class="row mt-5 g-4">
  <!-- === Демонстрационен чат (30%) — ВЛЯВО === -->
  <div class="col-lg-4">
    <div class="card border-0 shadow-lg rounded-4 overflow-hidden chat-demo-wrapper">
      <div class="chat-header bg-viber text-white p-3 d-flex align-items-center">
        <i class="fa-brands fa-viber me-2 fs-5"></i>
        <strong>Viber Chat (демо)</strong>
      </div>
      <div class="chat-body p-3" id="chatMessages">
        <div class="message incoming">
          <div class="bubble">Здравейте! Как мога да помогна?</div>
        </div>
        <div class="message outgoing">
          <div class="bubble">Имам въпрос относно задачата ми.</div>
        </div>
      </div>
      <div class="chat-footer p-3 bg-light border-top">
        <div class="input-group">
          <input type="text" class="form-control" id="chatInput" placeholder="Напиши съобщение...">
          <button class="btn btn-viber" id="sendBtn"><i class="fa fa-paper-plane"></i></button>
        </div>
      </div>
    </div>
  </div>







  <div class="col-lg-8">
    <div class="card border-0 shadow-lg rounded-4 overflow-hidden calendar-wrapper">
      <div class="card-header text-center border-0 bg-transparent pt-4 pb-2 position-relative">
        <div class="icon-circle mb-3 mx-auto">
          <i class="fa-solid fa-calendar-days fa-lg"></i>
        </div>
        <h5 class="fw-bold mb-1 text-primary-emphasis">Календар на задачите</h5>
        <p class="text-muted small mb-0">Всички задачи от секцията <strong>„Моите задачи“</strong></p>
      </div>

      <div class="card-body p-4">
        <div id="tasksCalendar"></div>
      </div>

      <div class="card-footer text-center text-muted small bg-light-subtle">
        Данните се зареждат автоматично от секцията „Моите задачи“.
      </div>
    </div>
  </div>
</div>

<!-- ✅ FULLCALENDAR -->
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js"></script>

<style>
/* === Общ стил === */
.bg-viber { background: #7360f2; }
.btn-viber {
  background: #7360f2;
  color: #fff;
  border: none;
}
.btn-viber:hover { background: #5a48d6; }

/* === Демонстрационен чат === */
.chat-demo-wrapper {
  height: 100%;
  display: flex;
  flex-direction: column;
}
.chat-header {
  font-weight: 600;
  background: linear-gradient(135deg, #7360f2, #5a48d6);
}/* FIX: премахва right: -XXXpx от dayGrid */
.fc-daygrid-event-harness {
  position: relative !important;
}

.fc-daygrid-event-harness-abs {
  position: relative !important;
  left: auto !important;
  right: auto !important;
  top: auto !important;
}

.chat-body {
  flex: 1;
  background: #f8f9fc;
  overflow-y: auto;
  display: flex;
  flex-direction: column;
  gap: 10px;
  max-height: 600px;
}
.message {
  display: flex;
}
.message.incoming { justify-content: flex-start; }
.message.outgoing { justify-content: flex-end; }
.bubble {
  background: #fff;
  padding: 8px 12px;
  border-radius: 15px;
  box-shadow: 0 2px 5px rgba(0,0,0,0.1);
  max-width: 80%;
}
.message.incoming .bubble {
  background: #e9e8ff;
  border-bottom-left-radius: 3px;
}
.message.outgoing .bubble {
  background: #7360f2;
  color: #fff;
  border-bottom-right-radius: 3px;
}

/* === Calendar === */
.calendar-wrapper {
  background: linear-gradient(145deg, #ffffff, #f3f7ff);
  border-radius: 1.25rem;
  box-shadow: 0 10px 30px rgba(13,110,253,0.1), inset 0 2px 8px rgba(255,255,255,0.5);
  transition: 0.4s ease;
}
.calendar-wrapper:hover {
  box-shadow: 0 14px 40px rgba(13,110,253,0.18);
  transform: translateY(-3px);
}
.icon-circle {
  width: 56px; height: 56px; border-radius: 50%;
  background: linear-gradient(135deg, #2563eb, #0d6efd);
  display: flex; align-items: center; justify-content: center;
  color: #fff; box-shadow: 0 5px 15px rgba(13,110,253,0.3);
}
#tasksCalendar {
  background: #fff; border-radius: 1rem; padding: 1rem;
  box-shadow: inset 0 0 12px rgba(0,0,0,0.03);
  min-height: 550px; font-family: 'Poppins', sans-serif;
}

/* === Tooltip === */
.task-tooltip {
  position: absolute;
  z-index: 9999;
  background: #fff;
  color: #333;
  border-radius: 12px;
  min-width: 260px;
  max-width: 320px;
  box-shadow: 0 6px 25px rgba(0, 0, 0, 0.15);
  transition: all 0.25s ease;
  opacity: 0;
  transform: translateY(-10px);
  animation: tooltipFadeIn 0.25s ease forwards;
}
@keyframes tooltipFadeIn {
  to {
    opacity: 1;
    transform: translateY(0);
  }
}
.task-tooltip::after {
  content: "";
  position: absolute;
  bottom: -8px;
  left: 50%;
  transform: translateX(-50%);
  border-width: 8px;
  border-style: solid;
  border-color: #fff transparent transparent transparent;
}
</style>

<script>
/* =========================================================
   STORAGE – ERP ЛОГИКА
========================================================= */


/* =========================================================
   HELPERS – СЪЩИТЕ КАТО ГОЛЕМИЯ КАЛЕНДАР
========================================================= */
function getEventColor(task) {
  const today = new Date();
  const end = task.endDate ? new Date(task.endDate) : null;

  if (task.status === "ЗАВЪРШЕНА") return "#198754";
  if (task.status === "В ПРОЦЕС НА РАБОТА") return "#fd7e14";
  if (task.status === "НЕЗАВЪРШЕНА") return "#dc3545";
  if (end && end < today) return "#dc3545";

  return "#0d6efd";
}

/* =========================================================
   MAP TASKS → FULLCALENDAR EVENTS
========================================================= */
function mapTasksToEvents() {
  return tasks.map(task => ({
    id: task.id,
    title: `${task.firm} — ${task.status}`,
    start: task.startDate,
    end: task.endDate || task.startDate,
    allDay: true,
    color: getEventColor(task),
    textColor: "#fff",
    extendedProps: {
      fullTask: task
    }
  }));
}


/* =========================================================
   SYNC – когато задачите се променят
========================================================= */
window.addEventListener("storage", () => {
  if (!dashboardCalendar) return;

  tasks = JSON.parse(localStorage.getItem("tasks") || "[]");
  dashboardCalendar.removeAllEvents();
  dashboardCalendar.addEventSource(mapTasksToEvents());
});
</script>
<!-- 🟩 MODAL: ADD / EDIT TASK -->
<div class="modal fade" id="addTaskModal2" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg rounded-4">

      <div class="modal-header bg-primary bg-opacity-10 border-0">
        <h5 class="modal-title fw-bold text-primary">
          <i class="fa-solid fa-list-check me-2"></i>Задача
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <form id="taskForm" class="row g-3">

          <input type="hidden" id="taskId">

          <div class="col-md-6">
            <label class="form-label">Фирма</label>
            <input type="text" id="firm" class="form-control form-control-sm" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Статус</label>
            <select id="status" class="form-select form-select-sm">
              <option value="НОВА">НОВА</option>
              <option value="В ПРОЦЕС НА РАБОТА">В ПРОЦЕС НА РАБОТА</option>
              <option value="ЗАВЪРШЕНА">ЗАВЪРШЕНА</option>
              <option value="НЕЗАВЪРШЕНА">НЕЗАВЪРШЕНА</option>
            </select>
          </div>

          <div class="col-md-6">
            <label class="form-label">Начална дата</label>
            <input type="date" id="startDate" class="form-control form-control-sm">
          </div>

          <div class="col-md-6">
            <label class="form-label">Крайна дата</label>
            <input type="date" id="endDate" class="form-control form-control-sm">
          </div>

          <div class="col-12">
            <label class="form-label">Описание</label>
            <textarea id="description" class="form-control form-control-sm"></textarea>
          </div>

          <div class="col-12 text-end">
            <button type="submit" class="btn btn-success btn-sm">
              <i class="fa fa-save me-1"></i>Запази
            </button>
          </div>

        </form>
      </div>

    </div>
  </div>
</div>

<script>
function getDeadlineText(task) {
  if (!task.endDate) return "ℹ️ No deadline";

  const today = new Date();
  const end = new Date(task.endDate);
  const diff = Math.ceil((end - today) / 86400000);

  if (diff > 0) return `⏳ ${diff} days left`;
  if (diff === 0) return "⚠️ Due today";
  return `❌ Overdue by ${Math.abs(diff)} days`;
}
</script>

<script>
let tasks = JSON.parse(localStorage.getItem("tasks") || "[]");

function getEventColor(task) {
  const today = new Date();
  const end = task.endDate ? new Date(task.endDate) : null;

  if (task.status === "ЗАВЪРШЕНА") return "#198754";
  if (task.status === "В ПРОЦЕС НА РАБОТА") return "#fd7e14";
  if (task.status === "НЕЗАВЪРШЕНА") return "#dc3545";
  if (end && end < today) return "#dc3545";

  return "#0d6efd";
}

function mapTasksToEvents() {
  return tasks.map(task => ({
    id: task.id,
    title: `${task.firm} — ${task.status}`,
    start: task.startDate,
    end: task.endDate || task.startDate,
    allDay: true,
    color: getEventColor(task),
    textColor: "#fff",
    extendedProps: { fullTask: task }
  }));
}

let dashboardCalendar;

document.addEventListener("DOMContentLoaded", () => {
  const el = document.getElementById("tasksCalendar");
  if (!el) return;

  function positionModalNearCalendar() {
    const calendar = document.querySelector(".calendar-wrapper");
    const modal = document.getElementById("addTaskModal");
    const dialog = modal.querySelector(".modal-dialog");
    if (!calendar || !modal || !dialog) return;

    const rect = calendar.getBoundingClientRect();
    const scrollTop = window.pageYOffset || document.documentElement.scrollTop;

    const width = Math.floor(window.innerWidth * 0.7);
    dialog.style.width = width + "px";
    dialog.style.maxWidth = width + "px";

    const left = (window.innerWidth - width) / 2;
    const top = rect.top + scrollTop + rect.height / 2 - dialog.offsetHeight / 2 - 490;

    dialog.style.position = "absolute";
    dialog.style.left = `${left}px`;
    dialog.style.top = `${Math.max(top, 20)}px`;
    dialog.style.transform = "none";
  }

  function fromISO(dateISO) {
    return dateISO ? dateISO.substring(0, 10) : "";
  }

  const taskForm        = document.getElementById("taskForm");
  const taskIdInput     = document.getElementById("taskId");

  const firmSelect      = document.getElementById("firmSelect");
  const taskUserSelect  = document.getElementById("taskUserSelect");

  const gradInput       = document.getElementById("grad");
  const adresInput      = document.getElementById("adres");
  const telInput        = document.getElementById("tel");

  const startDateInput  = document.getElementById("startDate");
  const endDateInput    = document.getElementById("endDate");

  const prioritetSelect = document.getElementById("prioritet");
  const ofertaInput     = document.getElementById("oferta");
  const projectValueInp = document.getElementById("projectValue");
  const documentInput   = document.getElementById("document");

  const descriptionInp  = document.getElementById("description");
  const commentInp      = document.getElementById("comment");
  const statusSelect    = document.getElementById("status");

  function applySelectColor(select) {
    if (!select) return;
    const option = select.options[select.selectedIndex];
    if (option) select.style.color = option.style.color || "";
  }

  function fillForm(task) {
    taskIdInput.value = task.id || "";

    pendingFirm = task.firm || "";
    pendingUser = task.user || "";

    if (gradInput) gradInput.value = task.grad || "";
    if (adresInput) adresInput.value = task.adres || "";
    if (telInput) telInput.value = task.tel || "";

    startDateInput.value = fromISO(task.startDate);
    endDateInput.value   = fromISO(task.endDate);

    if (prioritetSelect) prioritetSelect.value = task.prioritet || "Нормален";
    if (ofertaInput) ofertaInput.value = task.oferta || "";
    if (projectValueInp) projectValueInp.value = task.projectValue || "";
    if (documentInput) documentInput.value = task.document || "";

    descriptionInp.value = task.description || "";
    if (commentInp) commentInp.value = task.comment || "";

    statusSelect.value = task.status || "НОВА";

    if (typeof loadFirmsTask === "function") loadFirmsTask();
    if (typeof loadUsersTask === "function") loadUsersTask();

    applySelectColor(statusSelect);
    applySelectColor(prioritetSelect);
  }

  dashboardCalendar = new FullCalendar.Calendar(el, {
    initialView: "dayGridMonth",
    locale: "bg",
    height: 600,
    selectable: true,
    selectMirror: true,

    headerToolbar: {
      left: "prev,next",
      center: "title",
      right: ""
    },

    events: mapTasksToEvents(),

    select(info) {
      taskForm.reset();
      taskIdInput.value = "";

      startDateInput.value = info.startStr;
      endDateInput.value = info.endStr ? info.endStr.substring(0, 10) : "";

      pendingFirm = null;
      pendingUser = null;

      const modalEl = document.getElementById("addTaskModal");
      const modal = new bootstrap.Modal(modalEl);
      modal.show();

      setTimeout(positionModalNearCalendar, 50);

      applySelectColor(statusSelect);
      applySelectColor(prioritetSelect);

      dashboardCalendar.unselect();
    },

eventClick(info) {
  fillForm(info.event.extendedProps.fullTask);

  const modalEl = document.getElementById("addTaskModal");
  const modal = new bootstrap.Modal(modalEl);
  modal.show();

  setTimeout(positionModalNearCalendar, 50);
}
  });

  dashboardCalendar.render();
});

window.addEventListener("storage", () => {
  if (!dashboardCalendar) return;
  tasks = JSON.parse(localStorage.getItem("tasks") || "[]");
  dashboardCalendar.removeAllEvents();
  dashboardCalendar.addEventSource(mapTasksToEvents());
});
</script>














<!-- ======== Блок: Движение на стока ======== -->
<div class="row mt-4">
  <div class="col-12">
    <div class="card shadow-sm border-0">
      <div class="card-header bg-white border-bottom py-3">
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">

          <h5 class="mb-0 fw-bold text-primary">
            <i class="bi bi-box-seam me-2"></i>Движение на стока
          </h5>

          <!-- МАРКЕР -->
          <span id="activeMode" class="badge bg-primary px-3 py-2 fs-6">
            СТОКИ
          </span>

          <div class="d-flex align-items-center gap-2">
            <button class="btn btn-warning btn-sm" id="switchViewBtn">
              <i class="bi bi-stars me-1"></i> НАЙ-ПРОДАВАНИ СТОКИ
            </button>
          </div>

        </div>
      </div>

      <div class="card-body">
        
        <!-- === Филтри === -->
        <!-- === Активни филтри === -->
        <div id="activeFiltersBox" class="alert alert-info py-2 px-3 small d-none">
          <strong>В момента са избрани:</strong>
          <span id="activeFiltersText"></span>
        </div>
        <div class="row g-2 align-items-center mb-3">

          <div class="col-md-auto">
            <label class="fw-semibold text-secondary small mb-1">Период:</label><br>
            <div class="btn-group" role="group">
              <button class="btn btn-outline-secondary btn-sm period-btn" data-period="day">Ден</button>
              <button class="btn btn-outline-secondary btn-sm period-btn active" data-period="month">Месец</button>
              <button class="btn btn-outline-secondary btn-sm period-btn" data-period="year">Година</button>
              <button class="btn btn-outline-secondary btn-sm period-btn" data-period="custom">Custom</button>
            </div>
          </div>

          <div class="col-md-auto">
            <label class="fw-semibold text-secondary small mb-1">От дата:</label>
            <input type="date" id="stockFromDate" class="form-control form-control-sm"  onkeydown="return false;">
          </div>

          <div class="col-md-auto">
            <label class="fw-semibold text-secondary small mb-1">До дата:</label>
            <input type="date" id="stockToDate" class="form-control form-control-sm"  onkeydown="return false;">
          </div>

          <div class="col-md-auto">
            <label class="fw-semibold text-secondary small mb-1">Група:</label>
            <select id="stockGroupFilter" class="form-select form-select-sm">
              <option value="">Всички</option>
              <option>МОНИТОРИ</option>
              <option>МРЕЖОВИ УСТРОЙСТВА</option>
              <option>КОМПЮТРИ</option>
              <option>ПРИНТЕРИ КОПИРНИ МАШИНИ И КОНСУМАТИВИ</option>
              <option>СЛУШАЛКИ</option>
              <option>КАБЕЛИ</option>
            </select>
          </div>

          <div class="col-md-auto">
            <label class="fw-semibold text-secondary small mb-1">Подгрупа:</label>
            <select id="subGroupFilter" class="form-select form-select-sm">
              <option value="">Всички</option>
            </select>
          </div>

        

        </div>

        <!-- === Таблици === -->
        <div class="table-responsive border rounded" style="max-height: 450px; overflow-y: auto;">

          <!-- ЕКСПОРТ БУТОНИ -->
          <div class="d-flex justify-content-end gap-2 p-2 border-bottom bg-light">
            <button id="exportStockBtn" class="btn btn-outline-primary btn-sm">
              <i class="bi bi-file-earmark-excel"></i> Експорт стоки
            </button>
            <button id="exportBestBtn" class="btn btn-outline-warning btn-sm">
              <i class="bi bi-file-earmark-excel"></i> Експорт НАЙ-ПРОДАВАНИ
            </button>
          </div>

          <!-- таблица стоки -->
          <table class="table table-hover mb-0" id="stockTable">
            <thead class="table-light sticky-top">
              <tr>
                <th data-sort="text" class="text-center">Главна група</th>
                <th data-sort="text" class="text-center">Подгрупа</th>
                <th data-sort="text" class="text-center">Стока</th>
                <th data-sort="num" class="text-center">Наличност</th>
                <th data-sort="num" class="text-center">Доставна цена</th>
                <th data-sort="num" class="text-center">ОБЩ ТОТАЛ БЕЗ ДДС</th>
                <th data-sort="num" class="text-center">Продадени</th>
                <th data-sort="num" class="text-center">Оборот</th>
                <th data-sort="num" class="text-center">Чист приход</th>
                <th data-sort="text" class="text-center">Дата на последна доставка</th>
              </tr>
            </thead>
            <tbody>
              <tr><td colspan="10" class="text-center text-muted py-3">Няма заредени данни</td></tr>
            </tbody>
          </table>

          <!-- таблица най-продавани -->
          <table class="table table-hover mb-0 d-none" id="bestSellerTable">
            <thead class="table-light sticky-top">
              <tr>
                <th data-sort="text">Продукт</th>
                <th data-sort="text">Група</th>
                <th data-sort="num" class="text-end">Продадени</th>
                <th data-sort="num" class="text-end">Оборот</th>
                <th data-sort="num" class="text-end">Чист приход</th>
              </tr>
            </thead>
            <tbody>
              <tr><td colspan="5" class="text-center text-muted py-3">Няма данни</td></tr>
            </tbody>
          </table>

        </div>
      </div>
    </div>
  </div>
</div>
<script>

document.addEventListener('DOMContentLoaded', ()=>{

    // ------------------------------
    // ОБЯВЯВАМЕ ЕДИНСТВЕНО ТУК !!!
    // ------------------------------
    const groupSelect     = document.getElementById('stockGroupFilter');
    const subGroupSelect  = document.getElementById('subGroupFilter');
    const stockFromDate   = document.getElementById('stockFromDate');
    const stockToDate     = document.getElementById('stockToDate');
    const stockTable      = document.getElementById('stockTable');
    const bestTable       = document.getElementById('bestSellerTable');
    const modeBadge       = document.getElementById('activeMode');

    // Експорт
    document.getElementById('exportStockBtn').onclick = ()=>{
        const from = stockFromDate.value;
        const to   = stockToDate.value;
        const g    = groupSelect.value;
        const s    = subGroupSelect.value;

        window.open(`/dashboard/exportStockMovement?from=${from}&to=${to}&group=${g}&sub=${s}`, '_blank');
    };

    document.getElementById('exportBestBtn').onclick = ()=>{
        const from = stockFromDate.value;
        const to   = stockToDate.value;
        const g    = groupSelect.value;
        const s    = subGroupSelect.value;

        window.open(`/dashboard/exportBestSellers?from=${from}&to=${to}&group=${g}&sub=${s}`, '_blank');
    };

    // Зареждане на динамични групи
    loadDynamicGroups();

async function loadDynamicGroups(){
    try {
        const res = await fetch('/dashboard/stockGroups');
        const data = await res.json();

        groupSelect.innerHTML = `<option value="">Всички</option>`;

        data.groups.forEach(g => {
            groupSelect.innerHTML += `<option value="${g}">${g}</option>`;
        });

        window.dynamicSubgroups = data.subgroups;

    } catch (err) {
        console.error("Грешка при зареждане на групи:", err);
    }
}

    // Подгрупи
    groupSelect.addEventListener('change', ()=>{
        const g = groupSelect.value;

        subGroupSelect.innerHTML = `<option value="">Всички</option>`;

        if(window.dynamicSubgroups && window.dynamicSubgroups[g]){
            window.dynamicSubgroups[g].forEach(s=>{
                subGroupSelect.innerHTML += `<option>${s}</option>`;
            });
        }
    });


    // ------------------------------
    // СМЯНА НА ИЗГЛЕДИ
    // ------------------------------
    let currentView = 'stock';

 

    document.getElementById('switchViewBtn').onclick = ()=>{
        currentView = 'best';
        applyMode();
        loadBest();
    };

    function applyMode(){
        if(currentView === 'stock'){
            modeBadge.innerText = "СТОКИ";
            modeBadge.className = "badge bg-primary px-3 py-2 fs-6";

            stockTable.classList.remove('d-none');
            bestTable.classList.add('d-none');
        } else {
            modeBadge.innerText = "НАЙ-ПРОДАВАНИ СТОКИ";
            modeBadge.className = "badge bg-warning text-dark px-3 py-2 fs-6";

            stockTable.classList.add('d-none');
            bestTable.classList.remove('d-none');
        }
    }

    // ------------------------------
    // ЗАРЕЖДАНЕ СТОКИ
    // ------------------------------

    function updateActiveFilters(){
        let filters = [];
    
        if (stockFromDate.value) filters.push(`От: <strong>${stockFromDate.value}</strong>`);
        if (stockToDate.value)   filters.push(`До: <strong>${stockToDate.value}</strong>`);
    
        if (groupSelect.value)   filters.push(`Група: <strong>${groupSelect.value}</strong>`);
        if (subGroupSelect.value)filters.push(`Подгрупа: <strong>${subGroupSelect.value}</strong>`);
    
        const box  = document.getElementById("activeFiltersBox");
        const text = document.getElementById("activeFiltersText");
    
        if (filters.length === 0){
            box.classList.add('d-none');
            text.innerHTML = '';
            return;
        }
    
        text.innerHTML = filters.join(" &nbsp; | &nbsp; ");
        box.classList.remove('d-none');
    }

    async function loadStock(){
        updateActiveFilters();
        const from = stockFromDate.value;
        const to   = stockToDate.value;
        const g    = groupSelect.value;
        const sg   = subGroupSelect.value;

        const res = await fetch(`/dashboard/stockMovement?from=${from}&to=${to}&group=${g}&sub=${sg}`);
        const data = await res.json();

        renderStock(data.products);
    }

    async function loadBest(){
         updateActiveFilters();
        const from = stockFromDate.value;
        const to   = stockToDate.value;
        const g    = groupSelect.value;
        const sg   = subGroupSelect.value;

        const res = await fetch(`/dashboard/bestSellers?from=${from}&to=${to}&group=${g}&sub=${sg}`);
        const data = await res.json();

        renderBest(data.products);
    }
    
    function reloadCurrentView(){
        if(currentView === 'stock'){
            loadStock();
        } else {
            loadBest();
        }
    }
    [groupSelect, subGroupSelect, stockFromDate, stockToDate].forEach(el => {
        el.addEventListener('change', reloadCurrentView);
    });

    // ------------------------------
    // РЕНДЕР СТОКИ
    // ------------------------------
    function renderStock(list){
        const tbody = stockTable.querySelector('tbody');
        tbody.innerHTML = '';

        if (!list || list.length === 0){
            tbody.innerHTML = `<tr><td colspan="10" class="text-center text-muted py-3">Няма данни</td></tr>`;
            return;
        }

        list.forEach(r=>{
            tbody.innerHTML += `
            <tr>
    <td class="text-center">${r['Главна група']}</td>
    <td class="text-center">${r['Подгрупа']}</td>
    <td class="text-center">${r['Стока']}</td>
    <td class="text-center">${r['Наличност']}</td>
    <td class="text-center">${Number(r['Доставна цена']).toFixed(2)}</td>

    <td class="text-center">
        ${(Number(r['Наличност']) * Number(r['Доставна цена'])).toFixed(2)}
    </td>

    <td class="text-center">${r['Продадени']}</td>
    <td class="text-center">${Number(r['Оборот']).toFixed(2)}</td>
    <td class="text-center">${Number(r['Чист приход']).toFixed(2)}</td>
    <td class="text-center">${r['Последна доставка']}</td>
</tr>`;
        });
    }

    // ------------------------------
    // РЕНДЕР БЕСТСЕЛЪРИ
    // ------------------------------
   function renderBest(list){
        const tbody = bestTable.querySelector('tbody');
        tbody.innerHTML = '';

        if (!list || list.length === 0){
            tbody.innerHTML = `<tr><td colspan="5" class="text-center text-muted py-3">Няма данни</td></tr>`;
            return;
        }

        list.forEach(r=>{
            tbody.innerHTML += `
            <tr>
                <td>${r['Продукт']}</td>
                <td>${r['Група']}</td>
                <td class="text-end">${r['Количество']}</td>
                <td class="text-end">${Number(r['Оборот']).toFixed(2)}</td>
                <td class="text-end">${Number(r['Чист приход']).toFixed(2)}</td>
            </tr>`;
        });
    }

    // ⬇⬇⬇ ТОЧНО ТУК ⬇⬇⬇
    applyMode();
    loadStock();

});

</script>







<!-- ======== Блок: Последни доставки ======== -->
<div class="row mt-4">
  <div class="col-12">
    <div class="card shadow-sm border-0">
      <div class="card-header bg-white border-bottom py-3 d-flex justify-content-between align-items-center">
        <h5 class="mb-0 fw-bold text-success">
          <i class="bi bi-truck"></i> Залежала стока
        </h5>
        <button id="exportDeliveriesBtn" class="btn btn-outline-danger btn-sm">
          <i class="bi bi-file-earmark-excel"></i> Експорт
        </button>
      </div>

      <div class="card-body">

        <!-- Филтри -->
        <div class="row g-2 align-items-center mb-3">
          <div class="col-md-auto">
            <label class="small fw-semibold text-secondary">Период без ДВИЖЕНИЕ:</label>
            <select id="delMonths" class="form-select form-select-sm">
              <option value="3">3 месеца</option>
              <option value="6" selected>6 месеца</option>
              <option value="12">12 месеца</option>
            </select>
          </div>

          <div class="col-md-auto">
            <label class="small fw-semibold text-secondary">Процент от общите продажби:</label>
            <input type="number" id="delPercent" min="1" max="50" value="10" class="form-control form-control-sm">
          </div>

          <div class="col-md-auto">
            <label class="small fw-semibold text-secondary">Група:</label>
            <select id="delGroup" class="form-select form-select-sm">
              <option value="">Всички</option>
              <option>МОНИТОРИ</option>
              <option>ВИДЕОНАБЛЮДЕНИЕ</option>
              <option>ВИДЕО КАРТИ</option>
            </select>
          </div>

          <div class="col-md-auto mt-3 mt-md-4">
            <button id="loadDeliveriesBtn" class="btn btn-success btn-sm" style="margin-top:7px;">
              <i class="bi bi-search"></i> Зареди
            </button>
          </div>
        </div>

        <!-- 🔍 Търсачка -->
        <div class="row mb-3">
          <div class="col-md-4">
            <input type="text" id="deliveriesSearch" class="form-control form-control-sm"
                   placeholder="Търси по ключова дума...">
          </div>
        </div>

        <!-- Таблица -->
        <div class="table-responsive border rounded" style="max-height: 420px; overflow-y:auto;">
          <table class="table table-hover align-middle mb-0" id="deliveriesTable">
            <thead class="table-light sticky-top">
              <tr>
                <th data-sort="text">Група</th>
                <th data-sort="text">Стока</th>
                <th data-sort="text">Последна доставка</th>
                <th class="text-end" data-sort="num">Продадени</th>
                <th class="text-end" data-sort="num">Налични</th>
              </tr>
            </thead>
            <tbody>
              <tr><td colspan="5" class="text-center text-muted py-3">Няма данни</td></tr>
            </tbody>
          </table>
        </div>

      </div>
    </div>
  </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', ()=>{

  const tbody = document.querySelector('#deliveriesTable tbody');

  // ==========================
  // ЕКСПОРТ
  // ==========================
  document.getElementById('exportDeliveriesBtn').onclick = ()=>{
      const months  = delMonths.value;
      const percent = delPercent.value;
      const group   = delGroup.value;

      window.open(`/dashboard/exportDeliveries?months=${months}&percent=${percent}&group=${encodeURIComponent(group)}`, '_blank');
  };


  // ==========================
  // ЗАРЕЖДАНЕ НА ДАННИ
  // ==========================
  document.getElementById('loadDeliveriesBtn').onclick = loadData;

  async function loadData(){
    const months  = delMonths.value;
    const percent = delPercent.value;
    const group   = delGroup.value;

    const url = `/dashboard/deliveries?months=${months}&percent=${percent}&group=${group}`;
    console.log('[deliveries] fetch:', url);

    try {
      const res = await fetch(url);
      const data = await res.json();

      tbody.innerHTML = '';
      const items = data.items || [];

      if (!items.length){
        tbody.innerHTML = '<tr><td colspan="5" class="text-center text-muted py-3">Няма данни</td></tr>';
        return;
      }

      items.forEach(row=>{
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>${row['Група']}</td>
          <td>${row['Стока']}</td>
          <td>${row['Последна доставка']}</td>
          <td class="text-end">${row['Продадени']}</td>
          <td class="text-end">${row['Налични']}</td>
        `;
        tbody.appendChild(tr);
      });

      enableSorting();

    } catch (e) {
      console.error('[deliveries]', e);
      tbody.innerHTML = '<tr><td colspan="5" class="text-center text-danger py-3">Грешка при зареждане</td></tr>';
    }
  }


  // ==========================
  // СОРТИРАНЕ
  // ==========================
  function enableSorting(){
    const table = document.getElementById('deliveriesTable');
    const ths = table.querySelectorAll('th[data-sort]');

    ths.forEach(th=>{
      th.onclick = ()=>{
        const index = [...th.parentNode.children].indexOf(th);
        const asc = !th.classList.contains('sorted-asc');
        const type = th.dataset.sort;

        ths.forEach(h=>h.classList.remove('sorted-asc','sorted-desc','active-sort'));
        th.classList.add(asc?'sorted-asc':'sorted-desc','active-sort');

        const rows = [...tbody.querySelectorAll('tr')];

        rows.sort((a,b)=>{
          const aVal = a.children[index].textContent.trim();
          const bVal = b.children[index].textContent.trim();
          return type==='num'
            ? (asc?parseFloat(aVal)-parseFloat(bVal):parseFloat(bVal)-parseFloat(aVal))
            : (asc?aVal.localeCompare(bVal):bVal.localeCompare(aVal));
        });

        tbody.innerHTML = '';
        rows.forEach(r=>tbody.appendChild(r));
      };
    });

    if (!table.querySelector('.active-sort'))
      ths[0].classList.add('sorted-asc','active-sort');
  }


  // ==========================
  // 🔍 ТЪРСАЧКА ПО КЛЮЧОВА ДУМА
  // ==========================
  document.getElementById('deliveriesSearch').addEventListener('input', function(){
      const val = this.value.toLowerCase();
      const rows = tbody.querySelectorAll('tr');

      rows.forEach(row=>{
        const txt = row.textContent.toLowerCase();
        row.style.display = txt.includes(val) ? '' : 'none';
      });
  });

  // Зареждаме първоначални данни
  loadData();

});
</script>








<style>
    #inactiveSummaryBar {
  background: linear-gradient(90deg, #fee2e2, #fef2f2);
  border: 1px solid #fecaca;
  border-radius: 10px;
  color: #991b1b;
  font-size: 1rem;
  font-weight: 600;
  letter-spacing: 0.3px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.05);
  animation: fadeInSummary 0.4s ease;
  display: inline-block;
  margin-bottom: 10px;
}

@keyframes fadeInSummary {
  from { opacity: 0; transform: translateY(-6px); }
  to { opacity: 1; transform: translateY(0); }
}

#inactiveFilterInfo {
  background: linear-gradient(90deg, #dbeafe, #eff6ff);
  border: 1px solid #bfdbfe;
  color: #1e3a8a;
  font-size: 0.95rem;
  font-weight: 500;
  border-radius: 10px;
  box-shadow: 0 3px 8px rgba(59,130,246,0.1);
  animation: fadeIn 0.4s ease;
}

#inactiveFilters {
  background: #f9fafb;
  border-radius: 10px;
  padding: 1rem 1.5rem !important;
}

#inactiveFilters label {
  color: #374151;
  font-weight: 500;
}

#inactiveFilters .btn {
  border-radius: 6px;
}

@keyframes fadeIn {
  from { opacity: 0; transform: translateY(-5px); }
  to { opacity: 1; transform: translateY(0); }
}/* === Заглавен ред на таблицата "Неактивни фирми" === */
#inactiveCompanies thead th {
  background: #007bff !important;         /* Син фон */
  color: #fff !important;                 /* Бял текст */
  font-weight: 600;
  text-transform: uppercase;
  letter-spacing: 0.04em;
  font-size: 0.85rem;
  border-bottom: 2px solid #0056b3 !important;
  padding-top: 10px !important;
  padding-bottom: 10px !important;
  position: relative;
}

/* Лека сянка под заглавието */
#inactiveCompanies thead {
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* === Редуващи се редове === */
#inactiveCompanies tbody tr:nth-child(even) {
  background-color: #f9fbff !important;
}
#inactiveCompanies tbody tr:nth-child(odd) {
  background-color: #ffffff !important;
}

/* === Hover ефект за редовете === */
#inactiveCompanies tbody tr:hover {
  background-color: #e9f3ff !important;
  transition: background-color 0.2s ease-in-out;
}

/* === Подравняване и стил на клетките === */
#inactiveCompanies td,
#inactiveCompanies th {
  vertical-align: middle !important;
  text-align: left;
  padding: 8px 10px !important;
}

#inactiveCompanies td:first-child,
#inactiveCompanies th:first-child {
  text-align: center;
  width: 45px;
}

/* === Индикатори за сортиране (▲ ▼) === */
table.dataTable thead .sorting_asc,
table.dataTable thead .sorting_desc {
  background-image: none !important;
  position: relative;
}

/* ↑ активна стрелка (по възходящ ред) */
table.dataTable thead .sorting_asc::after {
  content: "▲";
  position: absolute;
  right: 8px;
  top: 50%;
  transform: translateY(-50%);
  color: #ffd43b; /* златисто-жълта стрелка */
  text-shadow: 0 0 4px rgba(0,0,0,0.3);
  font-size: 0.7rem;
}

/* ↓ активна стрелка (по низходящ ред) */
table.dataTable thead .sorting_desc::after {
  content: "▼";
  position: absolute;
  right: 8px;
  top: 50%;
  transform: translateY(-50%);
  color: #ffd43b; /* златисто-жълта стрелка */
  text-shadow: 0 0 4px rgba(0,0,0,0.3);
  font-size: 0.7rem;
}

/* === Обща рамка на таблицата === */
#inactiveCompanies {
  border-radius: 10px;
  overflow: hidden;
  border: 1px solid #dee2e6;
  box-shadow: 0 3px 10px rgba(0,0,0,0.05);
}

#debtModal.custom-position .modal-dialog {
    position: absolute !important;
    margin: 0 !important;
    transform: none !important;
}

#debtModal.custom-position .modal-backdrop {
    display: none !important;
}

</style>
<script>
let allFirms = null;

// === Зареждане на всички фирми ===
async function loadFirms() {
  $('#activeFooter').html('⏳ Зареждане на активни фирми...');
  $('#inactiveFooter').html('⏳ Зареждане на неактивни фирми...');

  const res = await fetch('/dashboard/firms');
  const { activeFirms, inactiveFirms } = await res.json();
  allFirms = { activeFirms, inactiveFirms };

  renderActiveTable(activeFirms);
  renderInactiveTable(inactiveFirms);
}

//-----------------------------------------------------------------------------------------------
let showTurnover = true; // 💱 по подразбиране показваме оборот

const toggleActiveBtn = document.getElementById('toggleActiveMode');

let firmDebts = {};

async function loadDebts() {
    const res = await fetch('/dashboard/debts');
    firmDebts = await res.json();
}
function showDebtModal(firmName) {
    const debt = firmDebts[firmName] ?? 0;

    document.getElementById("debtFirmName").textContent = firmName;
    document.getElementById("debtFirmValue").textContent =
        debt.toLocaleString("bg-BG", { minimumFractionDigits: 2 }) + " лв";

    const modalEl = document.getElementById("debtModal");
    modalEl.classList.add("custom-position", "active-firms-class");

    const modal = new bootstrap.Modal(modalEl);
    modal.show();

    const target = document.getElementById("inactiveCompanies_filter");
    const rect   = target.getBoundingClientRect();

    const dialog = modalEl.querySelector(".modal-dialog");

    setTimeout(() => {

        // ➤ Y = твоя custom вертикална позиция
        const top = rect.top + window.scrollY - 250;

        // ➤ Хоризонтален център МИНУС 8% от ширината
        const offsetPercent = 0.08; // ← промени на 0.05 / 0.10 и т.н.
        const left =
            (window.innerWidth - dialog.offsetWidth) / 2   // реален център
            - (window.innerWidth * offsetPercent);         // малко вляво

        dialog.style.position = "absolute";
        dialog.style.top  = top + "px";
        dialog.style.left = left + "px";

    }, 20);
}





loadDebts();
toggleActiveBtn.addEventListener('click', () => {
  showTurnover = !showTurnover;
  toggleActiveBtn.textContent = showTurnover
    ? '💱 Показвай: Чист приход'
    : '💱 Показвай: Оборот';

  if (allFirms?.activeFirms) renderActiveTable(allFirms.activeFirms);
});
function renderActiveTable(activeFirms) {
  const $table = $('#activeCompanies');

  // 1) ако има активна DataTable -> изчисти и унищожи
  if ($.fn.DataTable.isDataTable('#activeCompanies')) {
    $table.DataTable().clear().destroy();
  }

  if (!Array.isArray(activeFirms) || activeFirms.length === 0) {
    $table.find('thead').empty();
    $table.find('tbody').html('<tr><td colspan="10" class="text-center text-muted py-4">Няма данни</td></tr>');
    $('#activeFooter').html('📈 Общо активни: <strong>0</strong>');
    return;
  }

  const modeKey  = showTurnover ? 'turnovers'      : 'profits';
  const totalKey = showTurnover ? 'total_turnover' : 'total_profit';
  const titleTxt = showTurnover ? 'Оборот (€)'   : 'Чист приход (€)';

  const dateSet = new Set();
  activeFirms.forEach(f => {
    const src = f && f[modeKey] ? f[modeKey] : {};
    Object.keys(src).forEach(k => dateSet.add(k));
  });
  const dates = Array.from(dateSet).sort(); 
  thead = `<tr><th>#</th><th>Фирма</th><th>Задължение</th>`;
  dates.forEach(d => {
    const [y, m, day] = d.split('-');
    thead += `<th>${parseInt(day,10)}.${parseInt(m,10)}.${y}</th>`;
  });
  thead += `<th>${titleTxt}</th></tr>`;
  $table.find('thead').html(thead);

  // 5) Тяло
  const fmt = n => Number(n || 0).toLocaleString('bg-BG', { minimumFractionDigits: 2 });
  let tbody = '';

    activeFirms.forEach((firm, i) => {
    const debt = firmDebts[firm.firm] ?? 0;

    tbody += `
    <tr>
      <td>${i + 1}</td>
      <td><strong>${firm.firm}</strong></td>
<td class="text-center">
    <span class="text-primary cursor-pointer"
          onclick="showDebtModal('${firm.firm}', ${debt})">
        👁️
    </span>
</td>
    `;

    const map = (firm && firm[modeKey]) ? firm[modeKey] : {};
    dates.forEach(d => {
      const val = Number(map[d] ?? 0);
      const cls = val > 0 ? 'text-success fw-bold' : (val < 0 ? 'text-danger' : '');
      tbody += `<td class="text-end ${cls}">${fmt(val)}</td>`;
    });

    const totalVal = Number(firm?.[totalKey] ?? 0);
    tbody += `<td class="fw-bold text-end">${fmt(totalVal)}</td></tr>`;
  });

  $table.find('tbody').html(tbody);
  $('#activeFooter').html(`📈 Общо активни: <strong>${activeFirms.length}</strong>`);

  // 6) Ре-инициализация на DataTable
  // Колони: 0:#, 1:Фирма, 2..(2+dates.length-1):дни, последна = 2+dates.length
  const lastColIndex = 2 + dates.length; // <-- това е правилният индекс на "Общо"
  $table.DataTable({
    autoWidth: false,
    deferRender: true,
    pageLength: 5,
    searching: true,
    ordering: true,
    order: [[lastColIndex, 'desc']],
    columnDefs: [
      { targets: 0, className: 'text-center' },
      { targets: Array.from({ length: dates.length + 1 }, (_, i) => i + 2), className: 'text-end' } // датите + общо
    ],
    language: {
      search: "Търси:",
      paginate: { previous: "«", next: "»" },
      info: "Показани _START_–_END_ от _TOTAL_ фирми",
      lengthMenu: "Покажи _MENU_"
    }
  });
}
//-----------------------------------------------------------------------------------------------

function renderInactiveTable(inactiveFirms) {
  const table = $('#inactiveCompanies');

  if ($.fn.DataTable.isDataTable('#inactiveCompanies')) {
    table.DataTable().clear().destroy();
  }

  if (!inactiveFirms || inactiveFirms.length === 0) {
    table.find('thead').html('');
    table.find('tbody').html('<tr><td colspan="6" class="text-center text-muted py-4">Няма данни</td></tr>');
    $('#inactiveFooter').html('⚠️ Общо неактивни: <strong>0</strong>');
    return;
  }

  table.find('thead').html(`
    <tr>
      <th>#</th>
      <th>Фирма</th>
      <th>Задължение</th>
      <th>Група</th>
      <th>Агент</th>
      <th class="text-end">${showNetProfit ? 'Чист приход' : 'Оборот'}</th>
      <th>Дата Последен приход</th>
    </tr>
  `);

  let tbody = '';

  inactiveFirms.forEach((f, i) => {

    const debt = firmDebts[f.firm] ?? 0;

    tbody += `
      <tr>
        <td>${i + 1}</td>

        <td><strong>${f.firm}</strong></td>

        <td class="text-center">
            <span class="text-primary cursor-pointer"
                  onclick="showDebtModal('${f.firm}', ${debt})">
                👁
            </span>
        </td>

        <td>${f.group_main}</td>
        <td>${f.agent}</td>

        <td class="text-end">
          ${(showNetProfit ? f.net_profit : f.turnover)
            .toLocaleString('bg-BG', { minimumFractionDigits: 2 })}
        </td>

        <td>${
            new Date(f.last_income_date)
                .toLocaleDateString('bg-BG')
                .replace(' г.', '')
        }</td>

      </tr>
    `;
  });

  table.find('tbody').html(tbody);
  $('#inactiveFooter').html(`⚠️ Общо неактивни: <strong>${inactiveFirms.length}</strong>`);

  // ✅ инициализиране отново (вече чисто)
  table.DataTable({
    pageLength: 5,
    searching: true,
    ordering: true,
    order: [[4, 'desc']],
    language: {
      search: "Търси:",
      paginate: { previous: "«", next: "»" },
      info: "Показани _START_–_END_ от _TOTAL_ фирми"
    }
  });
}

// === 🧮 Общ метод за филтриране ===
function filterByPeriod(type, period, from = null, to = null) {
  if (!allFirms) return;
  const now = new Date();
  let start = new Date();

  switch (period) {
    case 'week': start.setDate(now.getDate() - 7); break;
    case 'month': start.setMonth(now.getMonth() - 1); break;
    case 'year': start.setFullYear(now.getFullYear() - 1); break;
    case 'custom':
      if (from && to) { start = new Date(from); now.setTime(new Date(to).getTime()); }
      break;
    default: start.setHours(0, 0, 0, 0);
  }

  if (type === 'active') {
    const filtered = allFirms.activeFirms.map(firm => {
      const profits = {};
      let total = 0;
      for (const [date, val] of Object.entries(firm.profits)) {
        const d = new Date(date);
        if (d >= start && d <= now && val !== 0) {
          profits[date] = val;
          total += val;
        }
      }
      return { ...firm, profits, total };
    }).filter(f => Object.keys(f.profits).length > 0);
    renderActiveTable(filtered);
  }

  if (type === 'inactive') {
    const filtered = allFirms.inactiveFirms.filter(firm => {
      const d = new Date(firm.last_income_date);
      return d >= start && d <= now;
    });
    renderInactiveTable(filtered);
  }
}

// === 🧭 Добавяне на отделни филтри над двата блока ===
function addFilterControls() {
  const filterTemplate = (idPrefix, label) => `
  <div class="d-flex flex-wrap justify-content-between align-items-center px-4 pb-2">
    <div class="btn-group mb-2" role="group">
      <button class="btn btn-outline-secondary btn-sm ${idPrefix}-btn active" data-period="day" data-type="${idPrefix}">Ден</button>
      <button class="btn btn-outline-secondary btn-sm ${idPrefix}-btn" data-period="week" data-type="${idPrefix}">Седмица</button>
      <button class="btn btn-outline-secondary btn-sm ${idPrefix}-btn" data-period="month" data-type="${idPrefix}">Месец</button>
      <button class="btn btn-outline-secondary btn-sm ${idPrefix}-btn" data-period="year" data-type="${idPrefix}">Година</button>
      <button class="btn btn-outline-secondary btn-sm ${idPrefix}-btn" data-period="custom" data-type="${idPrefix}">Custom</button>
    </div>
    <div id="${idPrefix}CustomRange" class="d-none">
      <input type="date" id="${idPrefix}From"  onkeydown="return false;" class="form-control form-control-sm d-inline-block w-auto"  />
      <span class="mx-1">до</span>
      <input type="date" id="${idPrefix}To"   onkeydown="return false;" class="form-control form-control-sm d-inline-block w-auto" />
      <button id="${idPrefix}Apply" class="btn btn-sm btn-primary ms-2">Филтрирай</button>
    </div>
  </div>`;

  document.querySelector('.card-header .text-success')
    .insertAdjacentHTML('afterend', filterTemplate('active', 'Активни фирми'));

  document.querySelector('.card-header .text-danger')
    .insertAdjacentHTML('afterend', filterTemplate('inactive', 'Неактивни фирми'));
}

// === Управление на бутоните ===
document.addEventListener('click', e => {
  // общ бутон за период
  if (e.target.matches('.active-btn, .inactive-btn')) {
    const type = e.target.dataset.type;
    const period = e.target.dataset.period;

    document.querySelectorAll(`.${type}-btn`).forEach(b => b.classList.remove('active'));
    e.target.classList.add('active');

    const customDiv = document.getElementById(`${type}CustomRange`);
    if (period === 'custom') customDiv.classList.remove('d-none');
    else {
      customDiv.classList.add('d-none');
      filterByPeriod(type, period);
    }
  }

  // custom apply
  if (e.target.id === 'activeApply' || e.target.id === 'inactiveApply') {
    const type = e.target.id.includes('active') ? 'active' : 'inactive';
    const from = document.getElementById(`${type}From`).value;
    const to = document.getElementById(`${type}To`).value;
    if (!from || !to) return alert('Моля, изберете начален и краен период!');
    filterByPeriod(type, 'custom', from, to);
  }
});

// === Старт ===
document.addEventListener('DOMContentLoaded', () => {
  //addFilterControls();
  loadFirms();
});

// === Динамично зареждане на филтрите ===
async function populateInactiveFilters() {
  const res = await fetch('/dashboard/firms');
  const data = await res.json();

  const agentSelect = document.getElementById('inactiveAgent');
  const groupSelect = document.getElementById('inactiveGroup');

  // Агенти
  data.agents.forEach(a => {
    const opt = document.createElement('option');
    opt.value = a;
    opt.textContent = a;
    agentSelect.appendChild(opt);
  });

  // Групи
  data.groups.forEach(g => {
    const opt = document.createElement('option');
    opt.value = g;
    opt.textContent = g;
    groupSelect.appendChild(opt);
  });
}







// === ФИЛТРИ ЗА АКТИВНИ ФИРМИ ===
async function populateActiveFilters() {
  const res = await fetch('/dashboard/firms');
  const data = await res.json();

  const agentSelect = document.getElementById('activeAgent');
  const groupSelect = document.getElementById('activeGroup');

  // Агент
  data.agents.forEach(a => {
    const opt = document.createElement('option');
    opt.value = a;
    opt.textContent = a;
    agentSelect.appendChild(opt);
  });

  // Група
  data.groups.forEach(g => {
    const opt = document.createElement('option');
    opt.value = g;
    opt.textContent = g;
    groupSelect.appendChild(opt);
  });
}

// 🧩 Прилагане на филтър
document.getElementById('activeFilterBtn').addEventListener('click', async () => {
  const from = document.getElementById('activeFrom').value;
  const to   = document.getElementById('activeTo').value;
  const agent = document.getElementById('activeAgent').value;
  const group = document.getElementById('activeGroup').value;

  

  const filtered = allFirms.activeFirms.filter(f => {
    let pass = true;

    // проверка на агент
    if (agent && f.agent !== agent) pass = false;
    // проверка на група
    if (group && f.group_main !== group) pass = false;

    // проверка на дати по ключовете turnovers/profits
    if (from || to) {
      const map = f[showTurnover ? 'turnovers' : 'profits'];
      const fromDate = from ? new Date(from) : new Date('1900-01-01');
      const toDate   = to ? new Date(to)   : new Date();

      const filteredDates = Object.entries(map).filter(([date]) => {
        const d = new Date(date);
        return d >= fromDate && d <= toDate;
      });

      if (filteredDates.length === 0) pass = false;
    }

    return pass;
  });

  renderActiveTable(filtered);
  $('#activeFooter').html(`🔍 Филтър активен (${filtered.length} фирми)`);
});

// 🧹 Нулиране
document.getElementById('activeResetBtn').addEventListener('click', () => {
  document.getElementById('activeFrom').value = '';
  document.getElementById('activeTo').value = '';
  document.getElementById('activeAgent').value = '';
  document.getElementById('activeGroup').value = '';

  renderActiveTable(allFirms.activeFirms);
  $('#activeFooter').html(`📈 Общо активни: <strong>${allFirms.activeFirms.length}</strong>`);
});

// 📅 Филтър по последни X месеца
document.getElementById('applyActiveMonthsBtn').addEventListener('click', () => {
  const months = parseInt(document.getElementById('activeMonthsBack').value) || 6;
  const cutoff = new Date();
  cutoff.setMonth(cutoff.getMonth() - months);

  const filtered = allFirms.activeFirms.filter(f => {
    const map = f[showTurnover ? 'turnovers' : 'profits'];
    return Object.keys(map).some(date => new Date(date) >= cutoff);
  });

  renderActiveTable(filtered);
  $('#activeFooter').html(`🗓 Показани фирми за последните <b>${months}</b> месеца (${filtered.length} резултата)`);
});

// === При стартиране ===
document.addEventListener('DOMContentLoaded', () => {
  populateActiveFilters();
});














let showNetProfit = false; // флаг за превключване между оборот и чист приход

// 🔁 Смяна на изгледа
document.getElementById('toggleValueBtn').addEventListener('click', () => {
  showNetProfit = !showNetProfit;
  document.getElementById('toggleValueBtn').textContent = showNetProfit ? '💱 Показвай: Чист приход' : '💱 Показвай: Оборот';
  
  if (allFirms?.inactiveFirms) {
    renderInactiveTable(allFirms.inactiveFirms);
  }
});

// 📅 Показване само на последните X месеца
document.getElementById('applyMonthsBtn').addEventListener('click', () => {
  const months = parseInt(document.getElementById('monthsBack').value) || 6;
  const cutoff = new Date();
  cutoff.setMonth(cutoff.getMonth() - months);

  const filtered = allFirms.inactiveFirms.filter(f => new Date(f.last_income_date) >= cutoff);
  renderInactiveTable(filtered);
  $('#inactiveFooter').html(`🗓 Показани фирми за последните <b>${months}</b> месеца (${filtered.length} резултата)`);
});

function updateFilterInfo() {
  const from = document.getElementById('inactiveFrom').value;
  const to = document.getElementById('inactiveTo').value;
  const agent = document.getElementById('inactiveAgent').value || 'Всички';
  const group = document.getElementById('inactiveGroup').value || 'Всички';
  const months = document.getElementById('monthsBack').value;

  let summaryParts = [];

  if (from && to) summaryParts.push(`от <b>${new Date(from).toLocaleDateString('bg-BG')}</b> до <b>${new Date(to).toLocaleDateString('bg-BG')}</b>`);
  else summaryParts.push(`без избран период`);

  summaryParts.push(`Агент: <b>${agent}</b>`);
  summaryParts.push(`Група: <b>${group}</b>`);
  summaryParts.push(`Последни месеци: <b>${months}</b>`);

  const text = summaryParts.join(' • ');
  document.getElementById('filterSummaryText').innerHTML = text;

  const infoBox = document.getElementById('inactiveFilterInfo');
  infoBox.style.display = 'block';
}

document.getElementById('inactiveFilterBtn').addEventListener('click', async () => {
  const from = document.getElementById('inactiveFrom').value;
  const to = document.getElementById('inactiveTo').value;
  const agent = document.getElementById('inactiveAgent').value;
  const group = document.getElementById('inactiveGroup').value;

  const params = new URLSearchParams();
  if (from) params.append('from', from);
  if (to) params.append('to', to);
  if (agent) params.append('agent', agent);
  if (group) params.append('group', group);

  try {
    const res = await fetch(`/dashboard/inactiveFiltered?${params.toString()}`);
    const data = await res.json();

    // 💥 унищожаваме старата DataTable, ако има
    if ($.fn.DataTable.isDataTable('#inactiveCompanies')) {
      $('#inactiveCompanies').DataTable().clear().destroy();
    }

    // 🎯 ако има резултати — визуализираме
    if (data && data.length > 0) {
      renderInactiveTable(data);
      $('#inactiveFooter').html(`🔍 Филтър активен (${data.length} фирми)`);
    } else {
      $('#inactiveCompanies tbody').html('<tr><td colspan="4" class="text-center text-muted py-3">Няма резултати</td></tr>');
      $('#inactiveFooter').html('⚠️ Няма фирми по избраните критерии.');
    }
    updateFilterInfo();
  } catch (err) {
    console.error('Грешка при заявката:', err);
    $('#inactiveFooter').html('❌ Грешка при зареждането на данните.');
  }
});

// === Нулиране ===
document.getElementById('inactiveResetBtn').addEventListener('click', async () => {
  document.getElementById('inactiveFilterInfo').style.display = 'none';
  document.getElementById('inactiveFrom').value = '';
  document.getElementById('inactiveTo').value = '';
  document.getElementById('inactiveAgent').value = '';
  document.getElementById('inactiveGroup').value = '';

  const res = await fetch('/dashboard/firms');
  const data = await res.json();
  renderInactiveTable(data.inactiveFirms);
});

// === При стартиране зареждаме опциите ===
document.addEventListener('DOMContentLoaded', () => {
  populateInactiveFilters();
});
</script>


<script>
let earningChart; // глобална променлива

document.addEventListener("DOMContentLoaded", function() {



  // 💰 Total Earning Gradient Line Chart
  const chartData = <?= json_encode($chartData ?? []) ?>;
  earningChart = new ApexCharts(document.querySelector("#earningChart"), {
    chart: {
      type: "area",
      height: 280,
      toolbar: { show: false },
      dropShadow: { enabled: true, top: 6, left: 0, blur: 6, opacity: 0.12 },
      animations: { enabled: true, easing: "easeinout", speed: 800 }
    },
    stroke: { curve: "smooth", width: 3 },
    colors: ["#007bff", "#ff4d4f", "#28a745"],
    fill: {
      type: "gradient",
      gradient: {
        shade: "light",
        type: "vertical",
        shadeIntensity: 0.3,
        gradientToColors: ["#b3d9ff", "#ffc0c0", "#b7f5c3"],
        opacityFrom: 0.5,
        opacityTo: 0.0,
        stops: [0, 90, 100]
      }
    },
    markers: {
      size: 4,
      strokeWidth: 2,
      strokeColors: ["#007bff", "#ff4d4f", "#28a745"],
      hover: { size: 6 }
    },
    grid: { borderColor: "#eee", strokeDashArray: 4 },
    dataLabels: { enabled: false },
    legend: { position: "top", horizontalAlign: "center", fontSize: "13px", fontWeight: 500 },
    series: [
      { name: "Приход", data: chartData.income },
      { name: "Чист приход", data: chartData.profit }
    ],
    xaxis: {
      categories: chartData.labels,
      labels: { rotate: -45, style: { fontSize: "12px", colors: "#777" } },
      axisBorder: { color: "#ddd" },
      axisTicks: { show: false }
    },
    yaxis: {
      labels: {
        formatter: val => val.toFixed(2) + " €",
        style: { colors: "#666", fontSize: "12px" }
      }
    },
    tooltip: { theme: "light", y: { formatter: val => val.toFixed(2) + " €" } }
  });

  earningChart.render();


  // 🧠 Анимирано обновяване при смяна на период
  const earningValue = document.querySelector(".card-body h2");
  document.querySelectorAll('.nav-link').forEach(btn => {
    btn.addEventListener('click', async () => {
      document.querySelectorAll('.nav-link').forEach(b => b.classList.remove('active'));
      btn.classList.add('active');

      const period = btn.textContent.toLowerCase();
      const response = await fetch(`/dashboard/data/${period}`);
      const data = await response.json();

      // 💰 анимация на сумата
      const start = parseFloat(earningValue.textContent.replace(/[^0-9.-]+/g,"")) || 0;
      const end = data.total;
      const duration = 800;
      const stepTime = 15;
      const steps = duration / stepTime;
      let current = 0;
      const timer = setInterval(() => {
        current++;
        const val = start + (end - start) * (current / steps);
        earningValue.textContent = val.toLocaleString('bg-BG', { minimumFractionDigits: 2 }) + " €";
        if (current >= steps) clearInterval(timer);
      }, stepTime);

      // 📈 обновяване на графиката
      earningChart.updateOptions({
        xaxis: { categories: data.labels },
        series: [
          { name: "Оборот", data: data.income },
          { name: "Чист приход", data: data.profit }
        ]
      });
    });
  });

});
</script>
<style>
#earningChart {
  background: linear-gradient(180deg, #ffffff 0%, #f9fbff 100%);
  border-radius: 14px;
  box-shadow: inset 0 2px 5px rgba(0,0,0,0.03);
  padding: 0.5rem;
}
</style>
<style>
    
 #inactiveFilterInfo {
  border-radius: 10px;
  background: #e9f4ff;
  border: 1px solid #c9e4ff;
  color: #004085;
  font-weight: 500;
  box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

/* --- Layout Improvements --- */
body {
  background: linear-gradient(180deg, #f9fafc 0%, #f1f3f8 100%);
  letter-spacing: 0.2px;
}

.container-fluid {
  max-width: 1800px;
}

/* --- Card Modernization --- */
.card {
  border-radius: 14px;
  border: 1px solid rgba(255,255,255,0.6);
  backdrop-filter: blur(12px);
  background: rgba(255,255,255,0.9);
  box-shadow: 0 6px 16px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
}

.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 12px 28px rgba(0,0,0,0.07);
}

/* --- Headings --- */
h1, h2, h3, h4, h5 {
  letter-spacing: 0.4px;
}

.card-header h5 {
  font-weight: 700;
  font-size: 1.05rem;
}

/* --- Tables --- */
table.dataTable {
  border-collapse: separate;
  border-spacing: 0;
  background: transparent;
  border-radius: 10px;
  overflow: hidden;
}

table.dataTable thead th {
  background: #f5f7fb;
  color: #555;
  border-bottom: 2px solid #e9ecef;
  text-transform: uppercase;
  font-size: 0.85rem;
  letter-spacing: 0.05em;
}

table.dataTable tbody tr {
  border-bottom: 1px solid #f1f1f1;
  transition: background 0.2s ease;
}

table.dataTable tbody tr:hover {
  background-color: #f8fbff !important;
}

/* --- Badges --- */
.badge {
  border-radius: 20px;
  box-shadow: 0 2px 5px rgba(0,0,0,0.05);
  text-transform: capitalize;
}

/* --- Pagination --- */
.dataTables_wrapper .dataTables_paginate {
  margin-top: 10px;
}
.dataTables_wrapper .dataTables_paginate .paginate_button {
  border-radius: 8px;
  background: #f5f7fa;
  color: #333 !important;
  transition: all 0.2s ease;
}
.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
  background: #007bff;
  color: #fff !important;
  transform: scale(1.05);
}
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
  background: #007bff !important;
  color: #fff !important;
  font-weight: 600;
  box-shadow: 0 0 8px rgba(0,123,255,0.3);
}

/* --- Footer --- */
.card-footer {
  background: linear-gradient(90deg, #f8f9fb 0%, #eef1f5 100%);
  font-size: 0.85rem;
  color: #666;
  border-top: 1px solid #e9ecef;
  font-weight: 500;
}

/* --- Subtle Animations --- */
.card, .table, .badge, .icon-box {
  animation: fadeInUp 0.5s ease both;
}

@keyframes fadeInUp {
  0% { opacity: 0; transform: translateY(10px); }
  100% { opacity: 1; transform: translateY(0); }
}

/* --- Scrollbars (modern) --- */
::-webkit-scrollbar {
  width: 8px;
}
::-webkit-scrollbar-thumb {
  background-color: rgba(0,0,0,0.2);
  border-radius: 4px;
}
::-webkit-scrollbar-thumb:hover {
  background-color: rgba(0,0,0,0.3);
}

/* --- Gradient Buttons (for future) --- */
.btn-gradient {
  background: linear-gradient(90deg, #007bff, #00c3ff);
  color: white;
  border: none;
  border-radius: 8px;
  transition: all 0.3s ease;
}
.btn-gradient:hover {
  background: linear-gradient(90deg, #006ae0, #00a5ff);
  transform: translateY(-1px);
}

/* --- Dark Mode polish --- */
@media (prefers-color-scheme: dark) {
  body {
    background: linear-gradient(180deg, #20202b 0%, #1b1b27 100%);
  }
  .card {
    background: rgba(40, 42, 60, 0.9);
    border-color: rgba(255,255,255,0.08);
    color: #eee;
  }
  table.dataTable thead th {
    background: #2c2e45;
    color: #ccc;
  }
  table.dataTable tbody tr:hover {
    background-color: #2b2e44 !important;
  }
  .card-footer {
    background: linear-gradient(90deg, #2a2d42 0%, #26283b 100%);
    color: #bbb;
  }
}


</style>

<!-- ✅ BOOTSTRAP -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- ✅ SELECT2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.full.min.js"></script>

<!-- ✅ SELECT2 ИНИЦИАЛИЗАЦИЯ -->
<script>
$(function() {
  $('#firmSelect').select2({
    placeholder: "Избери фирма...",
    allowClear: true,
    width: '100%',
    dropdownParent: $('#addTaskModal')
  });
});
</script>

<script>
document.addEventListener("DOMContentLoaded", async () => {
  try {
    // взимаме датите за последните 3 години
    const now = new Date();
    const start = new Date();
    start.setFullYear(now.getFullYear() - 3);

    const from = start.toISOString().split("T")[0];
    const to = now.toISOString().split("T")[0];

    // слагаме ги в полетата
    document.getElementById("fromDate").value = from;
    document.getElementById("toDate").value = to;

    // извикваме endpoint-а, който вече връща и summary
    const res = await fetch(`/dashboard/dataCustom?from=${from}&to=${to}`);
    const data = await res.json();

    if (data.error) {
      console.error("Грешка при зареждане:", data.error);
      return;
    }

    // обновяваме графиката и таблицата
    updateEarnings(data);

    // автоматично показваме таблицата (а не графиката)
    const toggleBtn = document.getElementById("toggleView");
    if (data.summary && toggleBtn) {
      toggleBtn.click();
    }
  } catch (err) {
    console.error("Грешка при автоматично зареждане на данните:", err);
  }
});
</script>


<script>

/* =========================
    SAVE PRESET PER MODULE
========================= */
function savePreset(type) {

    let data = {};

    if (type === "active") {
        data = {
            from: $("#activeFrom").val(),
            to: $("#activeTo").val(),
            agent: $("#activeAgent").val(),
            group: $("#activeGroup").val(),
            monthsBack: $("#activeMonthsBack").val()
        };
    }

    if (type === "inactive") {
        data = {
            from: $("#inactiveFrom").val(),
            to: $("#inactiveTo").val(),
            agent: $("#inactiveAgent").val(),
            group: $("#inactiveGroup").val(),
            monthsBack: $("#monthsBack").val()
        };
    }

    if (type === "earnings") {
        data = {
            from: $("#fromDate").val(),
            to: $("#toDate").val(),
            agent: $("#agentFilter").val()
        };
    }

    if (type === "stock") {
        data = {
            from: $("#stockFromDate").val(),
            to: $("#stockToDate").val(),
            group: $("#stockGroupFilter").val()
        };
    }

    if (type === "deliveries") {
        data = {
            months: $("#delMonths").val(),
            percent: $("#delPercent").val(),
            group: $("#delGroup").val()
        };
    }

    localStorage.setItem("PRESET_" + type.toUpperCase(), JSON.stringify(data));
    alert("Записан е профил за: " + type.toUpperCase());
}



/* =========================
    SAVE EVERYTHING
========================= */
function saveAllPresets() {
    savePreset("active");
    savePreset("inactive");
    savePreset("earnings");
    savePreset("stock");
    savePreset("deliveries");
    alert("Всички филтър профили са запазени!");
}



/* =========================
     LOAD PRESETS
========================= */
function loadPreset(type) {
    const saved = localStorage.getItem("PRESET_" + type.toUpperCase());
    if (!saved) return;

    const f = JSON.parse(saved);

    if (type === "active") {
        $("#activeFrom").val(f.from);
        $("#activeTo").val(f.to);
        $("#activeAgent").val(f.agent);
        $("#activeGroup").val(f.group);
        $("#activeMonthsBack").val(f.monthsBack);
        $("#activeFilterBtn").click();
    }

    if (type === "inactive") {
        $("#inactiveFrom").val(f.from);
        $("#inactiveTo").val(f.to);
        $("#inactiveAgent").val(f.agent);
        $("#inactiveGroup").val(f.group);
        $("#monthsBack").val(f.monthsBack);
        $("#inactiveFilterBtn").click();
    }

    if (type === "earnings") {
        $("#fromDate").val(f.from);
        $("#toDate").val(f.to);
        $("#agentFilter").val(f.agent);
        $("#applyRange").click();
    }

    if (type === "stock") {
        $("#stockFromDate").val(f.from);
        $("#stockToDate").val(f.to);
        $("#stockGroupFilter").val(f.group);
        $("#loadStockBtn").click();
    }

    if (type === "deliveries") {
        $("#delMonths").val(f.months);
        $("#delPercent").val(f.percent);
        $("#delGroup").val(f.group);
        $("#loadDeliveriesBtn").click();
    }
}



$(document).ready(function () {
    loadPreset("active");
    loadPreset("inactive");
    loadPreset("earnings");
    loadPreset("stock");
    loadPreset("deliveries");
});

</script>

<div class="modal fade" id="debtModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content rounded-4 shadow-lg">

      <div class="modal-header bg-danger bg-opacity-10 border-0">
        <h5 class="modal-title fw-bold text-danger">
          <i class="fa-solid fa-scale-balanced me-2"></i>
          Задължения на фирма
        </h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">


        <h5 id="debtFirmName" class="fw-bold mb-2"></h5>
        <p class="mb-1 text-muted">Баланс на Фирмата:</p>
        <h4 id="debtFirmValue" class="fw-bold text-danger mb-4"></h4>


        <div class="small">
          <div><strong>Потенциал:</strong> Висок</div>
          <div><strong>Основен предмет на дейност:</strong> Фармацевтична дистрибуция</div>
          <div><strong>Статус:</strong> Активна</div>
          <div><strong>Основни продукти:</strong> 3434</div>
          <div><strong>Лице за контакт и телефон:</strong> Иван Петров — 0888 123 456</div>
          <div><strong>Тип клиент:</strong> Малка фирма без достъп до основни доставчици</div>
          <div><strong>Търговец:</strong> Младен Мавродиев</div>
          <div><strong>Особености:</strong> 3434343434</div>
        </div>

      </div>

      <div class="modal-footer border-0">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Затвори</button>
      </div>

    </div>
  </div>
</div>

<script>
function simulateActive() {
    const rows = document.querySelectorAll('#activeCompanies tbody tr');
    if (!rows.length) return;

    rows.forEach(row => {
        const tds = row.querySelectorAll('td');
        for (let i = 3; i < tds.length; i++) {
            let newVal = Math.random() * 4000;
            tds[i].textContent = newVal.toLocaleString('bg-BG', { minimumFractionDigits: 2 });
        }
    });
}

function simulateInactive() {
    const rows = document.querySelectorAll('#inactiveCompanies tbody tr');
    if (!rows.length) return;

    rows.forEach(row => {
        const tds = row.querySelectorAll('td');
        let newTurn = Math.round(Math.random() * 15000);
        tds[5].textContent = newTurn.toLocaleString('bg-BG');

        let d = new Date();
        d.setDate(d.getDate() - Math.floor(Math.random() * 300));
        tds[6].textContent = d.toLocaleDateString('bg-BG').replace(' г.', '');
    });
}

function simulateStock() {
    const rows = document.querySelectorAll('#stockTable tbody tr');
    if (!rows.length) return;
    if (rows[0].textContent.includes("Няма данни")) return;

    let totalQty = 0;
    let totalTurn = 0;
    let totalProfit = 0;

    rows.forEach(row => {
        const tds = row.querySelectorAll('td');

        let qty = Math.round(Math.random() * 15) + 1;
        tds[2].textContent = qty.toLocaleString('bg-BG');
        totalQty += qty;

        let turn = Math.round(Math.random() * 2000);
        tds[3].textContent = turn.toLocaleString('bg-BG');
        totalTurn += turn;

        let profit = Math.round(turn * (0.05 + Math.random() * 0.15));
        tds[4].textContent = profit.toLocaleString('bg-BG');
        totalProfit += profit;
    });

    document.getElementById("totalQty").textContent = totalQty.toLocaleString('bg-BG');
    document.getElementById("totalTurn").textContent = totalTurn.toLocaleString('bg-BG');
    document.getElementById("totalProfit").textContent = totalProfit.toLocaleString('bg-BG');
}

function simulateGroupTotals() {
    const totalsBox = document.querySelector("#groupsTotals");
    if (!totalsBox) return;

    const cleanProfitEl = totalsBox.querySelectorAll(".pr-data")[0].querySelector("h5");
    const turnoverEl    = totalsBox.querySelectorAll(".pr-data")[1].querySelector("h5");
    const groupsCountEl = totalsBox.querySelectorAll(".pr-data")[2].querySelector("h5");

    let cleanProfit = Math.round(5000 + Math.random() * 25000);
    let turnover = Math.round(15000 + Math.random() * 75000);
    let groupCount = 10 + Math.floor(Math.random() * 16);

    cleanProfitEl.textContent = cleanProfit.toLocaleString('bg-BG') + " лв";
    turnoverEl.textContent    = turnover.toLocaleString('bg-BG') + " лв";
    groupsCountEl.textContent = groupCount.toLocaleString('bg-BG');
}

setInterval(() => {
    simulateActive();
    simulateInactive();
    simulateStock();
    simulateGroupTotals();
}, 10000);

function toISO(dateDMY) {
  if (!dateDMY) return "";
  const [d, m, y] = dateDMY.split("/");
  return `${y}-${m}-${d}`;
}

function fromISO(dateISO) {
  if (!dateISO) return "";
  const [y, m, d] = dateISO.split("-");
  return `${d}/${m}/${y}`;
}
</script>

</div>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/bg.js"></script>

<script>
flatpickr(".date-picker", {
  locale: "bg",
  dateFormat: "d/m/Y",   
  allowInput: false,    
  clickOpens: true,
  disableMobile: true
});
</script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/bg.js"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  flatpickr(".date-picker2", {
    locale: "bg",
    dateFormat: "d/m/Y",
    allowInput: false,
    disableMobile: true
  });
});
</script>
</body>
</html>
