<!DOCTYPE html>
<html lang="bg">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?></title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <style>
        .active-sub {
            box-shadow: 0 0 0 3px rgba(25,135,84,0.5) !important;
            transform: translateY(-1px);
            border-radius: 8px;
            font-weight: 700;
        }

        body { background-color: #f8f9fc; font-family: 'Inter','Segoe UI',sans-serif; }

        /* --- SIDEBAR --- */
        .modern-sidebar {
            position: fixed;
            top: 0; left: 0;
            width: 240px; height: 100vh;
            background: linear-gradient(180deg, #0d6efd 0%, #2563eb 100%);
            color: #fff;
            display: flex; flex-direction: column;
            justify-content: space-between;
            padding: 20px 0;
            box-shadow: 3px 0 15px rgba(0,0,0,.1);
            z-index: 1050;
        }
        .nav-item {
            display: flex; align-items: center; gap: 10px;
            padding: 10px 20px;
            color: rgba(255,255,255,0.9);
            text-decoration: none;
            transition: .3s;
            border-left: 4px solid transparent;
            font-weight: 500;
        }
        .nav-item:hover {
            background: rgba(255,255,255,0.1);
            transform: translateX(5px);
            color: #fff;
        }
        .nav-item.active {
            background: rgba(255,255,255,0.15);
            border-left-color: #fff;
            color: #fff;
        }
        .nav-item.logout { color: #ffcccc; }

        .main-content { margin-left:240px; padding:2rem; }

        /* Таблица + стрелки */
        th.sortable { cursor:pointer; user-select:none; white-space: nowrap; }
        th.sortable i { margin-left:6px; }
        .arrow-red { color:#dc3545; }
        .arrow-green { color:#28a745; }

        .due-green { color:#198754 !important; font-weight:700; }
        .due-red   { color:#dc3545 !important; font-weight:700; }

        .btn-sub  { width:120px; }

        .filter-box {
            background:#f1f4ff;
            border-left:4px solid #0d6efd;
            padding:15px;
            border-radius:10px;
        }

        .progress {
            background-color:#e9ecef;
        }
        
        .nav-path {
            background: #e9ecef;
            border-radius: 8px;
            padding: 10px 15px;
            margin-bottom: 20px;
            font-weight: 500;
        }
        
        .no-results {
            text-align: center;
            padding: 40px;
            color: #6c757d;
            font-size: 1.2rem;
        }
        
        .due-limit-field {
            background-color: #f8f9fa;
            font-weight: bold;
            color: #495057;
        }
    </style>
</head>

<body>

<!-- SIDEBAR -->
<aside class="modern-sidebar">
    <div class="sidebar-top">
        <div class="sidebar-logo text-center mb-4 fw-bold">
            <i class="fa-solid fa-chart-pie"></i> Табло
        </div>

        <nav class="sidebar-nav">
               <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
                <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
              </a>
            
              <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
                <i class="fa-solid fa-list-check"></i><span>Задачи</span>
              </a>
            
              <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
                <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
              </a>
            
              <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
                <i class="fa-solid fa-building"></i><span>Активни</span>
              </a>
            
              <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
                <i class="fa-solid fa-ban"></i><span>Неактивни</span>
              </a>
            <a href="/clients" class="nav-item"><i class="fa-solid fa-users"></i><span>Профили</span></a>
            <a href="/clients/create" class="nav-item"><i class="fa-solid fa-user-plus"></i><span>Нов профил</span></a>
            <a href="/calendar" class="nav-item"><i class="fa-solid fa-calendar-days"></i><span>Календар</span></a>
            <a href="/dashboard/cashflow" class="nav-item">
                <i class="fa-solid fa-money-bill-transfer"></i><span>РАЗХОДИ</span>
            </a>
            
            <a href="/dashboard/debtors" class="nav-item active">
                <i class="fa-solid fa-user-clock"></i><span>Длъжници</span>
            </a>
            
            
            <a href="/refillstock" class="nav-item">
                <i class="fa-solid fa-boxes-packing"></i><span>Дозареждане на стока</span>
            </a>
            
            <a href="/analytics" class="nav-item"><i class="fa-solid fa-chart-line"></i>Аналитика</a>
        </nav>
    </div>

    <div class="sidebar-bottom">
        <a href="#" class="nav-item logout"><i class="fa-solid fa-right-from-bracket"></i>Изход</a>
    </div>
</aside>



<!-- CONTENT -->
<div class="main-content">

    <div class="bg-white rounded-4 shadow-sm p-4">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3 class="fw-bold mb-0 text-primary">
                <i class="fa-solid fa-money-bill"></i> Длъжници <span id="companyName">ВАЛПЕРС</span>
            </h3>

            <button class="btn btn-outline-success btn-sm" id="btnExport">
                <i class="fa-regular fa-file-excel me-1"></i> Excel
            </button>
        </div>

        <!-- Навигационна лента -->
        <div class="nav-path text-center">
            <h5 class="fw-bold mb-0">
                📊 <span id="reportTitle">ЗАДЪЛЖЕНИЯ – БАНКА</span>
            </h5>
        </div>

        <!-- Подрежим: Банка / Брой -->
        <div class="d-flex gap-3 mb-3">
            <button class="btn btn-outline-success btn-sub subMode" data-sub="bank">БАНКА</button>
            <button class="btn btn-outline-primary btn-sub subMode" data-sub="cash">БРОЙ</button>
            <button class="btn btn-outline-secondary btn-sub subMode" data-sub="all">ВСИЧКИ</button>
        </div>

        <!-- Поле за срок на падеж -->
        <div class="row mb-3">
            <div class="col-md-3">
                <label class="form-label fw-bold">Срок на падеж (дни)</label>
                <input type="number" id="dueDays" class="form-control due-limit-field" value="7" readonly>
            </div>
        </div>

        <!-- Филтри (отворени по подразбиране) -->
        <div class="filter-box mb-3">
            <h5 class="fw-bold mb-3">
                <i class="fa-solid fa-filter me-2"></i> Филтри
            </h5>

            <div class="row g-3">

                <div class="col-lg-3">
                    <label class="form-label">Фирма</label>
                    <select id="filterFirm" class="form-select">
                        <option value="">Всички</option>
                    </select>
                </div>

                <div class="col-lg-3">
                    <label class="form-label">Агент</label>
                    <select id="filterAgent" class="form-select">
                        <option value="">Всички</option>
                    </select>
                </div>

                <div class="col-lg-3">
                    <label class="form-label">Email</label>
                    <select id="filterEmail" class="form-select">
                        <option value="">Всички</option>
                    </select>
                </div>
                
                <div class="col-lg-3">
                    <label class="form-label">Тип документ</label>
                    <select id="filterDocType" class="form-select">
                        <option value="">Всички</option>
                        <option value="Фактура">Фактура</option>
                        <option value="Протокол">Протокол</option>
                        <option value="Кредитно известие">Кредитно известие</option>
                    </select>
                </div>

                <div class="col-lg-3">
                    <label class="form-label">ПАДЕЖ</label>
                    <select id="filterStatus" class="form-select">
                        <option value="">Всички</option>
                        <option value="good">В ПАДЕЖ</option>
                        <option value="bad">Просрочено</option>
                    </select>
                </div>

                <div class="col-lg-3">
                    <label class="form-label">Дата от</label>
                    <input id="filterDateFrom" type="date" class="form-control">
                </div>

                <div class="col-lg-3">
                    <label class="form-label">Дата до</label>
                    <input id="filterDateTo" type="date" class="form-control">
                </div>

            </div>

            <div class="mt-3 text-end">
                <button class="btn btn-secondary btn-sm" onclick="clearFilters()">
                    <i class="fa-solid fa-eraser me-1"></i> Изчисти
                </button>
            </div>

        </div>

        <!-- Търсачка -->
        <div class="mb-3">
            <label class="form-label fw-bold">Търси във всички полета</label>
            <input id="search" type="text" class="form-control" placeholder="Въведете текст за търсене...">
        </div>

        <div id="tableContainer">
            <div class="no-results">
                <i class="fa-solid fa-info-circle fa-2x mb-3"></i><br>
                Изберете режим за показване на данните
            </div>
        </div>

    </div>
</div>


<script>
let subMode = 'bank';
let rawGroups = [];
let filteredGroups = [];
let sortCol = "dateObj";
let sortDir = -1;

// SUB MODE
document.querySelectorAll('.subMode').forEach(btn => {
    btn.onclick = () => {
        subMode = btn.dataset.sub;
        updateStatus();
        updateDueDays();
        
        // МАРКЕР
        document.querySelectorAll('.subMode').forEach(b => b.classList.remove('active-sub'));
        btn.classList.add('active-sub');

        // Автоматично зареждане на данните при избор на режим
        loadData();
    };
});

// UPDATE DUE DAYS BASED ON SUBMODE
function updateDueDays() {
    const dueDaysField = document.getElementById('dueDays');
    
    switch(subMode) {
        case 'cash': dueDaysField.value = '7'; break;
        case 'bank': dueDaysField.value = '14'; break;
        case 'all': dueDaysField.value = '7'; break;
        default: dueDaysField.value = '7';
    }
}

// LOAD DATA
function loadData() {
    if (!subMode) return;

    fetch("/dashboard/debtors/load?mode=" + subMode)
        .then(r => r.json())
        .then(d => {
            rawGroups = d.items || [];
            filteredGroups = JSON.parse(JSON.stringify(rawGroups));
            buildFilterOptions(rawGroups);
            applyFilters(); // Apply filters immediately after loading
        });
}

// BUILD FILTER DROPDOWNS
function buildFilterOptions(groups) {
    let firms = new Set();
    let agents = new Set();
    let emails = new Set();
    let docTypes = new Set();

    groups.forEach(g => {
        (g.rows || []).forEach(r => {
            if (r["Фирма"]) firms.add(r["Фирма"]);
            if (r["Агент"]) agents.add(r["Агент"]);
            if (r["e-mail"]) emails.add(r["e-mail"]);
            if (r["Тип документ"]) docTypes.add(r["Тип документ"]);
        });
    });

    buildSelect("filterFirm", firms);
    buildSelect("filterAgent", agents);
    buildSelect("filterEmail", emails);
    buildDocTypeSelect();
}
function buildDocTypeSelect() {
    let sel = document.getElementById("filterDocType");

    sel.innerHTML = `
        <option value="">Всички</option>
        <option value="Фактура">Фактура</option>
        <option value="Протокол">Протокол</option>
        <option value="Кредитно известие">Кредитно известие</option>
    `;
}
function buildSelect(id, set) {
    let sel = document.getElementById(id);
    sel.innerHTML = `<option value="">Всички</option>`;
    Array.from(set).sort().forEach(v => {
        sel.innerHTML += `<option value="${v}">${v}</option>`;
    });
}

// APPLY FILTERS (now triggered automatically)
function applyFilters() {
    let firm = document.getElementById("filterFirm").value;
    let agent = document.getElementById("filterAgent").value;
    let email = document.getElementById("filterEmail").value;
    let docType = document.getElementById("filterDocType").value;
    let status = document.getElementById("filterStatus").value;

    let dFrom = document.getElementById("filterDateFrom").value;
    let dTo = document.getElementById("filterDateTo").value;

    let fromDate = dFrom ? new Date(dFrom) : null;
    let toDate = dTo ? new Date(dTo) : null;

    filteredGroups = rawGroups.map(group => {
        let rows = (group.rows || []).filter(r => {
            let ok = true;

            if (firm && r["Фирма"] !== firm) ok = false;
            if (agent && r["Агент"] !== agent) ok = false;
            if (email && r["e-mail"] !== email) ok = false;
            if (docType && r["Тип документ"] !== docType) ok = false;

            let statusText = r["ПАДЕЖ"] || "";
            if (status === "good" && statusText.includes("Просрочено")) ok = false;
            if (status === "bad" && !statusText.includes("Просрочено")) ok = false;

            if ((fromDate || toDate) && r["От дата"]) {
                let dt = new Date(r["От дата"]);
                if (fromDate && dt < fromDate) ok = false;
                if (toDate && dt > toDate) ok = false;
            }

            return ok;
        });

        return {
            ...group,
            rows
        };
    });

    renderTable(filteredGroups);
}

function clearFilters() {
    ["filterFirm", "filterAgent", "filterEmail", "filterDocType", "filterStatus", "filterDateFrom", "filterDateTo"]
        .forEach(id => document.getElementById(id).value = "");
    filteredGroups = JSON.parse(JSON.stringify(rawGroups));
    renderTable(filteredGroups);
}

// RENDER TABLE
function renderTable(groups) {
    let html = "";
    let hasResults = false;

    groups
        .filter(g => Number(g.total) > 0)
        .forEach(group => {
            (group.rows || []).forEach(r => {
                // sale date
                if (r["От дата"]) {
                    r.dateObj = new Date(r["От дата"]);
                } else {
                    r.dateObj = null;
                }

                // падежна дата от бекенда
                if (r["due_date_iso"]) {
                    r.dueDateObj = new Date(r["due_date_iso"]);
                } else {
                    r.dueDateObj = null;
                }
            });

            group.rows.sort((a, b) => compareValues(a, b));

            // Проверка дали има редове след търсенето
            let visibleRows = group.rows.filter(r => {
                let term = document.getElementById("search").value.toLowerCase();
                return term === "" || JSON.stringify(r).toLowerCase().includes(term);
            });

            if (visibleRows.length === 0) return;

            hasResults = true;

            html += `
        <div class="border rounded-4 p-3 mb-4 shadow-sm">
            <h5 class="fw-bold mb-3">
                ${group.group_name}
                ${typeof group.total !== "undefined"
                    ? `<span class="text-muted">— БАЛАНС: ${Number(group.total).toFixed(2)} лв.</span>`
                    : ""}
            </h5>

            <div class="table-responsive">
                <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        ${renderTH('dateObj', 'Дата')}
                        ${renderTH('Тип документ', 'Тип документ')}
                        ${renderTH('Документ', 'Документ')}
                        ${renderTH('Фирма', 'Фирма')}
                        ${renderTH('за сума', 'Сума')}
                        ${renderTH('Плащане', 'Плащане')}
                        ${renderTH('Агент', 'Агент')}
                        ${renderTH('e-mail', 'Email')}
                        ${renderTH('dueDateObj', 'Падеж')}
                    </tr>
                </thead>
                <tbody>
        `;

            visibleRows.forEach(r => {
                let pad = r["ПАДЕЖ"] || "";
                let stat = r["status_code"] || (pad.includes("Просрочено") ? "bad" : "good");

                let dueClass = (stat === "bad") ? "due-red" : "due-green";
                let barClass = (stat === "bad") ? "bg-danger" : "bg-success";

                let limit = r["limit_days"] || 0;
                let days = r["days_diff"] || 0;
                let pct = 0;
                if (limit > 0) {
                    pct = Math.round((days / limit) * 100);
                    if (pct > 100) pct = 100;
                    if (pct < 0) pct = 0;
                }

                let tooltip = "";
                if (r["due_date"] && limit) {
                    tooltip = `Падеж: ${r["due_date"]} • Лимит: ${limit} дни`;
                }

                html += `
                <tr>
                    <td>${r["От дата"] || ""}</td>
                    <td>${r["Тип документ"] || ""}</td>
                    <td>${r["Документ"] || ""}</td>
                    <td>${r["Фирма"] || ""}</td>
                    <td>${r["за сума"] || ""}</td>
                    <td>${r["Плащане"] || ""}</td>
                    <td>${r["Агент"] || ""}</td>
                    <td>${r["e-mail"] || ""}</td>
                    <td class="${dueClass}">
                        <span ${tooltip ? `data-bs-toggle="tooltip" title="${tooltip}"` : ""}>
                            ${pad}
                        </span>
                        ${limit ? `
                        <div class="progress mt-1" style="height:6px;">
                            <div class="progress-bar ${barClass}" role="progressbar"
                                 style="width:${pct}%;"
                                 aria-valuenow="${pct}" aria-valuemin="0" aria-valuemax="100">
                            </div>
                        </div>` : ``}
                    </td>
                </tr>
            `;
            });

            html += `
                </tbody>
                </table>
            </div>
        </div>`;
    });

    if (!hasResults) {
        html = `<div class="no-results">
                    <i class="fa-solid fa-search fa-2x mb-3"></i><br>
                    ❗ НЯМА НАМЕРЕНИ РЕЗУЛТАТИ
                </div>`;
    }

    document.getElementById("tableContainer").innerHTML = html;

    initTooltips();

    document.querySelectorAll("th.sortable").forEach(th => {
        th.onclick = () => {
            let col = th.dataset.col;
            if (sortCol === col) sortDir *= -1;
            else { sortCol = col; sortDir = 1; }
            renderTable(filteredGroups);
        };
    });
}

// SORT
function renderTH(col, label) {
    let icon = "";
    if (sortCol === col) {
        icon = sortDir === 1
            ? `<i class="fa-solid fa-arrow-up arrow-green"></i>`
            : `<i class="fa-solid fa-arrow-down arrow-red"></i>`;
    }
    return `<th class="sortable" data-col="${col}">${label} ${icon}</th>`;
}

function compareValues(a, b) {
    const col = sortCol;

    if (col === "dateObj") {
        let av = a.dateObj ? a.dateObj.getTime() : 0;
        let bv = b.dateObj ? b.dateObj.getTime() : 0;
        return (av - bv) * sortDir;
    }

    if (col === "dueDateObj") {
        let av = a.dueDateObj ? a.dueDateObj.getTime() : 0;
        let bv = b.dueDateObj ? b.dueDateObj.getTime() : 0;
        return (av - bv) * sortDir;
    }

    if (col === "за сума") {
        let an = parseFloat(String(a[col] || "").replace(/[^\d,.-]/g, "").replace(",", ".")) || 0;
        let bn = parseFloat(String(b[col] || "").replace(/[^\d,.-]/g, "").replace(",", ".")) || 0;
        return (an - bn) * sortDir;
    }

    let av = (a[col] ?? "").toString().toLowerCase();
    let bv = (b[col] ?? "").toString().toLowerCase();

    if (av < bv) return -1 * sortDir;
    if (av > bv) return 1 * sortDir;
    return 0;
}

// SEARCH
document.getElementById("search").addEventListener("keyup", function() {
    renderTable(filteredGroups);
});

// TOOLTIPS
function initTooltips() {
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.forEach(function (tooltipTriggerEl) {
        new bootstrap.Tooltip(tooltipTriggerEl);
    });
}

// EXCEL EXPORT
document.getElementById('btnExport').addEventListener('click', () => {
    if (!subMode) {
        alert("Моля, изберете режим преди експорт.");
        return;
    }
    
    const selectedFirm = document.getElementById("filterFirm").value;
    if (!selectedFirm) {
        alert("Моля, изберете конкретна фирма преди експорт.");
        return;
    }

    const firm = document.getElementById("filterFirm").value;
    const agent = document.getElementById("filterAgent").value;
    const email = document.getElementById("filterEmail").value;
    const docType = document.getElementById("filterDocType").value;
    const status = document.getElementById("filterStatus").value;
    const from = document.getElementById("filterDateFrom").value;
    const to = document.getElementById("filterDateTo").value;

    const params = new URLSearchParams();
    params.set('mode', subMode);
    if (firm) params.set('firm', firm);
    if (agent) params.set('agent', agent);
    if (email) params.set('email', email);
    if (docType) params.set('docType', docType);
    if (status) params.set('status', status);
    if (from) params.set('from', from);
    if (to) params.set('to', to);

    window.location = '/dashboard/debtors/export?' + params.toString();
});

function updateStatus() {
    const title = document.getElementById("reportTitle");
    const companyName = document.getElementById("companyName");

    const selectedFirm = document.getElementById("filterFirm").value;
    companyName.textContent = selectedFirm || "ВАЛПЕРС";

    let text = "";
    switch (subMode) {
        case "bank": text = "ЗАДЪЛЖЕНИЯ – БАНКА"; break;
        case "cash": text = "ЗАДЪЛЖЕНИЯ – БРОЙ"; break;
        case "all":  text = "ЗАДЪЛЖЕНИЯ – ВСИЧКИ"; break;
        default:     text = "ЗАДЪЛЖЕНИЯ"; break;
    }

    title.textContent = text;
}


// Add event listeners for real-time filtering
document.getElementById('filterFirm').addEventListener('change', applyFilters);
document.getElementById('filterAgent').addEventListener('change', applyFilters);
document.getElementById('filterEmail').addEventListener('change', applyFilters);
document.getElementById('filterDocType').addEventListener('change', applyFilters);
document.getElementById('filterStatus').addEventListener('change', applyFilters);
document.getElementById('filterDateFrom').addEventListener('change', applyFilters);
document.getElementById('filterDateTo').addEventListener('change', applyFilters);

// ==============================
// DEFAULT MODE: BANK
// ==============================
document.addEventListener("DOMContentLoaded", () => {
    const bankBtn = document.querySelector('.subMode[data-sub="bank"]');
    if (bankBtn) bankBtn.click();
});
</script>

</body>
</html>
