<!DOCTYPE html>
<html lang="bg">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>КАСА — РАЗХОДИ И ПЕЧАЛБА</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <style>
        body { background:#f3f6fa; font-family:Inter,Arial }

.table-modern {
    border-collapse: separate;
    border-spacing: 0 6px;
}

.table-modern thead th {
    background: #0d6efd;
    color: #fff;
    border: none !important;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.table-modern tbody tr {
    background: #ffffff;
    box-shadow: 0 3px 12px rgba(0,0,0,0.05);
    border-radius: 10px;
}

.table-modern tbody tr td:first-child {
    border-top-left-radius: 10px;
    border-bottom-left-radius: 10px;
}
.table-modern tbody tr td:last-child {
    border-top-right-radius: 10px;
    border-bottom-right-radius: 10px;
}

.amount-negative { color:#d9534f; font-weight:600; }

.table-modern tbody tr:hover {
    background:#eef3ff;
    transform:scale(1.012);
    transition:.15s;
}

.filter-input { border-radius:6px; border:1px solid #ccd3e0; font-size:13px; }
.filter-input:focus {
    border-color:#0d6efd;
    box-shadow:0 0 0 1px rgba(13,110,253,.4);
}
.is-invalid {
    border-color: #dc3545 !important;
    box-shadow: 0 0 3px rgba(220,53,69,0.6);
}
.modern-sidebar {
    position:fixed;
    top:0; left:0;
    width:240px; height:100vh;
    background:linear-gradient(180deg,#0d6efd 0%,#2563eb 100%);
    color:white;
    display:flex;
    flex-direction:column;
    justify-content:space-between;
    padding:20px 0;
    box-shadow:3px 0 15px rgba(0,0,0,.1);
}

.nav-item {
    display:flex; align-items:center;
    gap:10px; padding:10px 20px;
    color:rgba(255,255,255,0.9);
    text-decoration:none;
    border-left:4px solid transparent;
    transition:.3s;
}
.nav-item:hover { background:rgba(255,255,255,.1); transform:translateX(5px); color:white; }
.nav-item.active { background:rgba(255,255,255,.2); border-left-color:white; color:white; }
.nav-item.logout { color:#ffcccc; }

.main-content { margin-left:240px; padding:2rem; }
    </style>
</head>
<body>

<!-- SIDEBAR -->
<aside class="modern-sidebar">

    <div class="sidebar-top">
        <div class="sidebar-logo text-center mb-4 fw-bold">
            <i class="fa-solid fa-chart-pie"></i> Табло
        </div>

        <nav class="sidebar-nav">
         <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
            <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
          </a>
        
          <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
            <i class="fa-solid fa-list-check"></i><span>Задачи</span>
          </a>
        
          <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
            <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-building"></i><span>Активни</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-ban"></i><span>Неактивни</span>
          </a>
            <a href="/clients" class="nav-item"><i class="fa-solid fa-users"></i>Профили</a>
            <a href="/clients/create" class="nav-item"><i class="fa-solid fa-user-plus"></i>Нов профил</a>
            <a href="/calendar" class="nav-item"><i class="fa-solid fa-calendar-days"></i>Календар</a>
            <a href="/dashboard/cashflow" class="nav-item"><i class="fa-solid fa-money-bill-transfer"></i>Разходи</a>
            <a href="/dashboard/debtors" class="nav-item"><i class="fa-solid fa-user-clock"></i>Длъжници</a>
            <a href="/refillstock" class="nav-item"><i class="fa-solid fa-boxes-packing"></i>Дозареждане на стока</a>
            <a href="/analytics" class="nav-item active"><i class="fa-solid fa-chart-line"></i>Аналитика</a>
        </nav>
    </div>

    <div class="sidebar-bottom">
        <a href="#" class="nav-item logout"><i class="fa-solid fa-right-from-bracket"></i>Изход</a>
    </div>

</aside>

<!-- MAIN CONTENT -->
<div class="main-content">

<div class="container py-4">

    <h2 class="fw-bold mb-4"><i class="fa-solid fa-coins"></i>РАЗХОДИ И ПЕЧАЛБА</h2>

    <!-- ФИЛТРИ -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">

            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">От дата</label>
                    <input  onkeydown="return false;" type="date" id="from" class="form-control">
                </div>

                <div class="col-md-3">
                    <label class="form-label">До дата</label>
                    <input  onkeydown="return false;" type="date" id="to" class="form-control">
                </div>

                <div class="col-md-3">
                    <label class="form-label">Заплати (общо)</label>
                    <input type="number" id="salary" class="form-control" value="0" required>
                </div>

                <div class="col-md-3 d-flex align-items-end">
                    <button class="btn btn-primary w-100" onclick="loadData()">Зареди</button>
                </div>
            </div>

        </div>
    </div>

    <!-- ТАБЛИЦА -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">

            <!-- Филтри по колони -->
            <div class="row mb-2">
                <div class="col"><input class="filter-input" placeholder="Филтър дата" data-col="0"></div>
                <div class="col"><input class="filter-input" placeholder="Филтър номер" data-col="1"></div>
                <div class="col"><input class="filter-input" placeholder="Филтър код" data-col="2"></div>
                <div class="col"><input class="filter-input" placeholder="Филтър описание" data-col="3"></div>
                <div class="col"><input class="filter-input" placeholder="Филтър сума" data-col="4"></div>
                <div class="col"><input class="filter-input" placeholder="Филтър каса" data-col="5"></div>
            </div>

            <table class="table table-modern" id="cashTable">
                <thead>
                <tr>
                    <th>От дата</th>
                    <th>Номер</th>
                    <th>Код</th>
                    <th>Описание</th>
                    <th class="text-end">лв.</th>
                    <th>ПРЕЗ КАСА</th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>

        </div>
    </div>

    <!-- Тотали -->
    <div class="card shadow-sm">
        <div class="card-body" id="totalsBox"></div>
    </div>

</div>

</div>


<script>
// === Зареждане ===
function loadData() {

    const salaryInput = document.getElementById("salary");
    const salary = salaryInput.value.trim();

    // 🔥 Силна задължителна проверка
    if (salary === "" || isNaN(salary) || Number(salary) <= 0) {
        salaryInput.classList.add("is-invalid");
        alert("Моля въведете валидна сума за заплати (по-голяма от 0)!");
        salaryInput.focus();
        return;
    } else {
        salaryInput.classList.remove("is-invalid");
    }

    const from = document.getElementById("from").value;
    const to   = document.getElementById("to").value;

    fetch(`/dashboard/cashflow/load?from=${from}&to=${to}&salary=${salary}`)
        .then(r => r.json())
        .then(d => renderData(d));
}

// === Рендер ===
function renderData(d) {

    const tbody = document.querySelector("#cashTable tbody");
    tbody.innerHTML = "";

    d.items.forEach(row => {

        // 🚫 НЕ ПОКАЗВАМЕ РЕДОВЕ ЗА ЗАПЛАТИ
        const desc = (row["Описание"] ?? "").toLowerCase();
        if (desc.includes("заплат")) return;

        tbody.innerHTML += `
        <tr>
            <td>${row["От дата"]}</td>
            <td>${row["Номер"]}</td>
            <td>${row["Код"]}</td>
            <td>${row["Описание"]}</td>
            <td class="text-end amount-negative">${row["лв."] ?? ""}</td>
            <td>${row["През"] ?? ""}</td>
        </tr>`;
    });

    // === Totals ===
    let profitColor = d.totals.profit >= 0 ? "green" : "red";

    document.getElementById("totalsBox").innerHTML = `
        <h5 class="fw-bold mb-3">Обобщение — ${d.period_label}</h5>

        <p><b>Общо разходи:</b> ${d.totals.total_expenses.toFixed(2)} лв.</p>
        <p><b>Заплати:</b> ${d.totals.salary.toFixed(2)} лв.</p>
        <p><b>Приходи:</b> ${d.totals.income_sum.toFixed(2)} лв.</p>

        <p class="mt-3 fs-4" style="color:${profitColor}">
            <b>ПЕЧАЛБА:</b> ${d.totals.profit.toFixed(2)} лв.
        </p>
    `;
}


// === Филтри по колони ===
document.querySelectorAll(".filter-input").forEach(input => {
    input.addEventListener("input", function() {
        const col = this.dataset.col;
        const val = this.value.toLowerCase();
        const rows = document.querySelectorAll("#cashTable tbody tr");

        rows.forEach(r => {
            const cell = r.children[col].innerText.toLowerCase();
            r.style.display = cell.includes(val) ? "" : "none";
        });
    });
});
</script>

</body>
</html>


