<!DOCTYPE html>
<html lang="bg">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= esc($title ?? 'Дозареждане на стока') ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<style>
:root{--sidebar-width:240px;--gradient:linear-gradient(180deg,#0d6efd 0%,#2563eb 100%);}
body{background:#f8f9fc;font-family:'Inter','Segoe UI',sans-serif;}
.modern-sidebar{position:fixed;top:0;left:0;width:var(--sidebar-width);height:100vh;background:var(--gradient);color:#fff;display:flex;flex-direction:column;justify-content:space-between;box-shadow:3px 0 15px rgba(0,0,0,.1);z-index:1050}
.sidebar-top{padding-top:20px}
.sidebar-logo{display:flex;align-items:center;justify-content:center;gap:8px;font-weight:600;font-size:1.15rem}
.sidebar-nav{margin-top:1rem;display:flex;flex-direction:column}
.nav-item{display:flex;align-items:center;gap:10px;color:rgba(255,255,255,.9);padding:10px 20px;text-decoration:none;border-left:4px solid transparent;transition:.3s;font-weight:500}
.nav-item:hover{background:rgba(255,255,255,.1);color:#fff;transform:translateX(5px)}
.nav-item.active{background:rgba(255,255,255,.2);border-left:4px solid #fff;color:#fff}
.sidebar-bottom{border-top:1px solid rgba(255,255,255,.2);padding:10px 0;text-align:center}
.nav-item.logout{color:#ffdede}
.main-content{margin-left:var(--sidebar-width);padding:2rem;min-height:100vh;background:#f3f6fb}
.table thead{background:#f0f4ff;color:#0d6efd;font-weight:600}
.table tbody tr:hover{background:#eef5ff;transition:.2s}
/* DataTables стрелки */
table.dataTable thead .sorting:after,
table.dataTable thead .sorting_asc:after,
table.dataTable thead .sorting_desc:after{font-family:"Font Awesome 6 Free";font-weight:900;margin-left:.5rem}
table.dataTable thead .sorting:after{content:"\f0dc";color:#bbb}
table.dataTable thead .sorting_asc:after{content:"\f062";color:#dc3545}
table.dataTable thead .sorting_desc:after{content:"\f063";color:#198754}
.row-highlight > td {
    background-color: #e6f3ff !important;
}
@media (max-width:991px){.modern-sidebar{left:-240px;transition:left .3s}.modern-sidebar.show{left:0}.main-content{margin-left:0}}
</style>
</head>
<body>

<aside class="modern-sidebar">
  <div class="sidebar-top">
    <div class="sidebar-logo"><i class="fa-solid fa-chart-pie"></i><span>Табло</span></div>
    <nav class="sidebar-nav">
         <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
            <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
          </a>
        
          <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
            <i class="fa-solid fa-list-check"></i><span>Задачи</span>
          </a>
        
          <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
            <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-building"></i><span>Активни</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-ban"></i><span>Неактивни</span>
          </a>
        <a href="/clients" class="nav-item"><i class="fa-solid fa-users"></i><span>Профили</span></a>
        <a href="/clients/create" class="nav-item"><i class="fa-solid fa-user-plus"></i><span>Нов профил</span></a>
        <a href="/calendar" class="nav-item"><i class="fa-solid fa-calendar-days"></i><span>Календар</span></a>
        <a href="/dashboard/cashflow" class="nav-item">
            <i class="fa-solid fa-money-bill-transfer"></i><span>Разходи</span>
        </a>
        
        
        <a href="/dashboard/debtors" class="nav-item">
            <i class="fa-solid fa-user-clock"></i><span>Длъжници</span>
        </a>
        
        
        <a href="/refillstock" class="nav-item  active">
            <i class="fa-solid fa-boxes-packing"></i><span>Дозареждане на стока</span>
        </a>
        
        <a href="/analytics" class="nav-item"><i class="fa-solid fa-chart-line"></i>Аналитика</a>
    </nav>
  </div>
  <div class="sidebar-bottom">
    <a href="#" class="nav-item logout"><i class="fa-solid fa-right-from-bracket"></i>Изход</a>
  </div>
</aside>

<div class="main-content">

    <!-- === Заглавие и експорт === -->
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold text-primary mb-0"><i class="fa-solid fa-truck-loading me-2"></i>Дозареждане на стока</h4>
        <button id="btn-export" class="btn btn-success btn-sm">
            <i class="fa-solid fa-file-excel me-1"></i>Експорт в Excel
        </button>
    </div>

    <!-- === ЛЕГЕНДА + АВТО ИЗЧИСЛЕНИЕ === -->
    <div class="alert alert-info py-2 mb-3">
        <strong>Легенда:</strong>  
        <span class="px-2 py-1" style="background:#e6f3ff;border:1px solid #bcd9f1;">&nbsp;</span>  
        – Продукти с зададено количество за доставка (qty > 0)
    </div>

    <button id="auto-calc" class="btn btn-primary mb-3">
        ⚙ Автоматично изчисли количества
    </button>

    <!-- === Филтри === -->
    <div class="row g-3 mb-4">
        <div class="col-md-3"><select id="filter-group" class="form-select"><option value="">Всички групи</option></select></div>
        <div class="col-md-3"><select id="filter-product" class="form-select"><option value="">Всички стоки</option></select></div>
        <div class="col-md-3"><select id="filter-warehouse" class="form-select"><option value="">Всички складове</option></select></div>
        <div class="col-md-2">
            <select id="filter-months" class="form-select">
                <option value="1">1 месец</option>
                <option value="3">3 месеца</option>
                <option value="6" selected>6 месеца</option>
                <option value="12">12 месеца</option>
            </select>
        </div>
        <div class="col-md-1"><button id="btn-search" class="btn btn-primary w-100"><i class="fa fa-search"></i></button></div>
    </div>

    <!-- === Таблица === -->
    <div class="table-responsive">
        <table id="refillTable" class="table table-hover align-middle">
            <thead></thead>
            <tbody></tbody>
        </table>
    </div>
</div>

<script>
$(function(){

    let table;
    let lastLoadedItems = [];

    /* ---------------------
        ДИНАМИЧНИ ЗАГЛАВИЯ
    ----------------------*/
    function buildHeader(warehouses){
        let thead = `
            <tr>
                <th>Група</th>
                <th>Стока</th>
                <th>Цена</th>
                <th>Продадени</th>
                <th>Налични</th>
        `;
        warehouses.forEach(w => {
            thead += `<th>${w} Продадени</th><th>${w} Наличност</th>`;
        });
        thead += `<th>Количество за доставка</th></tr>`;
        $("#refillTable thead").html(thead);
    }

    /* ---------------------
        ДИНАМИЧНО ТЯЛО
    ----------------------*/
    function buildBody(items, warehouses){
        lastLoadedItems = items; // запазваме за автоизчисление

        const tbody = items.map(r => {
            let row = `
                <tr>
                    <td>${r['Група']}</td>
                    <td>${r['Стока']}</td>
                    <td>${Number(r['Цена без ДДС']).toFixed(2)} лв.</td>
                    <td>${r['Продадени']}</td>
                    <td>${r['Налични']}</td>
            `;

            warehouses.forEach(w=>{
                const ww = r.warehouses?.[w] ?? {sold:0,stock:0};
                row += `<td>${ww.sold}</td><td>${ww.stock}</td>`;
            });

            row += `<td class="qty-cell" contenteditable="true">${r['Количество за доставка']}</td></tr>`;
            return row;
        }).join('');

        $("#refillTable tbody").html(tbody);

        refreshRowHighlighting();
    }

    /* -------------------------------------
       ОЦВЕТЯВАНЕ НА РЕДОВЕ С qty > 0
    --------------------------------------*/
    function refreshRowHighlighting(){
        $("#refillTable tbody tr").each(function () {
            let qty = parseInt($(this).find(".qty-cell").text()) || 0;
            if (qty > 0) $(this).addClass("row-highlight");
            else $(this).removeClass("row-highlight");
        });
    }

    /* -------------------------------------
       ПРИ ПРОМЯНА НА qty — ОЦВЕТЯВАЙ
    --------------------------------------*/
    $(document).on("input", ".qty-cell", function(){
        refreshRowHighlighting();
    });

    /* ---------------------
        ЗАРЕЖДАНЕ ДАННИ
    ----------------------*/
function loadRefill(){
    const params = {
        group: $("#filter-group").val(),
        product: $("#filter-product").val(),
        warehouse: $("#filter-warehouse").val(),
        months: $("#filter-months").val(),
    };

    $.getJSON("/refillstock/data", params, function(res){

        const items = res.items ?? [];
        const warehouses = res.warehouses ?? [];
        const opts = res.options ?? {};

        // ---------------------------
        // 🔵 ПОПЪЛВАНЕ НА ФИЛТРИ !!
        // ---------------------------

        // Групи
        let g = `<option value="">Всички групи</option>`;
        (opts.groups ?? []).forEach(x => {
            let sel = (x === params.group) ? "selected" : "";
            g += `<option ${sel}>${x}</option>`;
        });
        $("#filter-group").html(g);

        // Стоки
        let p = `<option value="">Всички стоки</option>`;
        (opts.products ?? []).forEach(x => {
            let sel = (x === params.product) ? "selected" : "";
            p += `<option ${sel}>${x}</option>`;
        });
        $("#filter-product").html(p);

        // Складове
        let w = `<option value="">Всички складове</option>`;
        (opts.warehouses ?? []).forEach(x => {
            let sel = (x === params.warehouse) ? "selected" : "";
            w += `<option ${sel}>${x}</option>`;
        });
        $("#filter-warehouse").html(w);

        // ---------------------------
        // Таблица
        // ---------------------------
        buildHeader(warehouses);
        buildBody(items, warehouses);

        if (table) table.destroy();

        table = $("#refillTable").DataTable({
            pageLength: 25,
            language:{ url:'//cdn.datatables.net/plug-ins/1.13.4/i18n/bg.json' },

            rowCallback: function(row, data) {
                let qty = parseInt($(row).find(".qty-cell").text()) || 0;
                if (qty > 0) $(row).addClass("row-highlight");
            }
        });

    });
}


    $("#btn-search").on("click", loadRefill);

    /* -------------------------------------
       🔵 БУТОН: Автоматично изчисли количества
    --------------------------------------*/
    $("#auto-calc").on("click", function () {

        $("#refillTable tbody tr").each(function(i){
            let sold = lastLoadedItems[i]['Продадени'];
            let stock = lastLoadedItems[i]['Налични'];
            let months = parseInt($("#filter-months").val());

            let avg = sold / months;
            let qty = Math.max(0, Math.round(avg - stock));

            $(this).find(".qty-cell").text(qty);
        });

        refreshRowHighlighting();
    });

    /* ------------------------------
        🟩 ЕКСПОРТ — само qty > 0
    -------------------------------*/
    $("#btn-export").on("click", function () {

        let exportData = [];

        $("#refillTable tbody tr").each(function(){
            let tds = $(this).find("td");
            let qty = parseInt(tds.last().text()) || 0;

            if (qty > 0) {
                exportData.push({
                    group: tds.eq(0).text().trim(),
                    product: tds.eq(1).text().trim(),
                    price: parseFloat(tds.eq(2).text()) || 0,
                    sold: parseInt(tds.eq(3).text()) || 0,
                    stock: parseInt(tds.eq(4).text()) || 0,
                    qty: qty
                });
            }
        });

        fetch("/refillstock/export", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(exportData)
        })
        .then(r => r.blob())
        .then(blob => {
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement("a");
            a.href = url;
            a.download = "dozarejdane_na_stoka.xlsx";
            a.click();
        });
    });

    /* --- ПРВО ЗАРЕЖДАНЕ ---*/
    loadRefill();

});
</script>

</body>
</html>

