<!-- dir[Views/common] прикачени файлове в модул -->

<div id="accordion" class="mt-3">
    <div class="card">
        <div class="card-header p-1" id="headingOne">
            <h5 class="mb-0">
                <button id="docExpand" class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                    <i class="fa fa-plus"></i> Прикачени файлове <span id="totalFiles"><?= !empty($get_documents['docs']) ? count($get_documents['docs']) . ' бр' : '' ?></span>
                </button>
            </h5>
        </div>

        <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion" style="">
            <div class="card-body">
                <form id="imageUpload">

                    <button type="button" class="fileup-btn btn btn-success">Избор на файлове
                        <input type="file" name="images[]" id="multiple_files" multiple="multiple" />
                    </button>

                    <a class="control-button btn btn-link" style="display: none"
                       href="javascript:$.fileup('multiple_files', 'upload', '*')">Качване на всички</a>
                    <a class="control-button btn btn-link" style="display: none"
                       href="javascript:$.fileup('multiple_files', 'remove', '*')">Премахване на всички</a>

                    <div id="upload-2-queue" class="queue d-flex"></div>
                </form>

                <table id="tbl_images" class="table table-striped table-bordered mt-1 table-sm" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th class="w-2"></th>
                            <th class="imgAction w-5"></th>
                            <th class="imgName">Име на прикаченият файл</th>
                            <th class="file w-5"></th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                        $_tab      = $get_documents['tab'];
                        $_orderTip = $get_documents['orderTip'] ?? '';
                        $_orderId  = $get_documents['orderId'];

                        if (!empty($get_documents['docs'])) {
                            foreach ($get_documents['docs'] as $doc) {
                                $pathinfo = pathinfo($doc);

                                $docPatch = $_ENV['app.imageDataDir'] . 'documents/' . $_tab . '/' . $_orderTip . '/' . $_orderId . '/' . $pathinfo['filename'] . '.' . $pathinfo['extension'];
                                ?> 

                                <tr> 
                                    <td class="align-middle text-center"></td>

                                    <td class="align-middle">
                                        <span class="btn-outline-danger p-1 border-0 fa fa-trash" title="Изтрий"></span>

                                        <a class="btn-outline-success p-1 border-0 fa fa-download" href="<?php echo $docPatch ?>" title="Свали" download target="_blank"> 
                                        </a>
                                    </td>

                                    <td class="imgName align-middle"> <?php echo $pathinfo['filename'] . '.' . $pathinfo['extension'] ?></td>

                                    <td class="align-middle text-center">
                                        <?php if (in_array($pathinfo['extension'], ["jpg", "png", "gif", "png", "tiff"])) { ?>
                                            <img class="zoomImg w-100" src="<?php echo $docPatch ?>" alt="">
                                            <?php
                                        } else {
                                            echo '<img src="' . base_url() . "assets/plugins/ssi_uploaderImage/imgIcons/img/" . $pathinfo['extension'] . '.gif' . '" alt="" >';
                                        }
                                        ?>
                                    </td>
                                </tr> 
                                <?php
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function ( ) {
        //плъгин качване на смимка
        const searchParams = new URLSearchParams(window.location.search);
        var dokNo = $(document).find('input#dokNo:hidden').val();
        var urlSegment = $(location).attr('href').split("/")[3];
        var tab = '<?= $_tab ?>';
        var orderTip = '<?= $_orderTip ?>';
        var orderId = '<?= $_orderId ?>';
        var totalFiles = 0;
//        searchParams.set('tab',<? //if (url_is('*Order*')) {echo '123'; }                                                         ?>//);

        $('#docExpand').click(function () {
            $(this).find('i').toggleClass('fa fa-plus fa fa-minus');
        });

        //  Бутон  delete на снимка
        // ============================
        $('table#tbl_images').off('click').on('click', '.fa-trash', function () {

            var imageName = $(this).closest('tr').find('td.imgName').text().trim();
            var tr = $(this).closest('tr');


            if (!confirm("Сигурнили сте, че искате да изтриете файла - " + imageName)) {
                return false;
            }

            $.ajax({
                url: '<?= route_to('BaseController-delete_documents_inModul') ?>',
                type: 'POST',
                data: {'tab': tab, 'orderTip': orderTip, 'orderId': orderId, 'imageName': imageName},
                dataType: 'json',
                success: function (response)
                {
                    tr.remove();
                    $('#totalFiles').text($('#tbl_images tbody tr').length);
                    alert('Файлът е изтрит');

                }
            });
        });

        $.fileup({
            url: '<?= route_to('BaseController-documents_inModul') ?>',
            inputID: 'multiple_files',
            queueID: 'upload-2-queue',
            fieldName: 'images[]',
            extraFields: {'tab': tab, 'orderTip': orderTip, 'orderId': orderId},
            lang: 'bg',
            onSelect: function (file) {
                $('.control-button').show();
            },
            onRemove: function (file, total) {
                if (file === '*' || total === 1) {
                    $('.control-button').hide();
                }
            },

            onSuccess: function (response, file_number, file) {
                var options = this.fileup.options;
                var childrenFiles = $('#upload-2-queue').children();

                $('#fileup-' + options.inputID + '-' + file_number).remove();

                if (childrenFiles.length - 1 === 0) {
                    $("#tbl_images").load(window.location.href + ' #tbl_images>*', function (response, status, xhr) {
                        $('#totalFiles').text($('#tbl_images tbody tr').length);
                    });
                }
            },

            onError: function (event, file, file_number) {
                var options = this.fileup.options;

                switch (event) {
                    case 'files_limit':
                        var message = i18n[options.lang].errorFilesLimit;
                        message = message.replace(/%filesLimit%/g, options.filesLimit);
                        alert(message);
                        break;
                    case 'size_limit':
                        var size = formatHuman(options.sizeLimit);
                        var message = i18n[options.lang].errorSizeLimit;
                        message = message.replace(/%sizeLimit%/g, size);
                        message = message.replace(/%fileName%/g, file.name);
                        alert(message);
                        break;
                    case 'file_type':
                        var message = i18n[options.lang].errorFileType;
                        message = message.replace(/%fileName%/g, file.name);
                        alert(message);
                        break;
                    case 'bad_status':
                    case 'error_load':
                        var $file = $('#file-' + options.inputID + '-' + file_number);
                        $file.find('.controls .abort').hide();
                        $file.find('.controls .upload').show();
                        $file.find('.result')
                                .addClass('error')
                                .text(i18n[options.lang].error);
                        break;
                    case 'old_browser':
                        var message = i18n[options.lang].errorOldBrowser;
                        alert(message);
                        break;
                }
            }, });

    });
</script>
