<?php
$_isProdChar = ($arg === 'prodCharValues');
$actions     = $actions ?? [];
?>

<div id="listbox" class="position-relative border-1">
    <?= "<div class='text-center bg-primary fw-bold'>$blockTitle</div>" ?>

    <?php
    if ($customConfig -> popup_product_edit['modelToBrand'] && $arg == 'model' && empty($brandId)) {
        echo '<label class="w-100 text-center text-danger fw-bold">Изберете марка преди това.</label>';
        return false;
    }
    ?>

    <div class="d-flex my-1 w-100">
        <input id="search-local" 
        <?php if ($arg === 'prodCharValues'): ?>
                   name="searchText"
                   data-hx-get="<?= route_to('Dropdown-renderView', 'prodCharValues') ?>"
                   data-hx-target="#listbox ul" 
                   data-hx-trigger="input delay:1000ms"
                   data-hx-select="ul>*"     
               <?php endif ?>
               type="text" 
               placeholder="филтър" 
               value="<?= $searchText ?? '' ?>">  

        <i id="insert-item" class="btn-outline-primary font-size-13 p-1 fa fa-save" data-route="<?= route_to('Dropdown-new', $arg) ?>"></i>
    </div>

    <ul>
        <?php
        if (empty($items) || ($_isProdChar && $searchText == null)) {
            echo '<li id="noResult"><label class="w-100 text-center text-danger fw-bold">Няма намерени резултати</label></li></ul>';

            return false;
        }
        ?>

        <li class="row" data-empty="1"
        <?php if ($arg == 'prodCharValues'): ?>
                data-route="<?= route_to('Dropdown-removeProductAttr') ?>" 
            <?php endif ?>>

            <label class="col text-center text-secondary">---</label>
        </li>

        <?php
        foreach ($items ?? [] as $row):

            $urlParams = http_build_query([
                'column'    => $arg,
                'tip'       => $arg,
                'primaryId' => $row['primaryId'] ?? '',
                    //'oldModelValue' => addslashes($row['model'] ?? '')
            ]);
            ?>

            <li class="row" data-id="<?= $row['primaryId'] ?>"  
            <?php if ($arg == 'prodCharValues' && !empty($row['primaryId'])): ?>
                    data-route="<?= route_to('Dropdown-setProductAttrText', $row['primaryId']) ?>" 
                <?php endif ?>
                data-image-path="<?= $row['else']['image_brand'] ?? $row['else']['image_model'] ?? '' ?>">

                <label class="col m-0"><?= $row['text'] ?></label>

                <div class="button-group ml-auto">
                    <?php if (in_array('edit', $actions)): ?>
                        <i data-route="<?= route_to('Dropdown-edit', $urlParams) ?>" class="dropdown-edit btn-outline-primary font-size-13 px-1 fa fa-edit"></i>
                    <?php endif ?>

                    <?php if (in_array('delete', $actions)): ?>
                        
                        <i class="dropdown-delete btn-outline-danger font-size-13 px-1 fa fa-trash" data-route="<?= route_to('Dropdown-delete', $urlParams) ?>"></i>
                    <?php endif; ?>

                </div>
            </li>
        <?php endforeach; ?>
    </ul>
</div>
