<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
<style> 
    .app-tile-wrap.hidden-item {
        opacity: 0.2;  /* избледняване */
    }

    .controls {
        position: absolute;top:0; right: 8px;
        display: none; gap: 6px;
    }

</style>

<div class="col-12 py-5">
    <?php if (!empty($isAdmin)): ?>
        <div style="position:fixed; right:16px; top:86px; z-index:9;">
            <button id="nav-edit-toggle" class="btn btn-sm btn-primary" type="button">Редакция</button>
            <button id="nav-save"  class="btn btn-sm btn-success" data-route="<?= route_to('Home_nav-save') ?>" type="button" style="display:none;">Запази</button>
            <button id="nav-reset" class="btn btn-sm btn-outline-danger" data-route="<?= route_to('Home_nav-reset') ?>" type="button" style="display:none;">Нулирай</button>
        </div>
    <?php endif; ?>

    <div class="apps-viewport"
         style="--bg-url: url('<?= $_ENV['app.imageDataDir'] . 'logos/rvb-logo.png' ?>');">
        <div class="container-fluid px-0 d-flex flex-column justify-content-center align-items-center">
            <div class="row justify-content-center mb-4">
                <div class="col-12 col-lg-10 col-xl-8 text-center apps-header">
                    <h1>Навигация • ERP / CRM</h1>
                    <p>Бързи инструменти и модули за администрация — като в Applications на macOS, но за вашата система. 🚀</p>
                </div>
            </div>

            <div id="renderHtml" class="w-100">
                <?php
                if (!empty($nav)):
                    $globalIndex = 0;

                    // Сортираме секциите по position
                    usort($nav, function ($a, $b) {
                        return $a['position'] <=> $b['position'];
                    });

                    foreach ($nav as $section):
                        if (empty($section['visible'])) {
                            continue;
                        }

                        if (in_array($section['key'], ['list', 'settings']) && !($acl -> isAdmin == 'admin' || $acl -> is_allowed($userGroupId, 'menu', 'root.setings', 'isActive'))) {
                            continue;
                        }
                        ?>
                        <div class="apps-section" data-key="<?= $section['key'] ?>">
                            <h2 class="apps-section-title text-center"><?= $section['title'] ?></h2>

                            <div class="nav-container row no-gutters justify-content-center w-100 app-grid" data-key="<?= $section['key'] ?>" data-title="<?= $section['title'] ?>">
                                <?php if (!empty($section['items'])): ?>
                                    <?php
                                    usort($section['items'], function ($a, $b) {
                                        $posA = $a['position'] ?? 0;
                                        $posB = $b['position'] ?? 0;
                                        return $posA <=> $posB;
                                    });

                                    foreach ($section['items'] as $item):
                                        $g         = 'g' . (($globalIndex++ % 8) + 1);
                                        $isVisible = !empty($item['visible']);
                                        $attrs     = '';

                                        if (!empty($item['attrs'])) {
                                            foreach ($item['attrs'] as $attrName => $attrValue) {
                                                $attrs .= "$attrName='$attrValue'";
                                            }
                                        }
                                        ?> 

                                        <div class="app-tile-wrap col-6 col-sm-4 col-md-3 col-lg-2 col-xl-1 mb-4 px-2 text-center <?= $isVisible ? '' : 'd-none' ?>"  
                                             data-visible="<?= $isVisible ? '1' : '0' ?>"
                                             data-title="<?= $item['label'] ?? '' ?>"
                                             data-icon="<?= $item['icon'] ?? '' ?>">

                                            <a class="app-tile" <?= $attrs ?? '' ?>>
                                                <div class="icon-box <?= $g ?>">
                                                    <i class="icon-fa fa-2x mb-2 <?= $item['icon'] ?? 'fa fa-square' ?>"></i>
                                                    <div class="controls text-white">
                                                        <i class="toggle-visibility btn-sm py-0 px-1  fa <?= $isVisible ? 'fa-eye-slash' : 'fa-eye' ?>"></i>
                                                        <i class="btn-sm py-0 px-1 fa fa-trash remove"></i>
                                                    </div>
                                                </div>
                                            </a>

                                            <div class="nav-item-label"><?= $item['label'] ?? '' ?></div>
                                        </div>
                                    <?php endforeach ?>
                                <?php endif ?>

                                <!-- ➕ бутон за добавяне -->
                                <?php if (!empty($isAdmin)): ?>
                                    <div class="col-6 col-sm-4 col-md-3 col-lg-2 col-xl-1 mb-4 px-2 text-center add-item-tile" style="display:none;">
                                        <a class="app-tile" href="javascript:;" data-add-tile="1" style="pointer-events:auto;">
                                            <div class="icon-box"
                                                 style="background:transparent; border:1px dashed rgba(0,0,0,.25); box-shadow:none;">
                                                <i class="icon-fa fa fa-plus" aria-hidden="true" style="color:#4b5563;"></i>
                                            </div>

                                            <div class="app-label" style="color:#4b5563;">Добави линк</div>
                                        </a>
                                    </div>
                                <?php endif ?>
                            </div>
                        </div>
                    <?php endforeach ?>
                <?php endif ?>
            </div>
        </div>

        <!-- Модал за добавяне на линк -->
        <div id="linkModal" class="modal fade"  tabindex="-1"  data-backdrop="static" data-keyboard="false" role="dialog" >
            <div class="modal-dialog modal-dialog-centered w-30" role="document">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title" id="linkModalLabel">Добави линк</h5>
                        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <div class="form-group"><label>Име на линка</label><input type="text" id="link-title" class="form-control" placeholder="Пример: Поръчки"></div>
                        <div class="form-group"><label>URL (href)</label><input type="text" id="link-url" class="form-control" placeholder="/some/path"></div>
                        <div class="form-group"><label>FA клас</label><input type="text" id="link-icon" class="form-control" placeholder="fa fa-square"></div>

                        <!-- ➕ под формата в модала -->
                        <div id="restore-container" class="mb-3" >
                            <label><strong>Скрити елементи (може да ги възстановите като ги изберете)</strong></label>
                            <div id="hidden-list" class="list-group small"></div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Отказ</button>
                        <button type="button" class="btn btn-success" id="popup-save">Добави</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

