<?php
//$oneMonthInSeconds = 30 * 24 * 60 * 60; // 1 month in seconds (30 days)
//// Set the Expires header to one month from now
//header("Expires: " . gmdate("D, d M Y H:i:s", time() + $oneMonthInSeconds) . " GMT");
//// Set the Cache-Control header to cache the response for one month
//header("Cache-Control: max-age=$oneMonthInSeconds, must-revalidate");
//$url_segment0 = \CodeIgniter\Config\Services::request() -> uri -> getSegment(1);
//$url_segment  = \CodeIgniter\Config\Services::request() -> uri -> getSegment(2);
// потребителски права до форми
$_userPreferences = array_column($userPreferences, null, 'modul_name');
$request          = \Config\Services::request();

if (!function_exists('groupAccess')) {

    function groupAccess($acl, $userGroupId, string $type, string $action): bool {
        if ($type === 'forms') {
            $tabs      = ['Zenova', 'Promo', 'Special', 'BiznesKlient', 'Order', 'Baner'];
            $activeTab = '';

            foreach ($tabs as $tab) {
                if (url_is("*$tab*")) {
                    $activeTab = lcfirst($tab);
                    break;
                }
            }

            if ($activeTab === '') {
                return false; // таб не е разпознат
            }

            $formKey = "$activeTab.deny_btnsInHeader";
        } elseif ($type === 'modules') {
            $activeTab = $_GET['tab'] ?? '';
            if ($activeTab === '') {
                return false; // липсва tab
            }

            $formKey = "mainPage.$activeTab";
        } else {
            return false; // непознат тип
        }

        return $acl -> isAdmin === 'admin' || $acl -> is_allowed($userGroupId, $type, $formKey, $action);
    }

}
?>
<!DOCTYPE html>
<html lang="bg">
    <head>
        <?= view('layouts/VIEW__head', $data ?? []); ?>
    </head>

    <body class="<?= url_is('*MainPage') || url_is('*raznos') || url_is('*site') || url_is('*Provider_mainPage') ? 'css-bacground' : '' ?> hold-transition sidebar-mini layout-fixed layout-footer-fixed" style="min-height:auto;">

        <header class="fixed-top">
            <?php if (empty($headerMenuHide)): ?>
                <?= view('layouts/VIEW__header_menu', $data ?? []); ?>
            <?php endif ?>
        </header>

        <aside id="sidebar-root">
            <?= view('layouts/sidebar/VIEW__sidebar-left'); ?>
        </aside>

        <main class="wrapper">
            <?= view($content, $data ?? []) ?> 
            <div class="control-sidebar-bg"></div>
        </main>

        <footer>
            <?= view('layouts/VIEW__footer', $data ?? []); ?>
            <script src="/assets/plugins/ckfinder/ckfinder.js"></script>
        </footer>
    </body>
</html>
