<?php
$settings       = service('settings') -> get('App.general') ?? [];
$_activeTab     = $_GET['tab'] ?? '';
$_priceAccuracy = $settings['priceAccuracy'] ?? 2;
$_dds           = ($settings['dds'] / 100) + 1;
$_dds           = isset($settings['dds']) ? ($settings['dds'] / 100) + 1 : 1.2;

$_userPreferences    = array_column($userPreferences ?? [], null, 'modul_name');
$_userPreferencesTip = $_userPreferences[$_activeTab] ?? []; //$_userPreferences['order-' . $_GET['orderTip']] ?? [];
$_moduleKey          = "mainPage.$_activeTab";

$_sort = $_GET['sort_order'] ?? 'DESC';
$_sort = $_sort === 'ASC' ? 'DESC' : 'ASC';
$_icon = array_fill(1, 7, 'unsorted');

$sortColumns = [
    'site_name'   => 1,
    'order_id'    => 2,
    'klient_name' => 3,
    'date_added'  => 4
];

// Set the appropriate icon for the selected sort column, if applicable
if (isset($_GET['sort_col'], $sortColumns[$_GET['sort_col']])) {
    $index         = $sortColumns[$_GET['sort_col']];
    $_icon[$index] = $_sort === 'ASC' ? 'sort-alpha-desc' : 'sort-alpha-asc';
}

$_tabs = [
    'site' => 'ПОРЪЧКИ - ДИЛЪРСКИ ОТ САЙТ',
    'L'    => 'ПОРЪЧКИ - ЛОКАЛНИ',
    'N'    => 'ПОРЪЧКИ - ДИЛЪРСКИ НЕЗАВЪРШЕНИ ОТ САЙТ',
    'K'    => 'ПОРЪЧКИ - КЛИЕНТСКИ ОТ САЙТ',
    'F'    => 'ПОРЪЧКИ - БЪРЗИ ОТ САЙТ',
];
?>

<nav class="col z-index-1">
    <ul class="nav d-flex flex-row justify-content-start align-items-center gap-11 fw-500" role="tablist">
        <?php
        foreach ($_tabs as $key => $label) {
            $_activeClass = ($_GET['orderTip'] == $key) ? 'bg-yellow' : '';

            if ((in_array($key, ['L', 'K', 'F', 'N']) && !$customConfig -> isVisible["tab_{$key}Orders"])) {
                continue;
            }
            $_notificationIcon = '';
            if (!empty($orderElseNotificationsCount)) { // брояч за броя поръчки
                $_count = match ($key) {
                    'site' => $orderElseNotificationsCount['dilarOrder'] ?? 0,
                    'L' => $orderElseNotificationsCount['localOrder'] ?? 0,
                    'K' => $orderElseNotificationsCount['klietOrder'] ?? 0,
                    'F' => $orderElseNotificationsCount['fasttOrder'] ?? 0,
                    'N' => $orderElseNotificationsCount['uncompleteOrder'] ?? 0,
                    default => 0
                };

                if ($_count > 0) {
                    $_notificationIcon = '<span class="countOrderNotification ' . ($key == 'N' ? 'bg-white' : 'bg-danger') . ' ' . 'px-1 rounded-circle">' . $_count . '</span>';
                }
            }

            echo "<li class='nav-item'>
                <a class='{$_activeClass} nav-link round-10' href='" . route_to('tabOrder', "orderTip={$key}") . "'>$_notificationIcon $label</a>
              </li>";
        }
        ?>
    </ul>
</nav>

<div id="currentView" class="visibleCols d-flex justify-content-end" data-view="<?= $_activeTab ?>">
    <div class="p-2 d-flex align-items-center order-0">
        <label class="fw-500"><?= lang('LANG__mainPage.perPage.labelTxt') ?> 

            <?php
            $perPageParams = urldecode(http_build_query([
                'user_preferences_id' => $_userPreferencesTip['user_preferences_id'] ?? '',
                'tab'                 => $_GET['tab']]));

            $urlParams = urldecode(http_build_query([
                'tab'      => $_GET['tab'],
                'orderTip' => $_GET['orderTip']
            ]));
            ?>

            <select id="perPage" class="css-dropdown-p css-focus-strong css-border-none" data-id="<?= $_userPreferencesTip['user_preferences_id'] ?? '' ?>" data-route="<?= route_to('BaseController-userPreferences', $perPageParams) ?>">
                <?php
                $_options  = [10, 2, 25, 50, 100];
                foreach ($_options as $opt) :
                    $selected = ($_userPreferencesTip['per_page'] ?? '') == $opt ? 'selected' : '';
                    ?>
                    <option <?= $selected ?> value="<?= $opt ?>"><?= $opt ?></option>
                <?php endforeach; ?>
            </select> 
            <?= lang('LANG__mainPage.perPage.labelTxt2') ?>
        </label>
    </div>

    <div class="p-2 d-flex align-items-center order-2 gap-11">
        <?php
        $_isGensoftEnableForSite = empty($_ENV['app.gensoftEnable']) && in_array($_GET['orderTip'], ['site', 'L']);

        if (($acl -> isAdmin == 'admin' || $acl -> is_allowed($userGroupId, 'modules', $_moduleKey, 'plus')) && (!in_array($_GET['orderTip'], ['site', 'K', 'F', 'N']) || $_isGensoftEnableForSite)):
            ?>
            <a class="btn btn-secondary round-10" href="<?= route_to('Order-index', $urlParams) ?>" style="background:#007BFF">
                <i class="fa fa-plus"></i>&nbsp;<?= lang('LANG__mainPage.btn-new.or') ?>
            </a>
        <?php endif ?>

        <?php if (($acl -> isAdmin == 'admin' || $acl -> is_allowed($userGroupId, 'modules', $_moduleKey, 'cart-plus')) && in_array($_GET['orderTip'], ['site', 'L'])): ?>
            <button id="unionOrdersByKlient" class="btn btn-secondary round-10" data-route="<?= route_to('MainPage-unionOrders_byIds') ?>" style="background:#007BFF">
                <i class="fa fa-plus"></i>&nbsp;ОБЕДИНЯВАНЕ НА ПОРЪЧКИ
            </button>
        <?php endif ?>
    </div>
</div>

<label class="fw-500">
    Легенда:
    <i class="fa fa-refresh"></i> - връщане на поръчка,
    <i class="fa fa-copy"></i> - клониране на поръчка
    <br>
    За да обедините поръчки (само със статус завършен),
    първо изберете клиент и след това маркирайте поръчките.
</label>

<?php
$_viewParams = [
    '_icon'          => $_icon,
    '_sort'          => $_sort,
    '_priceAccuracy' => $_priceAccuracy,
    '_dds'           => $_dds,
    '_activeTab'     => $_activeTab,
    '_moduleKey'     => $_moduleKey
];

echo match ($_GET['orderTip']) {
    'site' => view($view_order['site'], $_viewParams),
    'L' => view($view_order['L'], $_viewParams),
    'K' => view($view_order['K'], $_viewParams),
    'F' => view($view_order['F'], $_viewParams),
    'N' => view($view_order['N'], $_viewParams),
    default => '',
};
?>

<div id="refreshPagnitation">
    <div id="pagination" class="d-flex col mt-2 justify-content-between fw-500">
        <div>
            <span><?= lang('LANG__mainPage.tbl.footer.total') ?></span> 
            <span class="countResults"><?= $countTotalRecords ?></span>
            <span><?= lang('LANG__mainPage.tbl.footer.records') ?></span>
        </div>
        <ul class="pagination">
            <?= $pagination ?>
        </ul>
    </div> 
</div>
