<?php
$_activeTab          = $_GET['tab'] ?? '';
// Инициализация на потребителски предпочитания
$_userPreferences    = array_column($userPreferences ?? [], null, 'modul_name');
$_userPreferencesTip = $_userPreferences[$_activeTab] ?? [];
$_moduleKey          = "mainPage.$_activeTab";

// Сортиране
$_sort = ($_GET['sort_order'] ?? 'DESC') === 'ASC' ? 'DESC' : 'ASC';
$_icon = array_fill(1, 7, 'unsorted');

$sortColumns = [
    'offersName'  => 1,
    'klient_name' => 2,
    'date_create' => 3
];

// Set the appropriate icon for the selected sort column, if applicable
if (isset($_GET['sort_col'], $sortColumns[$_GET['sort_col']])) {
    $index         = $sortColumns[$_GET['sort_col']];
    $_icon[$index] = $_sort === 'ASC' ? 'sort-alpha-desc' : 'sort-alpha-asc';
}

$_GET['promoTip'] = $_GET['promoTip'] ?? null;

$urlParams  = urldecode(http_build_query([
    'tab'      => $_activeTab,
    'promoTip' => $_GET['promoTip']
        ]));
?>

<!-- Навигация -->
<nav class="col z-index-1">
    <ul class="nav gap-11" role="tablist">
        <?php
        $_promoTabs = [
            'D' => 'Дилърски',
            'K' => 'Клиентски'
        ];

        foreach ($_promoTabs as $key => $label) {
            $_activeClass = ($_GET['promoTip'] == $key) ? 'bg-yellow round-10' : '';

            if (!$customConfig -> isVisible['tab_promoKl'] && $key == 'K') {
                break;
            }

            echo "<li class='nav-item'>
                <a class='nav-link {$_activeClass}' href='" . route_to('tabPromo', "promoTip={$key}") . "'>$label</a>
                 
              </li>";
        }
        ?>
    </ul>
</nav>

<!-- Видими колони -->
<div id="currentView" class="visibleCols d-flex justify-content-end" data-view="<?= $_activeTab ?>">
    <div class="p-2 d-flex align-items-center order-0">
        <label class="fw-500"><?= lang('LANG__mainPage.perPage.labelTxt') ?> 

            <?php
            $perPageParams = urldecode(http_build_query([
                'user_preferences_id' => $_userPreferencesTip['user_preferences_id'] ?? '',
                //'tip'                 => $_GET['orderTip'],
                'tab'                 => $_activeTab]))
            ?>

            <!-- Генериране на селектора за страница -->
            <select id="perPage" class="css-dropdown-p css-focus-strong css-border-none" data-id="<?= $_userPreferencesTip['user_preferences_id'] ?? '' ?>" data-route="<?= route_to('BaseController-userPreferences', $perPageParams) ?>">
                <?php foreach ([10, 25, 50, 100] as $opt): ?>
                    <option <?= ( $_userPreferencesTip['per_page'] ?? '') == $opt ? 'selected' : '' ?> value="<?= $opt ?>"><?= $opt ?></option>
                <?php endforeach; ?>
            </select> 
            <?= lang('LANG__mainPage.perPage.labelTxt2') ?></label>
    </div>

    <div class="p-2 d-flex align-items-center order-0">
        <label class="fw-500">Легенда: <span class="border-1" style="background: #d8ffbc;">&nbsp;&nbsp;&nbsp;</span> прикачен файл</label>
    </div>

    <div class="p-2 d-flex align-items-center order-2"> 
        <?php if ($_GET['promoTip'] == 'D'): ?>
            <div class="input-group justify-content-end">
                <input id="uploadFileName" class="hide form-control notClear" name="is_file" type="text">
                <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'modules', 'upload')): ?>
                    <label id="chooseFile" class="btn btn-outline-primary css-btn-close round-10 fw-500">
                        <i class="fa fa-upload"></i>&nbsp;Избор на файл
                    </label>
                <?php endif ?>

                <label id="canselFile" class="hide btn btn-outline-danger border-0 rounded-0">
                    <i class="fa fa-trash"></i>
                </label>

                <label id="uploadFile" class="hide btn btn-outline-success border-0 rounded-0" data-route="<?= route_to('FileManager-uploadFile', 0, 'promo') ?>">
                    <i class="fa fa-upload"></i>&nbsp;Качи файл 
                </label>

                <input name="is_file" type="file" accept=".pdf,.xlsx,.xls" style="display:none">
            </div>
        <?php endif ?> 
    </div>

    <!-- дали е активен бутона нова оферта -->
    <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'modules', 'plus')): ?>
        <div class="p-2 d-flex align-items-center order-3"> 
            <a class="btn btn-secondary round-10" href="<?= route_to('Promo-new', $urlParams) ?>"  style="background:#007BFF">
                <i class="fa fa-plus"></i>&nbsp;НОВА ПРОМОЦИЯ
            </a>
        </div>
    <?php endif ?>
</div>

<table id="tbl_promo" class="css-background-transparent css-border-none ui-responsive table table-striped table-sm my-2" cellspacing="0" width="100%">
    <thead class="css-background">
        <tr class="css-bg-purple">
            <th></th>

            <th>
                <input id="tbl-filter" class="css-input-p css-focus-strong css-border-none css-max-input-width" data-route="<?= route_to('tabPromo', 'promoTip=' . $_GET['promoTip']) . '&isRefresh=1' ?>" type="search" placeholder="<?= lang('LANG__mainPage.tbl.th.filter') ?>" value="<?= @$_GET['searchName'] ?>" >
            </th>

            <th colspan="6"></th>
        </tr>

        <tr class="labels">
            <th class="thN w-01">№</th>

            <th class="oferName text-left w-15">Име на промоция 
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[1] ?>" data-sql='{"col":"offersName","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="CustName text-left w-15">Име на клиент  
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[2] ?>" data-sql='{"col":"klient_name","sort":"<?= $_sort ?>"}'></i>
            </th>
            <th class="thStatus text-center w-7">Създадена на  
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[3] ?>" data-sql='{"col":"date_create","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="thUser text-center w-7">Потребител</th>
            <th class="thDateModify text-center w-7">Последна промяна</th>
            <th class="thDate text-center w-5">Валидност</th>
            <th class="thAction text-center w-1 no-sort"></th>
        </tr>
    </thead>

    <tbody> 
        <?php
        $_page    = $_GET['page'] ?? 1;
        $_perPage = $_GET['perPage'] ?? 10;

        foreach ($list as $k => $row) {
            $_rowBackground = $row['is_file'] ? 'background:#d8ffbc' : '';
            ?> 
            <tr class="notAutoNum" style="<?= $_rowBackground ?>" data-id="<?= $row['id'] ?>"> 
                <td><?= $_page == 1 ? $k + 1 : ($k + 1) + ($_perPage * ($_page - 1)) ?></td> 
                <td class="offersName text-left">
                    <input type="hidden" value="<?= $row['offersName'] ?>">
                    <span><?= $row['offersName'] ?></span>
                </td> 
                
                <td class="text-left"><?= $row['klient_name'] ?></td> 
                <td class="text-center"><?= date('d-m-Y', strtotime($row['date_create'])) ?></td> 
                <td class="text-center"<?= $row['userName_create'] ?>></td> 
                <td class="text-center"><?= $row['userName_modify'] . ' ' . $row['date_update'] ?></td>
                <td class="text-center"><?= $row['date_expire'] ?></td> 
                <td class="action text-center"> 
                    <?php
                    $_isFile        = $row['is_file'];
                    $_fileDir       = $row['file_dir'];
                    $_name          = $row['offersName'] ?? '';
                    $_id            = $row['id'] ?? '';

                    $urlParams = urldecode(http_build_query([
                        'tab'      => $_activeTab,
                        'promoTip' => $_GET['promoTip'],
                        'id'       => $_id,
                        'name'     => $_name,
                    ]));

                    // Генериране на бутони
                    $btns = [
                        // printPreview
                        'print' => $_isFile ? anchor($_ENV['app.imageDataDir'] . "docAsOfer/$_fileDir", '<i class="btn-outline-dark p-1 border-0 fa fa-download"></i>', 'download target="_blank" title="Изтегли файла"'
                        ) : anchor(route_to('PrintPreview', $urlParams), '<i class="btn-outline-dark p-1 border-0 fa fa-print" title="' . lang('LANG__global.btn.printPreview') . '"></i>', 'target="_blank"'),
                        // редакция
                        'edit'  => $_isFile ? '<a class="editFile"><i class="btn-outline-primary p-1 border-0 fa fa-edit" title="' . lang('LANG__global.btn.edit') . '"></i></a>' : anchor(route_to('Promo-index', $urlParams), '<i class="btn-outline-primary p-1 border-0 fa fa-edit" title="' . lang('LANG__global.btn.edit') . '"></i>', "class=\"edit_ofer\" data-id=\"$_id\""),
                        // изтриване
                        'trash' => anchor($_isFile ? route_to('FileManager-deleteFile', $_id, 'promo', 0) : route_to('MainPage-delete', $urlParams), '<i class="btn-outline-danger p-1 border-0 fa fa-trash" title="' . lang('LANG__global.btn.delete') . '"></i>', 'onclick="return confirm(\'' . lang('LANG__global.js.confirm.deleteOferta', [$_name]) . '\')"'
                        ),
                    ];

                    $_buttons = '';

                    if ($acl -> isAdmin == 'admin') {
                        $_buttons = implode('', $btns);
                    } else {
                        foreach (['print', 'edit', 'trash'] as $action) {
                            if ($acl -> is_allowed($userGroupId, 'modules', $_moduleKey, $action)) {
                                $_buttons .= $btns[$action] ?? '';
                            }
                        }
                    }
                    ?>

                    <div class = "btnGroup1 btn-group btn-group-sm">
                        <?= $_buttons ?>
                    </div>

                    <div class="btnGroup2 btn-group btn-group-sm hide">
                        <a class="saveFile" data-route="<?= route_to('FileManager-saveFile', $row['id'], 'promo', 0)
                        ?>" title="Запис">
                            <i class="btn-outline-primary p-1 border-0 fa fa-save"></i>
                        </a>

                        <a class="canselEdit" title="Отмяна на редакцията">
                            <i class="btn-outline-secondary p-1 border-0 fa fa-reply-all"></i>
                        </a>
                    </div>
                </td> 
            </tr> 
        <?php } ?> 
    </tbody> 
</table>

<div id="refreshPagnitation">
    <div id="pagination" class="d-flex col mt-2 justify-content-between fw-500">
        <div>
            <span><?= lang('LANG__mainPage.tbl.footer.total') ?></span> 
            <span class="countResults"><?= $countTotalRecords ?></span>
            <span><?= lang('LANG__mainPage.tbl.footer.records') ?></span>
        </div>
        <ul class="pagination">
            <?= $pagination ?>
        </ul>
    </div> 
</div>
