<?php
$preval        = service('settings') -> get('App.general')['preval'] ?? [];
$_currencyCode = $preval['base_currency'] ?? 'BGN';
?>

<table id="tbl_order" class="css-background ui-responsive table table-striped table-sm my-2" cellspacing="0" width="100%">
    <thead class="css-background">
        <tr class="css-bg-purple">
            <th colspan="2"></th>

            <th>
                <input class="filter css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__mainPage.tbl.th.filter') ?>" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="order_id" >
            </th>

            <th>
                <input class="filter css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__mainPage.tbl.th.filter') ?>" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="klient_name" value="<?= $_GET['searchName'] ?? '' ?>">
            </th>

            <th colspan="2"></th>

            <th>
                <input id="filter_date" class="css-input-p css-focus-strong css-border-none css-max-input-width" type="date" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="date_added">
            </th>

            <th colspan="2"></th>
        </tr>

        <tr class="labels">
            <th class="w-01 text-center">№</th>

            <th class="w-3">
                <?= lang('LANG__mainPage.tbl.th.site') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[1] ?>" data-sql='{"col":"site_name","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="w-2 text-center">
                №
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[2] ?>" data-sql='{"col":"order_id","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="w-8"><?= lang('LANG__mainPage.tbl.th.klient') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[3] ?>" data-sql='{"col":"klient_name","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="w-10">Адрес</th>

            <th class="w-3">Общо с ДДС (<?= $_currencyCode ?>)</th>

            <th class="w-1"><?= lang('LANG__mainPage.tbl.th.dateCreate') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[4] ?>" data-sql='{"col":"date_added","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="w-1"><?= lang('LANG__mainPage.tbl.th.orderStatus') ?></th>

            <th class="w-1"></th>
        </tr>
    </thead>

    <tbody> 
        <?php
        foreach ($list ?? [] as $row) :
            $deliveryJson = json_decode($row['delivery_json'] ?? '[]', true);

            if (!empty($deliveryJson)) {
                $_deliveryAdres = trim(($deliveryJson['grad'] ?? '') . ', ' . (!empty($deliveryJson['ofis']) ? 'офис: ' . $deliveryJson['ofis'] : ''), ', ');
            }

            $ko           = json_decode($row['delivery_json'] ?? '[]');
            $shippingCode = $ko -> izborKurier ?? '';

            $_isEcont   = in_array($shippingCode, ['econt_office', 'econt_machina', 'econt_door']);
            $_isSpeedy  = in_array($shippingCode, ['speedy_office', 'speedy_machina', 'speedy_door']);
            ?> 

            <tr data-id="<?= $row['order_id'] ?>"> 
                <td class="fw-400 align-middle text-center"></td>

                <td class="offerName align-middle fw-400"><?= $row['site_name'] ?? $row['order_name'] ?? '' ?></td> 
                <td class="text-center align-middle fw-400"><?= $row['order_id'] ?></td> 

                <td class="align-middle fw-400"><?= $deliveryJson['lice_zaKont'] ?? '' ?></td>

                <td class="fw-400"><?= $_deliveryAdres ?? '' ?></td> 

                <td class="text-center align-middle fw-400"><?= sprintf('%0.' . $_priceAccuracy . 'f', ($row['total_price'])) ?></td>

                <td class="align-middle fw-400" data-sort="<?= strtotime($row['date_added']) ?>"><?= date('d-m-Y H:i:s', strtotime($row['date_added'])); ?></td> 

                <?php
                $_cellBg    = $row['color'] ?? '';
                $_textColor = $row['text_color'] ?? 'text-white';
                $_bgClass   = $_cellBg . ' ' . $_textColor;
                ?>

                <td class="text-center align-middle fw-400 <?= $_bgClass ?> "><?= $row['status_name'] ?? 'нова' ?></td> 

                <td class="action text-center align-middle fw-400"> 
                    <?php
                    $_id        = $row['order_id'] ?? '';
                    $_name      = $row['order_id'] ?? '';

                    $urlParams = urldecode(http_build_query([
                        'tab'      => $_GET['tab'],
                        'orderTip' => $_GET['orderTip'],
                        'orderId'  => $_id,
                        'name'     => $_name,
                    ]));

                    $_classHideReturn = $row['sp_status_id'] != 4 ? 'hide' : '';

                    // Генериране на бутони
                    $btns = [
                        // printPreview
                        'print'   => ($_GET['orderTip'] ?? '') !== 'N' ? anchor(route_to('PrintPreview', $urlParams), '<i class="btn-outline-dark p-1 border-0 fa fa-print" title="' . lang('LANG__global.btn.printPreview') . '"></i>', 'target="_blank"') : '',
                        // редакция
                        'edit'    => anchor(route_to('Order-index', $urlParams), '<i class="btn-outline-primary p-1 border-0 fa fa-edit" title="' . lang('LANG__global.btn.edit') . '"></i>', "class='edit_ofer' data-id=\"$_id\""),
                        // връщане на поръчка
                        'refresh' => anchor(route_to('MainPage-orderReturn', $urlParams), '<i class="btn-outline-danger p-1 border-0 fa fa-refresh" title="Връщане на поръчка"></i>', "class='$_classHideReturn' onclick=\"javasciprt: return confirm('Сигурнили сте, че искате да върнете поръчка: $_id')\" "),
                        // клониране
                        'clone'   => anchor(route_to('MainPage-copy', $urlParams), '<i class="btn-outline-success p-1 border-0 fa fa-copy" title="' . lang('LANG__global.btn.clone') . '"></i>', array('class' => 'copyOfer')),
                        // изтриване
                        'trash'   => anchor(route_to('MainPage-orderDelete', $urlParams), '<i class="btn-outline-danger p-1 border-0 fa fa-trash" title="' . lang('LANG__global.btn.delete') . '"></i>', "onclick=\"javasciprt: return confirm('Сигурнили сте, че искате да изтриете поръчка: $_id')\" "),
                    ];

                    if (!empty($row['tavaritelniza_no'])) {
                        $btns['trash'] = anchor('', '<i class="btn-outline-danger p-1 border-0 fa fa-trash" title="' . lang('LANG__global.btn.delete') . '"></i>', "onclick=\"javasciprt: confirm('Има генерирана товарителница за поръчка: $_id и неможе да бъде изтрита.'); return false;\" ");
                    }

                    $_buttons = '';

                    // статус 4- завършен 5- върнат 6-авансово
                    if ($acl -> isAdmin == 'admin') {
                        $_buttons = match ((int) $row['sp_status_id']) {
                            5 => $btns['edit'] . $btns['clone'] . $btns['trash'],
                            default => implode('', $btns),
                        };
                    } else {
                        // ACL проверките за статус 5
                        foreach (((int) $row['sp_status_id'] === 5) ? ['edit', 'clone', 'trash'] : ['print', 'edit', 'refresh', 'clone', 'trash'] as $action) {
                            if ($acl -> is_allowed($userGroupId, 'modules', $_moduleKey, $action)) {
                                $_buttons .= $btns[$action] ?? '';
                            }
                        }
                    }
                    ?> 

                    <div class = "btnGroup1 notAllowed btn-group btn-group-sm">
                        <?= $_buttons ?>
                    </div>
                </td> 
            </tr> 
        <?php endforeach ?> 
    </tbody> 
</table>
