<?php
$_priceAccuracy = service('settings') -> get('App.general')['priceAccuracy'];
$_valutaSign    = service('settings') -> get('App.default_valutaSymbol');
$_prodavach     = service('settings') -> get('App.firma');

$_labels = match ($ofer -> ofer_lang) {
    'en' => [
'kod'              => 'code',
 'marka'            => 'Brand',
 'totalPrice'       => 'Total Price',
 'product'          => 'Product',
 'description'      => 'Description',
 'qty'              => 'Qty/m',
 'kkc'              => 'KKC',
 'unitPrice'        => 'Unit price',
 'picture'          => 'Picture',
 'priceFor'         => 'price for:',
 'in_stock'         => 'in stock',
 's_porachka'       => 'with order',
 'vat'              => 'VAT',
 'total_witout_vat' => 'Total without VAT',
 'total_vat'        => 'Total with VAT',
 'at'               => 'To the attention<br>of',
 'from'             => $ofer -> klient_adres != '' ? 'from' : '',
 'tel'              => $ofer -> klient_tel != '' ? 'Tel.:' : ''
    ],
    default => [
'kod'              => 'код',
 'marka'            => 'Марка',
 'totalPrice'       => 'Стойност.',
 'product'          => 'Продукт',
 'description'      => 'Описание',
 'qty'              => 'Бр./м',
 'unitPrice'        => 'Един. цена',
 'picture'          => 'Снимка',
 'kkc'              => 'ККЦ',
 'priceFor'         => 'цена за:',
 'in_stock'         => 'в наличност',
 's_porachka'       => 'с поръчка',
 'vat'              => 'ДДС',
 'total_witout_vat' => 'Сума без вкл. ДДС:',
 'total_vat'        => 'Сума тотал с вкл. ДДС:',
 'at'               => 'На вниманието<br>на',
 'from'             => $ofer -> klient_adres != '' ? 'от' : '',
 'tel'              => $ofer -> klient_tel != '' ? 'Тел.:' : ''
    ],
};

$dateCreate = $ofer -> date_create;
$dateCustom = $ofer -> date_custom;
$dateFinal  = $dateCustom == '' ? $dateCreate : $dateCustom;
?>

<!-- Bootstrap --> 
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" integrity="sha512-rt/SrQ4UNIaGfDyEXZtNcyWvQeOq0QLygHluFQcSjaGB04IxWhal71tKuzP6K8eYXYB6vJV4pHkXcmFGGQ1/0w==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<link rel="stylesheet" type="text/css" href="<?= auto('assets/css/layouts/fonts.css') ?>">

<link rel="stylesheet" type="text/css" href="<?= auto('assets/css/printPreview/printProtocol.css') ?>">

<div id="wrapper" class="protocol">

    <div class="headerTitle">
        <h3>ПРИЕМО-ПРЕДАВАТЕЛЕН ПРОТОКОЛ </h3>
        <p>No: <?= $ofer -> customNo ?>, от дата: <?= $dateFinal . ' г.' ?></p>
        <p>към фактура №: <input value=""></p>
    </div>

    <br>

    <div class="no-print2">
        <button class="btn_pdfCreate" type="button" data-oferName="oferta" onclick="window.print();">Печат</button>
        <span style="clear:both;"></span>
    </div>

    <div class="customer_block">
        <div class="d-flex">
            <div class="col-4">
                <label class="AkrobatBlack">Купувач:</label>
            </div>
            <div class="col">
                <span><?= $ofer -> klient_name ?></span>
            </div>
        </div>

        <div class="d-flex">
            <div class="col-4">
                <label>Адрес:</label>
            </div>
            <div class="col">
                <span><?= $ofer -> klient_adres ?></span>
            </div>
        </div>
    </div>

    <div class="prodavach_block ">
        <div class="d-flex">
            <div class="col-4">
                <label class="AkrobatBlack">Продавач:</label>
            </div>
            <div class="col">
                <span><?= $_prodavach['f_name'] ?></span>
            </div>
        </div>

        <div class="d-flex">
            <div class="col-4">
                <label>Адрес:</label>
            </div>
            <div class="col">
                <span><?= $_prodavach['f_adres'] ?></span>
            </div>
        </div>
    </div>

    <div class="clear"></div>

    <br>

    <table id="tbl_products" class="table table-striped" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th class="number"> № </th>
                <th class="kod"><?= $_labels['kod'] ?></th>
                <th class="title"><?= $_labels['product'] ?></th>
                <th class="broj"><?= $_labels['qty'] ?></th>
                <th class="ed_zena"><?= $_labels['unitPrice'] ?></th>
                <th class="total"><?= $_labels['totalPrice'] ?></th>   
            </tr>
        </thead>
        <tbody> 
            <?php
            foreach ($list as $key => $row) :
                $_qtyPrice_json = json_decode($row['qtyPrice_json'] ?? '');
                $_quantity      = $_qtyPrice_json -> {$row['product_id']} -> qty ?? '';
                $_price         = $_qtyPrice_json -> {$row['product_id']} -> price;
                ?> 

                <tr data-id="<?= $row['product_id'] ?>" data-symbol="<?= $_valutaSign ?>" > 
                    <td class="number"> <?= $key + 1 ?> </td>
                    <td class="kod wrapword"> <?= $row['kod'] ?? $row['model'] ?> </td>
                    <td class="opencartTitle wrapword"><?= $row['product_name'] ?></td> 
                    <td class="qty text-center">
                        <?= $_quantity ? $_quantity . ' ' . $row['mqrka_unit'] : '' ?>
                    </td>
                    <td class="zenaProdava text-center "><?= empty($_price) ? '' : $_price . ' ' . $_valutaSign ?></td>
                    <td class="total text-right"></td> 
                </tr> 
            <?php endforeach ?>
        </tbody> 

        <tfoot>
            <tr id="total_bez_dds">
                <th colspan="5"><label><?= $_labels['total_witout_vat'] ?></label></th>
                <th class="suma text-right"></th>
            </tr>

            <?php if ($ofer -> is_dds) : ?>
                <tr id="dds" class="">
                    <th colspan="5">
                        <label>
                            <?= $_labels['vat'] ?> <?= service('settings') -> get('App.general')['dds'] ?? '' ?>%
                        </label>
                    </th>
                    <th class="suma text-right"></th>
                </tr>

                <tr id="total_s_dds" class="">
                    <th colspan="5">
                        <label>
                            <?= $_labels['total_vat'] ?>
                        </label>
                    </th>
                    <th class="suma text-right"></th>
                </tr>
                <?php endIf ?>
        </tfoot>
    </table>


    <br> 

    <p class="nachinPlachtane"> <label>НАЧИН НА ПЛАЩАНЕ:</label>  
        <select> 
            <option>по банка</option>
            <option>в брой</option>
        </select>  
    </p>

    <br>

    <div class="col-sm-8 float-sm-left">
        <p>Стоката получена от:</p>
        <p>ЕГН:</p>
        <br>
        <p>Подпис:</p> 

    </div>

    <div class="col-sm-4 float-sm-right">
        <p>СЪСТАВИЛ :  <?= $userName_label ?></p>
        <br> 
        <br>
        <p> / подпис и печат /</p> 
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.3/jquery.min.js" ></script>

<script>
            var SETTINGS = <?php echo (json_encode(service('settings') -> get('App.general'))) ?>;
            var SETTINGS_NUM_FIXED = SETTINGS.priceAccuracy;
            var SETTINGS_DDS = SETTINGS.dds;
            // var LANG__special = <? // print_r(json_encode(lang('LANG__special.js')))                           ?>

            ( function ($, window, document) {
                var total = 0, valuta_sign = '', sum = 0;

                var ddsPercent = typeof SETTINGS_DDS !== "undefined" ? SETTINGS_DDS / 100 : 0;

                $('#tbl_products').find('tbody tr').each(function () {
                    var $tr = $(this);
                    var zena_prodava = $tr.find('td.zenaProdava');
                    var qty = $tr.find('td.qty').text();
                    var sum = 0;

                    valuta_sign = $tr.data('symbol') || '';
                    sum = parseFloat(zena_prodava.text()) * parseFloat(qty);

                    if (!isNaN(sum)) {
                        total += sum;
                        $tr.find('td.total').text(sum.toFixed(SETTINGS_NUM_FIXED) + ' ' + valuta_sign);// тотал
                    }
                    sum.toFixed(SETTINGS_NUM_FIXED)
                });

                // тотал без ддс
                $('#tbl_products').find('tfoot tr#total_bez_dds th.suma').text(total.toFixed(SETTINGS_NUM_FIXED) + ' ' + valuta_sign);

                //ддс
                $('#tbl_products').find('tfoot tr#dds th.suma').text(( total * ddsPercent ).toFixed(SETTINGS_NUM_FIXED) + ' ' + valuta_sign);

                // тотал с ддс
                $('#tbl_products').find('tfoot tr#total_s_dds th.suma').text(( ( total * ddsPercent ) + total ).toFixed(SETTINGS_NUM_FIXED) + ' ' + valuta_sign);
            }(window.jQuery, window, document) );
</script>	
