<div id="shablon_header" class="text-center pt-2">
    <?php
    helper('print_colorRows'); // Load the helper
    $settings       = service('settings') -> get('App.general') ?? [];
    $_priceAccuracy = $settings['priceAccuracy'] ?? 2;
    $preval         = $settings['preval'] ?? [];
    $currency       = $preval['base_currency'] ?? 'BGN';

    $_default_valutaSymbol = match ($currency) {
        'EUR' => '€',
        'USD' => '$',
        default => 'лв',
    };

    $_customerBlock = <<<HTML
                        <div class="customer_block float-right mb-2">
                          <div id="customer">на вниманието на <br>
                              <label>{$ofer?->klient_name}</label>
                          </div>
                          <div id="customerGrad">от
                              <label>{$ofer?->klient_grad}</label>
                          </div>
                          <div id="customerAdres">
                              <label>{$ofer?->klient_adres}</label>
                          </div>
                          <div id="customerTel">тел. 
                              <label>{$ofer?->klient_tel}</label>
                          </div>
                      </div>
                HTML;

    $search  = array('док№/дата', 'customerBlock', 'oferName');
    $replace = array('', $_customerBlock, '');

    echo str_replace($search, $replace, $ofer?->shablon_header);

    $_products    = [];
    $_productData = array_column($list, null, 'product_id');

    foreach ($category_attribute as $row) {
        $_catCharId = $row['category_characteristic_id'];
        $_productId = $row['product_id'] ?? null;

        if ($_productId && isset($_productData[$_productId]) && $row['category_id'] == $_productData[$_productId]['category_id']) {
            // Initialize the product_id group if it doesn't exist
            if (!isset($_products[$_productId])) {
                $_products[$_productId] = [];
            }

            // Append the current row data to the product_id group
            $_products[$_productId][] = [
                'category_characteristic_value'   => $row['category_characteristic_value'],
                'product_characteristic_value_id' => $row['product_characteristic_value_id'] ?? '',
                'product_characteristic_text'     => $row['product_characteristic_text'] ?? '',
                'category_characteristic_id'      => $row['category_characteristic_id'],
                'category_id'                     => $row['category_id'],
                'is_visible_inCatalog'            => $row['is_visible_inCatalog']
            ];
        }
    }
    ?>
</div>

<table id="tbl_products" class="css-product table-bordered" width="100%" cellspacing="0" role="presentation">
    <thead class="akrobatExtraBold bg-dark">
        <tr>
            <th class="w-10 text-center">Марка</th>
            <th class="w-20 text-center">Продукт</th>
            <th class="w-20 text-center">Описание</th>
            <th class="kod w-6 text-center" style="display: none">Код</th>
            <th class="qty w-9 text-center">Цена без ДДС</th>
            <th class="cenaKKC w-9 text-center" style="display:none">ККЦ с ДДС</th>
            <th class="w-6 text-center">Налич.</th>
            <th class="w-10 text-center">Снимка</th>
        </tr>
    </thead>

    <tbody>
        <?php foreach ($list as $key => $row): ?>
            <?php
            $_qtyPrice_json = json_decode($row['qtyPrice_json'] ?? '');
            $_quantity      = $_qtyPrice_json -> {$row['product_id']} -> qty ?? '';

            $_colorRows = isset($row['colorRows']) ? json_decode($row['colorRows'], true) : [];
            $_clRow     = generate_colorRows_inPrint(['list' => $list, 'key' => $key, 'colspan' => 6, 'colorRows' => $_colorRows]);

            $_img      = empty($row['image']) ? '' : $_ENV['app.imageDir'] . $row['image'];
            $_imgBrand = empty($row['image_brand']) ? '' : $_ENV['app.imageDir'] . $row['image_brand'];
            ?>
            <tr data-id="<?= $row['product_id']; ?>" data-category-name="<?= $row['category_name'] ?? 0 ?>">

                <td class="p-2 text-center">
                    <img class="w-100 m-auto" src="<?= $_imgBrand; ?>" onerror="this.onerror=null;this.src='';" alt="">
                </td>

                <td class="text-break"><?= $row['product_name'] ?></td>

                <td class="opisanie text-break">
                    <b class="desk maxHeight"><?= $row['description'] ?></b>

                    <?php if ($row['gensoft_item_id']) : ?>
                        <ul class="attr p-0 m-0 list-unstyled" style="display: none;">
                            <?php
                            foreach ($_products[$row['product_id']] ?? [] as $a) {
                                $_prodCharText = $a['product_characteristic_text'] ?? '';

                                echo '<li><label class="m-0 p-0">' . ($a['category_characteristic_value'] ?? '') . ':</label> ' . $_prodCharText . '</li>';
                            }
                            ?>
                        </ul>
                    <?php else: ?> 
                        <b class="attr" style="display: none;"><?= $row['description'] ?></b>
                    <?php endif ?>
                </td>

                <td class="kod text-break" style="display: none"><?= $row['kod'] ?></td>

                <td class=" text-center "><?= sprintf('%0.' . $_priceAccuracy . 'f', $_qtyPrice_json -> {$row['product_id']} -> price) . ' ' . $_default_valutaSymbol ?></td>

                <td class="cenaKKC" style="display:none"><?php $row['cenaKKC'] != '' ? sprintf('%0.' . $_priceAccuracy . 'f', ['cenaKKC']) : '' ?></td> 

                <td class="nalichnost text-center">
                    <span class="first"><?= $row['nalichnost'] == 0 ? 'с поръчка' : 'на склад' ?></span>
                    <span class="second"></span> 
                </td>

                <td class="p-2 text-center">
                    <?=
                    match ($row['badge_index']) {
                        '1' => '<div class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></div>',
                        '2' => '<div class = "mb-1 text-left position-absolute"><img class = "w-40" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                        '3' => '<div class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></div>',
                        '4' => '<div class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></div>',
                        default => '',
                    }
                    ?>
                    <img class="w-100 m-auto" src="<?= $_img; ?>" onerror="this.onerror=null;this.src='';" alt="">
                </td>
            </tr>
            <?= implode('', $_clRow) ?>
        <?php endforeach ?>
    </tbody>

</table>

<br>
<div class="belezka_oferta"><?= $ofer?->belezka_oferta ?></div>

<?= $ofer?->shablon_footer ?>

<br><br>

<div class="clear"><?= $ofer?->date_expire == '' ? '' : ' ВАЛИДНОСТ НА ОФЕРТАТА ДО ' . $ofer?->date_expire ?></div>
