<div id="shablon_header" class="text-center pt-2">
    <?php
    helper('print_colorRows'); // Load the helper
    helper('utils'); // helper 
    $settings       = service('settings') -> get('App.general') ?? [];
    $_priceAccuracy = $settings['priceAccuracy'] ?? 2;

    $preval   = $settings['preval'] ?? [];
    $currency = $preval['base_currency'] ?? 'BGN';

    /* --- Цени -------------------------------------------------- */
    $_pricesWithDds    = !empty($settings['prices_with_dds']);
//$_gensoftLabel  = $priceType === 'gensoft' ? 'ККЦ Генсофт' : 'Цена';
    $_pricesLabel      = $_pricesWithDds ? "Цена с ДДС" : 'Цена без ДДС';
    $_pricesLabelKkc   = $_pricesWithDds ? "ККЦ с ДДС" : 'ККЦ без ДДС';
    $priceType         = $settings['zenoobr']['price_type'] ?? 'discount';
    $_isRoundedToFirst = (bool) ($ofer -> isRoundedToFirst ?? false);

    $_default_valutaSymbol = match ($currency) {
        'EUR' => '€',
        'USD' => '$',
        default => 'лв',
    };

    $_labels = match ($ofer -> ofer_lang) {
        'en' => [
    'marka'        => 'Brand',
    'kod'          => 'Code',
    'availability' => 'Availability',
    'product'      => 'Product',
    'description'  => 'Description',
    'qty'          => 'Qty/m',
    'kkc'          => 'KKC',
    'unitPrice'    => 'Price without VAT',
    'picture'      => 'Picture',
    'priceFor'     => 'price for:',
    'in_stock'     => 'in stock',
    's_porachka'   => 'with order',
    'at'           => 'To the attention<br>of',
    'from'         => $ofer -> klient_adres != '' ? 'from' : '',
    'tel'          => $ofer -> klient_tel != '' ? 'Tel.:' : ''
        ],
        default => [
    'marka'        => 'Марка',
    'kod'          => 'Код',
    'availability' => 'Налич.',
    'product'      => 'Продукт',
    'description'  => 'Описание',
    'qty'          => 'Бр./м',
    'unitPrice'    => $_pricesLabel,
    'picture'      => 'Снимка',
    'kkc'          => $_pricesLabelKkc,
    'priceFor'     => 'цена за:',
    'in_stock'     => 'в наличност',
    's_porachka'   => 'с поръчка',
    'at'           => 'На вниманието<br>на',
    'from'         => $ofer -> klient_grad != '' ? 'от' : '',
    'tel'          => $ofer -> klient_tel != '' ? 'Тел.:' : ''
        ],
    };

    $_customerBlock = <<<HTML
                        <div class="customer_block">
                          <div id="customer">{$_labels['at']}
                              <label>{$ofer -> klient_name}</label>
                          </div>
                          <div id="customerGrad">{$_labels['from']} 
                              <label>{$ofer -> klient_grad}</label>
                          </div>
                          <div id="customerAdres"> 
                              <label>{$ofer -> klient_adres}</label>
                          </div>
                          <div id="customerTel">{$_labels['tel']} 
                              <label>{$ofer -> klient_tel}</label>
                          </div>
                      </div>
                HTML;

    $search  = array('док№/дата', 'customerBlock', 'oferName');
    $replace = array('', $_customerBlock, '<div class="oferName_norm" >' . $ofer -> offersName . '</div>');

    echo str_replace($search, $replace, $ofer -> shablon_header);

    $_products    = [];
    $_productData = array_column($list, null, 'product_id');

    foreach ($category_attribute as $row) {
        $_catCharId = $row['category_characteristic_id'];
        $_productId = $row['product_id'] ?? null;

        if ($_productId && isset($_productData[$_productId]) && $row['category_id'] == $_productData[$_productId]['category_id']) {
            // Initialize the product_id group if it doesn't exist
            if (!isset($_products[$_productId])) {
                $_products[$_productId] = [];
            }

            // Append the current row data to the product_id group
            $_products[$_productId][] = [
                'category_characteristic_value'   => $row['category_characteristic_value'],
                'product_characteristic_value_id' => $row['product_characteristic_value_id'] ?? '',
                'product_characteristic_text'     => $row['product_characteristic_text'] ?? '',
                'category_characteristic_id'      => $row['category_characteristic_id'],
                'category_id'                     => $row['category_id'],
                'is_visible_inCatalog'            => $row['is_visible_inCatalog']
            ];
        }
    }
    ?>
</div>

<table id="tbl_products" class="css-product table-bordered " width="100%" cellspacing="0" role="presentation">
    <thead class="akrobatExtraBold css-bacground">
        <tr>
            <th class="w-10 text-center"><?= $_labels['marka'] ?></th>
            <th class="w-20 text-center"><?= $_labels['product'] ?></th>
            <th class="w-20 text-center"><?= $_labels['description'] ?></th>
            <th class="kod w-6 text-center" style="display: none;"><?= $_labels['kod'] ?></th>
            <th class="qty w-6 text-center"><?= $_labels['qty'] ?></th>
            <th class="w-9 text-center"><?= $_labels['unitPrice'] ?></th>
            <th class="cenaKKC w-9 text-center" style="display:none"><?= $_labels['kkc'] ?></th>
            <th class="w-8 text-center"><?= $_labels['availability'] ?></th>
            <th class="w-15 text-center"><?= $_labels['picture'] ?></th>
        </tr>
    </thead>

    <tbody>
        <?php foreach ($list as $key => $row): ?>
            <?php
            $_qtyPrice_json = json_decode($row['qtyPrice_json'] ?? '');
            $_gensoftJson   = json_decode($row['gensoft_json'] ?? '');
            $_quantity      = $_qtyPrice_json -> {$row['product_id']} -> qty ?? '';

            $_colorRows = isset($row['colorRows']) ? json_decode($row['colorRows'], true) : [];
            $_clRow     = generate_colorRows_inPrint(['list' => $list, 'key' => $key, 'colspan' => 7, 'colorRows' => $_colorRows]);

            $_img = empty($row['image']) ? '' : $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION);

            // $_img      = empty($row['image']) ? '' : $_ENV['app.imageDir'] . $row['image'];

            $_imgBrand = empty($row['image_brand']) ? '' : $_ENV['app.imageCasheDir'] . $row['image_brand'] . '/' . pathinfo($row['image_brand'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image_brand'], PATHINFO_EXTENSION);
            ?>
            <tr data-id="<?= $row['product_id']; ?>" data-category-name="<?= $row['category_name'] ?? 0 ?>">

                <td class="p-2 text-center">
                    <img class="w-100 m-auto" src="<?= $_imgBrand ?>" onerror="this.onerror=null;this.src='';" alt="">
                </td>

                <td class="text-break"><?= $row['product_name'] ?></td>

                <td class="opisanie text-break">
                    <b class="desk maxHeight"><?= $row['description'] ?></b>

                    <?php if ($row['gensoft_item_id']) : ?>
                        <ul class="attr p-0 m-0 list-unstyled" style="display: none;">
                            <?php
                            foreach ($_products[$row['product_id']] ?? [] as $a) {
                                $_prodCharText = $a['product_characteristic_text'] ?? '';

                                if (!empty($_prodCharText)) {
                                    echo '<li><label class="m-0 p-0">' . ($a['category_characteristic_value'] ?? '') . ':</label> ' . $_prodCharText . '</li>';
                                }
                            }
                            ?>
                        </ul>
                    <?php else: ?> 
                        <b class="attr" style="display: none;"><?= $row['description'] ?></b>
                    <?php endif ?>

                    <span class="belezka"><?= $row['belezka'] != '' ? '<br><br><label class="belezka_label"><u>Бележка</u></label>:<br>' . $row['belezka'] : '' ?></span>     
                </td>

                <td class="kod text-break" style="display: none;"><?= $row['kod'] ?></td>

                <td class="qty text-center">
                    <div><?= $_labels['priceFor'] ?></div>
                    <div><?= $_quantity ? $_quantity . ' ' . $row['mqrka_unit'] : '' ?></div>
                </td>

                <td class="text-center ">
                    <?php
                    $_zenaProdava = $_qtyPrice_json -> {$row['product_id']} -> price ?? '';
                    $_promoPrice  = null;
                    $_gsKKC       = h_toFixed($_gensoftJson -> KKC ?? null, $_isRoundedToFirst); // gensoft KKC 

                    $_gPromoPercent = is_numeric($_gensoftJson -> promoPercent ?? null) ? (float) $_gensoftJson -> promoPercent : null; // gensoft промо % 

                    if ($_gPromoPercent && is_numeric($_gsKKC)) {
                        $_promoPrice = h_toFixed($_gsKKC * (1 + ($_gPromoPercent / 100)), $_isRoundedToFirst);
                    }

                    $_gsKKC       = $_gsKKC . ' ' . $_default_valutaSymbol;
                    $_zenaProdava = $_zenaProdava . ' ' . $_default_valutaSymbol;

                    echo $priceType === 'gensoft' ? $_gsKKC : $_zenaProdava;

                    if ($_promoPrice !== null && !empty($_gsKKC)):
                        $_promoPrice = $_promoPrice . ' ' . $_default_valutaSymbol;
                        ?>

                        <?php ?>
                        <small class="<?= $_gPromoPercent < 0 ? 'text-danger' : 'text-success' ?>">
                            <?= ($_gPromoPercent > 0 ? '+' : '') . $_promoPrice . '&nbsp;&nbsp;(' . $_gPromoPercent . '%)' ?>
                        </small>
                    <?php endif; ?>
                </td>

                <td class="cenaKKC" style="display:none"><?php $row['cenaKKC'] != '' ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaKKC'] . ' ' . $_default_valutaSymbol) : '' ?></td> 

                <td class="nalichnost text-center">
                    <span class="first"><?= $row['nalichnost'] == 0 ? 'с поръчка' : 'на склад' ?></span>
                    <span class="second"></span> 
                </td>

                <td class="p-2 text-center">
                    <?=
                    match ($row['badge_index']) {
                        '1' => '<div class="new_label mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></div>',
                        '2' => '<div class = "mb-1 text-left position-absolute"><img class = "w-40" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                        '3' => '<div class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></div>',
                        '4' => '<div class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></div>',
                        default => '',
                    }
                    ?>
                    <img class="w-100 m-auto" src="<?= $_img; ?>" onerror="this.onerror=null;this.src='';" alt="">
                </td>
            </tr>
            <?= implode('', $_clRow) ?>
        <?php endforeach ?>
    </tbody>

</table>

<br>
<div class="belezka_oferta"><?= $ofer -> belezka_oferta; ?></div>

<?= $ofer -> shablon_footer ?>
