<?php
$settings = service('settings') -> get('App.general') ?? [];
helper('print_colorRows'); // Load the helper

$_priceAccuracy = $settings['priceAccuracy'] ?? 2;
$preval         = $settings['preval'] ?? [];
$currency       = $preval['base_currency'] ?? 'BGN';

$_defaultValutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв',
};
?>

<style>
    body{background: #fff;}

    .print-section {
        width: 21.2cm;
    }

    @page {
        margin:0.5cm 0;
        size:A4;
    }

    #wrapper1{
        margin:0 auto;
        width: 21cm;
        height:  29.5cm;
        background: #fff;
    }

    .left{
        position: relative;
        margin-top: 8px;
        display:inline-block;
        height:15cm;
        width: 10.5cm;
    }

    .left img{
        width: 100%;
        position: absolute;
    }
    .title {
        height: 60px;
        margin-left: 20px;
        margin-right: 20px;
        font-size: 17px;
        word-break: break-word;
        font-weight: bold;
        text-align: center;
        margin-top: 95px;
        position: relative;
    }
    .attr{
        padding-left: 10px;
        position: relative;
        margin-top: 13px;
        overflow: hidden;
        height: 240px;
    }
    .footer{
        padding-left: 10px;
        position: relative;
        margin-top: -5px;
    }
    .price{
        font-size: 50px;
        font-weight: bold;
        margin-right: 80px;
        margin-left: 80px;
    }
    .man{
        width: 95%;
        font-size: 12px;
    }
    sup{
        font-size: 30px;
    }

    @media print
    {
        * {
            -webkit-print-color-adjust: exact !important;   
            color-adjust: exact !important;                
            print-color-adjust: exact !important;  
        }

        body,page {
            -webkit-transform: scale(0.85);  /* Saf3.1+, Chrome */
            -moz-transform: scale(0.85);  /* FF3.5+ */
            -ms-transform: scale(0.85);  /* IE9 */
            -o-transform: scale(0.85);  /* Opera 10.5+ */
            transform: scale(0.85);
            margin: -50px -75px 0;  /* big hack to reposition the page top the top and left of the viewer control */
        }

        #printArea{
            width: 100%
        }
        .print-section{
            -webkit-transform: scale(1.2);  /* Saf3.1+, Chrome */
            -moz-transform: scale(1.2);  /* FF3.5+ */
            -ms-transform: scale(1.2);  /* IE9 */
            -o-transform: scale(1.2);  /* Opera 10.5+ */
            transform: scale(1.2);
        }

        .oferName, .headerS,.no-print2,#toolbarContainer
        {
            display: none !important;
            height: 0;
        }

        p {orphans: 4;}

        .page-break { 
            display: block !important;  
            page-break-before: always !important;
            page-break-inside: unset;
        }
    }
</style>

<section class="row content-header p-1 align-items-center position-fixed w-100" style="border-bottom: 1px solid #c3c3c3;top:40px;position: relative;">
    <div class="col-8 float-left">
        <div class="row col">
            <h5 class="m-0 text-dark">Предпечат табелки с характеритики - </h5> 
            <span id="oferName" class="p-1"><?= $ofer -> offersName ?? '' ?></span>  
        </div>
    </div>

    <div class="col-4 d-flex float-right justify-content-end align-items-center">
        <button style="float: right;" onclick="window.print();">Print</button>
    </div>
</section>

<div id="printArea" class="mt-5 pt-5">
    <?php
    foreach ($list as $key => $row) {
        $brandTxt = empty($row['brandTxt']) ? '' : '<b>Производител: </b>' . $row['brandTxt'];

        $vnositel = empty($row['belezka']) ? '' : '<b>Вносител: </b>' . $row['belezka'];

        $_price = $row['cenaKKC'] == '' ? '0.00' : sprintf('%0.2f', $row['cenaKKC']);
        $_price = !empty($_price) ? preg_replace('/\.([0-9]*)/', '<sup class=""> .$1</sup>', $_price) . ' ' . $_defaultValutaSymbol : '';

        if ($key % 4 == 0) {
            echo '<div class="print-section m-auto border-1">';
        }
        ?> 
        <div  class="left" data-id="<?= $row['product_id'] ?>">
            <img src="<?= $_ENV['app.imageDataDir'] ?>tabelka/tabelkaRamka.jpg" alt="alt"/>
            <p class="title"><?= $row['product_name'] ?></p>

            <div class="attr">
                <ul class="mr-3 pr-1" style="font-size: 13px">
                    <?php
                    foreach ($category_attribute as $v) {
                        if ($v['product_id'] == $row['product_id'] && $v['is_visible_inCatalog'] == 1) {

                            $_catCharId    = $v['category_characteristic_id'];
                            $_product_id   = $v['product_id'] ?? '';
                            $_prodCharText = $v['product_characteristic_text'] ?? '';
                            $_prodCharId   = $_attr[$_catCharId]['product_characteristic_id'] ?? '';

                            $_attrName = $v['category_characteristic_value'] ?? '';
                            //$_attrId   = $v['category_characteristic_id'];
                            $_attrText = $v['product_characteristic_value'] ?? '';

                            echo '<li><label>' . ($v['category_characteristic_value'] ?? '') . ':</label> ' . $_prodCharText . '</li>';
                        }
                    }
                    ?>
                </ul>
            </div>

            <div class="footer">
                <div class="price"><?= $_price ?></div>

                <div class="man mt-2">
                    <span style="word-break: break-word;float: left;margin: 0;"><?php echo $vnositel ?></span>

                    <span style="word-break: break-word;float: right;margin: 0;"><?php echo $brandTxt ?></span>  
                    <span class="valpers" style="float: right;margin: 0;clear: both;color:#ff5f5f">www.valpers.eu</span>  

                </div>
            </div>
        </div>
        <?php
        if ($key % 4 == 3) {
            echo '</div><div class="page-break my-2"></div>';
        }
    }
    ?> 
</div>

