<?php
$tab                 = $_GET['tab'] ?? '';
$_userPreferences    = array_column($userPreferences, null, 'modul_name');
$_userPreferencesTip = $_userPreferences[$_GET['tab']] ?? [];

if (isset($_GET['col'], $_GET['searchName'])) {
    $_filter[$_GET['col']] = $_GET['searchName'] ?? null;
}

$_sort = match ($_GET['sort_order'] ?? 'DESC') {
    'ASC' => 'DESC',
    'DESC' => 'ASC',
};

$_columnIcons = [
    'klient_name' => ['sort-alpha-asc', 'sort-alpha-desc'],
        // Add more columns and icons as needed
];

$_sortColumn = $_GET['sort_col'] ?? null;

$_icon         = array_key_exists($_sortColumn, $_columnIcons) ?
        $_columnIcons[$_sortColumn][($_sort === 'ASC' ? 0 : 1)] :
        'unsorted';
?>

<div id="currentView" class="visibleCols css-background d-flex justify-content-end" data-view="<?= $tab ?>">
    <div class="p-2">
        <label class="fw-500"><?= lang('LANG__global.perPage.labelTxt') ?> 
            <?php
            $perPageParams = urldecode(http_build_query([
                'user_preferences_id' => $_userPreferencesTip['user_preferences_id'] ?? '',
                'tab'                 => $_GET['tab']]))
            ?>
            <select id="perPage" class="css-dropdown-p css-focus-strong css-border-none input-sm py-2" data-id="<?= $_userPreferencesTip['user_preferences_id'] ?? '' ?>" data-route="<?= route_to('BaseController-userPreferences', $perPageParams) ?>">
                <?php foreach ([10, 25, 50, 100] as $opt) : ?>
                    <option <?= ( $_userPreferencesTip['per_page'] ?? '') == $opt ? 'selected' : '' ?> value="<?= $opt ?>"><?= $opt ?></option>
                <?php endforeach; ?>
            </select> 
            <?= lang('LANG__global.perPage.labelTxt2') ?></label>  
    </div>
</div> 

<label class="css-background col p-1 mb-1 fw-500">При използване на филтъра използвайте ENTER, когато се готови с въвеждане на търсеният клиент или част от името.</label>

<table id="tbl_products" class="table table-striped css-border-none table-sm" cellspacing="0" width="100%">
    <thead class="css-background css-border-none">
        <tr>
            <th class="css-border-none fw-500" colspan="3"></th>

            <th class="css-border-none fw-500"> 
                <input class="filter css-input-p css-focus-strong css-border-none css-max-input-width" data-sql-col="klient_name" type="search" placeholder="<?= lang('LANG__global.tbl.th.filter') ?>" value="<?= $_filter['klient_name'] ?? '' ?>" >
            </th>  

            <th class="css-border-none fw-500">
                <input class="filter css-input-p css-focus-strong css-border-none css-max-input-width" data-sql-col="klient_mol" type="search" placeholder="<?= lang('LANG__global.tbl.th.filter') ?>" value="<?= $_filter['klient_mol'] ?? '' ?>">
            </th>

            <th class="css-border-none fw-500">
                <input class="filter css-input-p css-focus-strong css-border-none css-max-input-width" data-sql-col="bulstat" type="search" placeholder="<?= lang('LANG__global.tbl.th.filter') ?>" value="<?= $_filter['bulstat'] ?? '' ?>">
            </th> 

            <th class="css-border-none fw-500" colspan="4"></th> 
        </tr>

        <tr class="labels">
            <th class="css-border-none text-center fw-500 w-1"><div><input id="select-all" type="checkbox"></div></th>

            <th class="css-border-none text-center fw-500 w-1"><?= lang('LANG__klient.tbl.th.id') ?></th>

            <th class="css-border-none text-center fw-500 w-1">Цена ниво</th>

            <th class="css-border-none fw-500 w-10"><?= lang('LANG__klient.tbl.th.klient') ?>  
<!--                <i class="sort pointer-cursor float-right text-white fa fa-<? // $_icon               ?>" data-sql-sort="<? // $_sort               ?>"></i>-->
            </th>

            <th class="css-border-none fw-500 w-10"><?= lang('LANG__klient.tbl.th.mol') ?></th>
            <th class="css-border-none fw-500 w-5"><?= lang('LANG__klient.tbl.th.bulstat') ?></th>
            <th class="css-border-none fw-500 w-5"><?= lang('LANG__klient.tbl.th.tel') ?></th>
            <th class="css-border-none fw-500 w-15"><?= lang('LANG__klient.tbl.th.adres') ?></th> 
            <th class="css-border-none fw-500 w-5"><?= lang('LANG__klient.tbl.th.email') ?></th>     
            <th class="css-border-none fw-500 w-3"></th>
        </tr>
    </thead>

    <tbody>
        <?php
        foreach ($list as $row) :
            $_isGensoft = $row['gensoft_firm_id'];
            ?>
            <tr class="notAutoNum" data-id="<?= $row['klient_id'] ?>">
                <td class="align-middle text-center">
                    <input type="checkbox" value="<?= $row['klient_id'] ?>">
                </td>

                <td class="align-middle fw-400">
                    <input name="klient_id"
                           type="hidden" 
                           value="<?= $row['klient_id'] ?>">
                           <?= $row['klient_id'] ?>
                </td>

                <td class="align-middle fw-400">
                    <select class="zenaNivo css-dropdown-p css-focus-strong css-border-none" data-route="<?= route_to('Klient-change_priceLevel') ?>">

                        <?php foreach (['Цена В', 'Цена А', 'Специална', 'Цена Кл'] as $level): ?>
                            <option value="<?= $level ?>" <?= $row['zenaNivo'] === $level ? 'selected' : '' ?>>
                                <?= $level ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </td>

                <td class="firma fw-400" style="white-space: pre;"><?= $row['klient_name'] ?></td>

                <td class="align-middle fw-400">
                    <input name="klient_mol"
                           type="hidden" 
                           value="<?= $row['klient_mol'] ?>">

                    <span> <?= $row['klient_mol'] ?></span>
                </td>

                <td class="align-middle fw-400"> 
                    <input name="bulstat"
                           type="hidden" 
                           value="<?= $row['bulstat'] ?>">

                    <span> <?= $row['bulstat'] ?></span>
                </td>

                <td class="align-middle fw-400">
                    <input name="klient_tel"
                           type="hidden" 
                           value="<?= $row['klient_tel'] ?>">

                    <span> <?= $row['klient_tel'] ?></span>
                </td>

                <td class="align-middle fw-400">
                    <input name="klient_adres"
                           type="hidden" 
                           value="<?= $row['klient_adres'] ?>">

                    <span> <?= $row['klient_adres'] ?></span>
                </td>

                <td class="align-middle fw-400">
                    <input name="email"
                           type="hidden" 
                           value="<?= $row['email'] ?>">

                    <span> <?= $row['email'] ?></span>
                </td>

                <td class="action text-center d-flex align-items-center justify-content-center">

                    <button type="button" class="edit btn p-0" data-route="<?= route_to('POPup_klient-open', $row['klient_id']) ?>">
                        <i class="btn-outline-primary p-1 border-0 fa fa-edit"></i>
                    </button>


                    <?php if (empty($_isGensoft)): ?>
                        <?php
                        $urlParams = urldecode(http_build_query([
                            'tab'  => $_GET['tab'],
                            'id'   => $row['klient_id'],
                            'name' => $row['klient_name'],
                        ]));
                        ?>

                        <a href="<?= route_to('Klient__delete', $urlParams) ?>" onclick="javascript: return confirm('Сигурнили сте, че искате да изтриете клиент - <?= $row['klient_name'] ?>')">
                            <i class="btn-outline-danger p-1 border-0 fa fa-trash"></i>
                        </a>
                    <?php endif ?>
                </td>
            </tr>
        <?php endforeach ?>
    </tbody> 
</table> 

<div class="d-flex col justify-content-between">
    <div>
        <span><?= lang('LANG__global.tbl.footer.total') ?></span> 
        <span class="countResults"><?= $countTotalPag ?></span>
        <span><?= lang('LANG__global.tbl.footer.records') ?></span>
    </div>
    <ul class="pagination">
        <?= $pagination ?>
    </ul>
</div> 
