<?php
$general   = service('settings') -> get('App.general') ?? [];
$preval    = $general['preval'] ?? [];
$priceType = $general['zenoobr']['price_type'] ?? 'discount';
$currency  = $preval['base_currency'] ?? 'BGN';

$tab                 = $_GET['tab'] ?? 'spProduct';
$_userPreferences    = array_column($userPreferences ?? [], null, 'modul_name');
$_userPreferencesTip = $_userPreferences[$tab] ?? [];

$show = [
    'cenaB'    => true,
    'cenaA'    => true,
    'cenaSpec' => true,
    'cenaKl'   => true,
    'cenaKKC'  => true,
    'dost'     => false,
];

// RULES
if ($priceType === 'gensoft') {
// създава нов масив с стойност false
    $show         = array_fill_keys(array_keys($show), false);
    $show['dost'] = true;
} elseif ($priceType === 'discount') {
    $show['cenaKl'] = false;
}

if (isset($_GET['col'], $_GET['searchName'])) {
    $_filter[$_GET['col']] = $_GET['searchName'] ?? null;
}

$_labelValuta = "<div style='background-color:#C61111;color:#fff!important;padding:1px 6px;border-radius:4px;font-size:0.85em;'> $currency </div>";

$_mqrka        = isset($mqrka) ? array_column($mqrka, null, 'sp_mqrka_id') : [];
?>

<div id="currentView" class="visibleCols d-flex justify-content-end" data-view="<?= $tab ?>">
    <div class="p-2">
        <label><?= lang('LANG__global.perPage.labelTxt') ?> 
            <?php
            $perPageParams = urldecode(http_build_query([
                'user_preferences_id' => $_userPreferencesTip['user_preferences_id'] ?? '',
                //'tip'                 => $_GET['orderTip'],
                'tab'                 => $tab]))
            ?>
            <select id="perPage" class="css-input-p css-focus-strong css-border-none py-2" data-id="<?= $_userPreferencesTip['user_preferences_id'] ?? '' ?>" data-route="<?= route_to('BaseController-userPreferences', $perPageParams) ?>">
                <?php
                $_options      = [10, 25, 50, 100];
                foreach ($_options as $opt) :
                    ?>
                    <option <?= ( $_userPreferencesTip['per_page'] ?? '') == $opt ? 'selected' : '' ?> value="<?= $opt ?>"><?= $opt ?></option>
                <?php endforeach; ?>
            </select> 
            <?= lang('LANG__global.perPage.labelTxt2') ?></label>  
    </div>
</div> 

<div class="col row p-2 h-50">
    <div class="input-group col-3">
        <select id="categoryList" class="css-dropdown-p css-focus-strong css-border-none css-border-radius-left p-1">
            <option value="">-- категория за избраните продукти --</option>
            <?php foreach ($categories ?? [] as $v) : ?>
                <option value="<?= $v['category_id'] ?>"><?= $v['category_name'] ?></option>
            <?php endforeach ?>
        </select>

        <div class="input-group-prepend">
            <button id="saveCategory" class="btn btn-outline-primary" data-route="<?= route_to('Product-change_categoryOnProducts') ?>" type="button">
                <i class="fa fa-save"></i>
            </button>
        </div>
    </div>

    <div class="input-group col-2">
        <label class="d-flex align-items-center">Наличност</label>
        <input id="nalich_for_update" class="css-dropdown-p css-focus-strong css-border-none css-border-radius-left  ml-2 w-30" data-isnumeric type="text">

        <div class="input-group-prepend">
            <button class="btn btn-outline-secondary" data-toggle="jTippy" data-title="Обновяване на наличността за селекция продукти или за всички продукти.<br>Ако има селектирани продукти се обновява само наличността за избраната селекция, ако не са избрани продукти се обновява наличността за всички продукти." type="button">
                <i class="fa fa-info"></i>
            </button>

            <button id="saveNalich" class="btn btn-outline-primary" data-route="<?= route_to('Product-save_nalich') ?>" type="button">
                <i class="fa fa-save"></i>
            </button>
        </div>
    </div>
</div>

<label class="col mb-2">При използване на филтъра използвайте ENTER, когато се готови с въвеждане на търсеният продукт или част от името.</label>

<table id="tbl_products" class="table table-striped table-sm" cellspacing="0" width="100%">
    <thead class="css-background text-center">
        <tr>
            <th></th><th></th>

            <th> 
                <select id="category" class="css-dropdown-p css-focus-strong css-border-none py-1 w-100">
                    <option value=""><?= lang('LANG__product.tbl.th.chooseCat') ?></option>
                    <?php
                    foreach ($categories ?? [] as $v) :
                        $selected = '';
                        if (isset($_GET['categoryId']) && $v['category_id'] == $_GET['categoryId']) {
                            $selected = 'selected';
                        }
                        ?>
                        <option value="<?= $v['category_id'] ?>" <?= $selected ?>><?= $v['category_name'] ?></option>
                    <?php endforeach ?>
                </select>
            </th>

            <?php if ($_ENV['app.gensoftEnable']) : ?> 
                <th> 
                    <input class="filter css-input-p css-focus-strong css-border-none" data-sql-col="gensoft_productName" type="search" placeholder="<?= lang('LANG__global.tbl.th.filter') ?>" value="<?= $_filter['gensoft_productName'] ?? '' ?>" >
                </th> 
            <?php endif ?>

            <th> 
                <input class="filter css-input-p css-focus-strong css-border-none" data-sql-col="product_name" type="search" placeholder="<?= lang('LANG__global.tbl.th.filter') ?>" value="<?= $_filter['product_name'] ?? '' ?>" >
            </th> 

            <th> 
                <input class="filter css-input-p css-focus-strong css-border-none" data-sql-col="model" type="search" placeholder="<?= lang('LANG__global.tbl.th.filter') ?>" value="<?= $_filter['model'] ?? '' ?>" >
            </th>  

            <th> 
                <input class="filter css-input-p css-focus-strong css-border-none" data-sql-col="kod" type="search" placeholder="<?= lang('LANG__global.tbl.th.filter') ?>" value="<?= $_filter['kod'] ?? '' ?>">
            </th>  

            <th></th>  

            <th colspan="10"></th>  
        </tr>

        <tr class="labels text-center">
            <th class="w-1"></th>
            <th class="w-1  align-middle"><div><input id="selectAll_product" type="checkbox"></div></th>
            <th class="w-7 align-middle"><?= lang('LANG__product.tbl.th.category') ?></th>
            <?php if ($_ENV['app.gensoftEnable']) : ?> 
                <th class="w-10 align-middle">Номенклатура Gensoft</th> 
            <?php endif ?>
            <th class="w-10 align-middle"><?= lang('LANG__product.tbl.th.product') ?></th>
            <th class="w-10 align-middle"><?= lang('LANG__product.tbl.th.model') ?></th>
            <th class="w-5 align-middle"><?= lang('LANG__product.tbl.th.kod') ?></th>
            <th class="w-10 align-middle"><?= lang('LANG__product.tbl.th.desc') ?></th>  
            <th class="w-3 align-middle">Наличност</th> 

            <?php if ($show['cenaB']): ?>
                <th class="w-5 align-middle"><?= lang('LANG__product.tbl.th.priceB') ?>
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($show['cenaA']): ?>
                <th class="w-5 align-middle"><?= lang('LANG__product.tbl.th.priceA') ?>
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($show['cenaSpec']): ?>
                <th class="w-5 align-middle"><?= lang('LANG__product.tbl.th.priceSpec') ?>
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($show['cenaKl']): ?>
                <th class="w-5 align-middle"><?= lang('LANG__product.tbl.th.klKl') ?>
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($show['dost']): ?>
                <th class="w-5 align-middle"><?= lang('LANG__product.tbl.th.priceDost') ?>
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($show['cenaKKC']): ?>
                <th class="w-5 align-middle">ККЦ
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <th class="w-5 align-middle"><?= lang('LANG__product.tbl.th.img') ?></th>
            <th class="w-5 align-middle"><?= lang('LANG__product.tbl.th.brandImg') ?></th>
            <th class="w-2 align-middle">Сайт</th>
            <th class="w-6 align-middle"></th>
        </tr>

    </thead>

    <tbody>
        <?php
        foreach ($list as $row) {
            $_category_name    = $row['category_name'] ?? '';
            $_subCategory_name = $row['subCategory_name'] ?? '';
            $_zenovaLista_id   = $row['zenovaLista_id'] ?? '';
            $_zenovaLista_name = $row['zenovaLista_name'] ?? '';
            $_isGensoft        = $row['gensoft_item_id'];

            $_mqrka_unit = $_mqrka[$row['sp_mqrka_id']]['mqrka_unit'] ?? '';

            $baseUrlParams = [
                'ctrl'       => 'spProduct',
                'product_id' => $row['product_id'],
                'arg'        => '',
            ];

            $urlParams = http_build_query($baseUrlParams);

            $urlDelParams = http_build_query(array_merge($baseUrlParams, [
                'product_name' => $row['product_name'] ?? '',
            ]));
            ?>
            <tr class="text-center" data-id="<?= $row['product_id'] ?>">
                <td class="align-middle"></td>

                <td class="align-middle">
                    <input class="chk_productId" type="checkbox" value="<?= $row['product_id'] ?>">
                </td>

                <td class="align-middle"><?= $_category_name . ( $_subCategory_name == '' ? '' : ' -> ') . $_subCategory_name ?>
                </td>

                <?php if ($_ENV['app.gensoftEnable']) : ?> 
                    <td class="align-middle text-left"><?= $row['gensoft_productName'] ?></td>
                <?php endif ?> 

                <td class="productName align-middle text-left"><?= $row['product_name'] ?></td>

                <td class="align-middle text-left"><?= $row['model'] ?> </td>

                <td class="align-middle"><?= $row['kod'] ?> </td>

                <td class="text-left">
                    <div class="maxHeight"><?= empty($row['description']) ? $row['short_description'] : $row['description'] ?></div>

                    <i class="fa fa-info-circle text-primary text-center d-block cursor-pointer maxHeight" data-toggle="tooltip" title="<?= htmlentities($row['description']) ?>"></i> 
                </td>

                <td class="align-middle"><?= $row['nalichnost'] ? "{$row['nalichnost']} $_mqrka_unit" : '' ?></td>

                <?php if ($show['cenaB']): ?>
                    <td class="align-middle"><?= $row['cenaB'] ?></td>
                <?php endif ?>

                <?php if ($show['cenaA']): ?>
                    <td class="align-middle"><?= $row['cenaA'] ?></td>
                <?php endif ?>

                <?php if ($show['cenaSpec']): ?>
                    <td class="align-middle"><?= $row['cenaSpec'] ?></td>
                <?php endif ?>

                <?php if ($show['cenaKl']): ?>
                    <td class="align-middle"><?= $row['cenaKl'] ?></td> 
                <?php endif ?>

                <?php if ($show['dost']): ?>
                    <td class="align-middle bg-success"><?= $row['price_dostavna'] ?></td>
                <?php endif ?>

                <?php if ($show['cenaKKC']): ?>
                    <td class="align-middle"><?= $row['cenaKKC'] ?></td>
                <?php endif ?>

                <td class="align-middle">
                    <div class="d-flex">
                        <?php
                        $imagePath     = $_ENV['app.imageDir'] . $row['image'];
                        $thumbnailPath = !empty($row['image']) ? $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION) : '';
                        ?>

                        <span id="zoom-icon-<?= $row['product_id'] ?>" class="<?= $thumbnailPath != '' ? 'fa fa-search-plus' : '' ?>  position-absolute"></span>

                        <img class="zoomImg mw-100 m-auto" src="<?= $thumbnailPath ?>" data-full-image="<?= $imagePath ?>" onerror="this.onerror=null;this.src='';document.getElementById('zoom-icon-<?= $row['product_id'] ?>').style.display='none';" data-img="<?= $row['image'] ?>" alt="">
                    </div>
                </td>

                <td class="align-middle">
                    <div class="d-flex">
                        <?php
                        $imagePath     = $_ENV['app.imageDir'] . $row['image_brand'];
                        $thumbnailPath = $row['image_brand'] != '' ? $_ENV['app.imageCasheDir'] . $row['image_brand'] . '/' . pathinfo($row['image_brand'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image_brand'], PATHINFO_EXTENSION) : ''
                        ?>

                        <img class="mw-100 m-auto" src="<?= $thumbnailPath ?>" onerror="this.onerror=null;this.src='';" data-img="<?= $row['image_brand'] ?>" alt="">
                    </div>
                </td>

                <td class="align-middle">
                    <input class="toSite" 
                           name="toSite[<?= $row['product_id'] ?>]" 
                           data-route="<?= route_to('Zenova-productToSites', $row['product_id']) ?>" 
                           <?= empty($row['cenaB']) && empty($row['cenaA']) && empty($row['cenaSpec']) && empty($row['cenaKl']) && empty($row['cenaKKC']) ? 'data-not-price' : ''
                           ?>
                           data-cenakkc="<?= $row['cenaKKC'] ?? '' ?>"
                           data-hasrootcat="<?= $row['categoryRoot_id'] ?? '' ?>"
                           type="checkbox" <?= !empty($row['sp_site_id']) ? 'checked' : '' ?> 
                           title="добавяне на продукта към сайт" 
                           value="1">
                </td>

                <td class="action align-middle">
                    <div>
                        <i class="edit_product btn-outline-primary p-1 border-0 fa fa-edit" data-route="<?= route_to('Popup_editProduct-open', $urlParams) ?>"></i> 

                        <?php if (empty($_isGensoft)): ?>
                            <i class="cloneProduct btn-outline-success p-1 border-0 fa fa-copy" data-route="<?= route_to('Product__clone', $row['product_id']) ?>"></i>

                            <a  href="<?= route_to('Product__delete', $urlDelParams) ?>" onclick="javascript: return confirm('<?= lang('LANG__global.js.validate.confirm.delete') . $row['product_name'] ?>')">
                                <i class="btn-outline-danger p-1 border-0 fa fa-trash"></i>
                            </a>
                        <?php endif ?>

                        <?= ($_zenovaLista_id != '' ? '<div><button class="btn px-1 " data-toggle="jTippy" type="button" data-title="Този продукт присъства в следната ценова листа: ' . $_zenovaLista_name . '"><i class="fa fa-info-circle"></i></button></div>' : '') ?>
                    </div>
                </td>
            </tr>
        <?php } ?>
    </tbody> 
</table> 

<div class="d-flex col justify-content-between">
    <div>
        <span><?= lang('LANG__global.tbl.footer.total') ?></span> 
        <span class="countResults"><?= $countTotalProducts ?? '' ?></span>
        <span><?= lang('LANG__global.tbl.footer.records') ?></span>
    </div>
    <ul class="pagination">
        <?= $pagination ?? '' ?>
    </ul>
</div> 
