<!-- Sidebar (Form for New User) -->
<aside class="sidebar">
    <h5 class="section-title mb-4 mt-3">Нова група</h5>

    <form id="form-group" method="post" action="<?= route_to('Groups__save-group', 'null') ?>">

        <div class="mb-1">
            <label>Група</label>
            <b class="text-danger">*</b>

            <input class="form-control-sm" name="group_name" type="text">
        </div>

        <div class="mb-1">
            <label>Детайли</label>
            <input class="form-control-sm" name="description" type="text">
        </div>

        <button id="new" class="btn btn-primary btn-sm btn-block mt-3">
            <i class="p-1 border-0 fa fa-save"></i>Запис
        </button>
    </form>
</aside>

<div class="p-3 main-content">
    <ul class="breadcrum list-unstyled d-flex p-1">
        <li class="breadcrumb-item fa fa-home"></li>
        <li class="breadcrumb-item font-italic">Списъци</li>
        <li class="breadcrumb-item font-italic">Потребители</li>
        <li class="breadcrumb-item active">Потребителсли групи</li>
    </ul>

    <h1 class="section-title">Списък с потребителски групи</h1>

    <div id="reloadDiv">
        <table id="tbl_groups" class="table table-bordered table-sm my-2" cellspacing="0" width="100%" >
            <thead class="bg-dark">
                <tr>
                    <th></th>
                    <th><input id="filter-group" class="filter" name="group_name" type="text" placeholder="филтър"></th>
                    <th colspan="2"></th>
                </tr>

                <tr class="pointer-events-none">
                    <th class="w-01 text-center">#</th>
                    <th class="w-1"><?= lang('LANG__users.tbl.group.th.gr') ?></th>
                    <th class="w-2"><?= lang('LANG__users.tbl.group.th.detail') ?></th>
                    <th class="w-01"></th>
                </tr>
            </thead>

            <tbody>
                <?php
                foreach ($groups as $group) :
                    ?>
                    <tr data-id="<?= $group -> id ?>">
                        <td class="text-center"></td>

                        <td class="groups" data-name="group">
                            <input class="border-0"
                                   name="group_name"
                                   type="hidden"
                                   value="<?= $group -> name ?>">

                            <span><?= $group -> name ?></span>
                        </td>

                        <td>
                            <input class="border-0"
                                   name="description"
                                   type="hidden"
                                   value="<?= $group -> description ?>">

                            <span><?= $group -> description ?></span>
                        </td>

                        <td class="action text-center">
                            <?php if ($group -> id != 1) { ?>
                                <div class="btnGroup1 btn-group  btn-group-sm">

                                    <button type="button" class="edit btn p-0">
                                        <i class="btn-outline-primary p-1 border-0 fa fa-edit"></i>
                                    </button>

                                    <button type="button" class="btn p-0">
                                        <a href="<?= route_to('Groups__delete-group', $group -> id, $group -> name) ?>" onclick="javascript: return confirm('Сигурнили сте, че искате да изтриете група - <?= $group -> name ?>')">
                                            <i class="btn-outline-danger p-1 border-0 fa fa-trash"></i>
                                        </a>
                                    </button>
                                </div>

                                <div class="btnGroup2 btn-group btn-group-sm hide">
                                    <button type="button" class="save btn p-0" data-route="<?= route_to('Groups__save-group', $group -> id) ?>">
                                        <i class="btn-outline-primary p-1 border-0 fa fa-save"></i>
                                    </button>

                                    <button type="button" class="cansel btn p-0">
                                        <i class="btn-outline-secondary p-1 border-0 fa fa-reply-all"></i>
                                    </button>
                                </div>
                            <?php } ?> 
                        </td>
                    </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    </div>
</div>
