<section id="block-forms" class="hidden">
    <h2 class="section-title">Рестрикции на форма - <span id="headerTitle" class="akrobatBold"></span></h2>
    
    <h6 class="text-muted">Легенда: Ако съответните бутони са деактивирани, ще бъдат скрити за конкретната потребителска група.</h6>
    
    <br>
    <h6 class="text-muted border-bottom w-50">Достъп до главни бутони в header</h6>

    <?php
    $allowedBtns = [
        'save'          => ['label' => 'Запис', 'icon' => 'save'],
        'trash'         => ['label' => 'Изтриване', 'icon' => 'trash'],
        'print'         => ['label' => 'Предпечат', 'icon' => 'print'],
        'clone'         => ['label' => 'Клониране', 'icon' => 'clone'],
        'zenoobr'       => ['label' => 'Ценообразуване', 'icon' => 'dollar'],
        'site'          => ['label' => 'Сайтове', 'icon' => 'globe'],
        'prodIzbor'     => ['label' => 'Избор на продукт', 'icon' => 'book'],
        'zenListaIzbor' => ['label' => 'Ценова листа', 'icon' => 'list'],
        'newProd'       => ['label' => 'Нов продукт', 'icon' => 'plus'],
        'gensoftOrder'  => ['label' => 'Gensoft поръчка', 'icon' => 'refresh'],
        'return'        => ['label' => 'Връщане', 'icon' => 'refresh'],
        'tovaritelniza' => ['label' => 'Товарителница', 'icon' => 'file'],
    ];
    ?>

    <table id="tbl-forms" class="table-sm noRowColor">
        <thead>
            <tr class="noRowColor">
                <th> 
                    <button id="selectAllInForm" class="selectAll btn btn-sm px-2" type="button"><i class="fa fa-eye"></i>&nbsp;Избери всички</button>
                </th>
            </tr>
        </thead>

        <tbody>
            <?php foreach (session() -> get('selectForm') as $key => $name): ?>
                <tr class="d-flex hidden notAutoNum" data-form="<?= $key ?>">

                    <?php
                    foreach ($name['btns'] as $btnName):
                        $btnsData = $allowedBtns[$btnName] ?? null;

                        if ($btnsData):
                            $isChecked = $acl -> is_allowed($ctrl['selectedGroupId'], 'forms', "$key.deny_btnsInHeader", $btnName)
                            ?>
                            <td class="button-item text-center mr-2">
                                <i class="d-block fa fa-<?= $allowedBtns[$btnName]['icon'] ?>"></i> <?= $allowedBtns[$btnName]['label'] ?>

                                <br>

                                <label class="switch">
                                    <input class="module-inform"
                                           name="forms[<?= $key ?>][deny_btnsInHeader][]"
                                           type="checkbox"
                                           value="<?= $btnName ?>"
                                           <?= $isChecked ? 'checked' : '' ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</section>
