<?php

use Config\Paths;
use CodeIgniter\Config\DotEnv;

require_once dirname(__DIR__) . '/app/Config/Paths.php';

$paths = new \Config\Paths();

require_once rtrim($paths -> systemDirectory, '\\/') . DIRECTORY_SEPARATOR . 'bootstrap.php';

// Зареждаме .env
require_once SYSTEMPATH . 'Config/DotEnv.php';
(new DotEnv(ROOTPATH)) -> load();
// Зареждане на рутовете
if (!defined('APPPATH')) {
    define('APPPATH', $root . '/app/');
}require_once APPPATH . 'Config/Routes.php';
// Дефинираме среда
defined('ENVIRONMENT') || define('ENVIRONMENT', env('CI_ENVIRONMENT', 'development'));

// Зареждаме Kint само в development среда
if (ENVIRONMENT === 'development') {
    require_once SYSTEMPATH . 'ThirdParty/Kint/init.php';
    require_once SYSTEMPATH . 'ThirdParty/Kint/init_helpers.php';
}



// Тестваме route_to (примерно)
echo Kint::dump(route_to('FileManager-deleteFile'));
// Свързване към базата чрез CI4
$db      = \Config\Database::connect();
$builder = $db -> table('_category');

$mcats = $builder -> where('parent_id', null)
                -> orderBy('category_position', 'ASC')
                -> get() -> getResultArray();

$scats = $builder -> where('parent_id IS NOT NULL')
                -> orderBy('ISNULL(category_position)')
                -> orderBy('category_position', 'ASC')
                -> get() -> getResultArray();

//Kint::dump(route_to('FileManager-deleteFile'));
//Kint::dump($scats);
?>

<?php
//
// Рекурсивна функция за дървото (може да се сложи в helper или директно във view)
function renderSubCategories($categories, $parentId) {
    $out = '';
    foreach ($categories as $cat) {
        if ($cat['parent_id'] == $parentId) {
            $hasChildren = false;
            foreach ($categories as $c2) {
                if ($c2['parent_id'] == $cat['category_id']) {
                    $hasChildren = true;
                    break;
                }
            }

            $categoryId    = esc($cat['category_id']);
            $categoryTitle = esc($cat['category_name']);
            $iconFolder    = $hasChildren ? '<i class="fas fa-folder"></i>' : '';

            $out .= <<<HTML
                    <li class="category-li" data-id="{$categoryId}" data-title="{$categoryTitle}">
                      <div class="category-row d-flex align-items-center" data-id="{$categoryId}">
                        <span class="category-toggle mr-2">{$iconFolder}</span>
                        <span class="cat-title flex-fill">{$categoryTitle}</span>
                        <button class="btn btn-outline-success border-0 btn-sm btn-add mr-1"><i class="fas fa-plus"></i></button>
                        <button class="btn btn-outline-info border-0 btn-sm btn-edit mr-1"><i class="fas fa-edit"></i></button>
                        <button class="btn btn-outline-danger border-0 btn-sm btn-del mr-1"><i class="fas fa-trash"></i></button>
                         <span class="fa fa-arrows-alt handle mr-2" style="cursor:move"></span>
                      </div>
                    HTML;

            // Деца
            $children = renderSubCategories($categories, $cat['category_id']);
            if ($children)
                $out      .= '<ul class="category-tree">' . $children . '</ul>';
            $out      .= '</li>';
        }
    }
    return $out;
}
?>

<!DOCTYPE html>
<html lang="bg">
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
        <style>
            .sortable-placeholder { min-height:32px; background:#dbeafe;border:2px dashed #1976d2; margin:4px 0; border-radius:6px;}

            #mainCatList li.active {
                background: #1976d2;
                color: #fff;
                border-color: #1976d2;
                font-weight: bold;
            }
            #mainCatList .fa-star { color: #f9be00;}
            .category-tree { list-style: none; padding-left: 24px; margin-bottom:0; }
            li { margin-bottom: 4px; position:relative;}
            .category-row {
                display: flex; align-items: center; background: #f8f9fa; border-radius: 6px;
                padding: 7px 10px; gap: 8px; border: 1px solid #e3e6ea;
                transition: background .18s; margin-bottom:2px;
            }
            .category-row:hover { background: #eaf3fb;}
            .category-toggle { width:20px; color:#1976d2; cursor:pointer;}

            @media (max-width: 900px) {.category-tree{padding-left:10px;}}
        </style>
    </head>

    <body>
        <div class="container py-4">
            <div class="row">
                <!-- Лява колона: главни категории -->
                <div class="col-md-4 col-lg-3">

                    <div class="input-group mt-3">
                        <input type="text" id="newRootCat" class="form-control" placeholder="Нова главна категория...">
                        <div class="input-group-append">
                            <button class="btn btn-primary" id="addRootCatBtn"><i class="fas fa-plus"></i></button>
                        </div>
                    </div>
                    <br>

                    <ul id="mainCatList" class="treeview list-group">
                        <?php
                        foreach ($mcats as $row) :
                            $_isFull = in_array($row['category_id'], array_column($scats, 'parent_id')) ? 'full' : 'empty'
                            ?>
                            <li class="row" data-route="<?= route_to('POPup_category-reorder') ?>" data-id="<?= $row['category_id'] ?>" data-sub-id="<?= $row['category_id'] ?>" data-isroot="1" data-title="<?= $row['category_name'] ?>">
                                <span class="node-plus"></span>

                                <!-- местене на реда -->
                                <i class="fa fa-arrows p-1" title="преместване на реда на различна позиция"></i>


                                <label class="categoryName cat-title flex-fill"><?= $row['category_name'] ?></label>

                                <div class="btnGroup btn-group">
                                    <button class="edit btn btn-outline-info btn-sm btn-editRoot mr-1" data-route="<?= route_to('POPup_category-save', $row['category_id'], 'null') ?>" title="Редактирай"><i class="fas fa-edit"></i></button>

                                    <button class="delete btn btn-outline-danger btn-sm btn-delRoot" data-route="<?= route_to('POPup_category-delete', $row['category_id']) ?>" title="Изтрий"><i class="fas fa-trash"></i></button>
                                </div>
<?php endforeach ?>
                    </ul>
                </div>

                <!-- Дясна колона: подкатегории -->
                <div class="col-md-8 col-lg-9">
                    <div id="subTreeContainer">
                        <h5>Подкатегории на <span id="breadcrumbs" class="text-primary">
                                <?php
                                // по подразбиране избери първата главна
                                echo count($mcats) ? esc($mcats[0]['category_name']) : '';
                                ?>
                            </span></h5>

                        <!-- Дървото се дефинира тук! -->
                            <?php foreach ($mcats as $row): ?>
                            <ul class="category-tree ul-sortable" id="tree-<?= esc($row['category_id']) ?>" style="<?= $row === $mcats[0] ? '' : 'display:none' ?>">
                            <?= renderSubCategories($scats, $row['category_id']) ?>
                            </ul>
<?php endforeach ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bootstrap Modal за редакция -->
        <div id="editPopup" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header py-2">
                        <h6 class="modal-title mb-0">Редакция на категория</h6>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Затвори">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body py-2">
                        <input type="text" id="editCatInput" class="form-control">
                    </div>
                    <div class="modal-footer py-2">
                        <button id="saveEditCat" class="btn btn-success btn-sm">Запази</button>
                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Отказ</button>
                    </div>
                </div>
            </div>
        </div>

        <div id="popup_addSubCat" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <form id="addSubCatForm">
                    <div class="modal-content">
                        <div class="modal-header py-2">
                            <h6 class="modal-title mb-0">Нова подкатегория</h6>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Затвори">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body py-2">
                            <div id="popup_breadcrumbs" class="small text-muted mb-2"></div>

                            <input  id="name" name="title" class="form-control" data-parent-sub-id="" type="text" placeholder="Име на подкатегория..." >
                        </div>

                        <div class="modal-footer py-2">
                            <button id="addSubCat-new"  class="btn btn-success btn-sm" data-route="<?= route_to('POPup_category-save2', 'null', $row['category_id']) ?>" type="button">Добави</button>
                            <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Отказ</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>


        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
        <script src="https://cdn.jsdelivr.net/gh/ilikenwf/nestedSortable/jquery.mjs.nestedSortable.js"></script>


        <script src="public/cat.js"></script>

    </body>
</html>
