$(document).ready(function ( ) {

    // Set up axios defaults and interceptors
    axios.defaults.timeout = 1000;

    axios.interceptors.request.use(config => {
        config.headers['Authorization'] = `Bearer ${localStorage.getItem('access_token')}`;
        return config;
    }, err => Promise.reject(err));

    axios.interceptors.response.use(response => {
        return response;
    }, err => {
        const status = err.response ? err.response.status : 500;
        const statusMap = {
            401: 409,
            403: 409,
            400: 400,
            404: 404,
            409: 409,
            422: 422,
            500: 500
        };
        const errorCode = statusMap[status] || 500;
        return Promise.reject(new APIError(err.message, errorCode));
    });


    $(document).ajaxStart(function () {
        const fadeStyle = 'position: fixed; background: black; width: 100%; height: 100%; opacity: 0.5; top: 0; z-index: 100000000; left: 0;';
        const imgStyle = 'position: fixed; z-index: 100000001; top: 45%; left: 45%;';
        const loaderHtml = `
            <div id="ajaxFade" style="${fadeStyle}"></div>
            <div id="ajaxLoader">
                <div style="${imgStyle}">
                    <img src="/assets/plugins/loader/loader.gif" alt="Loading..." />
                    <div id="progress" style="background:#5fe457;text-align:center;color:#000;font-weight: bold;"></div>
                    <div><button onclick="$.ajaxQ.abortAll()">Refresh</button></div>
                </div>
            </div>
        `;
        $('body').append(loaderHtml);
    });

    $.ajaxSetup({
        //timeout: 2000,
        retries: 2,
        retryInterval: 1000,
        cache: false,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf_test_name"]').attr('content')},
        beforeSend: function (xhr) {
            // xhr.setRequestHeader('X-CSRF-Token', $('meta[name="csrf_test_name"]').attr('content'));
        },
        xhr: function ( ) {

            var jqXHR = null;
            if (window.ActiveXObject)
            {
                jqXHR = new window.ActiveXObject("Microsoft.XMLHTTP");
            }
            else
            {
                jqXHR = new window.XMLHttpRequest( );
            }

            //Upload progress
            jqXHR.upload.addEventListener("progress", updateProgress, false);
            jqXHR.addEventListener("progress", updateProgress, false);
            return jqXHR;
        }
    }
    );

    // Handle AJAX progress
    function updateProgress (evt) {
        if (evt.lengthComputable) {
            const percentComplete = Math.round(( evt.loaded * 100 ) / evt.total);
            $('#ajaxLoader #progress').text(`Прогрес: ${percentComplete} %`);
        }
    }

    // ръчно абортране на заявка
    $.ajaxQ = ( function () {
        let id = 0, Q = {};

        $(document).ajaxSend((e, jqx) => {
            jqx._id = ++id;
            Q[jqx._id] = jqx;
        });

        $(document).ajaxComplete((e, jqx) => delete Q[jqx._id]);

        return {
            abortAll: function () {
                $.each(Q, function (i, jqx) {
                    jqx.abort();
                });
                $('#ajaxLoader, #ajaxFade').remove();
            }
        };
    } )();

    $(document).ajaxSuccess(function () {
        $('#ajaxLoader, #ajaxFade').remove();
    });

    $(document).ajaxError(function (event, xhr, error) {
        $('#ajaxLoader,#ajaxFade').remove();
        event.stopImmediatePropagation();

        // когато дру потребител премахне ръчно сесията за закл оферта
        if (xhr.status === 410) {
            let responseText = xhr.responseText;

            this.retries = 0;
            alert('⚠ Друг потребител премахна вашата сесия! Ще бъдете пренасочени към началната страницата.');
            window.location.replace('/');
        }
        if (xhr.status === 400) {
            this.retries = 0;
            alert('Логин сесията изтече! Ще бъдете пренасочени към login страницата.');
            window.location.replace('/');
        }
        if (xhr.status === 500) {

            //$('input[type=checkbox]').prop('checked', false);
            let responseText = xhr.responseText;
            let pattern = /\[internal function\]:(.*?)(?=\[|$)/g;
            let matches = [ ];
            let match;

            while (match = pattern.exec(responseText)) {
                matches.push(match[1].trim());
            }

            let response = xhr.responseJSON || {};

            let message = response.message || ( responseText.includes('Fatal error') ? 'Транзакцията се провали.' : ( responseText.startsWith('message') ? responseText : '' ) ) || 'Непозната грешка';
            const trace = response.trace && response.trace[0] ? response.trace[0].args || [ ] : [ ];
            const traceArg0 = trace[0] || ( matches.length > 0 ? matches : '' ) || 'No trace data available';
            let traceArg1Err = 'No error details';

            if (trace[1]) {
                traceArg1Err = trace[1].err || trace[1];
            }

            match = xhr.responseText.match(/\{[^{}]*(\{[^{}]*\}[^{}]*)*\}/);
            if (match) {

                try {
                    response = JSON.parse(match[0]);

                    if (typeof response === 'object' && response !== null && 'message' in response) {
                        message = response.message;
                    }

                } catch (e) {
                    console.warn('JSON parsing failed:', e);
                }
            }

            const errorMessage = `Статус грешка код = ${xhr.status}\n${message}\n\nDebugger:\n${traceArg0}\n${traceArg1Err}`;

            this.retries = 0;
            alert(errorMessage.trim());
        }
    });

    function getCookie (name) {
        const cookies = document.cookie.split(';').map(cookie => cookie.trim());
        console.log(document.cookie);
        const cookie = cookies.find(cookie => cookie.startsWith(name + '='));
        return cookie ? decodeURIComponent(cookie.split('=')[1]) : null;
    }
});

// времезакъснение
function timeOut (func, wait, immediate) {
    var timeout;
    return function () {
        var context = this, args = arguments;
        var later = function () {
            timeout = null;
            if (!immediate)
                func.apply(context, args);
        };
        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        if (callNow)
            func.apply(context, args);
    };
}
;
