
var dropdown = ( () => {
    let vd = {};
    const self = {
        'initialized': false,
        '__var' () {
            vd.$modal = $('.modal');
            vd.$tabProperty = $('#tabProperty');
            vd.$tabOsnovniDani = $('#tabOsnovniDani');
            vd.$listHXbox = $('.hx-box');
            vd.hx_box = '.hx-box';
        },

        'init' (force = false ) {

            if (self.initialized && !force)
                return;

            self.initialized = true;
            self.__var();  // Създава или обновява DOM референции динамично
            self.setUpListeners();
        },

        'setUpListeners' () {
            const NS = 'dropdown';
            const sel = vd.hx_box;
            const ev = (type, target) => [ `${type}.${NS}`, `${sel} ${target}` ];

            $(document).off('htmx:afterSwap').on('htmx:afterSwap', (event) => {
                self.init(true);

                // филтрираш само swap-овете, които те интересуват
                if ($(event.target).is(vd.$tabProperty)) {
                    Lp.count_validate_chk_productAttr(vd.$modal);

                    const subCat = vd.$modal.find('select.subcatGroup.active option:selected');
                    vd.$tabProperty.find('#properyName').text(subCat.text().trim());
                }
            });

            vd.$modal.off(`.${NS}`)
                    // --- Change events ---
                    .on(`change.${NS}`, `${sel} ul li[data-tip="modelAddt"] input[type="checkbox"]`, this.ev.setMultiModels)

                    // --- Click events ---
                    .on(`mousedown.${NS}`, this.ev.closeListbox)
                    .on(...ev('click', 'li label'), this.ev.selectItem)
                    .on(...ev('click', '.js-toggleCheckbox'), this.ev.toggleCheckboxes)
                    .on(...ev('click', '#insert'), this.ev.insert)
                    .on(...ev('click', 'li .edit'), this.ev.edit)
                    .on(...ev('click', 'li .delete'), this.ev.delete);
        },

        'ev': {

            'closeListbox' (e) {
                if (!$(e.target).closest(vd.hx_box).length) {
                    vd.$modal.find('.productAttrText').css({border: '1px dashed blue'});
                    vd.$modal.find(vd.hx_box).empty();
                    window.doomEditActive = false;
                }
            },

            // селектиране и ресет на всички отметки за доп модели
            'toggleCheckboxes' (e) {
                const route = $(this).data('route');
                const firstModelId = vd.$tabOsnovniDani.find('#brand_model_id').val();
                const state = $(e.currentTarget).data('check') === 1 ? 1 : 0;
                const checkboxes = vd.$listHXbox.find('ul li input[type="checkbox"]');
                let countSelectedModelsAddt = vd.$tabOsnovniDani.find('#js-countSelectedModelsAddt');
                const productId = vd.$modal.find('#productId2').val();
                let changedValues = [ ];
                let shouldChange;

                if (!confirm('Сигурни ли сте, че искате да ' + ( state ? 'добавите' : 'премахнете' ) + ' всички избрани допълнителни модели?')) {
                    return false;
                }

                checkboxes.each(function () {
                    shouldChange = ( state === 1 && !this.checked ) || ( state === 0 && this.checked );
                    if (!shouldChange)
                        return;

                    this.checked = !!state;// пропуска вече отметнатите
                    changedValues.push(this.value);
                });

                $.ajax({
                    global: false,
                    url: route,
                    method: 'POST',
                    data: {'productId': productId, 'firstModelId': firstModelId, 'modelAdditId': changedValues, 'isChecked': state},
                    dataType: 'json',
                    success (response) {
                        countSelectedModelsAddt.text(state ? changedValues.length : 0);
                        alert('Избраните модели са ' + ( state ? 'добавени' : 'премахнати' ));
                        console.log(state ? 'Маркирани ids:' : 'Ресетнати ids:', changedValues);
                    }
                });
            },

            // присвояване на мулти модели към главния избран модел 
            'setMultiModels' (e) {
                e.stopImmediatePropagation();
                const el = $(e.currentTarget);
                const li = el.closest('li');
                const route = li.data('route');
                const productId = vd.$modal.find('#productId2').val();
                const isChecked = el.is(':checked') ? 1 : 0;
                const checkedLen = li.closest('ul').find('input[type="checkbox"]:checked').length;
                const firstModelId = vd.$tabOsnovniDani.find('#brand_model_id').val()
                const countSelectedModelsAddt = vd.$tabOsnovniDani.find('#js-countSelectedModelsAddt');
                const tip = li.data('tip') || '';
                const id = el.val();
                console.log(checkedLen);
                $.ajax({
                    global: false,
                    url: route,
                    method: 'POST',
                    data: {'productId': productId, 'firstModelId': firstModelId, 'modelAdditId': id, 'isChecked': isChecked},
                    dataType: 'json',
                    success (response) {
                        countSelectedModelsAddt.text(checkedLen);
                    }
                });
            },

            'selectItem' (e) {
                e.stopImmediatePropagation();
                const el = $(e.currentTarget);
                const li = el.closest('li');
                const tip = li.data('tip') || '';
                const payload = {
                    li: li.parents('li'),
                    tip,
                    isEmpty: li.data('empty') || 0,
                    route: li.data('route'),
                    id: li.data('id') || '',
                    text: el.text(),
                    image: li.attr('data-image-path') || ''
                };
                const fn = self.actionsSelect[tip];

                if (typeof fn === 'function') {
                    fn(payload);
                }

                if (tip !== 'modelAddt') {
                    self.ev.closeListbox(self);
                }
            },

            'insert' (e) {
                e.stopImmediatePropagation();
                const _this = $(e.currentTarget);
                const dataAttr = JSON.parse(_this.attr('data-attr'));
                const {tip, route, routeRefresh} = dataAttr;
                const listbox = _this.closest('#listbox');
                const val = _this.parent().find('#search-local').val();
                const productId = vd.$modal.find('#productId2').val();
                const attr = _this.closest('li').find('.productAttrText');
                const tipMap = {
                    prodCharValues: 'нова характеристика',
                    brand: 'нова марка',
                    model: 'нов модел'
                };
                const arr = {tip, name: val};
                const $ul = listbox.find('ul');
                const exists = $ul.find('li:not(:first)').filter((_, li) =>
                    $(li).text().trim().toLowerCase() === val.toLowerCase()
                ).length;

                if (!val)
                    return alert('Въведете име.');

                if (exists)
                    return alert(`Това име - ${val} вече съществува.`);

                if (!confirm(`Сигурни ли сте, че искате да запишете ${tipMap[tip] || ''} "${val}"?`))
                    return;

                if ([ 'model', 'modelYear', 'modelKupe' ].includes(tip)) {
                    arr.brandId = vd.$tabOsnovniDani.find('#brandId').val();
                    arr.firstModelId = vd.$tabOsnovniDani.find('#brand_model_id').val();
                }
                else if (tip === 'prodCharValues') {
                    arr.productId = productId;
                    arr.var = attr.data() || {};
                }

                self.ajax.send('insert', arr, route, {
                    'searchText': val,
                    routeRefresh,
                    'htmx': {target: `#${listbox.attr('id')}`}
                });
            },

            'edit' (e) {
                e.stopImmediatePropagation();
                const _this = $(e.currentTarget);
                const dataAttr = JSON.parse(_this.attr('data-attr'));
                const {route, tip} = dataAttr;
                const btnGroup = _this.parent();
                const li = _this.closest('li');
                const id = li.data('id');
                const label = li.find('label');
                const role = _this.closest('[data-role]').attr('data-role') || '';
                const curentTarget = vd.$modal.find(`[data-role="${role}"]`);

                btnGroup.hide();

                Lp.loadDoomEdit({
                    el: label,
                    route,
                    form_class: 'd-flex w-100',
                    action: 'edit',
                    btnGroup,
                    name: 'name',
                    extraFields: {tip, 'primaryId': id},
                    callback (response) {
                        if (response === 'false')
                            return false;

                        const curentProductAttr = _this.closest('.cell-prodAttr').find('.productAttrText');
                        if (curentTarget.find('.hiddenId').val() == li.data('id')) {
                            curentTarget.find('.dropdownBtn').text(label.text());
                        }

                        // Намери всички, където ID-то съвпада
                        vd.$tabProperty.find('.cell-prodAttr .productAttrText').filter(function () {
                            return $(this).data('prod-charvalue-id') == li.data('id');
                        }).text(label.text());

                    },
                });
            },

            'delete' (e) {
                e.stopImmediatePropagation();
                const _this = $(this);
                const dataAttr = JSON.parse(_this.attr('data-attr'));
                const listbox = _this.closest('#listbox');
                const li = _this.closest('li');
                const id = li.data('id');
                const label = li.find('label').text();
                const {route, tip} = dataAttr;

                if (!confirm('Сигурни ли сте че искате да изтриете ' + label))
                    return false;

                self.ajax.send('delete', {'name': label, id, tip}, route, [ li ]);
            }
        },

        // ---------------- ACTIONS ----------------
        'actionsSelect': {
            'brand' (p) {
                const $tab = vd.$tabOsnovniDani;
                const modelToBrand = $tab.find('#isModelToBrand').val();
                const $imgRow = $tab.find('#brandModelImgRow');
                const $brandImg = $imgRow.find('[data-role="_brand"]');
                const $camera = $imgRow.find('.camera');
                const hasImage = !!p.image;
                const imageSrc = hasImage ? GLOBVAR.productImageBaseDir + p.image : '';

                // ако сменим марката
                if (modelToBrand) {
                    $tab.find('.productModel, .model, .customDropdown').text('').val('');
                    $tab.find('#js-btn-modelAddt').prop('disabled', true);
                }

                $imgRow.find('img').attr('src', '');
                $imgRow.find('.avatar').val('');
                $camera.addClass('fa-camera w-100 m-auto');

                $tab.find('#brandId').val(p.id);
                $tab.find('#brand-name').text(p.text);

                $brandImg.find('img').attr('src', imageSrc).toggleClass('w-50px', hasImage);
                $brandImg.find('.camera').toggleClass('fa-camera w-100 m-auto', !hasImage);
            },

            'model': p => self.actionsSelect.setModel(p, 'model'),
            'model2': p => self.actionsSelect.setModel(p, 'model2'),
            'model3': p => self.actionsSelect.setModel(p, 'model3'),
            'modelYear': p => self.actionsSelect.setModelOptions(p, 'modelYear'),
            'modelKupe': p => self.actionsSelect.setModelOptions(p, 'modelKupe'),

            'setModel' (p, role) {
                const $tab = vd.$tabOsnovniDani;
                const modelToBrand = $tab.find('#isModelToBrand').val();
                const imageRow = $tab.find('#brandModelImgRow [data-role="_models"]');
                const img = imageRow.find('img');
                const hasImage = !!p.image;
                const imageSrc = hasImage ? GLOBVAR.productImageBaseDir + p.image : '';
                const camera = imageRow.find('.camera');
                let countSelectedModelsAddt = parseInt($tab.find('#js-countSelectedModelsAddt').text()) || 0;

                if (role === 'model') {
                    if (countSelectedModelsAddt > 0) {
                        alert('Имате допълнителни модели за избрнаия главен модел.Преди да смените главния модел нулирайте допъл. модели.');
                        return false;
                    }

                    $tab.find('#js-btn-modelAddt').prop('disabled', p.isEmpty);

                    $tab.find('.model').val('');
                    img.attr('src', imageSrc).toggleClass('w-50px', hasImage);
                    camera.toggleClass('fa-camera w-100 m-auto', !hasImage);
                }

                $tab.find('.productModel').text(p.text);
                $tab.find('#brand_model_id').val(p.id);
                $tab.find('.model').val(p.id);

                if (modelToBrand) {
                    $tab.find('.customDropdown').text('').val('');
                }
            },

            'setModelOptions' (p, role) {
                $(`#${role}-id`).val(p.id);
                $(`#${role}-name`).text(p.text);
            },

            'prodCharValues' (p) {
                const attrText = p.li.find('.productAttrText');
                const match = vd.$tabProperty.find('.productAttrText').filter(function () {
                    return $(this).data('prod-charvalue-id') == p.id;
                });

                if (match.length) {
                    const name = match.closest('li').find('.categoryAttrName').text();
                    if (!p.isEmpty && !confirm(`Тази опция вече е присвоена на- ${name}. Продължавате ли?`))
                        return;
                }

                Object.assign(attrText.data(), {tip: p.tip});
                self.ajax.send('select', attrText.data(), p.route);
            }
        },

        // ---------------- AJAX ----------------
        'ajax': {
            'send' (action, data, route, extra = {} ) {
                $.ajax({
                    url: route,
                    method: 'POST',
                    data: {action, ...data},
                    dataType: 'json',
                    success (response) {
                        const $tp = vd.$tabProperty;
                        const routeRefresh = $tp.find('#createCategoryAttr').data('routeRefresh');
                        const subCat = vd.$modal.find('select.subcatGroup.active option:selected');
                        const subCatId = subCat.val();

                        if (response.err)
                            return alert(response.err);

                        switch (action) {
                            case 'insert':
                                if (data.tip == 'prodCharValues') {
                                    Lp.htmxReloadPage(routeRefresh, {target: '#tabProperty', subCatId});
                                }
                                else if (data.tip == 'brand') {
                                    vd.$modal.find('#brand-name').trigger('click').text(data.name);
                                    vd.$tabOsnovniDani.find('#brandId').val(response);
                                }
                                else if (data.tip == 'model') {
                                    vd.$modal.find('.productModel:first').trigger('click').text(data.name);
                                    vd.$tabOsnovniDani.find('#brand_model_id, .modelAdditId').val(response);
                                }
                                else if ([ 'modelYear', 'modelKupe' ].includes(data.tip)) {
                                    vd.$tabOsnovniDani.find(`#${data.tip}-name`).trigger('click').text(data.name);
                                    vd.$tabOsnovniDani.find(`#${data.tip}-id`).val(response);
                                }
                                break;
                            case 'select':
                                if (data.tip == 'prodCharValues')
                                    Lp.htmxReloadPage(routeRefresh, {target: '#tabProperty', subCatId});
                                break;
                            case 'delete':
                                if (data.tip == 'prodCharValues') {
                                    Lp.htmxReloadPage(routeRefresh, {target: '#tabProperty', subCatId});
                                }

                                if (!Array.isArray(extra) || !extra[0]) {
                                    break;
                                }

                                const $el = extra[0];
                                const role = $el.closest('[data-role]').attr('data-role') || '';
                                const target = vd.$modal.find(`[data-role="${role}"]`);
                                const productAttr = target.find('.cell-prodAttr .productAttrText');

                                if (target.find('.hiddenId').val() == $el.data('id')) {
                                    target.find('.dropdownBtn, .hiddenId').text('').val('');
                                }

                                if (productAttr.attr('data-prod-charvalue-id') == $el.data('id')) {
                                    productAttr.text('');
                                }

                                $el.remove();
                                break;
                        }
                    }
                });
            }
        }
    };
    return self;
} )();
