/* global loadPlugins, SETTINGS_NUM_FIXED  */
( function ($, window, document) {

    let self = klient_modify_inOfer;

    var klient_modify_inOfer = klient_modify_inOfer || {};

    $('#leftAside #klient_block').dontJustLeaveMe('#edit_klient');

    klient_modify_inOfer = {

        'init': function () {
            self = this;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;
        },

        'setUpListeners': function ( ) {
            $(document).on('click', '#edit_klient,#new_klient', this.modal.open_popup_klient);

            // EVENTS
            $(document)
                    // --- in left aside
                    .on('keyup', '[data-klient-autocomplete]', Lp.debounce(this.event.leftAside.klient_autocomplete, 500));

            // BUTONS
            $(document).find('#leftAside')
                    //.on('click', '#new_klient', this.btn.leftAside.new_klient)
                    // .on('click', '#insert_klient', this.btn.leftAside.insert_klient)
                    //.on('click', '#edit_klient, #ok_klient', this.btn.leftAside.edit_klient)
                    //.on('click', '#cansel_klient', this.btn.leftAside.cansel_klient)
                    .on('click', '#clear_klient', this.btn.leftAside.clear_klient);
        },

        'modal': {
            'open_popup_klient': function () {
                if ($(this).attr('id') == 'edit_klient') {
                    let klientName = $('#leftAside #klient_block').find('#klient_name').val();

                    if (klientName == '') {
                        alert('Редакцията на клиент ще бъде активна след, като е избран клиент.');
                        return false;
                    }
                }

                Lp.ajax_modalFormOpen({'route': $(this).attr('data-route'), 'ajaxType': 'GET'});
            }
        },

        'event': {
            'leftAside': {
                'klient_autocomplete': function (e) {
                    e.stopImmediatePropagation();

                    const _this = $(this);
                    const searchParams = new URLSearchParams(window.location.search);
                    var inputWidth = _this.outerWidth();
                    let $_klient_block = $('#leftAside #klient_block');
                    let $_autocomplete = $('.autocomplete');
                    let $_leftAside = $('#leftAside');
                    let $_deliveryInfo = $('#deliveryObekt-block');
                    let $_customerInfo = $('#customerInfo');
                    let gensoftLogo = $_customerInfo.find('#isGensoftKlient');
                    let prevozvach = $('#leftAside #prevozvach');

                    let arr;
                    let deliveryJson = [ ];
                    let keycode = ( e.keyCode ? e.keyCode : e.which );

                    if ([ 40, 38, 13, 37, 39, 18, 16 ].includes(keycode)) {
                        return false;
                    }

                    $_leftAside.find('input[type=hidden]').val('');
                    $_customerInfo.find('select,input').val('');

                    // ако input полето е празно
                    if ($(this).val().length == 0) {
                        $_autocomplete.empty();
                        $_deliveryInfo.addClass('hide');
                        gensoftLogo.addClass('hide');
                        return false;
                    }

                    $.ajax({
                        url: _this.attr('data-route'),
                        type: "GET",
                        data: {'text': _this.val().trim()},
                        dataType: 'json',
                        beforeSend: function (xhr) {
                            _this.addClass('Spiner_loading');
                        },
                        success: function (response)
                        {
                            arr = [ ];
                            $('.Spiner_loading').removeClass('Spiner_loading');

                            $.each(response, function (index, value) {
                                let gensoftIimg = '';
                                let myObj = JSON.stringify({
                                    'gensoft_firm_id': value['gensoft_firm_id'],
                                    'klient_id': value['klient_id'],
                                    'mol': value['klient_mol'],
                                    'klient_grad': value['klient_grad'],
                                    'postCode': value['klient_postCode'],
                                    'tel': value['klient_tel'],
                                    'adres': value['klient_adres'],
                                    'klient_country': value['klient_country']
                                });

                                if ($.isNumeric(value['gensoft_firm_id'])) {
                                    gensoftIimg = `<img class='w-13 mr-1' src='${gensoftLogo.find('img').attr('src')}'>`;
                                }

                                deliveryJson[value['klient_id']] = value['klient_obekt_json'];
                                arr.push(`<li data-info='${myObj}'>${gensoftIimg} ${value['klient_name']}</li>`);
                            });

                            $_autocomplete.html(`<div class="triangle"></div><ul style="width: ${inputWidth}px;"></ul>`);
                            $_autocomplete.find('.triangle').css({'top': _this.position().top + 'px'});

                            if (arr.length > 0) {
                                $_autocomplete.find('ul').html(arr.join(''));
                            }
                            else {
                                $_autocomplete.find('ul').html('<li>Няма намерени резултати</li>');
                            }

                            // когато изберем клиент от списъка autocomplete
                            $_autocomplete.find('ul').on('mousedown', 'li', function () {
                                // проверка дали клиента е от Gensoft
                                let dataInfo = $(this).data('info');
                                let isNumericGensoftFirmId = $.isNumeric(dataInfo.gensoft_firm_id);
                                var deliveryJson_decoded = $.parseJSON(deliveryJson[dataInfo.klient_id]);

                                $(e.target).val($(this).text().trim());

                                $_leftAside.find('#klient_block .klientId').val(dataInfo.klient_id);
                                $_leftAside.find('#klient_block #edit_klient')
                                        .attr('data-route', function (index, value) {
                                            return value.replace(/\/([^\/]+)$/, '/' + dataInfo.klient_id);
                                        });

                                $_customerInfo.find('#klient_mol').text(dataInfo.mol);
                                $_customerInfo.find('#klient_adres').text(dataInfo.adres);
                                $_customerInfo.find('#klient_grad').text(dataInfo.klient_grad);
                                $_customerInfo.find('#klient_postCode').text(dataInfo.postCode);
                                $_customerInfo.find('#klient_tel').text(dataInfo.tel);
                                $_customerInfo.find('#klient_country').text(dataInfo.klient_country);
                                gensoftLogo.toggleClass('hide', !isNumericGensoftFirmId);

                                $_deliveryInfo.removeClass('hide');
                                $_deliveryInfo.find(':input').not('#paymentMethod').val('');

                                //$_klient_block.find('#klientActionBtns').toggleClass('hide', isNumericGensoftFirmId);

                                // ако има обект за доставка
                                if (searchParams.get('orderTip')) {

                                    let deliveryData = $_deliveryInfo.find('#deliveryData');
                                    let imgElement = $_deliveryInfo.find('#curierLogo');
                                    let deliveryRoute = $_deliveryInfo.find('#izbor-klientObekt').data('route');
                                    let dRsegments = deliveryRoute.split('/');
                                    dRsegments[dRsegments.length - 1] = dataInfo.klient_id;
                                    let mdRroute = dRsegments.join('/');
                                    let kurierMapping = {
                                        'speedy_machina': 'до автомат на Speedy',
                                        'speedy_office': 'до офис с Speedy',
                                        'speedy_door': 'до адрес с Speedy',
                                        'econt_machina': 'до еконтомат с Еконт',
                                        'econt_office': 'до офис с Еконт',
                                        'econt_door': 'до адрес с Еконт'
                                    };
                                    let cleanedValue = {};

                                    //deliveryData.toggleClass('hide', $this.val() !== 'curier').find(':input').val('');

                                    imgElement.attr('src', '');

                                    $_deliveryInfo.find('#izbor-klientObekt').data('route', mdRroute).attr('data-route', mdRroute);

                                    prevozvach.addClass('hide');

                                    $.each(deliveryJson_decoded, function (index, value) {
                                        // извлича се само основният обект
                                        if (value.default) {
                                            $.each(value, function (key, val) {

                                                if (key === 'default')
                                                    return;

                                                // Пропускай празни стойности
                                                if (val === null || val === undefined || ( typeof val === 'string' && val.trim() == '' )) {
                                                    return; // пропусни този ключ
                                                }

                                                if (key == 'deliveryMetod' && val == 'curier') {
                                                    deliveryData.removeClass('hide');
                                                }
                                                else if (key == 'deliveryMetod' && val != 'curier') {
                                                    prevozvach.removeClass('hide');
                                                }

                                                if (typeof val === 'string') {
                                                    if (val.includes('econt')) {
                                                        imgElement.attr('src', '/assets/images/curier/EcontLogo.png');
                                                    }
                                                    else if (val.includes('speedy')) {
                                                        imgElement.attr('src', '/assets/images/curier/SpeedyLogo.png');
                                                    }
                                                }

                                                cleanedValue[key] = val;

                                                $_deliveryInfo.find(`#${key}`).val(kurierMapping[val] || val);
                                            });

                                            $_deliveryInfo.find('#deliveryObekt').val(JSON.stringify(cleanedValue));
                                        }
                                    });
                                }

                                $_autocomplete.empty();
                            });
                        }
                    });

                    $(e.target).blur(function () {
                        $_autocomplete.empty();// премахване на autocomplete списъка
                    });
                }
            }
        },

        'btn': {
            'leftAside': {

                'localStorage': function (arg, action, data) {
                    var backupStorage = [ ];

                    if (arg == 'set') {
                        data.not('input[type=hidden]').each(function (ind, input) {

                            backupStorage.push({
                                'val': input.value, // value на input полето 
                                'inp_id': input.id // id - klient_mol на input полето 
                            });
                        });

                        localStorage.setItem('user-info', JSON.stringify(backupStorage));
                    }
                    else if (arg == 'get') {
                        $.each(JSON.parse(localStorage.getItem('user-info')), function (ind, value) {
                            data.find('input#' + value.inp_id + ',select#' + value.inp_id).val(value.val);
                        });

                        action == 'cansel' ? localStorage.removeItem('user-info') : '';
                    }

                    event.stopImmediatePropagation();
                },

                'new_klient': function (e) {
                    e.stopImmediatePropagation();

                    var _this = $(this);
                    var route = _this.data('route');
                    var klient_block = $('#leftAside #klient_block');
                    var customerInfo = klient_block.find('#customerInfo');
                    var userInfo = customerInfo.find('input, select');
                    var customerLabelNew = klient_block.find('#customerLabelNew');//етикет за редакция или нов
                    var klientName = klient_block.find('#klient_name');

                    klientName.removeAttr('data-klient-autocomplete');

                    $('button, select, input, a').css({'pointer-events': 'none'});

                    klient_block.find('input:not(input[name="order[klient_id]"])').attr('value', '').val('');
                    klient_block.find('button,input,select').css({'pointer-events': ''});
                    userInfo.removeClass('css-pointer-events-none2');
                    customerInfo.removeClass('css-pointer-events-none2');
                    customerLabelNew.removeClass('hide');

                    _this.parent().addClass('hide');
                    klient_block.find('#btnGroup3').removeClass('hide');

                    //  за клиент ако се кликне извън полето клиент
                    $(document).on('click', function (e) {
                        if (klient_block.find('#save_klient').is(":visible") || klient_block.find('#insert_klient').is(":visible") && !$(e.target).closest('#leftAside div#klient_block').length) {
                            alert(LANG__global.loadPlugins.alert.errorNewKlient);
                            e.stopImmediatePropagation();
                            return false;
                        }
                    });
                },

                'insert_klient': function (e) {
                    e.stopImmediatePropagation();

                    var _this = $(this);
                    var route = _this.data('route');
                    var klient_block = $('#leftAside #klient_block');
                    var customerInfo = klient_block.find('#customerInfo');
                    var userInfo = customerInfo.find('input, select');
                    var customerLabelNew = klient_block.find('#customerLabelNew');//етикет за редакция или нов
                    var klientName = klient_block.find('#klient_name');

                    //ако е натиснат бутона добави нов клиент
                    if (klient_block.find('#klient_name').val() == '') {
                        alert(LANG__global.loadPlugins.alert.errorNameKlient);
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'klient': $('#leftAside #klient_block').find('input ,select').serializeJSON()},
                        success: function (lastId)
                        {
                            // ako този клиент съществува
                            if (lastId == 'null') {
                                alert(LANG__global.loadPlugins.alert.existKlient);
                            }
                            else {
                                klientName.attr('data-klient-autocomplete', '');
                                klient_block.find('input[name="user[klient_id]"]').attr('value', lastId);
                                klient_block.find('input[name="special[klient_id]"]').attr('value', lastId);

                                klient_block.find('#btnGroup1').removeClass('hide');
                                userInfo.addClass('css-pointer-events-none2');
                                customerLabelNew.addClass('hide');

                                _this.parent().addClass('hide');
                                $('button, select, input, a').css({'pointer-events': ''});

                                alert(LANG__global.loadPlugins.alert.saveNеwKlient);
                            }
                        }
                    });

                },

                'edit_klient': function (e) {
                    e.stopImmediatePropagation();

                    var _this = $(this);
                    var route = _this.data('route');
                    var klient_block = $('#leftAside #klient_block');
                    var userInfo = klient_block.find('input:not(#klient_name), select');
                    var customerInfo = klient_block.find('#customerInfo');
                    var customerLabelEdit = klient_block.find('#customerLabelEdit');//етикет за редакция или нов
                    var klientName = klient_block.find('#klient_name');

                    klientName.removeAttr('data-klient-autocomplete');
                    $('button, select, input, a:not([href="#clear"])').css({'pointer-events': 'none'});
                    klient_block.find('button,input,select').css({'pointer-events': ''});
                    userInfo.removeClass('css-pointer-events-none2');
                    customerInfo.removeClass('css-pointer-events-none2');
                    customerLabelEdit.removeClass('hide');

                    _this.parent().addClass('hide');
                    klient_block.find('#btnGroup2').removeClass('hide');

                    //  за клиент ако се кликне извън полето клиент
                    $(document).on('click', function (e) {
                        if (( klient_block.find('#save_klient').is(":visible") || klient_block.find('#ok_klient').is(":visible") ) && !$(e.target).closest('#leftAside div#klient_block').length) {
                            alert(LANG__global.loadPlugins.alert.errorKlient);
                            e.stopImmediatePropagation();
                            return false;
                        }
                    });

                    //ако е натиснат бутона добави нов клиент
                    if (_this.attr('id') == 'ok_klient') {

                        if (klientName.val() == '') {
                            alert(LANG__global.loadPlugins.alert.errorNameKlient);
                            return false;
                        }

                        $.ajax({
                            url: route,
                            type: 'POST',
                            data: {'klient': $('#leftAside #klient_block').find('input ,select').serializeJSON()},
                            success: function ()
                            {
                                localStorage.removeItem('user-info');

                                klientName.attr('data-klient-autocomplete', '');
                                klient_block.find('#btnGroup1').removeClass('hide');
                                userInfo.addClass('css-pointer-events-none2');
                                customerLabelEdit.addClass('hide');

                                _this.parent().addClass('hide');
                                $('button, select, input,a ').css({'pointer-events': ''});

                                alert(LANG__global.loadPlugins.alert.okKlient);
                            }
                        });
                    }
                    else {
                        self.btn.leftAside.localStorage('set', null, userInfo); // localStorage set
                    }
                },

                'cansel_klient': function (e) {
                    e.stopImmediatePropagation();

                    var _this = $(this);

                    var klient_block = $('#leftAside #klient_block');

                    var customerInfo = klient_block.find('#customerInfo');
                    var userInfo = customerInfo.find('input, select');
                    var customerLabelNew = klient_block.find('#customerLabelNew');
                    var customerLabelEdit = klient_block.find('#customerLabelEdit');
                    var klientName = klient_block.find('#klient_name');

                    klientName.attr('data-klient-autocomplete', '');
                    if (klient_block.find('#insert_klient').is(":visible")) {
                        klientName.val('');
                    }

                    $('button, select, input, a').css({'pointer-events': ''});
                    userInfo.addClass('css-pointer-events-none2');
                    customerLabelNew.addClass('hide');
                    customerLabelEdit.addClass('hide');

                    klient_block.find('#btnGroup1').removeClass('hide');
                    _this.parent().addClass('hide');

                    self.btn.leftAside.localStorage('get', 'cansel', klient_block);
                },

                'clear_klient': function (e) {
                    e.stopImmediatePropagation();
                    $('#klient_block,#deliveryObekt-block').find('input,input[type=hidden],select').val('');
                    $('#klient_block').find('.clear').text('');
                }
            }
        }
    };

    klient_modify_inOfer.init();

}(window.jQuery, window, document) );
