/* global ajax_searchProducts, LANG__global, parseFloat, parseInt,  Lp */

var loadPlugins = loadPlugins || {};

loadPlugins = {
    'Lp': this,

    // ако кликнем на забранен елемент
    'click_onDisabled': function () {
        $(document).on('click', '[disabled]', function (e) {
            e.stopImmediatePropagation();

            var _this = $(this);
            var action = _this.data('action');
            var name = _this.data('name');
            var isTavaritelnizaNo = $('#tavaritelnizaNo').text().trim();

            if (action == 'delete') {
                if (isTavaritelnizaNo != '') {
                    alert('Има генерирана товарителница и операцията изтриване е деактивирана.');
                }
            }
            else if (action == 'print') {
                alert(_this.text().trim() + ' ' + LANG__order.buttonDisabled); //функцията ще бъде активна след запис
            }
            else if (action == 'moveToSklad') {
                alert('Бутона прехвърли към Gensoft склад ще бъде активен след запис на поръчката  ');
            }

            return false;
        });
    },

    'inputMask': function (arg = '' ) {
        $(".mask").inputmask({
            removeMaskOnSubmit: true,
            onUnMask: function (maskedValue, unmaskedValue) {
                // отстраняваме всички интервали
                return maskedValue.replace(/\s+/g, '');
            }}
        );

        if (arg == 'tel') {
            $(".mask").on("keyup", function ( ) {
                let value = $(this).val();
                let prefixIndex = value.indexOf('+359'); // Намираме позицията на "+359-"

                // Проверяваме дали веднага след "+359-" има "0"
                if (prefixIndex !== -1 && value.charAt(prefixIndex + 5) === "0") {
                    value = value.substring(0, prefixIndex + 5);
                    $(this).val(value);
                }
            });
    }
    },

    'lazyLoadTable': function ( ) {
        // Utility function for debouncing
        function debounce (func, wait) {
            let timeout;
            return function () {
                const context = this, args = arguments;
                clearTimeout(timeout);
                timeout = setTimeout(() => func.apply(context, args), wait);
            };
        }

        const lazyLoadTable = function () {
            let bufferRows = 10;
            let $tableBody = $('table tbody#tableBody'); // Use the appropriate selector for your table body

            function lazyLoadNext (numRows) {
                let $rows = $tableBody.children();
                numRows = Math.min(numRows, $rows.length);

                let rowsLoaded = 0;
                $rows.each(function () {
                    let $row = $(this);

                    if ($row.is(':visible')) {
                        return true; // continue
                    }

                    if ($row.attr('data-filtered') === 'negative') {
                        return true; // continue
                    }
                    else {
                        $row.show();
                    }

                    rowsLoaded++;
                    if (rowsLoaded >= numRows) {
                        return false; // break
                    }
                });
            }


            function lazyLoadBuffer () {
                let $rows = $tableBody.children();
                for (let i = $rows.length - 1; i >= 0; i--) {
                    let $row = $($rows[i]);

                    if (!$row.is(':visible')) {
                        continue;
                    }

                    if ($row.find("[data-filtered=negative]").length > 0) {
                        continue;
                    }

                    let rect = $row[0].getBoundingClientRect();
                    let viewHeight = window.innerHeight || document.documentElement.clientHeight;

                    // If we are within 3 screens of the viewport, lazy load more rows
                    if (rect.bottom <= viewHeight * 3) {
                        console.log(`Lazy loading ${bufferRows} more rows...`);
                        lazyLoadNext(bufferRows);
                    }

                    break;
                }
            }

            lazyLoadNext(bufferRows);


            $(window).on('scroll', debounce(lazyLoadBuffer, 100)); // debounce with 100ms delay
        };

        lazyLoadTable();
    },

    // fixed elements при скрол
    'sticky': function ( ) {

        $('.modal-body').scroll(function () {
            var header = $('.modal-header');
            var headerPos = header.offset().top + header.height();
            var li = $('.sticky.li');

            if (li.length > 0) {
                var liPos = li.offset().top + ( li.height() - headerPos );
            }

            var window_top = $(this).scrollTop();
            console.log(window_top);
            console.log(header.offset().top);
            // li
            if (window_top > liPos) {
                li.addClass('position-fixed').css({'top': header.height() + li.height() + 'px'});
            }
            if (window_top <= 90) {
                li.removeClass('position-fixed').removeAttr('style');
            }

        });
    },

    // === добавяне на поле за редакция ===========
    loadDoomEdit: function (arg = {} ) {
        window.doomEditActive = false;
        window.doomEditCurrentForm = null;
        arg.btnGroup.hide();
        console.log(arg);
        $(arg.el).doomEdit({
            autoTrigger: true,
            showOnEvent: null, // важно!
            editForm: {
                method: 'post',
                class: 'd-inline' + ' ' + arg.form_class,
                action: arg.route
            },
            editFieldName: arg.name ? arg.name : 'doomEditElement',
            extraFields: arg.extraFields,
            onStartEdit: function (form, el) {
                window.doomEditActive = true;
                window.doomEditCurrentForm = form;
            },
            beforeFormSubmit: function (data, form, el) {
                var msg = '';

                msg = arg.action == 'edit' ? 'Сигурни ли сте, че искате да промените -' + el[0].textContent : 'Сигурни ли сте, че искате да запишете нов запис?';

                if (!confirm(msg)) {
                    return false;
                }
            },
            afterFormSubmit: function (data, form, el) {
                let newValue = $('input', form).val();
                let blockMainCat = $('#block-mainCat');
                let blockSubCat = $('#block-subCat');
                let isActiveMainCat = blockMainCat.find('li.active').length;

                window.doomEditActive = false;
                window.doomEditCurrentForm = null;

                arg.btnGroup.show();
                el.text(newValue);

                if (isActiveMainCat) {
                    blockSubCat.find('#breadcrumbs').text(newValue);
                }

                //el.doomEdit('destroy'); // ВАЖНО: destroy след отказ!

                if (typeof arg.callback === 'function') {
                    arg.callback(data); // Call the callback with the response data
                }
            },

            onCancel: function (el) {
                window.doomEditActive = false;
                window.doomEditCurrentForm = null;
                arg.btnGroup.show();
                //el.doomEdit('destroy'); // ВАЖНО: destroy след отказ!

                return false;
            }});

        $(document).on('mousedown', function (e) {

            if (window.doomEditActive) {

                // Ако кликваш извън активната форма
                let $form = $(window.doomEditCurrentForm);
                if ($form.length && !$.contains($form[0], e.target) && $form[0] !== e.target) {
                    // Съобщение
                    alert('В момента сте в режим на редакция. Запишете или откажете преди да продължите.');
                    // Optionally: $form.find('input,textarea').focus();
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    return false;
                }
            }
        });
    },

    // проверка дали дадената оферта
    'check_ofer': {

        // е отворена 
        'isOpen': function (e, _this) {
            e.stopImmediatePropagation( );
            e.preventDefault( );

            const searchParams = new URLSearchParams(window.location.search);
            var a = $(_this).closest('a').attr('href');
            var oferId = $(_this).data('id');
            var urlTab = searchParams.get('tab');

            $.ajax({
                url: GLOBVAR.checkIsOpenOfferUrl, // var in VIEW__footer
                type: 'POST',
                dataType: 'json',
                async: false,
                data: {'oferId': oferId, 'urlTab': urlTab},
                success: function (response)
                {

                    console.log(response);
                    if (response.error) {

                        alert(response.message + ' - ' + response.opened_by + '.\nВ момента неможе да продължите.');
                        var pass = prompt('Може да въведете парола за отключване:');
                        if (pass === GLOBVAR.passForUnlockOfer) {
                            $.ajax({
                                url: GLOBVAR.unlockOfferUrl,
                                type: 'POST',
                                async: false,
                                dataType: 'json',
                                data: {'oferId': oferId, 'urlTab': urlTab},
                                success: function (response) {
                                    Lp.check_ofer.isOpen(e, _this);
                                    window.location.href = a;
                                }
                            });
                        }
                        else if (pass !== null) {
                            alert('Грешна парола!');
                        }
                        return false;
                    }
                    else {
                        window.location.href = a;
                    }
                }
            });
        },

        'beforeUnload': function () {
            let isPreview = $(location).attr('href').split('/')[7];
            let isFormSubmitting = false;

            if (isPreview == 'preview') {
                return false;
            }

            $('form').on('submit', function () {
                isFormSubmitting = true;
            });

            $(window).on('beforeunload', function (e) {
                e.stopImmediatePropagation( );
                const url = GLOBVAR.unlockOfferUrl; // в view_footer се намира
                const searchParams = new URLSearchParams(window.location.search);
                let urlTab = $(location).attr('href').split('/')[4].toLowerCase();
                let oferId = $(location).attr('href').split('/')[6] || searchParams.get('orderId') || searchParams.get('id');
                let data = JSON.stringify({'oferId': oferId, 'urlTab': urlTab});
                let blob = new Blob([ data ], {type: 'application/json'});

                if (url == '' || oferId == '' || urlTab == '') {
                    return false;
                }
                console.log('beforeunload: ' + isFormSubmitting);
                if (!isFormSubmitting) {
                    console.log(data);
                    navigator.sendBeacon(url, blob);
                }
            });
        }
    },

    // проверка в оферта дали е изтекла сесията от 30 мин неактивност
    'sessionTimeout': function () {
        var url = $(location).attr('href');
        var parts = url.split('/');

        if (parts.includes('new')) {
            return false;
        }

        $('#sessionOferTimeout').idleCat({
            // Number of seconds to wait between two scans of user activity.
            interval: 2,
            // How many seconds to hold the activity from the moment of knowing there was not any activity.
            release: GLOBVAR.sessiontimeout * 60, // 20 min
            state: 'active',
            activeCallback: function () {
                //$(this).addClass('active');
            },
            idleCallback: function (element) {
                var url = GLOBVAR.unlockOfferUrl;
                var urlTab = $(location).attr('href').split('/')[4].toLowerCase();
                var oferId = $(location).attr('href').split('/')[6];

                var data = JSON.stringify({'oferId': oferId, 'urlTab': urlTab});
                var blob = new Blob([ data ], {type: 'application/json'});

                navigator.sendBeacon(url, blob);
                alert(`Вашата сесия от ${GLOBVAR.sessiontimeout} мин. изтече поради неактивност.`);
                window.location.href = 'https://' + window.location.hostname + '/MainPage/index?tab=' + urlTab.toLowerCase() + '&page=1&perPage=50';
                //$(this).removeClass('active');
            }
        });
    },

    'onBlurToFixed': function (e, num) {
        if (num != '') {
            if (num % 1 !== 0) {
                num = num.split(".")[1].length;
                if (num != SETTINGS_NUM_FIXED) {

                    $(e).val(Lp.toFixed(num));
                    $(e).trigger('keyup');
                }
            }
        }
    },

    'toFixed': function (num) {
        let regexPattern = /^-?[0-9]+$/;

        // check if the passed number is integer or float
        let result = regexPattern.test(num);


        if (result) {
            // num = parseInt(num).toFixed(SETTINGS_NUM_FIXED);
            return parseInt(num).toFixed(SETTINGS_NUM_FIXED);
        }
        else {
            //num = parseFloat(num).toFixed(SETTINGS_NUM_FIXED);
            return parseFloat(num).toFixed(SETTINGS_NUM_FIXED);
        }
    },

    // качване на файлове в поръчка
    'upload_files': function (route, id) {
        $.fileup({
            url: route,
            inputID: id,
            queueID: 'upload-2-queue',
            lang: 'bg',
            onSelect: function (file) {
                $('#files_area button').show();
            },
            onRemove: function (file, total) {
                if (file === '*' || total === 1) {
                    $('#files_area button').hide();
                }
            },
            onSuccess: function (response, file_number, file) {
                var options = this.fileup.options;

                $('#fileup-' + options.inputID + '-' + file_number).remove();

                if ($('#files_area #upload-2-queue').children('div').length == 0) {
                    $('#files_area button').hide();
                    $("#tbl_files").load(location.href + " #tbl_files", function (response, status, xhr) {
                        loadPlugins.zoomImg();
                    });
                    return false;
                }
            },
            onError: function (event, file, file_number) {
//                Snarl.addNotification({
//                    title: 'Upload error',
//                    text: file.name,
//                    icon: '<i class="fa fa-times"></i>'
//                });
            }
        });


    },

    'zoomImg': function (arg = {} ) {
        const modal = arg.isModal ? '.modal' : '';

        $(document).on('click', `${modal} .zoomImg`, function () {
            const $btn = $(this);

            let $img = $btn.is('img') ? $btn : $btn.parent().find('img').first();
            const fullSrc = $img.data('full-image') || $img.attr('src');
            const isPng = fullSrc.toLowerCase().endsWith('.png');
            const caption = $btn.closest('tr').find('td.productName').text().trim() || ( $img.closest('li').data('title') || '' );

            if (!$img.length)
                return;

            if ($.fancybox.getInstance()) {
                $.fancybox.close();
            }

            $.fancybox.open([ {
                    src: fullSrc,
                    type: 'image',
                    caption: caption
                } ], {
                buttons: [
                    "zoom",
                    "close",
                    "download",
                    "share"
                ],

                toolbar: "auto",
                smallBtn: "auto",
                infobar: true,
                animationEffect: false,
                transitionEffect: false,
                loop: false,
                arrows: false,
                image: {
                    preload: true
                },
                caption: function (instance, item) {
                    return item.caption; // използваме подаденото `caption` директно
                },
                protect: true,
                afterShow: function (instance, current) {
                    // Добавяме клас fancybox-png към .fancybox-content
                    if (isPng && current && current.$content) {
                        current.$content.addClass('fancybox-png');
                    }
                },
                afterClose: function () {
                    // Премахваме класа
                    $('.fancybox-png').removeClass('fancybox-png');
                }
            });
        });
    },

    // изкач  popup  за title
    'popupTitle': function (arg = 'click' ) {
        let tooltipstered = $('[data-toggle="tooltip"]:not(".tooltipstered")');
        let jTippy = $('[data-toggle="jTippy"]');

        if (tooltipstered.length) {
            tooltipstered.tooltipster({
                //string ('click', 'hover', 'focus', 'hoverfocus')
                theme: 'tooltipster-noir',
                trigger: arg,
//            contentCloning: true,
                contentAsHTML: true,
                //multiple: true,
                animation: 'fade',
                maxWidth: 1000,
                interactive: true,
                plugins: [ 'sideTip', 'scrollableTip' ],
                functionBefore: function (instance, helper) {
                    $("body").css('overflow', 'hidden');
                    $.each($.tooltipster.instances(), function (i, instance) {
                        instance.close();
                    });
                },
                functionAfter: function (instance, helper) {
                    $("body").css('overflow', 'initial');
                }
            });
        }

        if (jTippy.length) {
            jTippy.jTippy({
                title: '',
                //string ('click', 'hover', 'focus', 'hoverfocus')
                trigger: arg,
                //string ('auto','top','bottom','left','right')
                position: 'auto',
                //string ('black', 'lt-gray', 'white', 'blue', 'green', 'red')
                theme: 'black',
                //string ('tiny', 'small', 'medium', 'large')
                size: 'small',
                //string|false ('black', 'white', 'blurred'): Only works with trigger: "click"
                backdrop: 'black',
                allowHTML: true,
                content: 'Loading...',
                //boolean: if true and trigger: 'click', when clicking outside the tooltip, it will be hidden
                close_on_outside_click: true
            }).on('jt-show', function (e, tooltip, hide) {
                $("body").css('overflow', 'hidden');
            }).on('jt-hide', function (e) {
                $("body").css('overflow', 'initial');
            });
    }
    },

    // load 
    'loadCKEditor': function (id, tip) {
        CKEDITOR.replace(id, tip);
    },

    // филтър в thead таблицата
    'tableRow_filter': function (options = {} ) {
        const {modal = '', input, table} = options;
        $(`${modal} ${input}`).multifilter({
            'target': $(table)
        });
    },

    // филтър в таблицата чрез select засега в модул разнос
    'tableRow_filterBySelect': function (table, value) {

        if (value === '') {
            table.find('tbody tr').show();
        }
        else {
            table.find('tbody tr').hide();
            table.find('tbody td.status,tbody td.user').find('select option:selected[value="' + value + '"]').each(function () {
                $(this).closest('tr').show();
            });
        }
    },
    // === freeze head таблица =========================
    'table_freezeHeader': function (options = {} ) {
        const {table = '', scroll = window, margin = 88, left = 0} = options;

        // $(table).freezeHeader({'offset': '45px'}); // freezeHeader
        $(table).stickyTableHeaders({'leftOffset': left, 'scrollableArea': scroll, 'marginTop': margin}); //
    },

    //местене на редове в ul лист
    'ul_move': function (options = {} ) {
        const {el = '', handle = '', isCategory = false} = options;

        $(el).sortable({
            handle: handle,
            forcePlaceholderSize: true,

            tolerance: 'pointer',
            stop: function (event, ui) {
                $(ui.item).removeAttr('style');
            },
            activate: function (event, ui) {
                $(ui.item).css('background-color', '#dec68f');
            },
            items: "> li:not(.disabledLi)",
            revert: true,
            //containment: "parent",
            update: function (event, ui) {

            },
            change: function (event, ui) {
                //console.log(ui.item.index());
            }
        }).on("sortupdate", function (event, ui) {
            event.stopImmediatePropagation();
            let ul = ui.item.closest('ul');
            let isRootLi = ui.item.data('isroot');
            let route = ui.item.data('route');
            let posArr = [ ];

            // промяна на позицията на  ред
            ul.find(( isRootLi ? 'li[data-isroot="1"]' : 'li' ) + ':not(.disabledLi)').each(function (index, li) {
                let subId = $(li).data('subId');
                let id = $(li).data('id');

                if (!route) {
                    route = $(li).find('.rowPosition').data('route')
                }
                console.log(route);

                if (isCategory === true) {
                    posArr.push({'category_id': subId, 'category_position': index + 1});
                }
                else {
                    posArr.push({'category_characteristic_id': id, 'category_id': subId, 'category_char_position': index + 1});
                }

                $(li).find('.count').text(index + 1 + '.');
            });

            $.ajax({
                url: route,
                type: 'POST',
                data: {'positionArr': posArr},
                dataType: 'json',
                success: function (response) {
                    return false;
                }
            });
        });

    },
    // местене на разни неща(слайдове в настройки за портал)
    'move_slide': function (options = {} ) {
        const {el = '', handle = ''} = options;

        $(el).sortable({
            handle: handle,
            forcePlaceholderSize: true,

            tolerance: 'pointer',
            stop: function (event, ui) {
                $(ui.item).css('background-color', '');
            },
            activate: function (event, ui) {
                $(ui.item).css('background-color', '#dec68f');
            },
            items: "> li",
            revert: true,
            //containment: "parent",
            update: function (event, ui) {

            },
            change: function (event, ui) {
                //console.log(ui.item.index());
            }
        });
    },

    // === скриване/показване на колони в таблицата =========================
    'columnTableToggle': function (table, tab) {

        $(table).columntoggle({
            toggleContainerId: 'chkBox-tblColShow',
            toggleContainerClass: 'dropdown-menu fade p-2',
            divClass: '.visibleCols',
            //Text in column toggle box
            showAllColsText: LANG__global.loadPlugins.colToggle.showAllColsTxt,
            showBtnText: LANG__global.loadPlugins.colToggle.showBtnText,
            //the prefix of key in localstorage
            keyPrefix: 'colToggle-',
            //keyname in localstorage, if empty, it will get from URL
            key: tab.replace(/[\W]+tab=|&.*/g, '')
        });
    },

    // === промяна на select box, колко записа да се показват в таблица в mainPage =======
    'perPage': function (el, tab) {

        $(el).PageLength({
            keyPrefix: 'perPage-',
            key: tab.replace(/[\W]+tab=|&.*/g, '')
        });
    },

    // === ajax за отваряне на модал форми =========================
    'ajax_modalFormOpen': function (data = {} ) {

        $.ajax({
            url: data.route,
            type: data.ajaxType,
            dataType: 'json',
            data: data.datastr,
            success: function (response) {
                $('body').append(response);
                $('.modal:not(#linkModal)').modal('show');

                if (data.shablon === true) {
                    loadPlugins.loadCKEditor('ck_header', ck_full);
                    loadPlugins.loadCKEditor('ck_footer', ck_full);
                }
                else if (data.ckeditor === true) {
                    loadPlugins.loadCKEditor('ck_area', ck_small);
                    loadPlugins.loadCKEditor('ck_shortDesc', ck_shortDesc);
                }
            }
        });

        return false;
    },

// Order totals calculation (footer)
    'order_total_in_footer': function (arg) {

        // TRUE  = prices entered WITH VAT
        // FALSE = prices entered WITHOUT VAT
        var pricesAreWithDDS = window.PRICES_WITH_DDS === true;
        // VAT percent (fallback to 20% if missing)
        var ddsPercent = typeof SETTINGS_DDS !== "undefined"
                ? ( SETTINGS_DDS / 100 )
                : 0.20;

        var total = 0;
        var prihodSuma = 0;
        var totalQty = 0;

        // === SUM ALL TABLE ROWS ===
        $(arg.table).find('tbody tr[data-id]').each(function () {
            var $row = $(this);

            var deliveryPrice = Number($row.find('td.zenaDostavna input:hidden').val()) || 0;
            var sellPrice = Number($row.find('td.zenaProdava .zenaProdava').val()) || 0;
            var qty = Number($row.find('td.qty .qty').val()) || 0;

            var rowSum = sellPrice * qty;

            total += rowSum;
            prihodSuma += deliveryPrice * qty;
            totalQty += qty;

            $row.find('td.total').html(Lp.toFixed(rowSum) + ' ' + arg.symbol);
        });

        // === VAT CALCULATION LOGIC ===
        var sumWithoutDDS = 0;
        var ddsSum = 0;
        var sumWithDDS = 0;

        if (pricesAreWithDDS) {
            // Prices INCLUDE VAT
            // For 20% VAT → VAT = gross / 6
            sumWithDDS = total;
            ddsSum = sumWithDDS / 6;
            sumWithoutDDS = sumWithDDS - ddsSum;
        }
        else {
            // Prices EXCLUDE VAT
            sumWithoutDDS = total;
            ddsSum = sumWithoutDDS * ddsPercent;
            sumWithDDS = sumWithoutDDS + ddsSum;
        }

        // Always show VAT rows
        $(arg.table).find('tfoot tr#dds, tfoot tr#total_s_dds').removeClass('hide');

        // === FOOTER OUTPUT ===
        $(arg.table).find('tfoot tr#total_bez_dds th.suma')
                .text(Lp.toFixed(sumWithoutDDS) + ' ' + arg.symbol);

        $(arg.table).find('tfoot tr#dds th.suma')
                .text(Lp.toFixed(ddsSum) + ' ' + arg.symbol);

        $(arg.table).find('tfoot tr#total_s_dds th.suma')
                .text(Lp.toFixed(sumWithDDS) + ' ' + arg.symbol);

        // === PROFIT ===
        var totalMarginPercent = sumWithoutDDS > 0
                ? ( ( sumWithoutDDS - prihodSuma ) / sumWithoutDDS ) * 100
                : 0;

        var totalProfit = sumWithoutDDS - prihodSuma;

        $(arg.table).find('tfoot tr#prihod th.nadz')
                .text(Lp.toFixed(totalMarginPercent) + ' %');

        $(arg.table).find('tfoot tr#prihod th.suma')
                .text(Lp.toFixed(totalProfit) + ' ' + arg.symbol);
    },
    /*
     // калкулация на доставката за куриер
     'order_total_in_footer': function (arg) {
     var leftAside = $('#leftAside');
     var radios = leftAside.find('input.isDDS:checked');
     var ddsPercent = typeof SETTINGS_DDS !== "undefined" ? ( SETTINGS_DDS / 100 ) : 0;
     var total = 0, prihodSuma = 0, totalNadz = 0, totalPrihod = '', prozentPechalba = '', totalQty = 0, sum = 0, valuta_symbol = '', dostavka = '', weight = 0;
     
     dostavka = $(arg.table).find('tfoot tr#dostavka #dostavkaVal').val( );
     
     $(arg.table).find('tbody tr[data-id]').each(function () {
     var _this = $(this);
     var zena_dostavna = _this.find('td.zenaDostavna input:hidden').val();
     var zena_prodava = _this.find('td.zenaProdava .zenaProdava').val();
     var qty = _this.find('td.qty .qty').val();
     sum = Number(zena_prodava) * Number(qty);
     
     total += sum;
     //weight += parseFloat(_this.find('td.weight').text());
     totalQty += Number(qty);
     prihodSuma += zena_dostavna * Number(qty);
     
     _this.find('td.total').html(Lp.toFixed(sum) + ' ' + arg.symbol); // тотал
     });
     
     //if (!isNaN(weight)) {
     //$(arg.table).find('tfoot tr#dostavka input#totalWeight').val(Lp.toFixed(weight));
     //}
     
     $(arg.table).find('tfoot tr#dds, tfoot tr#total_s_dds').toggleClass('hide', radios.val( ) == '');
     
     // общо количество
     $(arg.table).find('tfoot tr#grandQtyRow th#grandQtyVal div').text(totalQty);
     
     // крайна сума без ддс
     $(arg.table).find('tfoot tr#total_bez_dds th.suma').text(Lp.toFixed(total) + arg.symbol);
     
     //ддс
     $(arg.table).find('tfoot tr#dds th.suma').text(Lp.toFixed(total * ddsPercent) + ' ' + arg.symbol);
     
     // крайна сума с ддс
     $(arg.table).find('tfoot tr#total_s_dds th.suma').text(Lp.toFixed(total * ( ddsPercent + 1 )) + ' ' + arg.symbol);
     
     if (dostavka != '') {
     total = total + Number(dostavka); // начисляване на куриерска доставка
     // крайна сума с ддс + доставка
     
     $(arg.table).find('tfoot tr#dostavka #totalAndDostavkaVal').text(Lp.toFixed(total * ( ddsPercent + 1 )) + ' ' + arg.symbol);
     }
     
     // приход
     totalNadz = ( total - prihodSuma ) / total * 100;
     totalPrihod = radios.val( ) == 1 ? ( total - prihodSuma ) * ( ddsPercent + 1 ) : total - prihodSuma;
     
     $(arg.table).find('tfoot tr#prihod th.nadz').text(Lp.toFixed(totalNadz) + ' %');
     $(arg.table).find('tfoot tr#prihod th.suma').text(Lp.toFixed(totalPrihod) + ' ' + arg.symbol);
     },
     */
    // времезакъснение
    'debounce': function (func, wait = 1000, immediate ) {

        var timeout;
        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate)
                    func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow)
                func.apply(context, args);
        };
    },

    // брояч и валидация на х-ки на продукт в редакция на продукт за покаване в каталог ф.
    'count_validate_chk_productAttr': function ($modal) {
        const chkInputs = $modal.find('#tabProperty li .showInCatalog');
        const maxCount = 11;
        const checkedCount = chkInputs.filter(':checked').length;

        if (checkedCount >= maxCount) {
            chkInputs.not(':checked').prop('disabled', true);
        }
        else {
            chkInputs.not(':checked').prop('disabled', false);
        }

        $modal.find('#tabProperty #countAttr_forCatalog').text(checkedCount)
    },

    'file': {
        'uploadFile': function () {
            var _this = $(this);
            var fileInput = _this.parent().find('input[type=file]');
            var uploadFileName = _this.parent().find('#uploadFileName');
            var fileLenght = fileInput[0].files.length;
            var fd = new FormData();

            //ако името е празно
            if (uploadFileName.val() == '') {
                alert('Внимание: Трябва да въведете име');
                return false;
            }
            //ако не е избран файл
            else if (fileLenght === 0) {
                alert('Внимание: не е избран файл!');
                return false;
            }

            fd.append('uploadName', uploadFileName.val().trim());
            fd.append('file', fileInput[0].files[0]);

            $.ajax({
                url: $(this).data('route'),
                type: "POST",
                contentType: false,
                processData: false,
                enctype: "multipart/form-data",
                dataType: 'html',
                data: fd,
                cache: false,
                success: function ()
                {
                    alert('Файлът е качен');
                }
            });
        },

        'chooseFile': function () {
            var _this = $(this);
            var fileInput = _this.parent().find('input[type=file]');
            var uploadFileName = _this.parent().find('#uploadFileName');
            var uploadFile = _this.parent().find('#uploadFile');

            fileInput.click();

            fileInput.off('change').on('change', function (e) {
                var selectedFile = e.target.files[0];

                if (selectedFile && uploadFileName.val() === '') {
                    uploadFileName.attr('placeholder', selectedFile.name);
                    _this.add(uploadFile).toggleClass('hide');
                }
            });
        },

        'canselFile': function () {
            var _this = $(this);
            var fileInput = _this.parent().find('input[type=file]');
            var uploadFileName = _this.parent().find('#uploadFileName');
            var chooseFile = _this.parent().find('#chooseFile');
            var uploadFile = _this.parent().find('#uploadFile');

            if (!chooseFile.is(':visible')) {
                chooseFile.add(uploadFile).toggleClass('hide');
            }

            uploadFileName.attr('placeholder', '').val('');
            fileInput.val('');
        }
    },
    'select2Simple': function (arg = {} ) {
        $(".select2-simple").select2({
            language: "bg",
            placeholder: 'Нищо не е избрано',
            dropdownAutoWidth: true,
            allowClear: true,
            width: '100%',
            positionDropdown: true,
            dropdownParent: arg.modal ? arg.modal : $('.autocomplete')
        });
    },

    'selectpicker': function ( ) {
        $('.selectpicker').selectpicker({
            liveSearch: true,
            size: 'auto',
            virtualScroll: 100,
            //width: 'auto',
            //dropdownAlignRight: 'auto',
            dropupAuto: true,
            //windowPadding:10,
            sanitizeFn: null,

        });
    },

    // зареждане на календар в разнос
    'datepicker': function ( ) {
        let route = $('#datepicker').data('route');

        $('#datepicker').datetimepicker({
            firstDayOfWeek: 1,
            language: 'bg',
            date: new Date(),
            viewMode: 'YMD',
            format: 'DD-MM-YYYY',
            onDateChange: function () {

                var newDate = this.getText('DD-MM-YYYY');

                $.ajax({
                    url: route,
                    type: "POST",
                    dataType: 'json',
                    data: {'date': newDate},

                    success: function (response)
                    {
                        var deleteRaznos = $('#deleteRaznos').attr('href');

                        $('.alert').remove();
                        $('#deleteRaznos')
                                .attr('href', deleteRaznos.replace(/(\d+)-(\d+)-(\d+)/, '' + newDate))
                                .attr('disabled', response.isNull === null);
                        $('#htmlTable').html(response.view);

                        Lp.tableRow_filter({'input': '#filter', 'table': '.table'}); // филтър
                        //Lp.addClearBtn();
                    }
                });


                // console.log( this.getValue());
//                $('#date-text2').text(this.getText());
//                $('#date-text-ymd2').text(this.getText('DD-MM-YYYY'));
//                $('#date-value2').text(this.getValue());
            }, onClear: function () {
                // code to run
            }, onOk: function () {
                // code to run
            }, onClose: function () {
                // code to run
            }
        });
    },

    'lazyLoadTableRows': function (arg = {} ) {
        $(arg.isModal ? '.modal-body table' : window).scrollTop(0);

        var content = function () {

            var $modalBody = $(arg.bodyHeight);
            var modalHeight = $modalBody.height();
            var $rows = $(arg.modal + ' ' + arg.tableId + ' tbody tr');
            var rowHeight = $rows.not('.colorRows').first().height();

            var rowsVisible = Math.round(modalHeight / rowHeight);
            var visibleCount = rowsVisible + 3; // Extra buffer rows
            var lastScrollTop = 0; // Track the last scroll position

            $rows.slice(visibleCount).hide();

            function updateVisibleRows (scrollDirection) {
                var $visibleRows = $rows.filter(':visible');
                var startIndex = $visibleRows.first().index(); // Index of the first visible row
                var endIndex = $visibleRows.last().index() + 1; // Index of the last visible row (+1 for slice)

                if (scrollDirection === 'down') {
                    // Show the next set of rows when scrolling down
                    startIndex = endIndex;
                    endIndex = startIndex + 1;
                    // Ensure we don't go out of bounds
                    //$rows.hide();
                }
                else {
                    // Show the previous set of rows when scrolling up
                    endIndex = startIndex;
                    startIndex = Math.max(startIndex - visibleCount, 0); // Prevent negative index
                    // Ensure we don't go out of bounds
                    //$rows.hide();
                    //$rows.slice(startIndex, endIndex).show();
                }
                $rows.slice(startIndex, startIndex + visibleCount).show();
            }


            $(arg.isModal ? '.modal .overflow-auto' : window).on('scroll', function () {

                var scrollTop = $(this).scrollTop();
                var scrollDirection = scrollTop > lastScrollTop ? 'down' : 'up';

                // Use requestAnimationFrame to ensure smooth scrolling
                window.requestAnimationFrame(function () {
                    updateVisibleRows(scrollDirection);
                });

                lastScrollTop = scrollTop;
            });
        };

        if (arg.isModal) {
            $('.modal').on('shown.bs.modal', function () {
                content();
            });
        }
        else {
            content();
    }

    },

//    // === календар =====================================
//    datePicker: function ( ) {
//        $('.datePicker').datepicker({
//            format: "dd-mm-yyyy",
//            language: 'bg',
//            todayBtn: true,
//            todayHighlight: true,
//            autoclose: true,
//            todayHighlight: true
//        }).on('changeDate', function (e) {
//            $(this).text(e.format(0, "dd-mm-yyyy") + 'г.');
//        });
//    },
//

    'subcategoryNestedSortable': function () {
        // Всички ul.category-tree във block-subCat
        $('.treeview').nestedSortable({
            items: 'li',
            handle: '.fa-arrows-alt', // само иконката ще работи като "дръжка"

            isTree: true,
            maxLevels: 5, // Ограничение за нива, колкото искаш
            placeholder: 'sortable-placeholder',
            toleranceElement: '> .category-row',

            forcePlaceholderSize: true,
            expandOnHover: 700,
            listType: 'ul', // <-- Ключово!
            startCollapsed: false,
            relocate: function (event, ui) {
                // ui.item е преместеният елемент
                var item = ui.item;
                let route = $(item).find('.fa-arrows-alt').data('route');
                var siblings = item.parent().children('li');
                var positions = [ ];

                // Взимаш всички ID-та на братята, подредени след преместването:
                siblings.each(function (index, el) {
                    positions.push({
                        category_id: $(el).attr('data-id'),
                        category_position: index
                    });
                });

                $.ajax({
                    url: route,
                    type: "POST",
                    dataType: 'json',
                    data: {'positionsArr': positions}, // изпращаш [{id:..., sort_order:...}, ...]},
                    success: function (response)
                    {

                    }
                });
            }
        });
    },

    'htmxReloadPage': function (routeRefresh, data = {} ) {
        const target = data.target;
        const values = Object.assign({isRefresh: true}, data);

        htmx.ajax('GET', routeRefresh, {
            target: target,
            swap: 'innerHTML',
            select: `${target} > *`,
            values: values
        });

    },
    // дали са добавени нови продукти
    'isAddedNewProduct': function (table) {

        const hasNewRows = $(`${table} > tbody > tr:not(.colorRows)`).filter(function () {
            return $(this).attr('data-fromizborproduct') == 'true';

        }).length > 0;

        if (hasNewRows) {
            alert('⚠ Имате новодобавени продукти. Моля, първо направете запис.');
        }

        return hasNewRows;
    },

};
