/* global ck_full, loadPlugins */
( function ($, window, document, undefined) {

    var topMenu = topMenu || {};
    let v = topMenu;

    topMenu = {
        '__var': {
        },
        'init': function () {
            v = this.__var;

            Lp = loadPlugins;
            this.setUpListeners();
        },
        'setUpListeners': function ( ) {
            // POPUP 
            $(document)
                    .on('click', '#fileManager', this.btn.open_fileManager)
                    .on('click', '#openExpImp', this.modal.open_popup_expImp)
                    .on('click', '#openShablon', this.modal.open_popup_shablon)
                    .on('click', '#openLanguage', this.modal.open_popup_language)
                    .on('click', '#openValuta', this.modal.open_popup_valuta)
                    .on('click', 'a#openMqrka', this.modal.open_popup_mqrka)
                    .on('click', 'a#spCat', this.modal.open_popup_category)
                    .on('click', 'a#productRank', this.modal.open_popup_productRank)
                    .on('click', 'a#spCatAttr', this.modal.open_popup_categoryAttributes);

            //EVENTS
            //this.events.orderNotification()
            // setInterval(this.events.orderNotification, 5000);

            //BTN
        },

        'modal': {

            'open_popup_expImp': function (e) {
                e.stopImmediatePropagation( );
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            // podredba продукти за сайт в категория
            'open_popup_productRank': function (e) {
                e.stopImmediatePropagation( );
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            // списък валута
            'open_popup_category': function (e) {
                e.stopImmediatePropagation( );
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_categoryAttributes': function (e) {
                e.stopImmediatePropagation( );
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_mqrka': function (e) {
                e.stopImmediatePropagation( );
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_shablon': function (e) {
                e.stopImmediatePropagation( );
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'shablon': true});
            },

            // списък езици
            'open_popup_language': function (e) {
                e.stopImmediatePropagation( );
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            // списък валута
            'open_popup_valuta': function (e) {
                e.stopImmediatePropagation( );
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            }
        },

        'events': {
            // камбанка за нови оферти
            'orderNotification': function () {
                const searchParams = new URLSearchParams(window.location.search);

                if (searchParams.get('tab') === null || searchParams.get('tab') == 'order') {
                    return false;
                }

                $.ajax({
                    url: '/BaseController/order_notifications',
                    dataType: 'json',
                    global: false,
                    cache: false,
                    success: function (response)
                    {
                        if (response != '0') {
                            $(".countOrderNotification").addClass('bg-danger').text(response);
                        }
                    }
                });
            }
        },

        'btn': {
            'open_fileManager': function ( ) {
                CKFinder.popup({
                    language: 'bg',
                    id: 'file',
                    swatch: 'b',
                    width: 1024,
                    height: 800,
                    skin: 'jquery-mobile',
                    rememberLastFolder: true,
                    startupFolderExpanded: true,
                });
            }
        }
    };

    topMenu.init();
} )(jQuery, window, document);
