/* global loadPlugins */

( function ($, window, document, undefined) {

    var mainPage = mainPage || {};
    let v = mainPage;

    mainPage = {
        '__var': {
            tab: $('#currentView').data('view'),
            table: '.table'
        },
        'init': function () {
            v = this.__var;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;

 
            Lp.popupTitle();
            Lp.columnTableToggle('.table', v.tab);
            Lp.perPage('#perPage', v.tab); // промяна колко стр да се показват в mainPage
            Lp.table_freezeHeader({'table': v.table, 'margin': 50}); // thead frezze
        },

        'setUpListeners': function ( ) {

            //EVENTS
            $(document)
                    .on('keyup', '#tbl-filter', Lp.debounce(this.events.tblFilter))
                    .on('keyup', '.filter', Lp.debounce(this.events.tblFilter))
                    .on('input', '#filter_status,#filter_date,#filter_users,#filter_curier', this.events.tblFilter)
                    .on('change', 'thead #select-allOrders', this.events.select_allOrders)
                    .on('change', 'tbody td.chk_orderRow input', this.events.isChecked_orderRow);

            //BTN
            $(document)
                    .on('click', '#myTab  a', this.btn.tabLink)
                    .on('click', '#unionOrdersByKlient', this.btn.unionOrdersByKlient)
                    // --- in table
                    .on('click', '.saveTovaritelnizaNo', this.btn.saveTovaritelnizaNo)
                    .on('click', 'thead .filter-status-clear', function () {
                        var select = $(this).parent().find('select');
                        if (select.val() != '') {
                            select.val('').trigger('input');
                        }
                    })
                    .on('click', 'thead .sort', this.btn.colSort)
                    .on('click', 'tbody td.action a.copyOfer', this.btn.copy_ofer)
                    .on('click', 'tbody a.edit_ofer', this.btn.edit_ofer);
        },

        'events': {
            // маркиране на всички поръчки
            'select_allOrders': function () {
                let _this = $(this);
                let table = _this.closest('table');
                let klientName = _this.closest('table').find('thead .filter[data-sort_col="klient_name"]').val();
                let isChecked = _this.is(':checked') || 0;
                let checkedValues = [ ];
                let uncheckedValues = [ ];

                if (!klientName) {
                    alert('Изберете преди това клиент от филтъра.');
                    _this.prop('checked', false);
                    return false;
                }

                table.find("tbody td.chk_orderRow input[type=checkbox]").prop('checked', isChecked);

                checkedValues = $("tbody td.chk_orderRow input[type=checkbox]:checked").map(function () {
                    return $(this).closest('tr').data('id');
                }).get();

                uncheckedValues = $("tbody td.chk_orderRow input[type=checkbox]:not(:checked)").map(function () {
                    return $(this).closest('tr').data('id');
                }).get();

                $.ajax({
                    url: $(this).data('route'),
                    type: 'POST',
                    global: false,
                    dataType: 'json',
                    data: {'sesionName': 'sesion_unionOrderIds', 'isChecked': isChecked, 'dataArr': isChecked ? checkedValues : uncheckedValues},
                    success: function (response) {

                    }
                });

            },

            // когато маркиране ред го записваме с сесията като ID
            'isChecked_orderRow': function () {
                let _this = $(this);
                let orderId = _this.closest('tr').data('id');
                let klientName = _this.closest('table').find('thead .filter[data-sort_col="klient_name"]').val();
                let isChecked;

                if (klientName == '') {
                    alert('Изберете преди това клиент от филтъра.');
                    _this.prop('checked', false);
                    return false;
                }

                isChecked = _this.is(':checked') || 0;

                $.ajax({
                    url: $(this).data('route'),
                    type: 'POST',
                    global: false,
                    dataType: 'json',
                    data: {'sesionName': 'sesion_unionOrderIds', 'isChecked': isChecked, 'dataArr': [ orderId ]},
                    success: function (response) {

                    }
                });
            },

            //търсене на листа
            'tblFilter': function (e) {
                e.stopImmediatePropagation( );

                var _this = $(this);
                var params = new URLSearchParams(window.location.search);
                var searchValue = _this.val().trim();
                var searchCol = _this.data('sort_col');//  само за поръчка
                var paramsToAdd = {};
                var sortColumn = '';

                if (e.key !== "Enter" && e.key !== undefined && searchValue !== '') {
                    return false;
                }

                _this.closest('tr').find(':input').not(_this).val('');

                paramsToAdd['searchName'] = searchValue;

                if (searchCol) {
                    paramsToAdd['searchCol'] = searchCol;
                }

                // Update the 'page' parameter to 1
                params.set('page', 1);
                Object.keys(paramsToAdd).forEach(function (param) {
                    params.set(param, paramsToAdd[param]);
                });

                //history.replaceState({}, '', '?' + params.toString());
                if (searchValue.length === 0) { // Check if input value is empty

                    Object.keys(paramsToAdd).forEach(function (param) {
                        params.delete(param);
                    });

                    history.replaceState({}, '', '?' + params.toString());
                    history.go(0); // Reload the page if input value is empty
                    return false; // Exit function to prevent further execution
                }

                if ($(this).data('sort_col')) {
                    sortColumn = '&searchCol=' + $(this).data('sort_col');
                }

                $.ajax({
                    url: $(this).data('route') + '&searchName=' + searchValue + sortColumn,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        $(document).find('tbody').html(response.table);
                        $(document).find('#refreshPagnitation').html(response.pagnitation);

                        // v.$modal.find('tbody').html(response.table);
                        // v.$modal.find('#refreshPagnitation').html(response.pagnitation);
                    }
                });
                // history.go(0);
            }
        },

        'btn': {
            // обединяване на поръчки според клиент
            'unionOrdersByKlient': function (e) {
                e.stopImmediatePropagation( );

                let length = $('tbody td.chk_orderRow input:checked').length;

                if (length < 2) {
                    alert('Трябва да изберете най малко две поръчки за стартирате функцията по обедиянване на поръчки.');
                    return false;
                }

                $.ajax({
                    url: $(this).data('route'),
                    type: 'POST',
                    dataType: 'json',
                    data: {'sesionName': 'sesion_unionOrderIds'},
                    success: function (response) {
                        history.go(0);
                    }
                });
            },

            'saveTovaritelnizaNo': function (e) {
                e.stopImmediatePropagation( );
                let _this = $(this);
                let route = _this.data('route');
                let tovaritelnizaNo = _this.parent().find('input');

                if (tovaritelnizaNo.val() == '') {
                    alert('Въведете номер на товарителница.');
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: {'tovaritelnizaNo': tovaritelnizaNo.val().trim()},
                    success: function (response) {

                        if (response.status === true) {
                            alert('Товарителница № е записан.');
                            _this.parent().attr('disabled', '').addClass('pointer-events-none');
                        }
                        else if (response.status === false) {
                            alert('Възникна грешка с записът.');
                        }
                        else if (response.notExist) {
                            alert(response.notExist);
                        }
                    }
                });

            },

            'edit_ofer': function (e) {
                Lp.check_ofer.isOpen(e, $(this));
            },

            'copy_ofer': function () {
                var $tr = $(this).closest('tr');
                var href = $(this).attr('href');
                var OfferName = $tr.find('td.offerName').text( );
                var urlParams = new URLSearchParams(window.location.search);
                var p;

                if (urlParams.get('tab') == 'order') {
                    return confirm('Сигурни ли сте, че искате да клонирате поръчката?');
                }

                p = prompt(LANG__mainPage.promt.newName, OfferName + '_1');//Моля въведете ново име

                if (p === null || p === '') {
                    if (p === '') {
                        alert(LANG__mainPage.promt.noName); // Ne e въведено име
                    }
                    return false;
                }

                // премахване на спец символи
                p = clearSpecial_char.remove_cpecial_chars_from_promt(p);

                function replaceNameParam (href, newNameValue) {
                    let url = new URL(href);
                    url.searchParams.set('name', newNameValue);
                    return url.toString();
                }

                href = replaceNameParam(href, p);

                $(this).attr('href', href);
            },

            //кликване на табовете за листи
            'tabLink': function (e) {
                var href = $(this).attr('href');
                var index = sessionStorage.getItem('perPage-' + href.replace(/[\W]+tab=|&.*/g, ''));
                if (index === null || index.length === 0) {
                    index = 10;
                }

                // $(this).attr('href', href.replace(/&perPage=.*/g, '') + '&perPage=' + index);
            },

            'colSort': function (e) {

                var sql = $(this).data('sql');

                console.log(sql);

                var params = new URLSearchParams(window.location.search);
                params.set('sort_col', sql.col);
                params.set('sort_order', sql.sort);
                history.replaceState({}, '', '?' + params.toString());

                history.go(0);
            }
        }
    };
    mainPage.init( );

} )(jQuery, window, document);

