/* global loadPlugins, SETTINGS_NUM_FIXED, leftAsideActions, tableActions  */
( function ($, window, document) {

    var baner = baner || {};
    let v = baner;
    let $self = baner;

    $('form').dontJustLeaveMe('a#prinPreview'); // plygin za напускане на стр и  ако има промяна 
    //в офертата за предпечат ценообр и нова оферта

    baner = {
        '__var': {
            table: '#tbl_products'
        },
        'init': function () {
            v = this.__var;
            $self = this;
            $root = this;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Ta = tableActions;
            Lsa = leftAsideActions;

            //Lp.lazyLoadTable();
            Lp.check_ofer.beforeUnload();
            Lp.zoomImg();
            Lp.popupTitle();
            Lp.table_freezeHeader({'table': v.table, 'margin': 100}); // thead frezze
            Lp.tableRow_filter({'input': '#filter', 'table': v.table}); // филтър
            Ta.getTotal_inFooter({'table': v.table, 'autoTigger': true});
            Ta.tableRow.move();
            Lsa.colorChoice(); // избор на цветни редове
        },
        'setUpListeners': function ( ) {

            // DISABLED CLICK
            $(document).on('click', '[disabled]', this.event.isAllowed);

            // POPUP 
            $(document)
                    .on('click', '#izbor-zenova', this.modal.open_popup_izborZenova)
                    .on('click', 'tbody .edit_product, #new_product', this.modal.open_popup_editProduct)
                    .on('click', '#izbor-product', this.modal.open_popup_izborProduct)
                    .on('click', '#add-colorRow', this.modal.open_popup_colorRow);

            //EVENTS
            $(document)
                    // --- left aside
                    .on('changed.bs.select', '#leftAside #valuta_izbor', Lsa.changeValuta)

                    // --- in table
                    .on('mouseover', 'tbody .rowPosition', Ta.tableRow.position.getTitle)
                    .on('keyup', 'tbody td.qty .qty, tbody td.zenaProdava .zenaProdava ', function () {
                        Ta.getTotal_inFooter({'table': v.table});
                    })
                    .on('blur', 'tbody td.zenaProdava .zenaProdava ', function () {
                        var numDec = this.value;

                        if (numDec != '') {
                            this.value = Lp.toFixed(this.value);
                            $(this).trigger('keyup');
                        }
                    });

            //BTN
            $(document)
                    // --- left aside
                    .on('click', '#leftAside .colorDisplay', Lsa.changeColor)

                    // --- in table
                    .on('keyup', 'tbody .zenaProdava', Ta.tableRow.change_zenaProdava)
                    .on('click', '#priceLevel button, #priceLevelAll button', Ta.tableRow.get_priceLevel) //избор на ц. ниво от tooltip

                    .on('click', 'tbody .rowPosition', Ta.tableRow.position.setPosition)
                    .on('click', 'tbody tr.colorRows .edit_colorRow', Ta.colorRow.edit)
                    .on('click', 'tbody .delete_colorRow', Ta.colorRow.delete)
                    .on('click', 'tbody .delete_product', Ta.tableRow.delete)

                    // --- header
                    .on('click', '#cloneOfer', this.btn.header.cloneOfer)
                    .on('click', '#save-ofer', this.btn.header.save);
        },

        'modal': {
            'open_popup_izborZenova': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_colorRow': function () {
                var colorValue = $('#left-aside').find('#colorValue').val();

                if ($(v.table).find('tbody tr').length == 0) {
                    alert(LANG__special.alert.emptyProducts);//ДОбавете поне 1 продукт в таблицата
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'POST', 'datastr': `colorValue=${colorValue}`});
            },

            'open_popup_izborProduct': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_editProduct': function () {
                if (Lp.isAddedNewProduct(v.table)) {
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'ckeditor': true});
            }
        },

        'event': {

            // ако бутон е забранен се извежда съобщение когато се кликне на него
            'isAllowed': function () {
                var _this = $(this);

                alert(this.outerText + ' ' + LANG__special.buttonDisabled);//функцията ще бъде активна след запис

                _this.removeAttr('href');
            },
        },

        'btn': {
            'leftAside': {

            },

            'table': {},

            'header': {

                'cloneOfer': function (e) {
                    var _this = $(this);
                    var route = _this.data('route');
                    var oferName = _this.data('name');

                    oferName = prompt('Ако желаете може да промените името', oferName + '_1');

                    if (oferName == '') {
                        alert('Трябва да въведете име за клонираната оферта.');
                        return false;
                    }

                    if (! confirm('Сигурни ли сте, че искате да клонирате тази оферта?')) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: {'oferName': oferName},
                        success: function (response) {
                            if (response.err) {
                                alert(response.err);
                                return false;
                            }
                            else {
                                alert('Клонирането е изпълнено.');
                            }
                        }
                    });

                    e.stopImmediatePropagation();
                },

                'save': function (e) {

                    if (! confirm(LANG__special.confirm.save)) {
                        return false;
                    }

                    if ($(v.table).find('tbody tr').length == 0) {
                        alert(LANG__special.alert.emptyProducts);
                        return false;
                    }

                    if (validate_empty.validate(e, null, null, $('#leftAside')) == true) {
                        return false;
                    }

                    $(document).off('submit').on('submit', 'form', function (e) {
                        e.preventDefault();

                        var form = $(this);

                        $.ajax({
                            url: form.attr('data-route'),
                            type: 'POST',
                            data: {'form': JSON.stringify(form.serializeJSON())},
                            dataType: 'json',
                            success: function (response) {
                                if (response.err) {
                                    alert(response.err);
                                }
                                //ако е нова оферта се пренасрочва
                                else if (response.hasOwnProperty('url')) {
                                    window.location.href = response.url;
                                }
                            }
                        });

                        e.stopImmediatePropagation();
                    });
                }
            }
        }
    };

    baner.init();

}(window.jQuery, window, document) );
