/* global loadPlugins, SETTINGS_NUM_FIXED, order_vars, tableActions, curierLocator  */

( function ($, window, document, undefined) {

    var order = order || {};
    let self = order;
    let v = order;

    $('form').dontJustLeaveMe('.tooltipGensoftSklad, #create_gensoftOrder'); // plygin za напускане на стр ако има промяна

    order = {
        'init': function ( ) {
            $root = this;
            self = this;
            V = order_vars; // променливи

            this.plugins( );
            this.popup( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;
            Ta = tableActions;
            Cl = curierLocator;

            Lp.click_onDisabled();
            Lp.check_ofer.beforeUnload();
            Lp.order_total_in_footer({'table': V.productTable, 'symbol': GLOBVAR.valutaSign, 'autoTigger': true});
            Lp.selectpicker();
            Lp.zoomImg( );
            Lp.popupTitle( );
            Lp.table_freezeHeader({'table': V.productTable, 'margin': 150}); // thead frezze
            Lp.tableRow_filter({'input': '#filter', 'table': $(document).find('.table').attr('id')}); // филтър
        },
        'popup': function ( ) {
            // --- POPUP FORM  ---
            $(document)
                    .on('click', '#returnProductsFromOrder', this.modal.open_popup_returnOrder)
                    .on('click', 'tbody .edit_product', this.modal.open_popup_editProduct)
                    .on('click', '#izbor-klientObekt', this.modal.open_popup_klient)
                    .on('click', '#generate-tovaritelniza', this.modal.open_popup_generateTovaritelniza)
                    .on('click', '#request-curier', this.modal.open_popup_requestCurier)
                    .on('click', '#izbor-product', this.modal.open_popup_izborProduct);
        },

        'setUpListeners': function ( ) {

            $(document)
                    // --- HEADER -------------------------------------------------
                    // events
                    .on('change', '#invoiceTip', this.event.header.change_invoice)
                    // btn
                    .on('click', '#delete-tovaritelniza', this.btn.header.delete_tovaritelniza)
                    .on('click', '#returnOrder', this.btn.header.returnOrder)
                    .on('click', '#create_gensoftOrder', this.btn.header.create_gensoftOrder)
                    .on('click', '#save-ofer', this.btn.header.save)

                    // --- LEFT ASIDE ------------------------------------
                    // events
                    .on('change', '#leftAside .izborKurierKl', this.event.leftAside.change_deliveryMetod)
                    .on('change', '#leftAside #deliveryMetod', this.event.leftAside.change_deliveryMetodDilar)
                    .on('keyup', '.autocompleteCity', Lp.debounce(this.event.leftAside.autocomplete_city, 300))
                    .on('change', '#leftAside .isDDS', this.btn.leftAside.change_dds)
                    // btn
                    // радио бутони за ддс
                    .on('click', '#leftAside #grad', this.btn.leftAside.open_autocomplete_city)
                    .on('click', '#leftAside #clearCity', function () {
                        var section = $(this).parents('section');
                        section.find('#grad').attr('value', '').val('');
                        section.find('#postCode').attr('value', '').val('');
                    })
                    .on('click', '#leftAside .econtLocator,#econtLocator', Cl.econtLocator)
                    .on('click', '#leftAside .speedyLocator,#speedyLocator', Cl.speedyLocator)

                    // --- TABLE --------------------------------------------
                    // events
                    .on('change', '#izbor_sklad', this.btn.table.save_singleProduct_toGensoftOrder)
                    .on('keyup', 'tbody td.qty .qty,tbody  td.zenaProdava .zenaProdava ', this.event.table.change_qtyPrice)
                    // btn
                    .on('click', 'tbody .delete_product', Ta.tableRow.delete)

                    .on('click', 'tfoot #calculateDostavka', this.btn.table.calculateDostavka)
                    .on('click', '#priceLevel button, #priceLevelAll button', Ta.tableRow.get_priceLevel) //избор на ц. ниво от tooltip
                    .on('click', 'tbody .lastPrice', this.btn.table.getLastPrice)
        },

        'modal': {
            'open_popup_editProduct': function () {
                var $row = $(this).closest('tr');
                // Initialize an empty object to store key-value pairs
                var jsonData = {};

                if (Lp.isAddedNewProduct(v.table)) {
                    return false;
                }

                // Iterate over input elements within the current row
                $row.find('input[name]').each(function () {
                    // Get the name and value of the input element
                    var name = $(this).attr('name');
                    var value = $(this).val();

                    // Add the key-value pair to the jsonData object
                    jsonData[name] = value;
                });

                // Convert the jsonData object to a JSON string
                var jsonString = ( jsonData );


                // console.log(jsonString);
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'POST', 'ckeditor': true, 'datastr': jsonString});
            },

            'open_popup_klient': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});

                $('body').on('shown.bs.modal', function () {
                    $(this).find('a#link-obekt').trigger('click');
                });
            },

            'open_popup_returnOrder': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_generateTovaritelniza': function (e) {
                var form = $('form');
                var formData = form.serializeJSON();

                form.dontJustLeaveMe('a#generate-tovaritelniza');

                if ($(V.productTable).find('tbody tr').length == 0) {
                    alert(LANG__order.alert.emptyProducts);
                    return false;
                }

                if ($('#deliveryObekt').val() == '') {
                    alert('Не е избран клиентски обект за доставка');
                    return false;
                }

                if (formData.product_json) {
                    formData.product_json = [ ]; // Изчиства масива, без да премахва самия ключ
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'POST', 'datastr': formData});
            },

            'open_popup_requestCurier': function (e) {
                var form = $('form');
                var formData = form.serializeJSON();

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'POST', 'datastr': formData});
            },

            'open_popup_izborProduct': function ( ) {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            }
        },

        'event': {
            'leftAside': {
                'autocomplete_city': function (e) {
                    e.stopImmediatePropagation();

//                    const _this = $(this);
//                    let route = _this.closest('.bootstrap-select').find('.cityName');
//                    let keycode = ( e.keyCode ? e.keyCode : e.which );
//
//                    if ([ 40, 38, 13, 37, 39, 18, 16 ].includes(keycode)) {
//                        return false;
//                    }

                    e.stopImmediatePropagation();
                    var _this = $(this);
                    var parent = _this.closest('#toCity');
                    var autocomplete = _this.parent();
                    var inputWidth = _this.outerWidth();
                    var route = autocomplete.data('route');
                    var currentVal = _this.val().trim();
                    let maxChar = 3;
                    let remainingChars = maxChar - currentVal.length;
                    let autocompleteHtml = '';

                    // Clear autocomplete suggestions if input is empty
                    if (! currentVal) {
                        autocomplete.find('ul').remove();
                        return false;
                    }

                    if (currentVal.length < maxChar) {
                        autocomplete.find('ul').remove(); // Ensure a fresh start
                        autocomplete.append(`<ul style="width: ${inputWidth}px;"><li>Въведете най-малко ${remainingChars} символа</li></ul>`);
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: "POST",
                        global: false,
                        data: {'method': 'get_cities', 'cityName': _this.val().trim()},
                        dataType: 'json',
                        success: function (response)
                        {
                            const data = typeof response === 'string' ? JSON.parse(response) : response;

                            if (! data.result || ! data.result.cities || data.result.cities.length === 0) {
                                autocomplete.find('ul').remove(); // Clear previous content
                                autocomplete.append(`<ul style="width: ${inputWidth}px;"><li>Няма намерени населени места.</li></ul>`);
                                return;
                            }

                            autocompleteHtml = data.result.cities.map(city => {
                                let cityInfo = JSON.stringify({id: city.id, postCode: city.postCode, name: city.name});
                                return `<li data-info='${cityInfo}'>${city.name}</li>`;
                            }).join('');

                            autocomplete.find('ul').remove(); // Clear previous content
                            autocomplete.append(`<ul style="width: ${inputWidth}px;">${autocompleteHtml}</ul>`);
                        }
                    });

                    // когато изберем град от списъка autocomplete
                    autocomplete.on('mousedown', 'li', function () {
                        const info = $(this).data('info');
                        parent.find('#grad').val(info.name).attr('value', info.name);
                        parent.find('#postCode').val(info.postCode).attr('value', info.postCode);
                        autocomplete.empty();
                    });
                },

                // Метод на доставка дилър
                'change_deliveryMetodDilar': function (e) {
                    let $this = $(this);
                    let deliveryObekt = $('#deliveryObekt-block').find('#deliveryData');
                    let prevozvach = $('#leftAside #prevozvach');
                    let isCurier = $this.val() === 'curier';

                    isCurier ? prevozvach.addClass('hide') : prevozvach.removeClass('hide');
                    deliveryObekt.toggleClass('hide', ! isCurier).find(':input').val('');
                },

                // Метод на доставка
                'change_deliveryMetod': function (e) {
                    let $this = $(this);
                    let deliveryObekt = $this.closest('#deliveryObekt-block');
                    let name = $this.val();

                    let deliveryOptions = {
                        'econt_office': {showOfis: true, showDoor: false},
                        'speedy_office': {showOfis: true, showDoor: false},
                        'econt_door': {showOfis: false, showDoor: true},
                        'speedy_door': {showOfis: false, showDoor: true}
                    };

                    if ($this.is(':checked')) {
                        let toOfis = deliveryObekt.find('#toOfice');
                        let toDoor = deliveryObekt.find('#toAdres');
                        let toCity = deliveryObekt.find('#toCity');
                        let options = deliveryOptions[name] || {showOfis: false, showDoor: false};

                        $('#grad').toggleClass('pointer-events-none', ! options.showDoor)
                                .next('#clearCity').toggleClass('hide', ! options.showDoor);

                        toOfis.toggleClass('hide', ! options.showOfis);
                        toDoor.toggleClass('hide', ! options.showDoor);
                        toOfis.add(toDoor).add(toCity).find(':input').val('');// Clear inputs

                        [ 'econt', 'speedy' ].forEach(courier => {
                            deliveryObekt.find(`.${courier}Locator`).toggleClass('hide', ! name.includes(courier) || options.showDoor);
                        });
                    }
                }
            },

            'table': {
                'change_qtyPrice': function (e) {
                    e.stopImmediatePropagation();
                    let _this = $(this);
                    let totalKolich = parseFloat(_this.closest('tr').find('td.totalKolich .totalKolich').text());

                    if (_this.hasClass('qty')) {
                        if (! $.isNumeric(totalKolich)) {
                            alert('Няма наличност');
                        }
                        if (_this.val() > parseFloat(totalKolich)) {
                            alert('Няма достатъчна наличност');
                        }
                    }

                    Lp.order_total_in_footer({'table': V.productTable, 'symbol': ' лв.'});
                }
            },

            'header': {
                'change_invoice': function (e) {
                    var value = $(this).val();
                    $('#' + ( value === 'фактура' ? 'sDDS' : 'bezDDS' )).trigger('click');
                }
            },
        },

        'btn': {
            'header': {
                'save': function (e) {
                    if ($(V.productTable).find('tbody tr').length == 0) {
                        alert(LANG__order.alert.emptyProducts);
                        return false;
                    }

                    if (validate_empty.validate(e, null, null, $('form')) == true) {
                        return false;
                    }

                    if (! confirm(LANG__order.confirm.save)) {
                        return false;
                    }

                    $(document).off('submit').on('submit', 'form', function (e) {
                        e.preventDefault( );
                        var form = $(this);

                        $.ajax({
                            url: form.attr('data-route'),
                            type: 'POST',
                            data: form.serializeJSON( ),
                            dataType: 'json',
                            success: function (response) {
                                const currentURL = new URL(window.location.href);
                                const orderTip = currentURL.searchParams.get('orderTip');

                                if (response.errors) {
                                    let errorMessages = response.errors.map(error => error.err).join("\n\n");
                                    alert("Следните грешки бяха открити:\n\n" + errorMessages);
                                    return false;
                                }

                                currentURL.searchParams.set('orderTip', orderTip);
                                currentURL.searchParams.set('orderId', response.orderId);
                                currentURL.searchParams.set('name', response.orderId);
                                window.history.pushState({}, '', currentURL);

                                alert('Поръчката записана');
                                window.location.reload();
                            }
                        });

                        //e.stopImmediatePropagation( );
                    });
                },

                // iztriwane na товарителница
                'returnOrder': function (e) {
                    var _this = $(this);
                    var form = _this.closest('form');
                    var route = _this.data('route');

                    if (! confirm('Сигурни ли сте, че искате да върнете цялата поръчка?')) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: form.serializeJSON( ),
                        dataType: 'json',
                        success: function (response) {
                            history.go(0);
                        }
                    });
                },

                // връщане на поръчката
                'delete_tovaritelniza': function (e) {
                    var _this = $(this);
                    var route = _this.data('route');

                    if (! confirm('Сигурни ли сте, че искате да изтриете товарителницата?')) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        success: function (response) {
                            history.go(0);
                        }
                    });
                },

                'create_gensoftOrder': function (e) {
                    var _this = $(this);
                    var form = _this.closest('form');
                    var route = _this.data('route');
                    var productIds = [ ];
                    let errors = [ ];
                    var agent = $('#agent').val();
                    var dateShipping = $('#date_shipping').val();
                    var is_tavaritelnizaNo = $('#tavaritelnizaNo').text();
                    var whoPayBill = $('#whoPayBill').val();
                    var deliveryMetod = $('#deliveryMetod').val();


                    //$('form').dontJustLeaveMe(':input');

                    if (! agent || ! dateShipping) {
                        _this.val('');

                        alert(! agent && ! dateShipping
                                ? 'Липсват агент и дата на експедиция.'
                                : ! agent
                                ? 'Липсва агент.'
                                : 'Липсва дата на експедиция.');
                        return false;
                    }

                    if (! is_tavaritelnizaNo && ( deliveryMetod == 'curier' && ! whoPayBill )) {
                        alert('Липсва за чия сметка е плащането!');
                        return false;
                    }

                    if (! confirm('Сигурни ли сте, че искате да прехвърлите цялата поръчка към нова Gensoft поръчка?')) {
                        return false;
                    }

                    $(V.productTable + ' tbody tr').filter(function () {
                        let productName = $(this).find('td.productName span').text();
                        let qty = $(this).find('input.qty').val();
                        let price = $(this).find('input.zenaProdava').val();

                        if (! price && ! qty) {
                            errors.push('Липсва продажна цена и количесто за продукт: ' + productName);
                        }
                        else if (! qty) {
                            errors.push('Липсва количество за продукт: ' + productName);
                        }
                        else if (! price) {
                            errors.push('Липсва продажна цена за продукт: ' + productName);
                        }

                        productIds.push($(this).data('id'));
                    });

                    if (errors.length > 0) {
                        alert(errors.join('\n\n'));
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'productIds': JSON.stringify(productIds), 'form': form.serializeJSON( ), 'orderTip': 'site'},
                        dataType: 'json',
                        success: function (response) {

                            if (response.err) {
                                alert(response.err);
                                return false;
                            }

                            alert('Създадена е Gensoft поръчка');
                            window.history.go(0);
                        }
                    });
                }
            },

            'leftAside': {
                // отваряне на доп поле за търсене на град
                'open_autocomplete_city': function (e) {
                    var _this = $(this);
                    var parent = _this.closest('#toCity');
                    var autocomplete = parent.find('.autocomplete');
                    var autocompleteHtml = '';

                    autocompleteHtml = `<input class="autocompleteCity" type="text" placeholder="въведете населено място" style="border: 5px solid #eac263;"><ul class="bg-transparent"></ul>`;
                    autocomplete.html(autocompleteHtml);
                    autocomplete.find('.autocompleteCity').focus();

                    $(document).on('mousedown.autocomplete', function (e) {
                        if (! autocomplete.is(e.target) && autocomplete.has(e.target).length === 0) {
                            autocomplete.empty(); // Clear suggestions
                        }
                    });
                },

                'change_dds': function (e) {
                    var isVatSelected = $(this).val() == ''; // bez dds
                    var prihod = $(V.productTable).find('tfoot tr#prihod td.suma');
                    var ddsPercent = typeof SETTINGS_DDS !== "undefined" ? ( SETTINGS_DDS / 100 ) : 0;

                    // ако изберем радио бутона с ДДС
                    $(V.productTable).find('tfoot tr#dds, tfoot tr#total_s_dds').toggleClass('hide', isVatSelected);

                    if (isVatSelected) {
                        prihod.text(Lp.toFixed(parseFloat(prihod.text()) / ( ddsPercent + 1 )) + ' лв');
                    }
                    else {
                        prihod.text(Lp.toFixed(parseFloat(prihod.text()) * ( ddsPercent + 1 )) + ' лв');
                    }
                }
            },

            'table': {
                // последна продажна цена от gensoft за клиент
                'getLastPrice': function (e) {
                    let _this = $(this);
                    let route = _this.data('route');
                    var firmaName = $('#leftAside #klient_name').val();
                    var td = _this.closest('td');

                    if (firmaName == '') {
                        alert('Липсва клиент!');
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: {'firmaName': firmaName},
                        success: function (response) {
                            if (response.err) {
                                alert(response.err);
                                return false;
                            }

                            td.find('input.zenaProdava').val(response).trigger('keyup');
                        }
                    });
                },

                // запис на продукт в генсофт поръчка
                'save_singleProduct_toGensoftOrder': function (e) {
                    let _this = $(this);
                    let route = _this.data('route');
                    let productId = _this.data('productid');
                    let skladName = _this.find('option:selected').text();
                    let table = $(V.productTable).find(`tbody tr[data-id=${productId}]`);
                    var qty = table.find('input.qty').val();
                    var price = table.find('input.zenaProdava').val();
                    var agent = $('#agent').val();
                    var dateShipping = $('#date_shipping').val();

                    if (_this.val() == '') {
                        return false;
                    }

                    if (! qty || ! price) {
                        _this.val('');
                        alert(! qty ? 'Липсва количество.' : 'Липсва продажна цена.');
                        return false;
                    }

                    if (! agent || ! dateShipping) {
                        _this.val('');
                        alert(! agent && ! dateShipping
                                ? 'Липсват агент и дата на експедиция.'
                                : ! agent
                                ? 'Липсва агент.'
                                : 'Липсва дата на експедиция.');
                        return false;
                    }

                    if (! confirm(`Сигурни ли сте, че искате да прехвърлите продукта към Gensoft поръчка в склад ${skladName}?`)) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: {'isSingleProduct': 1, 'productIds': productId, 'sklad': skladName, 'orderTip': 'site'},
                        success: function (data) {

                            if (data.err) {
                                alert(data.err);
                                return false;
                            }

                            $('.tooltipster-show').remove();

                            $(V.productTable).load(window.location.href + '&no_ajax=true ' + V.productTable + '>*', function (response, status, xhr) {
                                self.plugins( );

                                $('#create_gensoftOrder').attr('disabled', true);
                                $('header #statusOrder').val(3);
                                alert('Продуктът е добавен в Gensoft поръчка.');
                            });
                        }
                    });
                },

                // изч. на доставката за куриер
                'calculateDostavka': function (e) {
                    e.stopImmediatePropagation();
                    var _this = $(this);
                    var route = _this.data('route');
                    var curierTip = V._leftAside.find(V.izborKutier + ' ' + 'option:selected').data('tip');
                    var form = $('form').serializeJSON( );
                    var dostavka = $(V.productTable).find('tfoot tr#dostavka');
                    var symbol = dostavka.find(V.valutaSymbol).text();
                    var isOfice = false;
                    var arr = [ ];

                    if (validate_empty.validate_calcDostavka($(V.grad + ', tfoot ' + V.totalWeight)) === true) {
                        return false;
                    }

                    if ($('#leftAside #deliveryObekt').val() == '') {
                        alert('Не е избран обект за доставка');
                        return false;
                    }

                    isOfice = $('#leftAside #ofis').val() != '';


                    arr = {'grad': $(V.grad).val(), 'weight': $(V.totalWeight).val(), 'isOfice': isOfice};
                    console.log(arr);

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: JSON.stringify(arr),
                        success: function (data) {

                            console.log(data);
                            if (data.error) {
                                alert(data.error.message || data.error);
                                return false;
                            }
                            else {

                                dostavka.find('#dostavkaVal').text(data.totalPrice + ' лв.');
                                dostavka.find('#totalAndDostavkaVal').text(parseFloat(data.totalPrice) + parseFloat($('#total_s_dds .suma').text()) + ' лв.');

                            }
                        }
                    });
                }
            }
        }
    };

    order.init( );
} )(jQuery, window, document);
