/* global loadPlugins, SETTINGS_NUM_FIXED, tableActions, leftAsideActions  */
( function ($, window, document) {

    var promo = promo || {};
    let v = promo;
    let $self = promo;

    $('form').dontJustLeaveMe('a#prinPreview'); // plygin za напускане на стр и  ако има промяна 
    //в офертата за предпечат ценообр и нова оферта

    promo = {
        '__var': {
            table: '#tbl_products'
        },
        'init': function () {
            v = this.__var;
            $self = this;
            $root = this;

            this.plugins();
            this.setUpListeners();
            this.triggers();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Ta = tableActions;
            Lsa = leftAsideActions;

            //Lp.lazyLoadTable();
            Lp.check_ofer.beforeUnload(); // ако излезем от отворената оферта
            Lp.sessionTimeout();
            Lp.zoomImg();
            Lp.popupTitle();
            Lp.table_freezeHeader({'table': v.table, 'margin': 100}); // thead frezze
            Lp.tableRow_filter({'input': '#filter', 'table': v.table}); // филтър

            Ta.getTotal_inFooter({'table': v.table, 'autoTigger': true});
            Ta.tableRow.move();

            Lsa.colorChoice(); // избор на цветни редове
        },

        'triggers': function () {
            $('tbody .cenaZavishena').trigger('keyup');
        },

        'setUpListeners': function ( ) {

            // DISABLED CLICK
            $(document).on('click', '[disabled]', this.event.isAllowed);

            // POPUP 
            $(document)
                    .on('click', '#izbor-zenova', this.modal.open_popup_izborZenova)
                    .on('click', '#popupToSite', this.modal.open_popup_toSite)
                    .on('click', 'tbody .edit_product, #new_product', this.modal.open_popup_editProduct)
                    .on('click', '#izbor-product', this.modal.open_popup_izborProduct)
                    .on('click', '#add-colorRow', this.modal.open_popup_colorRow);

            //  EVENTS
            $(document)
                    // --- left aside

                    // --- in table
                    .on('mouseover', 'tbody .rowPosition', Ta.tableRow.position.getTitle)
                    .on('keyup', 'td.zenaProdava .zenaProdava ', function () {
                        Ta.getTotal_inFooter({'table': v.table});
                    })
                    .on('keyup', 'tbody .cenaZavishena', this.event.table.zavishenaZena)
                    .on('keyup', 'tbody .percent_zavishenaZena', this.event.table.percent_zavishenaZena)
                    .on('keyup', 'tbody .zenaProdava', this.event.table.zenaProdava)
                    .on('blur', 'tbody td.zenaProdava .zenaProdava,tbody td.kkc .kkc ', function () {
                        var numDec = this.value;
                        if (numDec != '') {
                            this.value = Lp.toFixed(this.value);
                        }
                    });

            //BTN
            $(document)
                    // --- left aside
                    .on('click', '#leftAside .colorDisplay', Lsa.changeColor)

                    // --- in table
                    .on('click', 'thead #allToSite', this.btn.table.change_allSite)
                    .on('click', 'thead #deleteFromSite', this.btn.table.delete_fromSite)
                    .on('click', 'thead #btn-total_percent_ок', this.btn.table.total_percent_zavishenaZena)
                    .on('click', 'thead .showHidePromoPrice_all_inSite', this.event.table.showHidePromoPrice_all_inSite)
                    .on('click', 'tbody .isShowPromoPrice_inSite', this.event.table.isShowPromoPrice_inSite)//показване на промо цена в сайт
                    .on('click', 'tbody .toSite', this.btn.table.toSite)
                    .on('click', 'tbody .rowPosition', Ta.tableRow.position.setPosition)
                    .on('click', 'tbody .delete_product', Ta.tableRow.delete)
                    .on('click', 'tbody tr.colorRows .edit_colorRow', Ta.colorRow.edit)
                    .on('click', 'tbody .delete_colorRow', Ta.colorRow.delete)
                    .on('click', '#priceLevel button, #priceLevelAll button', Ta.tableRow.get_priceLevel) //избор на ц. ниво от tooltip

                    // --- header
                    .on('click', '#convertOfer', this.btn.header.convertOfer)
                    .on('click', '#save-ofer', this.btn.header.save);
        },

        'modal': {
            'open_popup_izborZenova': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_toSite': function () {
                var _this = $(this);
                var productIds = [ ];

                if (_this.is("[disabled]")) {
                    return false;
                }

                if ($(v.table).find('tbody tr').length == 0) {
                    alert(LANG__special.alert.emptyProducts);
                    return false;
                }

                $(v.table + " > tbody > tr:not(.colorRows)").filter(function () {
                    productIds.push($(this).data('id'));
                });

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'datastr': "productIds=" + JSON.stringify(productIds)});
            },

            'open_popup_colorRow': function () {
                var colorValue = $('#left-aside').find('#colorValue').val();

                if ($(v.table).find('tbody tr').length == 0) {
                    alert(LANG__special.alert.emptyProducts);//ДОбавете поне 1 продукт в таблицата
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'POST', 'datastr': `colorValue=${colorValue}`});
            },

            'open_popup_izborProduct': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_editProduct': function () {
                if (Lp.isAddedNewProduct(v.table)) {
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'ckeditor': true});
            }
        },

        'event': {
            'table': {
                // показва промо цената за всички продукти в сайт
                'showHidePromoPrice_all_inSite': function () {
                    const _this = $(this);
                    const action = _this.data('action');
                    const route = _this.data('route');
                    const chkInputs = $(v.table).find('tbody td.chk_promoPrice .isShowPromoPrice_inSite');
                    const productIds = chkInputs.map(function () {
                        return {
                            'id': $(this).closest('tr').data('id'),
                            'checked': $(this).is(':checked')
                        };
                    }).get();

                    const filteredIds = productIds
                            .filter(item => action === 'show' ? ! item.checked : item.checked)
                            .map(item => item.id);

                    let confirmationMessage = action == 'show' ?
                            'Потвърдете показването на промоционалните цени за всички продукти от промоцията в сайт.' :
                            'Сигурнили сте че искате да премахнете промоционалните цени за всички продукти от промоцията в сайт.';

                    if (! confirm(confirmationMessage)) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'action': action, 'productIds': filteredIds},
                        dataType: 'json',
                        success: function (response) {
                            if (response.err) {
                                alert(response.err);
                            }

                            else if (response.success) {
                                // Update input states based on action
                                chkInputs.each(function () {
                                    chkInputs.each(function () {
                                        $(this).prop('checked', action === 'show');
                                    });
                                });

                                alert(response.success);
                            }
                        }
                    });
                },

                // дали да се вижда промо цената на продукт в сайт
                'isShowPromoPrice_inSite': function () {

                    var _this = $(this);
                    var route = _this.data('route');

                    var confirmationMessage = this.checked ?
                            'Потвърдете показването на промоционалната цена.' :
                            'Сигурнили сте че искате да премахнете промоционалната цена.';

                    if (! confirm(confirmationMessage)) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'isChecked': this.checked},
                        dataType: 'json',
                        success: function (response) { }
                    });
                },

                // промяна на процент за завишена цена
                'percent_zavishenaZena': function () {
                    const _this = $(this);
                    var $tr = _this.closest('tr');
                    var cenaKKC = parseFloat($tr.find('td.zenaProdava .zenaProdava').val());
                    var percent = parseFloat(_this.val()) / 100;
                    var $cenaZavishena = _this.closest('td').find('.cenaZavishena');

                    if (isNaN(cenaKKC) || cenaKKC <= 0) {
                        alert('Липсва цена дилър');
                        $cenaZavishena.val('');
                        _this.val('');
                        return false;
                    }

                    if (isNaN(percent) || ! isFinite(percent)) {
                        $cenaZavishena.val('');
                    }
                    else {
                        var calculatedValue = cenaKKC / ( 1 - percent );
                        $cenaZavishena.val(calculatedValue.toFixed(2));
                    }
                },

                // промяна на завишена цена se променя и процент завиш цена
                'zavishenaZena': function (e) {
                    e.stopImmediatePropagation();

                    const _this = $(this);
                    var tr = _this.closest('tr');
                    var cenaKKC = parseFloat(tr.find('td.zenaProdava .zenaProdava').val());
                    var zavishenaZena = parseFloat(_this.val());
                    var inpPercent = _this.closest('td').find('.percent_zavishenaZena');

                    if (isNaN(cenaKKC) || cenaKKC <= 0) {
                        if (e.isTrigger !== undefined) {
                            return false;
                        }

                        alert('Липсва цена дилър');
                        inpPercent.val('');
                        _this.val('');
                        return false;
                    }

                    if (isNaN(zavishenaZena) || zavishenaZena <= 0) {
                        inpPercent.val('');
                    }
                    else {
                        var percent = ( ( zavishenaZena - cenaKKC ) / zavishenaZena ) * 100;
                        inpPercent.val(percent.toFixed(SETTINGS_NUM_FIXED));
                    }
                },

                // промяна на завишена цена se променя и процент завиш цена
                'zenaProdava': function (e) {
                    e.stopImmediatePropagation();

                    const _this = $(this);
                    let tr = _this.closest('tr');
                    let cenaKKC = parseFloat(_this.val());
                    let zavishenaZena = parseFloat(tr.find('.cenaZavishena').val());
                    let inpPercent = tr.find('.percent_zavishenaZena');

                    if (isNaN(cenaKKC) || cenaKKC <= 0) {
                        inpPercent.val('');
                        _this.val('');
                        return false;
                    }

                    if (isNaN(zavishenaZena) || zavishenaZena <= 0) {
                        inpPercent.val('');
                    }
                    else {
                        let percent = ( ( zavishenaZena - cenaKKC ) / zavishenaZena ) * 100;

                        inpPercent.val(percent.toFixed(SETTINGS_NUM_FIXED));
                        inpPercent.trigger('keyup');
                    }
                }
            },

            // ако бутон е забранен се извежда съобщение когато се кликне на него
            'isAllowed': function () {
                var _this = $(this);

                alert(this.outerText + ' ' + LANG__special.buttonDisabled);//функцията ще бъде активна след запис

                _this.removeAttr('href');
            },

            'leftAside': {}
        },

        'btn': {
            'leftAside': {},

            'table': {

                // обща ф-я за добавяне на продукти към сайтове за конкретната ценова листа
                'toggleSiteProducts': function (route, is_toSite, confirmMessage) {
                    var isConfirmed = confirm(confirmMessage);
                    var productIds = [ ];

                    if (! isConfirmed) {
                        return;
                    }

                    $(v.table).find('tbody input.toSite').each(function () {
                        var isChecked = is_toSite ? 1 : 0;

                        $(this).prop('checked', isChecked);
                        productIds.push($(this).closest('tr').data('id'));
                    });

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'is_toSite': is_toSite, 'productIds': productIds},
                        dataType: 'json',
                        success: function (response) {
                            if (response.err) {
                                $(v.table).find('tbody input.toSite').prop('checked', false);
                                alert(response.err);
                            }
                            else if (response.success) {
                                alert(response.success);
                            }
                        }
                    });
                },

                // премахване на всички продукти към всички сайтове за конкретната ценова листа
                'delete_fromSite': function () {
                    var _this = $(this);
                    var route = _this.data('route');
                    var is_toSite = 0; // false
                    var confirmMessage = 'Сигурни ли сте, че искате да отмаркирате всички продукти участващи в сайтовете!';

                    $self.btn.table.toggleSiteProducts(route, is_toSite, confirmMessage);
                },

                // всички на продукт към всички сайтове за конкретната ценова листа
                'change_allSite': function () {
                    var _this = $(this);
                    var route = _this.data('route');
                    var is_toSite = 1 // true 
                    var confirmMessage = 'Сигурни ли сте, че искате да маркирате всички продукти участващи в сайтовете!';

                    $self.btn.table.toggleSiteProducts(route, is_toSite, confirmMessage);
                },

                // маркиране на продукт към всички сайтове за конкретната ценова листа
                'toSite': function (e) {
                    var _this = $(this);
                    var productName = _this.closest('tr').find('td.productName').data('name');
                    var route = $(this).data('route');
                    var hasKKC = $(this).data('cenakkc');
                    var is_toSite = _this.is(':checked') ? 1 : 0; // 0-false 1-true
                    var actionText = is_toSite ? 'добавите в' : 'премахнете от';

                    // Филтрира null стойностите от priceData , само ако има ценообразуванр може да се добави към сайтове
                    var filteredPriceData = _this.data('price').filter(function (price) {
                        return price !== null;
                    });

                    if (productName == '') {
                        alert('Липсва име на продукта и неможе да бъде избран!');
                        return false;
                    }
                    else if (! hasKKC) {
                        alert('Ценообразуване не е пълно за този продукт. Липсва цена ККЦ и неможе да бъде избран!');
                        return false;
                    }

                    if (! confirm(`Сигурни ли сте, че искате да ${actionText} всички сайтове продукта \n\n ${productName}`)) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'is_toSite': is_toSite},
                        dataType: 'json',
                        success: function (response) {
                            if (response.err) {
                                _this.prop('checked', false);
                                alert(response.err);
                            }

                            else if (response.success) {
                                alert(response.success);
                            }
                        }
                    });
                },

                // всички на продукт към всички сайтове за конкретната ценова листа
                'change_allSite': function () {
                    var _this = $(this);
                    var route = _this.data('route');
                    var is_toSite = 1 // true 
                    var confirmMessage = 'Сигурни ли сте, че искате да маркирате всички продукти участващи в сайтовете!';

                    $self.btn.table.toggleSiteProducts(route, is_toSite, confirmMessage);
                },

                // процент за всички редове
                'total_percent_zavishenaZena': function () {

                    var input = $(this).closest('th').find('#total_percent_zavishenaZena');

                    if (confirm('Тази функция ще присвои избран процент за всички продукти в текущата промоция.\nИскате ли да продължите?')) {
                        $(this).closest('table').find('tbody input.percent_zavishenaZena').val(input.val());

                        input.val('');

                        // премахване за закл. input полета в кол. завишена цена
                        $(this).closest('table').find('tbody input.percent_zavishenaZena,tbody input.cenaZavishena').prop("readonly", false);
                        $(this).closest('table').find('tbody input.percent_zavishenaZena').trigger('keyup');
                    }
                },

                // избиране на цен ниво за всички продукти
//                'izbor_zenovoNivo': function () {
//                    var productIdArr = [ ];
//
//                    $.each($(v.table).find('tbody tr:not(.colorRows)'), function () {
//                        productIdArr.push($(this).data('id'));
//                    });
//
//                    $.ajax({
//                        url: $(this).closest('table').data('route'),
//                        type: 'POST',
//                        data: {'nivo': $(this).data('nivo'), 'productIdArr': productIdArr},
//                        dataType: 'json',
//                        success: function (response) {
//                            var valuta_izbor = $('#valuta_izbor').find(":selected").data();
//
//                            $(v.table).find('tbody').html(response);
//
//                            if (valuta_izbor && valuta_izbor.val != 'undefined' && valuta_izbor.val != 'null') {
//                                Ta.getTotal_inFooter({'table': v.table, 'addZenova': true});
//                            }
//
//                            $self.plugins();
//                        }
//                    });
//
//                    event.stopImmediatePropagation();
//                },
            },

            'header': {

                'convertOfer': function (e) {
                    var _this = $(this);
                    var route = _this.data('route');
                    var oferName = _this.data('name');

                    if (! confirm('Сигурни ли сте, че икскате да преобразувате тази оферта в поръчка')) {
                        return false;
                    }

                    oferName = prompt('Ако желаете може да промените името', oferName);

                    if (oferName == '') {
                        alert('Трябва да въведете име за преобразуването на оферта в поръчка')
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: {'oferName': oferName},
                        success: function (response) {

                            if (response.messages) {
                                $('body').append(response.messages);
                            }
                        }
                    });

                    e.stopImmediatePropagation();
                },

                'save': function (e) {

                    var deletedProductArrId = $(this).attr('data-delete-product').split(',');

                    if (! confirm(LANG__special.confirm.save)) {
                        return false;
                    }

                    if ($(v.table).find('tbody tr').length == 0) {
                        alert(LANG__special.alert.emptyProducts);
                        return false;
                    }

                    if (validate_empty.validate(e, null, null, $('#leftAside')) == true) {
                        return false;
                    }

                    $(document).off('submit').on('submit', 'form', function (e) {
                        e.preventDefault();

                        var form = $(this);

                        $.ajax({
                            url: form.attr('data-route'),
                            type: 'POST',
                            data: {'form': JSON.stringify(form.serializeJSON()), 'deletedProductArrId': deletedProductArrId},
                            dataType: 'json',
                            success: function (response) {
                                const currentURL = new URL(window.location.href);

                                if (response.err) {
                                    alert(response.err);
                                }
                                //ако е нова оферта се пренасрочва
                                else {
                                    currentURL.searchParams.set('id', response.id);
                                    window.history.pushState({}, '', currentURL);
                                    window.location.reload();
                                    //history.go(0);
                                }
                            }
                        });

                        e.stopImmediatePropagation();
                    });
                }
            }
        }
    };

    promo.init();

}(window.jQuery, window, document) );
