/* global categoryTree, mqrkaTree, form, Popup_product_fillCatSelect, loadPlugins, categoryAttr, CKEDITOR, curierLocator */
( function ($, window, document, undefined) {

    var nastrojki = nastrojki || {};
    let v = nastrojki;

    nastrojki = {
        '__var': {
            tab: $('#currentView').data('view'),
        },
        'init': function ( ) {
            v = this.__var;

            Lp = loadPlugins;
            Cl = curierLocator;

            Lp.popupTitle();
            this.setUpListeners( );
        },
        'setUpListeners': function ( ) {

            //=====  EVENTS ====================================
            $(document)
                    .on('change', '#pricesWithVat', this.ui.change_pricesWithVat)


            //=====  BUTTONS ====================================
            $(document)
                    .on('click', '#econtLocator', Cl.econtLocator)
                    .on('click', '#speedyLocator', Cl.speedyLocator)
                    .on('click', 'tbody .editSite', this.btn.editSite)
                    .on('click', '#clearSiteData', this.btn.clearSiteData)
                    .on('click', '#formatAllProductModel', this.btn.formatAllProductModel)
                    //.on('click', '.js-passwordRequired', this.btn.grantAcsses)
                    // подготовка на нова gensоft база данни
                    .on('click', '.sql', this.btn.sql)
                    .on('click', '#saveSite', this.btn.saveSite)
                    .on('click', '.js-saveFormVisible', this.btn.header.save);
        },

        'ui': {
            // смяна на цената със или без ДДС
            'change_pricesWithVat': function (e) {
                e.stopImmediatePropagation( );
                let _this = $(this);
                let checked = _this.is(':checked');
                let route = _this.data('route');
                let data = {};

                if (checked) {
                    data['settings[prices_with_dds]'] = 1;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: data,
                    dataType: 'json',
                    success: function (response) {
                        if (response && response.ok) {

                            let parent = _this.parent();

                            parent.find('#js-priceLblDDS, #js-priceLblBezDDS').removeClass('text-danger fw-bold');
                            parent.find(checked ? '#js-priceLblDDS' : '#js-priceLblBezDDS').addClass('text-danger fw-bold');

                            alert('✔ Цените вече са ' + ( checked ? 'С ДДС' : 'БЕЗ ДДС' ));
                        }
                        else {
                            _this.prop('checked', ! checked);
                            alert('❌ Грешка при запис на настройката.\nМоля, опитайте отново.');
                        }
                    }
                });
            }
        },

        'btn': {
            // преди да кликнем на този таб се пита за парола
            'grantAcsses': function (e) {
                e.stopImmediatePropagation( );
                let password = prompt("Моля, въведете парола за достъп:");

                $($(this).attr('href')).hide();

                if (! password) {
                    return false;
                }

                if (password !== GLOBVAR.passwordLock) {
                    alert('Въведената парола е грешна!');
                    return false;
                }

                $($(this).attr('href')).show();
            },

            // заявки към gensoft за подготвяне на новата база само от мен суперадмин
            'sql': function (e) {
                var _this = $(this);

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                   // dataType: 'json',
                    success: function (response) {
          
                        _this.parent().find('span').html(response);
                    }
                });
            },

            'clearSiteData': function ( ) {
                $('form').trigger("reset");
            },
            'editSite': function ( ) {
                var _this = $(this);
                var tr = _this.closest('tr');

                tr.find('td:not(.action)').each(function ( ) {
                    $('form').find('input#' + $(this).attr('class')).val($(this).text( ));
                });
            },
            // форматиране текста на моделите на продукт с ГЛАВНИ или с 1-ва Главна буква
            'formatAllProductModel': function (e) {
                let _this = $(this);
                let format = $(document).find('#formatProduktModel option:selected');

                if (! confirm(`Сигурни ли сте че искате да промените текста на всички модели да да започват ${format.text()}`)) {
                    return false;
                }

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    data: {'format': format.val()},
                    dataType: 'json',
                    success: function (response) {
                        alert('Форматирането е готово');
                    }
                });
            },

            'saveSite': function (e) {
                var _this = $(this);

                if (validate_empty.validate(e, null, null, $('form')) == true) {
                    e.preventDefault( );
                    return false;
                }

                $(document).off('submit').on('submit', 'form', function (e) {
                    e.preventDefault( );
                    var form = $('form');

                    $.ajax({
                        url: _this.attr('data-route'),
                        global: false,
                        type: 'POST',
                        data: {'form': form.serializeJSON( )},
                        dataType: 'json',
                        statusCode: {
                            500: function ( ) {
                                alert("Грешка при свързване с базата данни!\nПроверете отново данните за връзка с MYSQL базата данни.");
                                return false;
                            }
                        },
                        success: function (response) {
                            history.go(0);
                        }
                    });
                });
            },
            'header': {
                'save': function () {

//                    if (validate_empty.validate(e, null, null, $('form')) == true) {
//                        //return false;
//                    }
                    var form = $(this).closest('form');
                    var url = form.attr('action');
                    var formData = form.find(':input:visible').serialize();
                    let activeLink = $('#accordionMenu a.active').attr('href');

                    $.ajax({
                        url: url,
                        method: 'POST',
                        dataType: 'json',
                        data: formData,
                        success: function (response) {

                            if (activeLink == '#tab-courier') {
                                $('#tab-courier').load(window.location.href + ' #tab-courier>*', function (response, status, xhr) {

                                });
                            }

                            alert('Настройките са запазени успешно!');
                        },
                    });
                }
            }

        }
    };
    nastrojki.init( );
} )(jQuery, window, document);
