/* global loadPlugins */
( function ($, window, document, undefined) {

    var nastrojkiPreval = nastrojkiPreval || {};
    let v = nastrojkiPreval;
    let helpers;

    nastrojkiPreval = {
        '__var': {
            GENSOFT_BLOCKED: GENSOFT_BLOCKED || false,
            formIsDirty: false,
            originalFormData: ''
        },
        'init': function ( ) {
            v = this.__var;
            helpers = this.helpers;

            v.originalFormData = $('#tab-preval :input').serialize();

            this.helpers.updateRevalueButtonState();
            helpers.activateTabFromUrl();
            this.setUpListeners();
        },
        'setUpListeners': function () {

            $(document)
                    /** UI ЗА ПРОМЯНА       
                     =================================================*/
                    .on('change', '#gensoftToggle', this.ui.toggleGensoft)
                    // при настъпила промяна 
                    .on('change keyup', '#tab-preval :input', this.ui.markDirty)
                    // смяна на режима
                    .on('change', "input[name='settings[preval][mode]']", this.ui.toggleBoxes)
                    /** BTN ДЕЙСТВИЯ    
                     =================================================*/
                    // проверка на apito
                    .on('click', '#btnCheckAPI', this.api.checkApi)
                    // изчисляване на коефициента
                    .on('click', '#calcCrossRate', this.ui.calcCrossRate)
                    // авт обновявне на коефициентите
                    .on('click', '#refreshAutoRates', this.api.refreshRates)
                    // обновяване на базата данни
                    .on('click', '#btnRevalue', this.btn.revalue)
                    .on('click', '#btnSaveSettings', this.btn.saveSettings);
        },
        // (user interactions)
        'ui': {
            'toggleGensoft': function () {
                let el = $(this);
                let url = el.data('url');

                $.post(url, {}, function (res) {
                    if (res.status !== 'ok') {
                        alert('Грешка при запис на Gensoft настройката');
                        el.prop('checked', ! el.is(':checked'));
                        return;
                    }

                    v.GENSOFT_BLOCKED = ! ! res.gensoft_block;

                    // Sync checkbox with backend truth
                    el.prop('checked', v.GENSOFT_BLOCKED);

                    // Update Revalue button
                    helpers.updateRevalueButtonState();
                });
            },

            'markDirty': function () {
                let current = $('#tab-preval :input').serialize();
                v.formIsDirty = ( current !== v.originalFormData );
                helpers.updateRevalueButtonState();
            },

            'toggleBoxes': function () {
                let mode = $("input[name='settings[preval][mode]']:checked").val();

                $('#manualBox').toggleClass('hide', mode === 'auto');
                $('#autoBox').toggleClass('hide', mode === 'manual');

                if (mode === 'auto') {
                    v.formIsDirty = false;
                    helpers.updateRevalueButtonState();
                }
            },

            'calcCrossRate': function () {
                let eur = parseFloat($('#eur_bgn').val());
                let usd = parseFloat($('#usd_bgn').val());

                if (eur > 0 && usd > 0) {
                    $('#eur_usd').val(( eur / usd ).toFixed(4));
                }
            }
        },

        'api': {

            'checkApi': function () {
                const _this = $(this);
                let icon = _this.find('i').addClass('spin');
                let route = _this.data('route');

                $('#apiStatusText').text('Проверка...');

                $.get(route, function (res) {
                    icon.removeClass('spin');

                    $('#apiStatusText').html(
                            res.status === 'ok'
                            ? '<span class="saas-badge badge-success-saas">Свързано</span>'
                            : '<span class="saas-badge badge-danger-saas">API недостъпно</span>'
                            );
                });
            },

            'refreshRates': function () {
                let btn = $(this);
                let icon = btn.find('i').addClass('spin');
                let route = btn.data('route');

                btn.prop('disabled', true);
                $('#apiStatusText').text('Зареждане...');

                $.get(route).done(function (res) {
                    if (res.status === 'ok') {
                        $('#api_eur_bgn').val(res.rates.EUR_BGN).addClass('flash');
                        $('#api_usd_bgn').val(res.rates.USD_BGN).addClass('flash');
                        $('#api_eur_usd').val(res.rates.EUR_USD).addClass('flash');

                        $('#apiStatusText').html(
                                '<span class="saas-badge badge-success-saas">Курсовете са обновени</span>'
                                );
                    }
                    else {
                        $('#apiStatusText').html(
                                '<span class="saas-badge badge-danger-saas">Грешка при зареждане</span>'
                                );
                    }
                })
                        .fail(function () {
                            $('#apiStatusText').html(
                                    '<span class="saas-badge badge-danger-saas">API недостъпно</span>'
                                    );
                        })
                        .always(function () {
                            icon.removeClass('spin');
                            btn.prop('disabled', false);
                        });
            }
        },

        'btn': {

            'revalue': function () {
                let route = $(this).data('route');

                if (v.formIsDirty) {
                    alert('Първо трябва да запазите настройките!');
                    return;
                }

                if (! confirm('❗ Това действие е необратимо. Сигурни ли сте?')) {
                    return;
                }

                $.post(route, {}, function (res) {
                    if (res.status === 'blocked') {
                        alert(res.msg);
                        return;
                    }

                    if (res.status === 'ok') {
                        v.GENSOFT_BLOCKED = true;

                        $('#btnRevalue').prop('disabled', true)
                                .css('opacity', 0.5)
                                .attr('title', 'Превалутирането вече е извършено');

                        alert('Превалутирането завърши успешно.');
                    }
                });
            },

            'saveSettings': function (e) {
                e.preventDefault();

                let route = $(this).data('route');
                let data = $('#tab-preval :input').serialize();

                $.post(route, data, function (res) {

                    if (res.status === 'ok') {
                        let modal = new bootstrap.Modal(
                                document.getElementById('successModal')
                                );
                        modal.show();

                        $('#modalCloseBtn').one('click', function () {
                            location.href = location.pathname + '?view=set&tab=preval';
                        });
                    }
                });
            }
        },

        /** HELPERS
         ================================================== */
        'helpers': {
            'activateTabFromUrl': function () {
                const params = new URLSearchParams(window.location.search);
                const tab = params.get('tab');


                if (! tab)
                    return;

                const tabId = '#tab-' + tab;
                const $link = $('a[data-toggle="tab"][href="' + tabId + '"]');
                const $pane = $(tabId);

                if ($link.length && $pane.length) {
                    $('.nav-link').removeClass('active');
                    $('.tab-pane').removeClass('active show');

                    $link.addClass('active');
                    $pane.addClass('active show');
                }
            },

            'updateRevalueButtonState': function () {

                if (typeof PREVAL_REVALUED !== 'undefined' && PREVAL_REVALUED === true) {
                    $('#btnRevalue')
                            .prop('disabled', true)
                            .css('opacity', 0.5)
                            .attr('title', 'Превалутирането вече е изпълнено');
                    return;
                }

                if (v.GENSOFT_BLOCKED) {
                    $('#btnRevalue')
                            .prop('disabled', true)
                            .css('opacity', 0.5)
                            .attr('title', 'Превалутирането е блокирано от Gensoft');
                    return;
                }

                if (v.formIsDirty) {
                    $('#btnRevalue')
                            .prop('disabled', true)
                            .css('opacity', 0.5)
                            .attr('title', 'Първо трябва да запазите настройките');
                }
                else {
                    $('#btnRevalue')
                            .prop('disabled', false)
                            .css('opacity', 1)
                            .attr('title', '');
                }
            }
        }
    };

    nastrojkiPreval.init( );
} )(jQuery, window, document);
