/* global loadPlugins */
( function ($, window, document, undefined) {

    var nastrojkiSeo = nastrojkiSeo || {};
    let v = nastrojkiSeo;
    let helpers;

    nastrojkiSeo = {
        '__var': {
            tab: $('#currentView').data('view') || '',
            mode: 'products',
            categoryId: ''
        },
        'init': function ( ) {
            v = this.__var;
            helpers = this.helpers;

            Lp = loadPlugins;

            Lp.popupTitle();
            Lp.perPage('#perPage', v.tab); // промяна колко стр да се показват в mainPage
            Lp.table_freezeHeader({'table': '.table', 'margin': 40}); // thead frezze

            this.helpers.loadCategories();
            this.setUpListeners( );
        },
        'setUpListeners': function () {

            $(document)
                    /** UI ЗА ПРОМЯНА       
                     =================================================*/
                    // избира / маха всички редове
                    .on('change', '#checkAll', this.ui.checkAll)
                    // търсене в SEO таблицата 
                    .on('input', '#seoSearch', this.ui.search)
                    // филтър по категория 
                    .on('change', '#seoCategory', this.ui.changeCategory)
                    // смяна на режим: продукти / категории
                    .on('change', '#seoMode', this.ui.changeMode)
                    // запис на SEO поле при промяна (inline save)
                    .on('change', '.seo-field', this.ui.saveSeoField)

                    /** BTN ДЕЙСТВИЯ       
                     -=================================================*/
                    // масово NOINDEX
                    .on('click', '#btnIndexSelected', this.btn.bulkNoindex)
                    // масово INDEX
                    .on('click', '#btnNoindexSelected', this.btn.bulkIndex)
                    // авто SEO за всички продукти
                    .on('click', '#btnAutoAll', this.btn.autoAll)
                    // авто SEO за конкретен продукт
                    .on('click', '.btnAutoSEO', this.btn.autoSingle);
        },
        // (user interactions)
        'ui': {
            'checkAll': function () {
                $('.row-check').prop('checked', this.checked);
            },

            'saveSeoField': function () {
                const _this = $(this);
                const tr = _this.closest('tr');
                const route = _this.data('route');

                $.post(route, {
                    mode: v.mode,
                    id: tr.data('id'),
                    product_id: tr.data('pid'),
                    category_id: tr.data('cid'),
                    name: this.name,
                    value: $(this).is(':checkbox')
                            ? ( this.checked ? 1 : 0 )
                            : $(this).val()
                }, function (resp) {

                    const cls = resp.status === 'success'
                            ? 'table-success'
                            : 'table-danger';

                    helpers.showAlert(
                            resp.status === 'success' ? 'success' : 'danger',
                            resp.status === 'success'
                            ? 'SEO данните са записани'
                            : 'Грешка при запис'
                            );

                    tr.addClass(cls);
                    setTimeout(() => tr.removeClass(cls), 600);

                }, 'json');
            },

            'search': function () {
                helpers.loadSeoData();
            },

            'changeCategory': function () {
                v.categoryId = this.value;
                helpers.loadSeoData();
            },

            'changeMode': function () {
                v.mode = this.value;

                $('#seoCategory, #seoSearch').val('');

                if (v.mode === 'products') {
                    $('.seo-category-filter').removeClass('d-none');
                    helpers.loadCategories();
                }
                else {
                    $('.seo-category-filter').addClass('d-none');
                    v.categoryId = '';
                }

                helpers.loadSeoData();
            },
        },

        'btn': {

            'bulkNoindex': function () {
                const _this = $(this);
                const route = _this.data('route');
                const ids = helpers.getSelectedProducts();

                if (!ids.length)
                    return helpers.showAlert('warning', 'Няма избрани продукти');

                $.post(route, {ids}, function (resp) {
                    helpers.showAlert(
                            resp.status === 'success' ? 'success' : 'danger',
                            resp.status === 'success'
                            ? 'Продуктите са NOINDEX'
                            : 'Грешка'
                            );
                    helpers.loadSeoData();
                }, 'json');
            },

            'bulkIndex': function () {
                const _this = $(this);
                const route = _this.data('route');
                const ids = helpers.getSelectedProducts();

                if (!ids.length)
                    return helpers.showAlert('warning', 'Няма избрани продукти');

                $.post(route, {ids}, function (resp) {
                    helpers.showAlert(
                            resp.status === 'success' ? 'success' : 'danger',
                            resp.status === 'success'
                            ? 'Продуктите са INDEX'
                            : 'Грешка'
                            );
                    helpers.loadSeoData();
                }, 'json');
            },

            'autoAll': function () {
                const _this = $(this);
                const route = _this.data('route');

                if (v.mode !== 'products')
                    return alert('Само за продукти');

                if (!confirm('Генериране на SEO за всички продукти?'))
                    return;

                const btn = $(this)
                        .prop('disabled', true)
                        .html('<i class="fa fa-spinner fa-spin"></i> Генериране...');

                $.post(route, {}, function (resp) {

                    btn.prop('disabled', false)
                            .html('<i class="fa fa-magic me-1"></i> Автоматично генериране');

                    helpers.showAlert(
                            resp.status === 'success' ? 'success' : 'danger',
                            resp.status === 'success'
                            ? 'SEO генерирано'
                            : 'Грешка'
                            );

                    helpers.loadSeoData();

                }, 'json');
            },

            'autoSingle': function () {
                   const _this = $(this);
                const route = _this.data('route');
                const tr = _this.closest('tr');

                $.post(route, {
                    product_id: tr.data('pid')
                }, function (resp) {

                    if (resp.status !== 'success')
                        return helpers.showAlert('danger', 'Грешка при генериране');

                    helpers.showAlert('success', 'SEO е генерирано');

                    Object.entries(resp.data).forEach(([k, v]) => {
                        tr.find(`[name="${k}"]`).val(v).trigger('change');
                    });

                }, 'json');
            }
        },

        /** HELPERS
         ================================================== */
        'helpers': {
            // зареждане на категории
            'loadCategories': function () {
                let param = new URLSearchParams(window.location.search);
                let selectedCategoryId = param.get('category_id') || '';

                $.get(GLOBVAR.seo.getCategories, function (data) {
                    const sel = $('#seoCategory');
                    sel.empty().append('<option value="">Всички категории</option>');

                    data.forEach(c => {
                        sel.append(
                                `<option value="${c.category_id}" ${c.category_id == selectedCategoryId ? 'selected' : ''}>
                            ${c.category_name}
                         </option>`
                                );
                    });
                }, 'json');
            },
            // зареждане/опреснява на продукти
            'loadSeoData': function () {
                const params = new URLSearchParams(window.location.search);
                const seoSearch = ( $('#seoSearch').val() || '' ).trim();
                const seoMode = $('#seoMode').val() || null;
                const seoCategory = $('#seoCategory:visible').val() || null;
                const tbody = $('#seoTable tbody');

                const setOrDelete = (key, value) => {
                    value ? params.set(key, value) : params.delete(key);
                };

                if (seoSearch) {
                    params.set('page', 1);
                }

                setOrDelete('search', seoSearch);
                setOrDelete('mode', seoMode);
                setOrDelete('category_id', seoCategory);

                tbody.find('#loadingRows').removeClass('hide');
                tbody.find('#notResultsFound').addClass('hide');

                const query = params.toString();
                history.replaceState({}, '', query ? `${location.pathname}?${query}` : location.pathname);

                Lp.htmxReloadPage('', {target: '#renderHtml'});
            },
            // взимане на избраните продукти от таблицата
            'getSelectedProducts': function () {
                let ids = [ ];

                $('#seoTable tbody tr').each(function () {
                    if ($(this).find('.row-check').is(':checked')) {
                        const pid = $(this).data('pid');
                        pid > 0 && ids.push(pid);
                    }
                });

                return ids;
            },
            // alert
            'showAlert': function (type, text, timeout = 3000 ) {

                const alertBox = $('#seoAlert');
                const alertText = $('#seoAlertText');

                alertBox
                        .removeClass('d-none alert-success alert-danger alert-warning')
                        .addClass('alert-' + type);

                alertText.text(text);

                if (timeout) {
                    setTimeout(() => {
                        alertBox.addClass('d-none');
                    }, timeout);
            }
            },
        }
    };

    nastrojkiSeo.init( );
} )(jQuery, window, document);
