/* global loadPlugins */

( function ($, window, document, undefined) {

    let popup_category = {};
    let v, self;

    popup_category = {

        $editingRow: null,
        $editingLi: null,

        '__var': {
            $modal: $('.modal').on('show.bs.modal', function (event) {
                $('#' + event.target.id);
            })
        },

        // ======================================================
        // INIT
        // ======================================================
        init: function () {
            v = this.__var;
            self = this;

            this.plugins();
            this.setUpListeners();
        },

        // ======================================================
        // PLUGINS
        // ======================================================
        plugins: function () {
            Lp = loadPlugins;

            this.initCategorySortable();
            Lp.zoomImg({isModal: true});
        },

        'setUpListeners': function ( ) {

            v.$modal
                    .on('click', '.btn-seo', this.modal.open_popup_categorySeo)

            v.$modal
                    .on('click', '.removeCatImg', this.btn.removeImage)
                    .on('click', '.catImg', this.btn.selectImage);


            v.$modal.find('#block-mainCat')
                    // Филтър по главна категория
                    .on('keyup', '#mainCatSearch', this.event.filter_mainCat)

                    // Главна категория: създаване
                    .on('click', '#btn-createRootCat', this.btn.mainCategory.create_root)
                    // Главна категория: редакция
                    .on('click', '.btn-editRoot', this.btn.mainCategory.edit_root)
                    // Главна категория: изтриване
                    .on('click', '.btn-del', this.btn.common.delete_category)
                    // Главна категория: избор
                    .on('click', 'ul#mainCat li', this.btn.mainCategory.choose_root);


            v.$modal.find('#block-subCat')
                    // Филтър по подкатегория
                    .on('keyup', '#subCatSearch', this.event.filter_subCat)

                    // (разгъване/затваряне) на подкатегории 
                    .on('click', '.category-icon, .cat-title', this.btn.subCategory.toggle_sub)
                    // Добавяне на подкатегория
                    .on('click', '.btn-showAddSubForm', this.btn.subCategory.show_addSubForm)
                    .on('click', '.btn-cancel', function () {
                        $(this).closest('.showAddSubForm').addClass('hide');
                    })
                    // Подкатегории: създаване
                    .on('click', '.submit-new-subCat', this.btn.subCategory.submit_newSub)
                    // Подкатегории: редакция
                    .on('click', '.btn-edit', this.btn.subCategory.edit_sub)
                    // Подкатегории: изтриване
                    .on('click', '.btn-del', this.btn.common.delete_category);

            // Добавяне на главна категория
            //v.$modal.on('click', '#addRootCatBtn', this.btn.mainCategory.add)
        },

        'initCategorySortable': function () {
            const route = $(this).data('route');

            $('.ul-root, .category-tree').sortable({
                handle: '.handle',
                connectWith: '.ul-root, .category-tree',
                placeholder: 'sortable-placeholder',
                tolerance: 'pointer',

                receive: function (e, ui) {

                    const $item = ui.item;
                    const categoryId = $item.data('id');
                    let route = $($item).find('.handle:first').attr('data-route-changeparent');
                    let newParentId = $(this).data('parent-id');

                    if (typeof newParentId === 'undefined') {
                        newParentId = null; // ROOT
                    }

                    console.log('CHANGE PARENT:', categoryId, newParentId);

                    $.ajax({
                        url: route,
                        method: 'POST',
                        data: {
                            category_id: categoryId,
                            parent_id: newParentId
                        }
                    });
                },

                update: function (e, ui) {

                    if (this !== ui.item.parent()[0]) {
                        return;
                    }

                    let positionsArr = [ ];
                    let route = $(this).find('.handle:first').attr('data-route-reorder');

                    $(this).children('li').each(function (i) {
                        positionsArr.push({
                            id: $(this).data('id'),
                            position: i + 1
                        });
                    });

                    console.log('REORDER:', positionsArr);

                    if (route && positionsArr.length) {
                        $.post(route, {positionsArr});
                    }
                }
            });
        },

        'modal': {
            'open_popup_categorySeo': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },
        },
        'event': {
            'filter_mainCat': function (e) {
                e.stopImmediatePropagation( );

                const search = $(this).val().toLowerCase().trim();

                $('.category-tree').hide();
                $('#block-createSubCat_to_rootCat').addClass('hide');
                $('#block-subCat #breadcrumbs').text('');

                if (search === '') {
                    $('#mainCat > li').removeClass('hide active');
                    return;
                }

                $('#mainCat > li').each(function () {
                    const title = $(this).data('title') || $(this).find('.cat-title').text();
                    if (title.toLowerCase().includes(search)) {
                        $(this).removeClass('hide');
                    }
                    else {
                        $(this).addClass('hide');
                    }
                });
            },

            'filter_subCat': function (e) {
                e.stopImmediatePropagation( );
                const search = $(this).val().toLowerCase().trim();

                $('.category-tree').hide();
                $('#mainCat > li').removeClass('active');
                $('#block-createSubCat_to_rootCat').addClass('hide');
                $('#block-subCat #breadcrumbs').text('');

                // Показване на всичко при празно търсене
                if (search === '') {
                    // Покажи само главните категории
                    $('#mainCat > li').removeClass('hide');

                    // Скрий всички подкатегории и техните списъци
                    $('.category-tree li').show();
                    $('.category-tree').hide();
                    $('.fa-folder-open').removeClass('fa-folder-open').addClass('fa-folder');

                    updateFolderIcons();

                    return;
                }

                // Скриване на всички категории и подкатегории
                $('.category-tree li').hide();
                $('.category-tree').hide();
                $('#mainCat > li').addClass('hide');

                // Събиране на засегнатите главни категории за по-ефективна обработка
                const mainCatIdsToShow = new Set();

                // Търсене и показване на съвпадения и път до тях
                $('.cat-title').filter(function () {
                    return $(this).text().toLowerCase().includes(search);
                }).each(function () {
                    const $li = $(this).closest('li');
                    const $tree = $li.closest('ul[id^=tree-]');

                    $li.show();
                    $li.parents('li').show();
                    $li.parents('ul.category-tree').show();
                    $li.children('ul.category-tree').show();

                    if ($tree.length) {
                        $tree.show();
                        const mainCatId = $tree.attr('id').replace('tree-', '');
                        mainCatIdsToShow.add(mainCatId);
                    }
                });

                // Покажи само засегнатите главни категории
                mainCatIdsToShow.forEach(id => {
                    $('#mainCat > li[data-id="' + id + '"]').removeClass('hide');
                });

                updateFolderIcons();

                // АКТУАЛИЗАЦИЯ НА ИКОНИТЕ: folder / folder-open
                function updateFolderIcons () {
                    $('.category-icon i.fa-folder, .category-icon i.fa-folder-open').each(function () {
                        const $ul = $(this).closest('li').children('ul.category-tree');

                        if ($ul.length && $ul.is(':visible')) {
                            $(this).removeClass('fa-folder').addClass('fa-folder-open');
                        }
                    });
                }
                ;
            }
        },

        'btn': {
            'removeImage': function (e) {
                e.stopPropagation(); // да не отваря CKFinder
                const _this = $(this);
                const route = _this.data('route');
                const block = _this.closest('.image-block');
                const li = _this.closest('li');

                if (! confirm('Наистина ли искате да премахнете снимката от категорията?')) {
                    return false;
                }

                self.ajax.send(route, {'id': li.data('id')}).then(function (res) {
                    if (res.err) {
                        return false;
                    }

                    _this.addClass('invisible');
                    block.find('.zoomImg').addClass('invisible');
                    block.find('.js-image').attr({'src': ''});
                    block.find('.camera').removeClass('d-none');
                });
            },

            'selectImage': function (e) {
                e.stopImmediatePropagation( );
                const $this = $(this);
                const route = $this.data('route');
                const plugins = config.pluginsPatch + '/' + config.plugins;
                const li = $this.closest('li');

                CKFinder.popup({
                    id: 'categories',
                    chooseFiles: true,
                    skin: 'jquery-mobile',
                    language: 'bg',
                    swatch: 'b',
                    width: 1024,
                    height: 800,
                    rememberLastFolder: false,
                    startupFolderExpanded: true,
                    startupPath: 'portal_images:/categories/',
                    plugins: [ plugins ],
                    onInit: function (finder) {
                        finder.config.extraPlugins = 'Image_modificate';

                        finder.on('files:choose', function (evt) {
                            var file = evt.data.files.first( );
                            const imgUrl = file.getUrl();
                            const newPath = imgUrl.replace(GLOBVAR.portalImageDir, '');
                            const imageBlock = $this.closest('.image-block');
                            const img = $this.find('img');
                            const cameraIcon = $this.find('.camera');
                            const removeBtn = imageBlock.find('.removeCatImg');
                            const zoomImgBtn = imageBlock.find('.zoomImg');

                            img.attr({'src': imgUrl});

                            // Показване/скриване на елементи
                            removeBtn.removeClass('invisible');
                            zoomImgBtn.removeClass('invisible');
                            cameraIcon.addClass('d-none');

                            self.ajax.send(route, {'id': li.data('id'), 'path': newPath});

                        });

                        finder.on('file:choose:resizedImage', function (evt) {
                            $this.attr('src', evt.data.resizedUrl);
                        });
                    }
                });
            },

            'mainCategory': {
                'create_root': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let route = _this.data('route');
                    let block = _this.parents('#block-createRootCat');
                    let name = block.find('#rootCatName').val().trim();

                    if (! name) {
                        alert('Въведете име на главната категория!');
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'isRoot': 1, 'name': name},
                        dataType: 'json',
                        success: function (response) {

                            if (response.err) {
                                alert(response.err);
                                return false;
                            }

                            v.$modal.find("#html").load($("#html").data('route') + " #html>*", function () {
                                self.init();
                            });
                        }
                    });
                },

                'choose_root': function (e) {
                    let _this = $(this);
                    let mainId = _this.data('id');
                    let createSub_toRoot = $('#block-createSubCat_to_rootCat');
                    let oldRoute = createSub_toRoot.find('.submit-new-subCat').attr('data-route');
                    let newRoute = oldRoute.replace(/(save2\/)[^\/]+/, '$1' + mainId);

                    if ($(e.target).is('button,i')) {
                        return;
                    }

                    $('ul#mainCat li').removeClass('active');
                    createSub_toRoot.removeClass('hide');
                    createSub_toRoot.find('.submit-new-subCat').attr('data-root-id', mainId).attr('data-route', newRoute);

                    _this.addClass('active');

                    //$('#block-subCat .category-tree').hide( );
                    $('#block-subCat #breadcrumbs').text($(this).text().trim());
                    $('.category-tree').hide();
                    $('#tree-' + mainId).show( );
                },

                'edit_root': function (e) {
                    e.stopImmediatePropagation( );
                    const _this = $(this);
                    let route = _this.data('route');
                    let li = _this.closest('li');
                    let el = li.find('.categoryName:first');
                    let btnGroup = li.find('.btnGroup:first');
                    let isRoot = li.data('isroot');

                    if (window.doomEditActive) {
                        return false;
                    }

                    Lp.loadDoomEdit({'el': el, 'form_class': 'domEdit', 'route': route, 'action': 'edit', 'btnGroup': btnGroup, extraFields: {'isRoot': isRoot}});
                }
            },

            'subCategory': {
                'toggle_sub': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let $li = _this.closest('li');
                    let $subtree = $li.children('.category-tree');
                    let $allSiblings = $li.siblings('li');

                    if (! $subtree.length) {
                        return false;
                    }

                    // 1. Затвори всички други дървета на това ниво
                    $allSiblings.each(function ( ) {
                        let $sibTree = $(this).find('.category-tree');

                        if ($sibTree.length && $sibTree.is(':visible')) {
                            $sibTree.slideUp(120);

                            $(this).find('.category-row .category-icon i').removeClass('fa-folder-open').addClass('fa-folder');
                        }
                    });

                    // 2. Разгъни/сгъни избраното
                    if ($subtree.length) {
                        if ($subtree.is(':visible')) {
                            $subtree.slideUp(120);

                            $li.find('.category-icon i').removeClass('fa-folder-open').addClass('fa-folder');
                        }
                        else {
                            $subtree.slideDown(120);
                            $li.find('i:first').removeClass('fa-folder').addClass('fa-folder-open');
                        }
                    }
                },

                // показване на форма за създаване на нова подкатегория
                'show_addSubForm': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let li = _this.closest('li');
                    let breadcrumbsHtml = self.private.getBreadcrumbs(li);
                    // Покажи формата
                    let $form = li.find('.showAddSubForm').first().removeClass('hide');

                    // Breadcrumbs  
                    $form.find('.breadcrumbs').html('<b>Добавяне в:</b> ' + breadcrumbsHtml);
                    $form.find('input.name').val('').focus(); // Празно поле при добавяне
                },

                // създавне нова подкатегория
                'submit_newSub': function (e) {
                    e.stopImmediatePropagation();
                    let _this = $(this);
                    let li = _this.closest('li');
                    let blockMainCat = $('#block-mainCat');
                    let activeMainCatText = blockMainCat.find('li.active label').text();

                    let rootId = li.closest('[data-root-id]').data('root-id') || _this.attr('data-root-id');
                    let parentSubId = li.data('id');
                    let route = _this.data('route');
                    let name = _this.parent().find('.name');
                    let action = _this.attr('data-action') || 'new'; // default 'new' ако липсва
                    let pathIds = [ ];


                    pathIds = self.private.getPathIds(li, rootId);

                    if (name.val() == '') {
                        alert('Въведете име.');
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'name': name.val().trim(), 'parentSubId': parentSubId, 'action': action},
                        dataType: 'json',
                        success: function (response) {

                            if (response.err) {
                                alert(response.err);
                                return false;
                            }


                            v.$modal.find("#html").load($("#html").data('route') + " #html>*", {'pathIds': pathIds, 'activeMainCatText': activeMainCatText}, function () {
                                self.init();
                            });
                        }
                    });
                },

                'edit_sub': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let route = _this.data('route');
                    let li = _this.closest('li');
                    let el = li.find('.cat-title:first');
                    let btnGroup = li.find('.btnGroup:first');

                    Lp.loadDoomEdit({'el': el, 'form_class': 'domEdit', 'route': route, 'action': 'edit', 'btnGroup': btnGroup});
                },
            },

            // обединени функции
            'common': {
                'delete_category': function (e) {
                    e.stopImmediatePropagation( );
                    const _this = $(this);

                    var li = _this.closest('li');
                    let isMainCat = _this.closest('#block-mainCat').length;
                    let rootId = li.closest('[data-root-id]').data('root-id');
                    var route = _this.data('route');
                    var name = li.find('.cat-title:first').text().trim();
                    let pathIds = [ ];

                    pathIds = self.private.getPathIds(li, rootId);

                    if (! confirm(`${LANGpop__category.confirm.delete} ${name}?`)) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: "POST",
                        dataType: 'json',
                        success: function (response)
                        {
                            if (response.err) {
                                alert(response.err);//Записът е изтрит
                                return false;
                            }

                            if (isMainCat) {
                                v.$modal.find("#html").load($("#html").data('route') + " #html>*", {'pathIds': pathIds}, function () {
                                    self.init();
                                });
                            }
                            else {
                                li.remove();
                            }

                            //li.remove();
                            alert('Записът е изтрит');//Записът е изтрит
                        }
                    });
                }
            },
        },

        'ajax': {
            'send': function (route, data) {

                return  $.ajax({
                    url: route,
                    method: 'POST',
                    data: {...data},
                    dataType: 'json',
                    success: function (response) {
                        if (response.err) {
                            alert(response.err);
                            return false;
                        }

                        Lp.zoomImg({'isModal': true});
                    }
                });
            }
        },

        private: {
            getBreadcrumbs: function ($li) {
                let parts = [ ];

                $li.parents('li').addBack().each(function () {
                    let title = $(this).find('.cat-title').first().text();

                    if (title)
                        parts.push(title);
                });

                return parts.reverse().join(' <i class="fa fa-angle-right"></i> ');
            },

            // взима всички id по веригата за да се ползват при refresh
            getPathIds: function (li, rootId) {
                let pathIds = [ ];

                // 1. Вземи само веригата от корен до текущата подкатегория
                li.parents('li').addBack().each(function () {
                    let id = $(this).data('id');

                    if (id) {
                        pathIds.unshift(id); // ако искаш да са по ред
                    }
                });

                // Добави и rootId (ако го няма вече)
                if (rootId && pathIds[0] != rootId) {
                    pathIds.unshift(rootId);
                }

                return pathIds;
            }
        }
//
//        'updateDataLevels': function ( ) {
//            $('#block-subCat .category-tree').each(function ( ) {
//                let $ul = $(this);
//                let depth = $ul.parents('.category-tree').length + 1; // корен е 1, първо дете е 2 и т.н.
//                $ul.children('li').each(function ( ) {
//                    $(this).children('.category-row').attr('data-level', depth);
//                });
//            });
//        }
    };

    popup_category.init( );

} )(jQuery, window, document);
