/* global categoryTree, $root, mqrkaTree, form, Popup_product_fillCatSelect, loadPlugins, categoryAttr, dropdown, Dropdown */

( function ($, window, document, undefined) {

    var popup_edit_product_properties = popup_edit_product_properties || {};
    let v = popup_edit_product_properties;
    let self = popup_edit_product_properties;

    popup_edit_product_properties = {
        '__initializedEvents': false,
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            $tabProperty: $('#tabProperty'),
            $tabOsnovniDani: $('#tabOsnovniDani'),
            table: '#tbl_products',
        },
        'init': function ( ) {
            if (this.__initializedEvents) {
                return;
            }
            this.__initializedEvents = true;

            v = this.__var;
            self = this;

            this.plugins( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;
            Dn = dropdown;

            Lp.ul_move({'el': v.$tabProperty.find('.ul-sortable'), 'handle': '.fa-arrows'});
            Lp.selectpicker( );
            Lp.count_validate_chk_productAttr(v.$modal); // брояч и валидация на х-ки на продукт за покаване в каталог ф.
        },
        'setUpListeners': function ( ) {

            // BTN
            v.$modal
                    .on('click', '.isVisibleCatAttr', this.btn.isVisibleCatAttr)
                    .on('click', '.editCatAttr', this.btn.editCatAttr)
                    .on('click', '.deleteCatAttr', this.btn.deleteCatAttr)
                    .on('click', '#createCategoryAttr', this.btn.createCategoryAttr)
                    .on('change', '.showInCatalog', this.btn.showInCatalog);
        },

        'btn': {

            // избор кои х-ки да се показват в предпечат каталог
            'showInCatalog': function (e) {
                const _this = $(this);
                const route = _this.data('route');
                const isVisible = _this.is(':checked') ? 1 : 0;

                if (_this.is('[disabled]')) {
                    return;
                }

                $.ajax({
                    url: route,
                    type: "POST",
                    data: {'isVisible': isVisible},
                    success: function (data) {}
                });

                _this.addClass('clicked');
                Lp.count_validate_chk_productAttr(v.$modal);
            },

            // dali da се показа атрибута на категорията в сайта
            'isVisibleCatAttr': function (e) {
                e.stopImmediatePropagation( );
                const _this = $(this);
                const route = _this.data('route');
                const isVisible = _this.hasClass('fa-eye') ? 0 : 1;

                $.ajax({
                    url: route,
                    type: "POST",
                    data: {'isVisible': isVisible},
                    success: function (data)
                    {
                        _this.toggleClass('fa-eye fa-eye-slash').toggleClass('text-secodary text-info');
                    }
                });
            },

            'deleteCatAttr': function (e) {
                e.stopImmediatePropagation( );
                const _this = $(this);
                const route = _this.data('route');
                const li = _this.closest('li');
                const name = li.find('.categoryAttrName').text( ).trim( );
                const properyName = v.$tabProperty.find('#properyName').text( ).trim( );

                if (v.$tabProperty.find('.save-btn').is(":visible")) {
                    alert('Имате недовършена редакция'); //Имате недовършена редакция
                    return false;
                }

                if (!confirm(`Сигурни ли сте че искате да изтриете характеристика ${name} на подкатегорията ${properyName}?`)) {
                    return false;
                }

                $.ajax({
                    url: route,
                    type: "POST",
                    success: function (data)
                    {
                        li.remove( );
                        Lp.count_validate_chk_productAttr(v.$modal);
                        alert('Характеристика е изтрита'); //Записът е изтрит
                    }
                });
            },

            'editCatAttr': function (e) {
                e.stopImmediatePropagation( );
                const _this = $(this);
                const route = _this.data('route');
                const li = _this.closest('li');
                const input = li.find('.categoryAttrName');
                const btnGroup = _this.parent( );

                if (v.$tabProperty.find('.save-btn').is(":visible")) {
                    alert('Имате недовършена редакция'); //Имате недовършена редакция
                    e.stopImmediatePropagation( );
                    return false;
                }

                btnGroup.hide( );
                Lp.loadDoomEdit({'el': input, 'route': route, 'action': 'edit', 'btnGroup': btnGroup});
            },

            // създаване на х-ки за подкатегория 
            'createCategoryAttr': function (e) {
                e.stopImmediatePropagation( );
                const _this = $(this);
                const route = _this.data('route');
                const routeRefresh = _this.data('routeRefresh');
                const name = _this.parent( ).find('#categoryAttrName');
                const subCatId = v.$tabOsnovniDani.find('select.subcatGroup.active').val( );

                if (!subCatId) {
                    alert('Не е избрана подкатегория.');
                    return false;
                }
                if (!name.val( )) {
                    alert('Липсва име на х-ката.');
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'new': 1, 'childCatId': subCatId, 'newName': name.val( ).trim( )},
                    dataType: 'json',
                    success: function (response) {

                        Lp.htmxReloadPage(routeRefresh, {'target': '#tabProperty', 'subCatId': subCatId});

                        alert('Характеристиката е създадена');
                        self.plugins( );
                    }
                });
            },
        }
    };
    popup_edit_product_properties.init( );
} )(jQuery, window, document);
